/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.gauss;

import mpicbg.imglib.algorithm.gauss.GaussianConvolution;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.numeric.RealType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GaussianConvolutionReal<T extends RealType<T>>
extends GaussianConvolution<T> {
    public GaussianConvolutionReal(Image<T> image, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory, double[] dArray) {
        super(image, outOfBoundsStrategyFactory, dArray);
    }

    public GaussianConvolutionReal(Image<T> image, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory, double d) {
        this(image, outOfBoundsStrategyFactory, GaussianConvolutionReal.createArray(image, d));
    }

    @Override
    protected void convolve(LocalizableByDimCursor<T> localizableByDimCursor, LocalizableCursor<T> localizableCursor, int n, double[] dArray, long l, long l2) {
        localizableCursor.fwd(l);
        int n2 = dArray.length;
        int n3 = n2 - 1;
        int n4 = n2 / 2;
        int n5 = n4 - 1;
        int n6 = localizableByDimCursor.getImage().getNumDimensions();
        int n7 = n4;
        double d = dArray[n3];
        int[] nArray = new int[n6];
        for (long i = 0L; i < l2; ++i) {
            localizableCursor.fwd();
            double d2 = 0.0;
            localizableCursor.getPosition(nArray);
            int n8 = n;
            nArray[n8] = nArray[n8] - n7;
            localizableByDimCursor.setPosition(nArray);
            for (int j = -n4; j <= n5; ++j) {
                d2 += ((RealType)localizableByDimCursor.getType()).getRealDouble() * dArray[j + n4];
                localizableByDimCursor.fwd(n);
            }
            ((RealType)localizableCursor.getType()).setReal(d2 += ((RealType)localizableByDimCursor.getType()).getRealDouble() * d);
        }
    }
}

