/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.gauss;

import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.MultiThreaded;
import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.algorithm.math.ImageConverter;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.function.Converter;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.multithreading.Chunk;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.NumericType;
import mpicbg.imglib.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GaussianConvolution3<A extends Type<A>, B extends NumericType<B>, C extends Type<C>>
implements MultiThreaded,
OutputAlgorithm<C>,
Benchmark {
    Image<A> image;
    final ImageFactory<B> factoryProcess;
    final ImageFactory<C> factoryOut;
    Image<C> convolved;
    Image<B> temp1;
    Image<B> temp2;
    final Converter<A, B> converterIn;
    final Converter<B, C> converterOut;
    final OutOfBoundsStrategyFactory<B> outOfBoundsFactory;
    int numDimensions;
    final double[] sigma;
    final double[][] kernel;
    long processingTime;
    int numThreads;
    String errorMessage = "";

    public GaussianConvolution3(Image<A> image, ImageFactory<B> imageFactory, ImageFactory<C> imageFactory2, OutOfBoundsStrategyFactory<B> outOfBoundsStrategyFactory, Converter<A, B> converter, Converter<B, C> converter2, double[] dArray) {
        this.image = image;
        this.factoryProcess = imageFactory;
        this.factoryOut = imageFactory2;
        this.converterIn = converter;
        this.converterOut = converter2;
        this.sigma = dArray;
        this.processingTime = -1L;
        this.outOfBoundsFactory = outOfBoundsStrategyFactory;
        this.numDimensions = image.getNumDimensions();
        this.kernel = new double[this.numDimensions][];
        this.setNumThreads();
        this.computeKernel();
    }

    public GaussianConvolution3(Image<A> image, ImageFactory<B> imageFactory, ImageFactory<C> imageFactory2, OutOfBoundsStrategyFactory<B> outOfBoundsStrategyFactory, Converter<A, B> converter, Converter<B, C> converter2, double d) {
        this(image, imageFactory, imageFactory2, outOfBoundsStrategyFactory, converter, converter2, GaussianConvolution3.createArray(image, d));
    }

    protected static double[] createArray(Image<?> image, double d) {
        double[] dArray = new double[image.getNumDimensions()];
        for (int i = 0; i < image.getNumDimensions(); ++i) {
            dArray[i] = d;
        }
        return dArray;
    }

    protected void computeKernel() {
        for (int i = 0; i < this.numDimensions; ++i) {
            this.kernel[i] = Util.createGaussianKernel1DDouble((double)this.sigma[i], (boolean)true);
        }
    }

    public void setSigma(double d) {
        this.setSigma(GaussianConvolution3.createArray(this.image, d));
    }

    public void setSigma(double[] dArray) {
        for (int i = 0; i < this.numDimensions; ++i) {
            this.sigma[i] = dArray[i];
        }
        this.computeKernel();
    }

    public double[] getSigma() {
        return (double[])this.sigma.clone();
    }

    public void setImage(Image<A> image) {
        this.image = image;
        this.numDimensions = image.getNumDimensions();
    }

    public Image<A> getImage() {
        return this.image;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public void setNumThreads() {
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    public void setNumThreads(int n) {
        this.numThreads = n;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public double[] getSigmas() {
        return this.sigma;
    }

    public int getKernelSize(int n) {
        return this.kernel[n].length;
    }

    public Image<C> getResult() {
        return this.convolved;
    }

    public boolean checkInput() {
        if (this.errorMessage.length() > 0) {
            return false;
        }
        if (this.image == null) {
            this.errorMessage = "GaussianConvolution: [Image<T> img] is null.";
            return false;
        }
        if (this.outOfBoundsFactory == null) {
            this.errorMessage = "GaussianConvolution: [OutOfBoundsStrategyFactory<T>] is null.";
            return false;
        }
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    protected Image<B> getInputImage() {
        ImageConverter<A, B> imageConverter = new ImageConverter<A, B>(this.image, this.factoryProcess, this.converterIn);
        if (!imageConverter.checkInput() || !imageConverter.process()) {
            this.errorMessage = "Cannot convert from A->B: " + imageConverter.getErrorMessage();
            return null;
        }
        return imageConverter.getResult();
    }

    protected Image<B> getTempImage1(int n) {
        if (n == 0) {
            this.temp1 = this.getInputImage();
        }
        return this.temp1;
    }

    protected Image<B> getTempImage2(int n) {
        if (n == 0) {
            this.temp2 = this.temp1.createNewImage();
        }
        return this.temp2;
    }

    protected LocalizableByDimCursor<B> getInputIterator(Image<B> image, Image<B> image2, int n) {
        if (n % 2 == 0) {
            return image.createLocalizableByDimCursor(this.outOfBoundsFactory);
        }
        return image2.createLocalizableByDimCursor(this.outOfBoundsFactory);
    }

    protected LocalizableCursor<B> getOutputIterator(Image<B> image, Image<B> image2, int n) {
        if (n % 2 == 0) {
            return image2.createLocalizableCursor();
        }
        return image.createLocalizableCursor();
    }

    protected Image<C> getConvolvedImage() {
        Image<B> image;
        if (this.numDimensions % 2 == 0) {
            image = this.temp1;
            this.temp2.close();
        } else {
            image = this.temp2;
            this.temp1.close();
        }
        ImageConverter<B, C> imageConverter = new ImageConverter<B, C>(image, this.factoryOut, this.converterOut);
        if (!imageConverter.checkInput() || !imageConverter.process()) {
            this.errorMessage = "Cannot convert from B->C: " + imageConverter.getErrorMessage();
            return null;
        }
        if (this.numDimensions % 2 == 0) {
            this.temp1.close();
        } else {
            this.temp2.close();
        }
        return imageConverter.getResult();
    }

    protected boolean processWithOptimizedMethod() {
        return false;
    }

    public boolean process() {
        long l = System.currentTimeMillis();
        if (this.processWithOptimizedMethod()) {
            this.processingTime = System.currentTimeMillis() - l;
            return this.errorMessage.length() == 0;
        }
        long l2 = this.image.getNumPixels();
        final Vector vector = SimpleMultiThreading.divideIntoChunks((long)l2, (int)this.numThreads);
        for (int i = 0; i < this.numDimensions; ++i) {
            final int n = i;
            final Image<B> image = this.getTempImage1(n);
            if (image == null) {
                return false;
            }
            final Image<B> image2 = this.getTempImage2(n);
            if (image2 == null) {
                return false;
            }
            final AtomicInteger atomicInteger = new AtomicInteger(0);
            Thread[] threadArray = SimpleMultiThreading.newThreads((int)this.numThreads);
            for (int j = 0; j < threadArray.length; ++j) {
                threadArray[j] = new Thread(new Runnable(){

                    public void run() {
                        int n2 = atomicInteger.getAndIncrement();
                        Chunk chunk = (Chunk)vector.get(n2);
                        LocalizableByDimCursor localizableByDimCursor = GaussianConvolution3.this.getInputIterator(image, image2, n);
                        LocalizableCursor localizableCursor = GaussianConvolution3.this.getOutputIterator(image, image2, n);
                        GaussianConvolution3.this.convolveDim(localizableByDimCursor, localizableCursor, n, chunk.getStartPosition(), chunk.getLoopSize());
                        localizableByDimCursor.close();
                        localizableCursor.close();
                    }
                });
            }
            SimpleMultiThreading.startAndJoin((Thread[])threadArray);
        }
        this.convolved = this.getConvolvedImage();
        this.processingTime = System.currentTimeMillis() - l;
        return true;
    }

    protected void convolveDim(LocalizableByDimCursor<B> localizableByDimCursor, LocalizableCursor<B> localizableCursor, int n, long l, long l2) {
        this.convolve(localizableByDimCursor, localizableCursor, n, this.kernel[n], l, l2);
    }

    protected void convolve(LocalizableByDimCursor<B> localizableByDimCursor, LocalizableCursor<B> localizableCursor, int n, double[] dArray, long l, long l2) {
        localizableCursor.fwd(l);
        int n2 = dArray.length;
        int n3 = n2 - 1;
        int n4 = n2 / 2;
        int n5 = n4 - 1;
        int n6 = localizableByDimCursor.getImage().getNumDimensions();
        int n7 = n4;
        double d = dArray[n3];
        int[] nArray = new int[n6];
        NumericType numericType = (NumericType)((NumericType)localizableByDimCursor.getType()).createVariable();
        NumericType numericType2 = (NumericType)((NumericType)localizableByDimCursor.getType()).createVariable();
        for (long i = 0L; i < l2; ++i) {
            localizableCursor.fwd();
            numericType.setZero();
            localizableCursor.getPosition(nArray);
            int n8 = n;
            nArray[n8] = nArray[n8] - n7;
            localizableByDimCursor.setPosition(nArray);
            for (int j = -n4; j <= n5; ++j) {
                numericType2.set(localizableByDimCursor.getType());
                numericType2.mul(dArray[j + n4]);
                numericType.add(numericType2);
                localizableByDimCursor.fwd(n);
            }
            numericType2.set(localizableByDimCursor.getType());
            numericType2.mul(d);
            numericType.add(numericType2);
            ((NumericType)localizableCursor.getType()).set((Type)numericType);
        }
    }
}

