/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.gauss;

import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.MultiThreaded;
import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.algorithm.gauss.GaussianConvolution3;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.function.RealTypeConverter;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.interpolation.Interpolator;
import mpicbg.imglib.interpolation.InterpolatorFactory;
import mpicbg.imglib.interpolation.nearestneighbor.NearestNeighborInterpolatorFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyMirrorFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.real.DoubleType;
import mpicbg.imglib.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownSample<T extends RealType<T>>
implements MultiThreaded,
OutputAlgorithm<T>,
Benchmark {
    Image<T> input;
    Image<T> downSampled;
    float sourceSigma;
    float targetSigma;
    int[] newSize;
    int[] imgSize;
    float[] scaling;
    String errorMessage = "";
    int numThreads;
    long processingTime;

    public DownSample(Image<T> image, int[] nArray, float f, float f2) {
        this.input = image;
        this.newSize = (int[])nArray.clone();
        this.setSourceSigma(f);
        this.setTargetSigma(f2);
        if (this.input != null) {
            this.imgSize = image.getDimensions();
            this.scaling = new float[image.getNumDimensions()];
            for (int i = 0; i < image.getNumDimensions(); ++i) {
                this.scaling[i] = (float)this.imgSize[i] / (float)nArray[i];
            }
        } else {
            this.imgSize = null;
            this.scaling = null;
        }
        this.setNumThreads();
        this.processingTime = -1L;
    }

    public DownSample(Image<T> image, float f) {
        this.setInputImage(image);
        if (this.input != null) {
            this.setDownSamplingFactor(f);
        }
        this.setSourceSigma(0.5f);
        this.setTargetSigma(0.5f);
        this.setNumThreads();
        this.processingTime = -1L;
    }

    public void setSourceSigma(float f) {
        this.sourceSigma = f;
    }

    public void setTargetSigma(float f) {
        this.targetSigma = f;
    }

    public void setDownSamplingFactor(float f) {
        this.newSize = new int[this.input.getNumDimensions()];
        this.scaling = new float[this.input.getNumDimensions()];
        for (int i = 0; i < this.input.getNumDimensions(); ++i) {
            this.newSize[i] = Util.round((float)((float)this.input.getDimension(i) * f));
            this.scaling[i] = 1.0f / f;
        }
    }

    public void setNewSize(int[] nArray) {
        this.newSize = (int[])nArray.clone();
    }

    public void setInputImage(Image<T> image) {
        this.input = image;
        this.imgSize = (int[])(this.input != null ? image.getDimensions() : null);
    }

    public float getSourceSigma() {
        return this.sourceSigma;
    }

    public float getTargetSigma() {
        return this.targetSigma;
    }

    public int[] getNewSize() {
        return (int[])this.newSize.clone();
    }

    public Image<T> getInputImage() {
        return this.input;
    }

    public boolean process() {
        long l = System.currentTimeMillis();
        int n = this.input.getNumDimensions();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            double d = this.targetSigma * this.scaling[i];
            dArray[i] = Math.sqrt(d * d - (double)(this.sourceSigma * this.sourceSigma));
        }
        ImageFactory imageFactory = new ImageFactory((Type)new DoubleType(), this.input.getContainerFactory());
        GaussianConvolution3 gaussianConvolution3 = new GaussianConvolution3(this.input, imageFactory, this.input.getImageFactory(), new OutOfBoundsStrategyMirrorFactory(), new RealTypeConverter(), new RealTypeConverter(), dArray);
        gaussianConvolution3.setNumThreads(this.getNumThreads());
        if (!gaussianConvolution3.checkInput() || !gaussianConvolution3.process()) {
            this.errorMessage = "Gaussian Convolution failed: " + gaussianConvolution3.getErrorMessage();
            return false;
        }
        Image image = gaussianConvolution3.getResult();
        this.downSampled = this.input.createNewImage(this.newSize);
        Interpolator interpolator = image.createInterpolator((InterpolatorFactory)new NearestNeighborInterpolatorFactory((OutOfBoundsStrategyFactory)new OutOfBoundsStrategyMirrorFactory()));
        LocalizableCursor localizableCursor = this.downSampled.createLocalizableCursor();
        int[] nArray = new int[n];
        float[] fArray = new float[n];
        float[] fArray2 = (float[])this.scaling.clone();
        while (localizableCursor.hasNext()) {
            localizableCursor.fwd();
            localizableCursor.getPosition(nArray);
            for (int i = 0; i < n; ++i) {
                fArray[i] = (float)nArray[i] * fArray2[i];
            }
            interpolator.moveTo(fArray);
            ((RealType)localizableCursor.getType()).set(interpolator.getType());
        }
        localizableCursor.close();
        interpolator.close();
        image.close();
        this.processingTime = System.currentTimeMillis() - l;
        return true;
    }

    public boolean checkInput() {
        if (this.errorMessage.length() > 0) {
            return false;
        }
        if (this.input == null) {
            this.errorMessage = "Input image is null";
            return false;
        }
        if (this.newSize == null) {
            this.errorMessage = "New size of image is null";
            return false;
        }
        for (int i = 0; i < this.input.getNumDimensions(); ++i) {
            if (this.newSize[i] <= this.imgSize[i]) continue;
            this.errorMessage = "New image supposed to be bigger than input image in dimension " + i + ", " + "this algorithm is only for downsampling (" + this.newSize[i] + " > " + this.imgSize[i] + " )";
            return false;
        }
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Image<T> getResult() {
        return this.downSampled;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public void setNumThreads() {
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    public void setNumThreads(int n) {
        this.numThreads = n;
    }
}

