/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.floydsteinberg;

import java.util.Random;
import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.cursor.Localizable;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.cursor.array.ArrayLocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyValueFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.logic.BitType;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.imglib.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloydSteinbergDithering<T extends RealType<T>>
implements OutputAlgorithm<BitType>,
Benchmark {
    Image<BitType> result;
    final Image<T> img;
    final Image<FloatType> errorDiffusionKernel;
    final int[] dim;
    final int[] tmp1;
    final int[] tmp2;
    final int numDimensions;
    final float ditheringThreshold;
    final float minValue;
    final float maxValue;
    long processingTime;
    String errorMessage = "";

    public FloydSteinbergDithering(Image<T> image, float f) {
        this.img = image.clone();
        this.dim = image.getDimensions();
        this.tmp1 = image.createPositionArray();
        this.tmp2 = image.createPositionArray();
        this.errorDiffusionKernel = this.createErrorDiffusionKernel(image.getNumDimensions());
        this.ditheringThreshold = f;
        image.getDisplay().setMinMax();
        this.minValue = (float)image.getDisplay().getMin();
        this.maxValue = (float)image.getDisplay().getMax();
        this.numDimensions = image.getNumDimensions();
    }

    public FloydSteinbergDithering(Image<T> image) {
        this(image, FloydSteinbergDithering.getThreshold(image));
    }

    public boolean process() {
        long l = System.currentTimeMillis();
        ImageFactory imageFactory = new ImageFactory((Type)new BitType(), this.img.getContainerFactory());
        this.result = imageFactory.createImage(this.dim);
        ArrayLocalizableCursor arrayLocalizableCursor = ArrayLocalizableCursor.createLinearCursor((int[])this.dim);
        LocalizableByDimCursor localizableByDimCursor = this.img.createLocalizableByDimCursor((OutOfBoundsStrategyFactory)new OutOfBoundsStrategyValueFactory());
        LocalizableByDimCursor localizableByDimCursor2 = this.result.createLocalizableByDimCursor();
        LocalizableCursor localizableCursor = this.errorDiffusionKernel.createLocalizableCursor();
        while (arrayLocalizableCursor.hasNext()) {
            float f;
            arrayLocalizableCursor.fwd();
            localizableByDimCursor.moveTo((Localizable)arrayLocalizableCursor);
            localizableByDimCursor2.moveTo((Localizable)arrayLocalizableCursor);
            float f2 = ((RealType)localizableByDimCursor.getType()).getRealFloat();
            if (f2 < this.ditheringThreshold) {
                ((BitType)localizableByDimCursor2.getType()).setZero();
                f = f2 - this.minValue;
            } else {
                ((BitType)localizableByDimCursor2.getType()).setOne();
                f = f2 - this.maxValue;
            }
            if (f == 0.0f) continue;
            localizableCursor.reset();
            localizableCursor.fwd((long)(this.errorDiffusionKernel.getNumPixels() / 2));
            arrayLocalizableCursor.getPosition(this.tmp1);
            while (localizableCursor.hasNext()) {
                localizableCursor.fwd();
                float f3 = f * ((FloatType)localizableCursor.getType()).get();
                localizableCursor.getPosition(this.tmp2);
                for (int i = 0; i < this.numDimensions; ++i) {
                    int n = i;
                    this.tmp2[n] = this.tmp2[n] + (this.tmp1[i] - 1);
                }
                localizableByDimCursor.moveTo(this.tmp2);
                ((RealType)localizableByDimCursor.getType()).setReal(((RealType)localizableByDimCursor.getType()).getRealFloat() + f3);
            }
        }
        arrayLocalizableCursor.close();
        localizableByDimCursor.close();
        localizableByDimCursor2.close();
        localizableCursor.close();
        this.img.close();
        this.processingTime = System.currentTimeMillis() - l;
        return true;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public Image<BitType> getResult() {
        return this.result;
    }

    public boolean checkInput() {
        return true;
    }

    public static <T extends RealType<T>> float getThreshold(Image<T> image) {
        image.getDisplay().setMinMax();
        return (float)(image.getDisplay().getMax() - image.getDisplay().getMin()) / 2.0f;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Image<FloatType> createErrorDiffusionKernel(int n) {
        int n2;
        ImageFactory imageFactory = new ImageFactory((Type)new FloatType(), (ContainerFactory)new ArrayContainerFactory());
        if (n == 2) {
            Image image = imageFactory.createImage(new int[]{3, 3});
            LocalizableByDimCursor localizableByDimCursor = image.createLocalizableByDimCursor();
            localizableByDimCursor.setPosition(2, 0);
            localizableByDimCursor.setPosition(1, 1);
            ((FloatType)localizableByDimCursor.getType()).setReal(0.4375f);
            localizableByDimCursor.move(1, 1);
            ((FloatType)localizableByDimCursor.getType()).setReal(0.0625f);
            localizableByDimCursor.move(-1, 0);
            ((FloatType)localizableByDimCursor.getType()).setReal(0.3125f);
            localizableByDimCursor.move(-1, 0);
            ((FloatType)localizableByDimCursor.getType()).setReal(0.1875f);
            localizableByDimCursor.close();
            return image;
        }
        Image image = imageFactory.createImage(Util.getArrayFromValue((int)3, (int)n));
        LocalizableCursor localizableCursor = image.createLocalizableCursor();
        int n3 = image.getNumPixels() / 2;
        float[] fArray = new float[n3];
        float f = 0.0f;
        Random random = new Random(435345L);
        for (n2 = 0; n2 < n3; ++n2) {
            fArray[n2] = random.nextFloat();
            f += fArray[n2];
        }
        n2 = 0;
        while (n2 < n3) {
            int n4 = n2++;
            fArray[n4] = fArray[n4] / f;
        }
        n2 = 0;
        while (localizableCursor.hasNext()) {
            localizableCursor.fwd();
            if (n2 > n3) {
                ((FloatType)localizableCursor.getType()).setReal(fArray[n2 - n3 - 1]);
            }
            ++n2;
        }
        for (int i = 0; i < 100; ++i) {
            for (int j = 0; j < n; ++j) {
                localizableCursor.reset();
                float f2 = 0.0f;
                while (localizableCursor.hasNext()) {
                    localizableCursor.fwd();
                    if (localizableCursor.getPosition(j) == 1) continue;
                    f2 += ((FloatType)localizableCursor.getType()).get();
                }
                localizableCursor.reset();
                while (localizableCursor.hasNext()) {
                    localizableCursor.fwd();
                    if (localizableCursor.getPosition(j) == 1) continue;
                    ((FloatType)localizableCursor.getType()).set(((FloatType)localizableCursor.getType()).get() / f2);
                }
            }
        }
        localizableCursor.close();
        f = 0.0f;
        localizableCursor.reset();
        while (localizableCursor.hasNext()) {
            localizableCursor.fwd();
            f += ((FloatType)localizableCursor.getType()).get();
        }
        localizableCursor.reset();
        while (localizableCursor.hasNext()) {
            localizableCursor.fwd();
            ((FloatType)localizableCursor.getType()).set(((FloatType)localizableCursor.getType()).get() / f);
        }
        return image;
    }
}

