/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.fft;

import mpicbg.imglib.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhaseCorrelationPeak
implements Comparable<PhaseCorrelationPeak> {
    int[] position = null;
    int[] originalInvPCMPosition = null;
    float phaseCorrelationPeak = 0.0f;
    float crossCorrelationPeak = 0.0f;
    long numPixels = 0L;
    boolean sortPhaseCorrelation = true;

    public PhaseCorrelationPeak(int[] nArray, float f, float f2) {
        this.position = (int[])nArray.clone();
        this.phaseCorrelationPeak = f;
        this.crossCorrelationPeak = f2;
    }

    public PhaseCorrelationPeak(int[] nArray, float f) {
        this(nArray, f, 0.0f);
    }

    public PhaseCorrelationPeak(int[] nArray) {
        this(nArray, 0.0f, 0.0f);
    }

    public PhaseCorrelationPeak() {
        this(null, 0.0f, 0.0f);
    }

    public void setPosition(int[] nArray) {
        this.position = (int[])nArray.clone();
    }

    public void setOriginalInvPCMPosition(int[] nArray) {
        this.originalInvPCMPosition = nArray;
    }

    public void setPhaseCorrelationPeak(float f) {
        this.phaseCorrelationPeak = f;
    }

    public void setCrossCorrelationPeak(float f) {
        this.crossCorrelationPeak = f;
    }

    public void setSortPhaseCorrelation(boolean bl) {
        this.sortPhaseCorrelation = bl;
    }

    public void setNumPixels(long l) {
        this.numPixels = l;
    }

    public int[] getPosition() {
        return (int[])this.position.clone();
    }

    public int[] getOriginalInvPCMPosition() {
        return this.originalInvPCMPosition;
    }

    public float getPhaseCorrelationPeak() {
        return this.phaseCorrelationPeak;
    }

    public float getCrossCorrelationPeak() {
        return this.crossCorrelationPeak;
    }

    public boolean getSortPhaseCorrelation() {
        return this.sortPhaseCorrelation;
    }

    public long getNumPixels() {
        return this.numPixels;
    }

    @Override
    public int compareTo(PhaseCorrelationPeak phaseCorrelationPeak) {
        if (this.sortPhaseCorrelation) {
            if (this.phaseCorrelationPeak > phaseCorrelationPeak.phaseCorrelationPeak) {
                return 1;
            }
            if (this.phaseCorrelationPeak == phaseCorrelationPeak.phaseCorrelationPeak) {
                return 0;
            }
            return -1;
        }
        if (this.crossCorrelationPeak > phaseCorrelationPeak.crossCorrelationPeak) {
            return 1;
        }
        if (this.crossCorrelationPeak == phaseCorrelationPeak.crossCorrelationPeak) {
            if (this.numPixels >= phaseCorrelationPeak.numPixels) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public String toString() {
        if (this.originalInvPCMPosition == null) {
            return Util.printCoordinates((int[])this.position) + ", phaseCorrelationPeak = " + this.phaseCorrelationPeak + ", crossCorrelationPeak = " + this.crossCorrelationPeak;
        }
        return Util.printCoordinates((int[])this.position) + " [" + Util.printCoordinates((int[])this.originalInvPCMPosition) + "], phaseCorrelationPeak = " + this.phaseCorrelationPeak + ", crossCorrelationPeak = " + this.crossCorrelationPeak;
    }
}

