/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.fft;

import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.MultiThreaded;
import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.algorithm.fft.FFTFunctions;
import mpicbg.imglib.algorithm.fft.FourierTransform;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.numeric.ComplexType;
import mpicbg.imglib.type.numeric.RealType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InverseFourierTransform<T extends RealType<T>, S extends ComplexType<S>>
implements MultiThreaded,
OutputAlgorithm<T>,
Benchmark {
    final Image<S> fftImage;
    final int numDimensions;
    Image<T> image;
    T type;
    FourierTransform.Rearrangement rearrangement;
    String errorMessage = "";
    int numThreads;
    long processingTime;
    boolean scale;
    boolean inPlace;
    boolean cropBack;
    int[] originalSize;
    int[] originalOffset;
    float additionalNormalization;

    public InverseFourierTransform(Image<S> image, T t, FourierTransform.Rearrangement rearrangement, boolean bl, boolean bl2, boolean bl3, int[] nArray, int[] nArray2) {
        this.fftImage = image;
        this.type = t;
        this.numDimensions = image.getNumDimensions();
        this.rearrangement = rearrangement;
        this.scale = bl2;
        this.inPlace = bl;
        this.cropBack = bl3;
        this.additionalNormalization = 1.0f;
        if (nArray != null) {
            this.originalSize = (int[])nArray.clone();
        }
        if (nArray2 != null) {
            this.originalOffset = (int[])nArray2.clone();
        }
        this.setNumThreads();
    }

    public InverseFourierTransform(Image<S> image, FourierTransform<T, ?> fourierTransform) {
        this(image, fourierTransform.getImageType(), fourierTransform.getRearrangement(), false, true, true, fourierTransform.getFFTInputSize(), fourierTransform.getFFTInputOffset());
    }

    public InverseFourierTransform(Image<S> image, FourierTransform<?, ?> fourierTransform, T t) {
        this(image, t, fourierTransform.getRearrangement(), false, true, true, fourierTransform.getFFTInputSize(), fourierTransform.getFFTInputOffset());
    }

    public InverseFourierTransform(Image<S> image, T t) {
        this(image, t, FourierTransform.Rearrangement.REARRANGE_QUADRANTS, false, true, false, null, null);
    }

    public void setRearrangement(FourierTransform.Rearrangement rearrangement) {
        this.rearrangement = rearrangement;
    }

    public void setInPlaceTransform(boolean bl) {
        this.inPlace = bl;
    }

    public void setDoScaling(boolean bl) {
        this.scale = bl;
    }

    public void setCropBackToOriginalSize(boolean bl) {
        this.cropBack = bl;
    }

    public void setOriginalSize(int[] nArray) {
        this.originalSize = nArray;
    }

    public void setOriginalOffset(int[] nArray) {
        this.originalOffset = nArray;
    }

    public void setAdditionalNormalization(float f) {
        this.additionalNormalization = f;
    }

    public FourierTransform.Rearrangement getRearrangement() {
        return this.rearrangement;
    }

    public boolean getInPlaceTransform() {
        return this.inPlace;
    }

    public boolean getDoScaling() {
        return this.scale;
    }

    public boolean getCropBackToOriginalSize() {
        return this.cropBack;
    }

    public int[] getOriginalSize() {
        return (int[])this.originalSize.clone();
    }

    public int[] getOriginalOffset() {
        return (int[])this.originalOffset.clone();
    }

    public float getAdditionalNormalization() {
        return this.additionalNormalization;
    }

    public boolean process() {
        long l = System.currentTimeMillis();
        Image image = this.inPlace ? this.fftImage : this.fftImage.clone();
        if (this.rearrangement == FourierTransform.Rearrangement.REARRANGE_QUADRANTS) {
            FFTFunctions.rearrangeFFTQuadrants(image, this.getNumThreads());
        }
        this.image = FFTFunctions.computeInverseFFT(image, this.type, this.getNumThreads(), this.scale, this.cropBack, this.originalSize, this.originalOffset, this.additionalNormalization);
        if (!this.inPlace) {
            image.close();
        }
        this.processingTime = System.currentTimeMillis() - l;
        return true;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public void setNumThreads() {
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    public void setNumThreads(int n) {
        this.numThreads = n;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public Image<T> getResult() {
        return this.image;
    }

    public boolean checkInput() {
        if (this.errorMessage.length() > 0) {
            return false;
        }
        if (this.fftImage == null) {
            this.errorMessage = "Input image is null";
            return false;
        }
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

