/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.fft;

import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.MultiThreaded;
import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.algorithm.fft.FourierTransform;
import mpicbg.imglib.algorithm.fft.InverseFourierTransform;
import mpicbg.imglib.algorithm.gauss.GaussianConvolution;
import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyValueFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.complex.ComplexFloatType;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.imglib.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FourierConvolution<T extends RealType<T>, S extends RealType<S>>
implements MultiThreaded,
OutputAlgorithm<T>,
Benchmark {
    final int numDimensions;
    Image<T> image;
    Image<T> convolved;
    Image<S> kernel;
    Image<ComplexFloatType> kernelFFT;
    Image<ComplexFloatType> imgFFT;
    FourierTransform<T, ComplexFloatType> fftImage;
    final int[] kernelDim;
    String errorMessage = "";
    int numThreads;
    long processingTime;

    public FourierConvolution(Image<T> image, Image<S> image2) {
        this.numDimensions = image.getNumDimensions();
        this.image = image;
        this.kernel = image2;
        this.kernelDim = image2.getDimensions();
        this.kernelFFT = null;
        this.imgFFT = null;
        this.setNumThreads();
    }

    public boolean replaceImage(Image<T> image) {
        if (!image.getContainer().compareStorageContainerCompatibility(this.image.getContainer())) {
            this.errorMessage = "Image containers are not comparable, cannot exchange image";
            return false;
        }
        this.image = image;
        this.imgFFT = null;
        return true;
    }

    public boolean replaceKernel(Image<S> image) {
        if (!image.getContainer().compareStorageContainerCompatibility(this.kernel.getContainer())) {
            this.errorMessage = "Kernel containers are not comparable, cannot exchange image";
            return false;
        }
        this.kernel = image;
        this.kernelFFT = null;
        return true;
    }

    public static final Image<FloatType> createGaussianKernel(ContainerFactory containerFactory, double d, int n) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = d;
        }
        return FourierConvolution.createGaussianKernel(containerFactory, dArray);
    }

    public static final Image<FloatType> createGaussianKernel(ContainerFactory containerFactory, double[] dArray) {
        int n = dArray.length;
        int[] nArray = new int[n];
        double[][] dArrayArray = new double[n][];
        for (int i = 0; i < n; ++i) {
            dArrayArray[i] = Util.createGaussianKernel1DDouble((double)dArray[i], (boolean)true);
            nArray[i] = dArrayArray[i].length;
        }
        Image image = new ImageFactory((Type)new FloatType(), containerFactory).createImage(nArray);
        LocalizableByDimCursor localizableByDimCursor = image.createLocalizableByDimCursor();
        int[] nArray2 = new int[n];
        while (localizableByDimCursor.hasNext()) {
            localizableByDimCursor.fwd();
            localizableByDimCursor.getPosition(nArray2);
            double d = 1.0;
            for (int i = 0; i < n; ++i) {
                d *= dArrayArray[i][nArray2[i]];
            }
            ((FloatType)localizableByDimCursor.getType()).set((float)d);
        }
        localizableByDimCursor.close();
        return image;
    }

    public static final <T extends RealType<T>> Image<T> getGaussianKernel(ImageFactory<T> imageFactory, double d, int n) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = d;
        }
        return FourierConvolution.getGaussianKernel(imageFactory, dArray);
    }

    public static final <T extends RealType<T>> Image<T> getGaussianKernel(ImageFactory<T> imageFactory, double[] dArray) {
        int n = dArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = Util.getSuggestedKernelDiameter((double)dArray[i]);
        }
        Image image = imageFactory.createImage(nArray);
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray2[i] = image.getDimension(i) / 2;
        }
        LocalizableByDimCursor localizableByDimCursor = image.createLocalizableByDimCursor();
        localizableByDimCursor.setPosition(nArray2);
        ((RealType)localizableByDimCursor.getType()).setOne();
        localizableByDimCursor.close();
        GaussianConvolution gaussianConvolution = new GaussianConvolution(image, new OutOfBoundsStrategyValueFactory(), dArray);
        if (!gaussianConvolution.checkInput() || !gaussianConvolution.process()) {
            System.out.println("Gaussian Convolution failed: " + gaussianConvolution.getErrorMessage());
            return null;
        }
        image.close();
        return gaussianConvolution.getResult();
    }

    public boolean process() {
        Object object;
        long l = System.currentTimeMillis();
        if (this.imgFFT == null) {
            this.fftImage = new FourierTransform<T, ComplexFloatType>(this.image, new ComplexFloatType());
            this.fftImage.setNumThreads(this.getNumThreads());
            this.fftImage.setPreProcessing(FourierTransform.PreProcessing.EXTEND_MIRROR);
            this.fftImage.setRearrangement(FourierTransform.Rearrangement.UNCHANGED);
            object = (int[])this.kernelDim.clone();
            int n = 0;
            while (n < this.numDimensions) {
                Object object2 = object;
                int n2 = n++;
                object2[n2] = object2[n2] - true;
            }
            this.fftImage.setImageExtension((int[])object);
            if (!this.fftImage.checkInput() || !this.fftImage.process()) {
                this.errorMessage = "FFT of image failed: " + this.fftImage.getErrorMessage();
                return false;
            }
            this.imgFFT = this.fftImage.getResult();
        }
        if (this.kernelFFT == null) {
            object = this.imgFFT.getDimensions();
            object[0] = (this.imgFFT.getDimension(0) - 1) * 2;
            ImageFactory imageFactory = new ImageFactory(this.kernel.createType(), this.image.getContainer().getFactory());
            Image image = imageFactory.createImage((int[])object);
            LocalizableCursor localizableCursor = this.kernel.createLocalizableCursor();
            LocalizableByDimCursor localizableByDimCursor = image.createLocalizableByDimCursor();
            int[] nArray = new int[this.numDimensions];
            while (localizableCursor.hasNext()) {
                localizableCursor.next();
                localizableCursor.getPosition(nArray);
                for (int i = 0; i < this.numDimensions; ++i) {
                    nArray[i] = (nArray[i] - this.kernelDim[i] / 2 + object[i]) % object[i];
                }
                localizableByDimCursor.setPosition(nArray);
                ((RealType)localizableByDimCursor.getType()).set(localizableCursor.getType());
            }
            FourierTransform fourierTransform = new FourierTransform(image, new ComplexFloatType());
            fourierTransform.setNumThreads(this.getNumThreads());
            fourierTransform.setPreProcessing(FourierTransform.PreProcessing.NONE);
            fourierTransform.setRearrangement(this.fftImage.getRearrangement());
            if (!fourierTransform.checkInput() || !fourierTransform.process()) {
                this.errorMessage = "FFT of kernel failed: " + fourierTransform.getErrorMessage();
                return false;
            }
            image.close();
            this.kernelFFT = fourierTransform.getResult();
        }
        this.multiply(this.imgFFT, this.kernelFFT);
        object = new InverseFourierTransform<FourierTransform<T, ComplexFloatType>, ComplexFloatType>(this.imgFFT, this.fftImage);
        ((InverseFourierTransform)object).setInPlaceTransform(true);
        ((InverseFourierTransform)object).setNumThreads(this.getNumThreads());
        if (!((InverseFourierTransform)object).checkInput() || !((InverseFourierTransform)object).process()) {
            this.errorMessage = "InverseFFT of image failed: " + ((InverseFourierTransform)object).getErrorMessage();
            return false;
        }
        this.imgFFT.close();
        this.convolved = ((InverseFourierTransform)object).getResult();
        this.processingTime = System.currentTimeMillis() - l;
        return true;
    }

    protected void multiply(Image<ComplexFloatType> image, Image<ComplexFloatType> image2) {
        Cursor cursor = image.createCursor();
        Cursor cursor2 = image2.createCursor();
        while (cursor.hasNext()) {
            cursor.fwd();
            cursor2.fwd();
            ((ComplexFloatType)cursor.getType()).mul((ComplexFloatType)cursor2.getType());
        }
        cursor.close();
        cursor2.close();
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public void setNumThreads() {
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    public void setNumThreads(int n) {
        this.numThreads = n;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public Image<T> getResult() {
        return this.convolved;
    }

    public boolean checkInput() {
        if (this.errorMessage.length() > 0) {
            return false;
        }
        if (this.image == null) {
            this.errorMessage = "Input image is null";
            return false;
        }
        if (this.kernel == null) {
            this.errorMessage = "Kernel image is null";
            return false;
        }
        for (int i = 0; i < this.numDimensions; ++i) {
            if (this.kernel.getDimension(i) % 2 == 1) continue;
            this.errorMessage = "Kernel image has NO odd dimensionality in dim " + i + " (" + this.kernel.getDimension(i) + ")";
            return false;
        }
        return true;
    }

    public void close() {
        this.kernelFFT.close();
        this.image = null;
        this.convolved = null;
        this.kernel = null;
        this.kernelFFT = null;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

