/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.fft;

import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.numeric.NumericType;
import mpicbg.imglib.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bandpass<T extends NumericType<T>>
implements OutputAlgorithm<T>,
Benchmark {
    String errorMessage = "";
    boolean inPlace;
    boolean bandPass;
    Image<T> img;
    Image<T> output;
    int beginRadius;
    int endRadius;
    long processingTime;
    int[] origin;

    public Bandpass(Image<T> image, int n, int n2) {
        this.img = image;
        this.inPlace = false;
        this.bandPass = true;
        this.beginRadius = n;
        this.endRadius = n2;
        this.origin = image.createPositionArray();
        this.origin[0] = image.getDimension(0) - 1;
        for (int i = 1; i < this.origin.length; ++i) {
            this.origin[i] = image.getDimension(i) / 2;
        }
    }

    public void setImage(Image<T> image) {
        this.img = image;
    }

    public void setInPlace(boolean bl) {
        this.inPlace = bl;
    }

    public void setBandPass(boolean bl) {
        this.bandPass = bl;
    }

    public void setOrigin(int[] nArray) {
        this.origin = (int[])nArray.clone();
    }

    public void setBandPassRadius(int n, int n2) {
        this.beginRadius = n;
        this.endRadius = n2;
    }

    public Image<T> getImage() {
        return this.img;
    }

    public boolean getInPlace() {
        return this.inPlace;
    }

    public int getBeginBandPassRadius() {
        return this.beginRadius;
    }

    public int getEndBandPassRadius() {
        return this.endRadius;
    }

    public int[] getOrigin() {
        return this.origin;
    }

    public boolean process() {
        Image<T> image;
        long l = System.currentTimeMillis();
        if (this.inPlace) {
            image = this.img;
        } else {
            this.output = this.img.clone();
            image = this.output;
        }
        LocalizableCursor localizableCursor = image.createLocalizableCursor();
        int[] nArray = image.createPositionArray();
        boolean bl = this.bandPass;
        while (localizableCursor.hasNext()) {
            localizableCursor.fwd();
            localizableCursor.getPosition(nArray);
            float f = Util.computeDistance((int[])this.origin, (int[])nArray);
            if (bl) {
                if (!(f < (float)this.beginRadius) && !(f > (float)this.endRadius)) continue;
                ((NumericType)localizableCursor.getType()).setZero();
                continue;
            }
            if (!(f >= (float)this.beginRadius) || !(f <= (float)this.endRadius)) continue;
            ((NumericType)localizableCursor.getType()).setZero();
        }
        this.processingTime = System.currentTimeMillis() - l;
        return true;
    }

    public Image<T> getResult() {
        if (this.inPlace) {
            return this.img;
        }
        return this.output;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public boolean checkInput() {
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

