/*
 * Decompiled with CFR 0.152.
 */
package jcuda.jcublas;

public class JCuDoubleComplex {
    public double x;
    public double y;

    private JCuDoubleComplex() {
    }

    public static double cuCreal(JCuDoubleComplex jCuDoubleComplex) {
        return jCuDoubleComplex.x;
    }

    public static double cuCimag(JCuDoubleComplex jCuDoubleComplex) {
        return jCuDoubleComplex.y;
    }

    public static JCuDoubleComplex cuCmplx(double d, double d2) {
        JCuDoubleComplex jCuDoubleComplex = new JCuDoubleComplex();
        jCuDoubleComplex.x = d;
        jCuDoubleComplex.y = d2;
        return jCuDoubleComplex;
    }

    public static JCuDoubleComplex cuConj(JCuDoubleComplex jCuDoubleComplex) {
        return JCuDoubleComplex.cuCmplx(JCuDoubleComplex.cuCreal(jCuDoubleComplex), -JCuDoubleComplex.cuCimag(jCuDoubleComplex));
    }

    public static JCuDoubleComplex cuCadd(JCuDoubleComplex jCuDoubleComplex, JCuDoubleComplex jCuDoubleComplex2) {
        return JCuDoubleComplex.cuCmplx(JCuDoubleComplex.cuCreal(jCuDoubleComplex) + JCuDoubleComplex.cuCreal(jCuDoubleComplex2), JCuDoubleComplex.cuCimag(jCuDoubleComplex) + JCuDoubleComplex.cuCimag(jCuDoubleComplex2));
    }

    public static JCuDoubleComplex cuCmul(JCuDoubleComplex jCuDoubleComplex, JCuDoubleComplex jCuDoubleComplex2) {
        JCuDoubleComplex jCuDoubleComplex3 = JCuDoubleComplex.cuCmplx(JCuDoubleComplex.cuCreal(jCuDoubleComplex) * JCuDoubleComplex.cuCreal(jCuDoubleComplex2) - JCuDoubleComplex.cuCimag(jCuDoubleComplex) * JCuDoubleComplex.cuCimag(jCuDoubleComplex2), JCuDoubleComplex.cuCreal(jCuDoubleComplex) * JCuDoubleComplex.cuCimag(jCuDoubleComplex2) + JCuDoubleComplex.cuCimag(jCuDoubleComplex) * JCuDoubleComplex.cuCreal(jCuDoubleComplex2));
        return jCuDoubleComplex3;
    }

    public static JCuDoubleComplex cuCdiv(JCuDoubleComplex jCuDoubleComplex, JCuDoubleComplex jCuDoubleComplex2) {
        double d = Math.abs(JCuDoubleComplex.cuCreal(jCuDoubleComplex2)) + Math.abs(JCuDoubleComplex.cuCimag(jCuDoubleComplex2));
        double d2 = 1.0 / d;
        double d3 = JCuDoubleComplex.cuCreal(jCuDoubleComplex) * d2;
        double d4 = JCuDoubleComplex.cuCimag(jCuDoubleComplex) * d2;
        double d5 = JCuDoubleComplex.cuCreal(jCuDoubleComplex2) * d2;
        double d6 = JCuDoubleComplex.cuCimag(jCuDoubleComplex2) * d2;
        d = d5 * d5 + d6 * d6;
        d2 = 1.0 / d;
        JCuDoubleComplex jCuDoubleComplex3 = JCuDoubleComplex.cuCmplx((d3 * d5 + d4 * d6) * d2, (d4 * d5 - d3 * d6) * d2);
        return jCuDoubleComplex3;
    }

    public static double cuCabs(JCuDoubleComplex jCuDoubleComplex) {
        double d;
        double d2 = JCuDoubleComplex.cuCreal(jCuDoubleComplex);
        double d3 = JCuDoubleComplex.cuCimag(jCuDoubleComplex);
        if (d2 == 0.0) {
            return d3;
        }
        if (d3 == 0.0) {
            return d2;
        }
        if ((d2 = Math.sqrt(d2)) < (d3 = Math.sqrt(d3))) {
            d = d2;
            d2 = d3;
            d3 = d;
        }
        d = d3 / d2;
        return d2 * Math.sqrt(1.0 + d * d);
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }
}

