/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.tfloat.ref;

import hep.aida.tfloat.FloatIAxis;
import hep.aida.tfloat.FloatIHistogram2D;
import hep.aida.tfloat.FloatIHistogram3D;
import hep.aida.tfloat.ref.FloatAbstractHistogram3D;
import hep.aida.tfloat.ref.FloatFixedAxis;
import hep.aida.tfloat.ref.FloatHistogram2D;
import hep.aida.tfloat.ref.FloatVariableAxis;

public class FloatHistogram3D
extends FloatAbstractHistogram3D
implements FloatIHistogram3D {
    private float[][][] heights;
    private float[][][] errors;
    private int[][][] entries;
    private int nEntry;
    private float sumWeight;
    private float sumWeightSquared;
    private float meanX;
    private float rmsX;
    private float meanY;
    private float rmsY;
    private float meanZ;
    private float rmsZ;

    public FloatHistogram3D(String string, float[] fArray, float[] fArray2, float[] fArray3) {
        this(string, new FloatVariableAxis(fArray), new FloatVariableAxis(fArray2), new FloatVariableAxis(fArray3));
    }

    public FloatHistogram3D(String string, int n, float f, float f2, int n2, float f3, float f4, int n3, float f5, float f6) {
        this(string, new FloatFixedAxis(n, f, f2), new FloatFixedAxis(n2, f3, f4), new FloatFixedAxis(n3, f5, f6));
    }

    public FloatHistogram3D(String string, FloatIAxis floatIAxis, FloatIAxis floatIAxis2, FloatIAxis floatIAxis3) {
        super(string);
        this.xAxis = floatIAxis;
        this.yAxis = floatIAxis2;
        this.zAxis = floatIAxis3;
        int n = floatIAxis.bins();
        int n2 = floatIAxis2.bins();
        int n3 = floatIAxis3.bins();
        this.entries = new int[n + 2][n2 + 2][n3 + 2];
        this.heights = new float[n + 2][n2 + 2][n3 + 2];
        this.errors = new float[n + 2][n2 + 2][n3 + 2];
    }

    public int allEntries() {
        return this.nEntry;
    }

    public int binEntries(int n, int n2, int n3) {
        return this.entries[this.mapX(n)][this.mapY(n2)][this.mapZ(n3)];
    }

    public float binError(int n, int n2, int n3) {
        return (float)Math.sqrt(this.errors[this.mapX(n)][this.mapY(n2)][this.mapZ(n3)]);
    }

    public float binHeight(int n, int n2, int n3) {
        return this.heights[this.mapX(n)][this.mapY(n2)][this.mapZ(n3)];
    }

    public float equivalentBinEntries() {
        return this.sumWeight * this.sumWeight / this.sumWeightSquared;
    }

    public void fill(float f, float f2, float f3) {
        int n = this.mapX(this.xAxis.coordToIndex(f));
        int n2 = this.mapY(this.yAxis.coordToIndex(f2));
        int n3 = this.mapZ(this.zAxis.coordToIndex(f3));
        int[] nArray = this.entries[n][n2];
        int n4 = n3;
        nArray[n4] = nArray[n4] + 1;
        float[] fArray = this.heights[n][n2];
        int n5 = n3;
        fArray[n5] = fArray[n5] + 1.0f;
        float[] fArray2 = this.errors[n][n2];
        int n6 = n3;
        fArray2[n6] = fArray2[n6] + 1.0f;
        ++this.nEntry;
        this.sumWeight += 1.0f;
        this.sumWeightSquared += 1.0f;
        this.meanX += f;
        this.rmsX += f;
        this.meanY += f2;
        this.rmsY += f2;
        this.meanZ += f3;
        this.rmsZ += f3;
    }

    public void fill(float f, float f2, float f3, float f4) {
        int n = this.mapX(this.xAxis.coordToIndex(f));
        int n2 = this.mapY(this.yAxis.coordToIndex(f2));
        int n3 = this.mapZ(this.zAxis.coordToIndex(f3));
        int[] nArray = this.entries[n][n2];
        int n4 = n3;
        nArray[n4] = nArray[n4] + 1;
        float[] fArray = this.heights[n][n2];
        int n5 = n3;
        fArray[n5] = fArray[n5] + f4;
        float[] fArray2 = this.errors[n][n2];
        int n6 = n3;
        fArray2[n6] = fArray2[n6] + f4 * f4;
        ++this.nEntry;
        this.sumWeight += f4;
        this.sumWeightSquared += f4 * f4;
        this.meanX += f * f4;
        this.rmsX += f * f4 * f4;
        this.meanY += f2 * f4;
        this.rmsY += f2 * f4 * f4;
        this.meanZ += f3 * f4;
        this.rmsZ += f3 * f4 * f4;
    }

    protected FloatIHistogram2D internalSliceXY(String string, int n, int n2) {
        if (n2 < n) {
            throw new IllegalArgumentException("Invalid bin range");
        }
        int n3 = this.xAxis.bins() + 2;
        int n4 = this.yAxis.bins() + 2;
        int[][] nArray = new int[n3][n4];
        float[][] fArray = new float[n3][n4];
        float[][] fArray2 = new float[n3][n4];
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                for (int k = n; k <= n2; ++k) {
                    int[] nArray2 = nArray[i];
                    int n5 = j;
                    nArray2[n5] = nArray2[n5] + this.entries[i][j][k];
                    float[] fArray3 = fArray[i];
                    int n6 = j;
                    fArray3[n6] = fArray3[n6] + this.heights[i][j][k];
                    float[] fArray4 = fArray2[i];
                    int n7 = j;
                    fArray4[n7] = fArray4[n7] + this.errors[i][j][k];
                }
            }
        }
        FloatHistogram2D floatHistogram2D = new FloatHistogram2D(string, this.xAxis, this.yAxis);
        floatHistogram2D.setContents(nArray, fArray, fArray2);
        return floatHistogram2D;
    }

    protected FloatIHistogram2D internalSliceXZ(String string, int n, int n2) {
        if (n2 < n) {
            throw new IllegalArgumentException("Invalid bin range");
        }
        int n3 = this.xAxis.bins() + 2;
        int n4 = this.zAxis.bins() + 2;
        int[][] nArray = new int[n3][n4];
        float[][] fArray = new float[n3][n4];
        float[][] fArray2 = new float[n3][n4];
        for (int i = 0; i < n3; ++i) {
            for (int j = n; j <= n2; ++j) {
                int n5 = 0;
                while (i < n4) {
                    int[] nArray2 = nArray[i];
                    int n6 = n5;
                    nArray2[n6] = nArray2[n6] + this.entries[i][j][n5];
                    float[] fArray3 = fArray[i];
                    int n7 = n5;
                    fArray3[n7] = fArray3[n7] + this.heights[i][j][n5];
                    float[] fArray4 = fArray2[i];
                    int n8 = n5;
                    fArray4[n8] = fArray4[n8] + this.errors[i][j][n5];
                    ++n5;
                }
            }
        }
        FloatHistogram2D floatHistogram2D = new FloatHistogram2D(string, this.xAxis, this.zAxis);
        floatHistogram2D.setContents(nArray, fArray, fArray2);
        return floatHistogram2D;
    }

    protected FloatIHistogram2D internalSliceYZ(String string, int n, int n2) {
        if (n2 < n) {
            throw new IllegalArgumentException("Invalid bin range");
        }
        int n3 = this.yAxis.bins() + 2;
        int n4 = this.zAxis.bins() + 2;
        int[][] nArray = new int[n3][n4];
        float[][] fArray = new float[n3][n4];
        float[][] fArray2 = new float[n3][n4];
        for (int i = n; i <= n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < n4; ++k) {
                    int[] nArray2 = nArray[j];
                    int n5 = k;
                    nArray2[n5] = nArray2[n5] + this.entries[i][j][k];
                    float[] fArray3 = fArray[j];
                    int n6 = k;
                    fArray3[n6] = fArray3[n6] + this.heights[i][j][k];
                    float[] fArray4 = fArray2[j];
                    int n7 = k;
                    fArray4[n7] = fArray4[n7] + this.errors[i][j][k];
                }
            }
        }
        FloatHistogram2D floatHistogram2D = new FloatHistogram2D(string, this.yAxis, this.zAxis);
        floatHistogram2D.setContents(nArray, fArray, fArray2);
        return floatHistogram2D;
    }

    public float meanX() {
        return this.meanX / this.sumWeight;
    }

    public float meanY() {
        return this.meanY / this.sumWeight;
    }

    public float meanZ() {
        return this.meanZ / this.sumWeight;
    }

    public void reset() {
        for (int i = 0; i < this.entries.length; ++i) {
            for (int j = 0; j < this.entries[0].length; ++j) {
                int n = 0;
                while (j < this.entries[0][0].length) {
                    this.entries[i][j][n] = 0;
                    this.heights[i][j][n] = 0.0f;
                    this.errors[i][j][n] = 0.0f;
                    ++n;
                }
            }
        }
        this.nEntry = 0;
        this.sumWeight = 0.0f;
        this.sumWeightSquared = 0.0f;
        this.meanX = 0.0f;
        this.rmsX = 0.0f;
        this.meanY = 0.0f;
        this.rmsY = 0.0f;
        this.meanZ = 0.0f;
        this.rmsZ = 0.0f;
    }

    public float rmsX() {
        return (float)Math.sqrt(this.rmsX / this.sumWeight - this.meanX * this.meanX / this.sumWeight / this.sumWeight);
    }

    public float rmsY() {
        return (float)Math.sqrt(this.rmsY / this.sumWeight - this.meanY * this.meanY / this.sumWeight / this.sumWeight);
    }

    public float rmsZ() {
        return (float)Math.sqrt(this.rmsZ / this.sumWeight - this.meanZ * this.meanZ / this.sumWeight / this.sumWeight);
    }

    public float sumAllBinHeights() {
        return this.sumWeight;
    }
}

