/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.tfloat.ref;

import hep.aida.tfloat.FloatIAxis;
import hep.aida.tfloat.FloatIHistogram1D;
import hep.aida.tfloat.FloatIHistogram2D;
import hep.aida.tfloat.ref.FloatHistogram;

abstract class FloatAbstractHistogram2D
extends FloatHistogram
implements FloatIHistogram2D {
    protected FloatIAxis xAxis;
    protected FloatIAxis yAxis;

    FloatAbstractHistogram2D(String string) {
        super(string);
    }

    public int allEntries() {
        int n = 0;
        int n2 = this.xAxis.bins();
        while (--n2 >= -2) {
            int n3 = this.yAxis.bins();
            while (--n3 >= -2) {
                n += this.binEntries(n2, n3);
            }
        }
        return n;
    }

    public int binEntriesX(int n) {
        return this.projectionX().binEntries(n);
    }

    public int binEntriesY(int n) {
        return this.projectionY().binEntries(n);
    }

    public float binHeightX(int n) {
        return this.projectionX().binHeight(n);
    }

    public float binHeightY(int n) {
        return this.projectionY().binHeight(n);
    }

    public int dimensions() {
        return 2;
    }

    public int entries() {
        int n = 0;
        for (int i = 0; i < this.xAxis.bins(); ++i) {
            for (int j = 0; j < this.yAxis.bins(); ++j) {
                n += this.binEntries(i, j);
            }
        }
        return n;
    }

    public int extraEntries() {
        return this.allEntries() - this.entries();
    }

    public void fill(float f, float f2) {
        this.fill(f, f2, 1.0f);
    }

    protected abstract FloatIHistogram1D internalSliceX(String var1, int var2, int var3);

    protected abstract FloatIHistogram1D internalSliceY(String var1, int var2, int var3);

    int mapX(int n) {
        int n2 = this.xAxis.bins() + 2;
        if (n >= n2) {
            throw new IllegalArgumentException("bin=" + n);
        }
        if (n >= 0) {
            return n + 1;
        }
        if (n == -2) {
            return 0;
        }
        if (n == -1) {
            return n2 - 1;
        }
        throw new IllegalArgumentException("bin=" + n);
    }

    int mapY(int n) {
        int n2 = this.yAxis.bins() + 2;
        if (n >= n2) {
            throw new IllegalArgumentException("bin=" + n);
        }
        if (n >= 0) {
            return n + 1;
        }
        if (n == -2) {
            return 0;
        }
        if (n == -1) {
            return n2 - 1;
        }
        throw new IllegalArgumentException("bin=" + n);
    }

    public int[] minMaxBins() {
        float f = Float.MAX_VALUE;
        float f2 = Float.MIN_VALUE;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = this.xAxis.bins();
        while (--n5 >= 0) {
            int n6 = this.yAxis.bins();
            while (--n6 >= 0) {
                float f3 = this.binHeight(n5, n6);
                if (f3 < f) {
                    f = f3;
                    n = n5;
                    n2 = n6;
                }
                if (!(f3 > f2)) continue;
                f2 = f3;
                n3 = n5;
                n4 = n6;
            }
        }
        int[] nArray = new int[]{n, n2, n3, n4};
        return nArray;
    }

    public FloatIHistogram1D projectionX() {
        String string = this.title() + " (projectionX)";
        return this.internalSliceX(string, this.mapY(-2), this.mapY(-1));
    }

    public FloatIHistogram1D projectionY() {
        String string = this.title() + " (projectionY)";
        return this.internalSliceY(string, this.mapX(-2), this.mapX(-1));
    }

    public FloatIHistogram1D sliceX(int n) {
        int n2 = this.mapY(n);
        String string = this.title() + " (sliceX [" + n + "])";
        return this.internalSliceX(string, n2, n2);
    }

    public FloatIHistogram1D sliceX(int n, int n2) {
        int n3 = this.mapY(n);
        int n4 = this.mapY(n2);
        String string = this.title() + " (sliceX [" + n + ":" + n2 + "])";
        return this.internalSliceX(string, n3, n4);
    }

    public FloatIHistogram1D sliceY(int n) {
        int n2 = this.mapX(n);
        String string = this.title() + " (sliceY [" + n + "])";
        return this.internalSliceY(string, n2, n2);
    }

    public FloatIHistogram1D sliceY(int n, int n2) {
        int n3 = this.mapX(n);
        int n4 = this.mapX(n2);
        String string = this.title() + " (slicey [" + n + ":" + n2 + "])";
        return this.internalSliceY(string, n3, n4);
    }

    public float sumAllBinHeights() {
        float f = 0.0f;
        int n = this.xAxis.bins();
        while (--n >= -2) {
            int n2 = this.yAxis.bins();
            while (--n2 >= -2) {
                f += this.binHeight(n, n2);
            }
        }
        return f;
    }

    public float sumBinHeights() {
        float f = 0.0f;
        for (int i = 0; i < this.xAxis.bins(); ++i) {
            for (int j = 0; j < this.yAxis.bins(); ++j) {
                f += this.binHeight(i, j);
            }
        }
        return f;
    }

    public float sumExtraBinHeights() {
        return this.sumAllBinHeights() - this.sumBinHeights();
    }

    public FloatIAxis xAxis() {
        return this.xAxis;
    }

    public FloatIAxis yAxis() {
        return this.yAxis;
    }
}

