/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.tfloat.quantile;

import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tobject.ObjectArrayList;
import cern.jet.random.tfloat.engine.FloatRandomEngine;
import cern.jet.random.tfloat.sampling.WeightedFloatRandomSampler;
import cern.jet.stat.Utils;
import cern.jet.stat.tfloat.quantile.FloatBuffer;
import cern.jet.stat.tfloat.quantile.FloatQuantileEstimator;
import java.util.Comparator;

class UnknownFloatQuantileEstimator
extends FloatQuantileEstimator {
    protected int currentTreeHeight;
    protected final int treeHeightStartingSampling;
    protected WeightedFloatRandomSampler sampler;
    protected float precomputeEpsilon;

    public UnknownFloatQuantileEstimator(int n, int n2, int n3, float f, FloatRandomEngine floatRandomEngine) {
        this.sampler = new WeightedFloatRandomSampler(1, floatRandomEngine);
        this.setUp(n, n2);
        this.treeHeightStartingSampling = n3;
        this.precomputeEpsilon = f;
        this.clear();
    }

    protected FloatBuffer[] buffersToCollapse() {
        FloatBuffer[] floatBufferArray = this.bufferSet._getFullOrPartialBuffers();
        UnknownFloatQuantileEstimator.sortAscendingByLevel(floatBufferArray);
        int n = floatBufferArray[1].level();
        if (floatBufferArray[0].level() < n) {
            floatBufferArray[0].level(n);
        }
        return this.bufferSet._getFullOrPartialBuffersWithLevel(n);
    }

    public synchronized void clear() {
        super.clear();
        this.currentTreeHeight = 1;
        this.sampler.setWeight(1);
    }

    public Object clone() {
        UnknownFloatQuantileEstimator unknownFloatQuantileEstimator = (UnknownFloatQuantileEstimator)super.clone();
        if (this.sampler != null) {
            unknownFloatQuantileEstimator.sampler = (WeightedFloatRandomSampler)unknownFloatQuantileEstimator.sampler.clone();
        }
        return unknownFloatQuantileEstimator;
    }

    protected void newBuffer() {
        this.currentBufferToFill = this.bufferSet._getFirstEmptyBuffer();
        if (this.currentBufferToFill == null) {
            throw new RuntimeException("Oops, no empty buffer.");
        }
        this.currentBufferToFill.level(this.currentTreeHeight - 1);
        this.currentBufferToFill.weight(this.sampler.getWeight());
    }

    protected void postCollapse(FloatBuffer[] floatBufferArray) {
        if (floatBufferArray.length == this.bufferSet.b()) {
            ++this.currentTreeHeight;
            if (this.currentTreeHeight >= this.treeHeightStartingSampling) {
                this.sampler.setWeight(this.sampler.getWeight() * 2);
            }
        }
    }

    public FloatArrayList quantileElements(FloatArrayList floatArrayList) {
        if ((double)this.precomputeEpsilon <= 0.0) {
            return super.quantileElements(floatArrayList);
        }
        int n = (int)Utils.epsilonCeiling(1.0 / (double)this.precomputeEpsilon);
        floatArrayList = floatArrayList.copy();
        float f = this.precomputeEpsilon;
        int n2 = floatArrayList.size();
        while (--n2 >= 0) {
            float f2 = floatArrayList.get(n2);
            int n3 = (int)Math.round((2.0 * (double)f2 / (double)f - 1.0) / 2.0);
            n3 = Math.min(n - 1, Math.max(0, n3));
            float f3 = f / 2.0f * (float)(1 + 2 * n3);
            floatArrayList.set(n2, f3);
        }
        return super.quantileElements(floatArrayList);
    }

    protected boolean sampleNextElement() {
        return this.sampler.sampleNextElement();
    }

    protected static void sortAscendingByLevel(FloatBuffer[] floatBufferArray) {
        new ObjectArrayList(floatBufferArray).quickSortFromTo(0, floatBufferArray.length - 1, new Comparator(){

            public int compare(Object object, Object object2) {
                int n;
                int n2 = ((FloatBuffer)object).level();
                return n2 < (n = ((FloatBuffer)object2).level()) ? -1 : (n2 == n ? 0 : 1);
            }
        });
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer + ", h=" + this.currentTreeHeight + ", hStartSampling=" + this.treeHeightStartingSampling + ", precomputeEpsilon=" + this.precomputeEpsilon + ")";
    }
}

