/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.tfloat.quantile;

import cern.colt.list.tfloat.FloatArrayList;
import cern.jet.math.tfloat.FloatArithmetic;
import cern.jet.random.tfloat.engine.FloatRandomEngine;
import cern.jet.random.tfloat.sampling.FloatRandomSamplingAssistant;
import cern.jet.stat.tfloat.quantile.FloatBuffer;
import cern.jet.stat.tfloat.quantile.FloatQuantileEstimator;

class KnownFloatQuantileEstimator
extends FloatQuantileEstimator {
    protected float beta;
    protected boolean weHadMoreThanOneEmptyBuffer;
    protected FloatRandomSamplingAssistant samplingAssistant;
    protected float samplingRate;
    protected long N;

    public KnownFloatQuantileEstimator(int n, int n2, long l, float f, FloatRandomEngine floatRandomEngine) {
        this.samplingRate = f;
        this.N = l;
        this.samplingAssistant = (double)this.samplingRate <= 1.0 ? null : new FloatRandomSamplingAssistant(FloatArithmetic.floor((float)l / f), l, floatRandomEngine);
        this.setUp(n, n2);
        this.clear();
    }

    protected void addInfinities(int n, FloatBuffer floatBuffer) {
        FloatRandomSamplingAssistant floatRandomSamplingAssistant = this.samplingAssistant;
        this.samplingAssistant = null;
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            if (bl) {
                floatBuffer.values.add(Float.MAX_VALUE);
            } else {
                floatBuffer.values.add(-3.4028235E38f);
            }
            bl = !bl;
        }
        this.samplingAssistant = floatRandomSamplingAssistant;
    }

    protected FloatBuffer[] buffersToCollapse() {
        int n = this.bufferSet._getMinLevelOfFullOrPartialBuffers();
        return this.bufferSet._getFullOrPartialBuffersWithLevel(n);
    }

    public void clear() {
        super.clear();
        this.beta = 1.0f;
        this.weHadMoreThanOneEmptyBuffer = false;
        FloatRandomSamplingAssistant floatRandomSamplingAssistant = this.samplingAssistant;
        if (floatRandomSamplingAssistant != null) {
            this.samplingAssistant = new FloatRandomSamplingAssistant(FloatArithmetic.floor((float)this.N / this.samplingRate), this.N, floatRandomSamplingAssistant.getRandomGenerator());
        }
    }

    public Object clone() {
        KnownFloatQuantileEstimator knownFloatQuantileEstimator = (KnownFloatQuantileEstimator)super.clone();
        if (this.samplingAssistant != null) {
            knownFloatQuantileEstimator.samplingAssistant = (FloatRandomSamplingAssistant)knownFloatQuantileEstimator.samplingAssistant.clone();
        }
        return knownFloatQuantileEstimator;
    }

    protected void newBuffer() {
        int n = this.bufferSet._getNumberOfEmptyBuffers();
        if (n == 0) {
            throw new RuntimeException("Oops, no empty buffer.");
        }
        this.currentBufferToFill = this.bufferSet._getFirstEmptyBuffer();
        if (n == 1 && !this.weHadMoreThanOneEmptyBuffer) {
            this.currentBufferToFill.level(this.bufferSet._getMinLevelOfFullOrPartialBuffers());
        } else {
            this.weHadMoreThanOneEmptyBuffer = true;
            this.currentBufferToFill.level(0);
        }
        this.currentBufferToFill.weight(1);
    }

    protected void postCollapse(FloatBuffer[] floatBufferArray) {
        this.weHadMoreThanOneEmptyBuffer = false;
    }

    protected FloatArrayList preProcessPhis(FloatArrayList floatArrayList) {
        if ((double)this.beta > 1.0) {
            floatArrayList = floatArrayList.copy();
            int n = floatArrayList.size();
            while (--n >= 0) {
                floatArrayList.set(n, (2.0f * floatArrayList.get(n) + this.beta - 1.0f) / (2.0f * this.beta));
            }
        }
        return floatArrayList;
    }

    public FloatArrayList quantileElements(FloatArrayList floatArrayList) {
        FloatBuffer floatBuffer = this.bufferSet._getPartialBuffer();
        int n = 0;
        if (floatBuffer != null) {
            n = this.bufferSet.k() - floatBuffer.size();
            if (n <= 0) {
                throw new RuntimeException("Oops! illegal missing values.");
            }
            this.addInfinities(n, floatBuffer);
            this.beta = (float)(this.totalElementsFilled + n) / (float)this.totalElementsFilled;
        } else {
            this.beta = 1.0f;
        }
        FloatArrayList floatArrayList2 = super.quantileElements(floatArrayList);
        if (floatBuffer != null) {
            this.removeInfinitiesFrom(n, floatBuffer);
        }
        return floatArrayList2;
    }

    protected void removeInfinitiesFrom(int n, FloatBuffer floatBuffer) {
        int n2 = 0;
        int n3 = 0;
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            if (bl) {
                ++n2;
            } else {
                ++n3;
            }
            bl = !bl;
        }
        floatBuffer.values.removeFromTo(floatBuffer.size() - n2, floatBuffer.size() - 1);
        floatBuffer.values.removeFromTo(0, n3 - 1);
    }

    protected boolean sampleNextElement() {
        if (this.samplingAssistant == null) {
            return true;
        }
        return this.samplingAssistant.sampleNextElement();
    }
}

