/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.tfloat.quantile;

import cern.colt.list.tfloat.FloatArrayList;
import cern.jet.stat.Buffer;
import cern.jet.stat.tfloat.FloatDescriptive;

class FloatBuffer
extends Buffer {
    protected FloatArrayList values = new FloatArrayList(0);
    protected boolean isSorted = false;

    public FloatBuffer(int n) {
        super(n);
    }

    public void add(float f) {
        if (!this.isAllocated) {
            this.allocate();
        }
        this.values.add(f);
        this.isSorted = false;
    }

    public void addAllOfFromTo(FloatArrayList floatArrayList, int n, int n2) {
        if (!this.isAllocated) {
            this.allocate();
        }
        this.values.addAllOfFromTo(floatArrayList, n, n2);
        this.isSorted = false;
    }

    protected void allocate() {
        this.isAllocated = true;
        this.values.ensureCapacity(this.k);
    }

    public void clear() {
        this.values.clear();
    }

    public Object clone() {
        FloatBuffer floatBuffer = (FloatBuffer)super.clone();
        if (this.values != null) {
            floatBuffer.values = floatBuffer.values.copy();
        }
        return floatBuffer;
    }

    public boolean contains(float f) {
        this.sort();
        return this.values.contains(f);
    }

    public boolean isEmpty() {
        return this.values.size() == 0;
    }

    public boolean isFull() {
        return this.values.size() == this.k;
    }

    public int memory() {
        return this.values.elements().length;
    }

    public float rank(float f) {
        this.sort();
        return FloatDescriptive.rankInterpolated(this.values, f);
    }

    public int size() {
        return this.values.size();
    }

    public void sort() {
        if (!this.isSorted) {
            this.values.sort();
            this.isSorted = true;
        }
    }

    public String toString() {
        return "k=" + this.k + ", w=" + Long.toString(this.weight()) + ", l=" + Integer.toString(this.level()) + ", size=" + this.values.size();
    }
}

