/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.tdouble.quantile;

import cern.colt.list.tdouble.DoubleArrayList;
import cern.jet.math.tdouble.DoubleArithmetic;
import cern.jet.random.tdouble.engine.DoubleRandomEngine;
import cern.jet.random.tdouble.sampling.DoubleRandomSamplingAssistant;
import cern.jet.stat.tdouble.quantile.DoubleBuffer;
import cern.jet.stat.tdouble.quantile.DoubleQuantileEstimator;

class KnownDoubleQuantileEstimator
extends DoubleQuantileEstimator {
    protected double beta;
    protected boolean weHadMoreThanOneEmptyBuffer;
    protected DoubleRandomSamplingAssistant samplingAssistant;
    protected double samplingRate;
    protected long N;

    public KnownDoubleQuantileEstimator(int n, int n2, long l, double d, DoubleRandomEngine doubleRandomEngine) {
        this.samplingRate = d;
        this.N = l;
        this.samplingAssistant = this.samplingRate <= 1.0 ? null : new DoubleRandomSamplingAssistant(DoubleArithmetic.floor((double)l / d), l, doubleRandomEngine);
        this.setUp(n, n2);
        this.clear();
    }

    protected void addInfinities(int n, DoubleBuffer doubleBuffer) {
        DoubleRandomSamplingAssistant doubleRandomSamplingAssistant = this.samplingAssistant;
        this.samplingAssistant = null;
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            if (bl) {
                doubleBuffer.values.add(Double.MAX_VALUE);
            } else {
                doubleBuffer.values.add(-1.7976931348623157E308);
            }
            bl = !bl;
        }
        this.samplingAssistant = doubleRandomSamplingAssistant;
    }

    protected DoubleBuffer[] buffersToCollapse() {
        int n = this.bufferSet._getMinLevelOfFullOrPartialBuffers();
        return this.bufferSet._getFullOrPartialBuffersWithLevel(n);
    }

    public void clear() {
        super.clear();
        this.beta = 1.0;
        this.weHadMoreThanOneEmptyBuffer = false;
        DoubleRandomSamplingAssistant doubleRandomSamplingAssistant = this.samplingAssistant;
        if (doubleRandomSamplingAssistant != null) {
            this.samplingAssistant = new DoubleRandomSamplingAssistant(DoubleArithmetic.floor((double)this.N / this.samplingRate), this.N, doubleRandomSamplingAssistant.getRandomGenerator());
        }
    }

    public Object clone() {
        KnownDoubleQuantileEstimator knownDoubleQuantileEstimator = (KnownDoubleQuantileEstimator)super.clone();
        if (this.samplingAssistant != null) {
            knownDoubleQuantileEstimator.samplingAssistant = (DoubleRandomSamplingAssistant)knownDoubleQuantileEstimator.samplingAssistant.clone();
        }
        return knownDoubleQuantileEstimator;
    }

    protected void newBuffer() {
        int n = this.bufferSet._getNumberOfEmptyBuffers();
        if (n == 0) {
            throw new RuntimeException("Oops, no empty buffer.");
        }
        this.currentBufferToFill = this.bufferSet._getFirstEmptyBuffer();
        if (n == 1 && !this.weHadMoreThanOneEmptyBuffer) {
            this.currentBufferToFill.level(this.bufferSet._getMinLevelOfFullOrPartialBuffers());
        } else {
            this.weHadMoreThanOneEmptyBuffer = true;
            this.currentBufferToFill.level(0);
        }
        this.currentBufferToFill.weight(1);
    }

    protected void postCollapse(DoubleBuffer[] doubleBufferArray) {
        this.weHadMoreThanOneEmptyBuffer = false;
    }

    protected DoubleArrayList preProcessPhis(DoubleArrayList doubleArrayList) {
        if (this.beta > 1.0) {
            doubleArrayList = doubleArrayList.copy();
            int n = doubleArrayList.size();
            while (--n >= 0) {
                doubleArrayList.set(n, (2.0 * doubleArrayList.get(n) + this.beta - 1.0) / (2.0 * this.beta));
            }
        }
        return doubleArrayList;
    }

    public DoubleArrayList quantileElements(DoubleArrayList doubleArrayList) {
        DoubleBuffer doubleBuffer = this.bufferSet._getPartialBuffer();
        int n = 0;
        if (doubleBuffer != null) {
            n = this.bufferSet.k() - doubleBuffer.size();
            if (n <= 0) {
                throw new RuntimeException("Oops! illegal missing values.");
            }
            this.addInfinities(n, doubleBuffer);
            this.beta = (double)(this.totalElementsFilled + n) / (double)this.totalElementsFilled;
        } else {
            this.beta = 1.0;
        }
        DoubleArrayList doubleArrayList2 = super.quantileElements(doubleArrayList);
        if (doubleBuffer != null) {
            this.removeInfinitiesFrom(n, doubleBuffer);
        }
        return doubleArrayList2;
    }

    protected void removeInfinitiesFrom(int n, DoubleBuffer doubleBuffer) {
        int n2 = 0;
        int n3 = 0;
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            if (bl) {
                ++n2;
            } else {
                ++n3;
            }
            bl = !bl;
        }
        doubleBuffer.values.removeFromTo(doubleBuffer.size() - n2, doubleBuffer.size() - 1);
        doubleBuffer.values.removeFromTo(0, n3 - 1);
    }

    protected boolean sampleNextElement() {
        if (this.samplingAssistant == null) {
            return true;
        }
        return this.samplingAssistant.sampleNextElement();
    }
}

