/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.tdouble.quantile;

import cern.colt.PersistentObject;
import cern.colt.function.tdouble.DoubleProcedure;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tobject.ObjectArrayList;
import cern.jet.stat.Utils;
import cern.jet.stat.tdouble.quantile.DoubleBuffer;
import cern.jet.stat.tdouble.quantile.DoubleBufferSet;
import cern.jet.stat.tdouble.quantile.DoubleQuantileFinder;

abstract class DoubleQuantileEstimator
extends PersistentObject
implements DoubleQuantileFinder {
    protected DoubleBufferSet bufferSet;
    protected DoubleBuffer currentBufferToFill;
    protected int totalElementsFilled;

    protected DoubleQuantileEstimator() {
    }

    public void add(double d) {
        ++this.totalElementsFilled;
        if (!this.sampleNextElement()) {
            return;
        }
        if (this.currentBufferToFill == null) {
            if (this.bufferSet._getFirstEmptyBuffer() == null) {
                this.collapse();
            }
            this.newBuffer();
        }
        this.currentBufferToFill.add(d);
        if (this.currentBufferToFill.isFull()) {
            this.currentBufferToFill = null;
        }
    }

    public void addAllOf(DoubleArrayList doubleArrayList) {
        this.addAllOfFromTo(doubleArrayList, 0, doubleArrayList.size() - 1);
    }

    public void addAllOfFromTo(DoubleArrayList doubleArrayList, int n, int n2) {
        int n3;
        double[] dArray = doubleArrayList.elements();
        int n4 = n3 = this.bufferSet.k();
        double[] dArray2 = null;
        if (this.currentBufferToFill != null) {
            dArray2 = this.currentBufferToFill.values.elements();
            n4 = this.currentBufferToFill.size();
        }
        int n5 = n - 1;
        while (++n5 <= n2) {
            if (!this.sampleNextElement()) continue;
            if (n4 == n3) {
                if (this.bufferSet._getFirstEmptyBuffer() == null) {
                    this.collapse();
                }
                this.newBuffer();
                if (!this.currentBufferToFill.isAllocated) {
                    this.currentBufferToFill.allocate();
                }
                this.currentBufferToFill.isSorted = false;
                dArray2 = this.currentBufferToFill.values.elements();
                n4 = 0;
            }
            dArray2[n4++] = dArray[n5];
            if (n4 != n3) continue;
            this.currentBufferToFill.values.setSize(n4);
            this.currentBufferToFill = null;
        }
        if (this.currentBufferToFill != null) {
            this.currentBufferToFill.values.setSize(n4);
        }
        this.totalElementsFilled += n2 - n + 1;
    }

    protected DoubleBuffer[] buffersToCollapse() {
        int n = this.bufferSet._getMinLevelOfFullOrPartialBuffers();
        return this.bufferSet._getFullOrPartialBuffersWithLevel(n);
    }

    public void clear() {
        this.totalElementsFilled = 0;
        this.currentBufferToFill = null;
        this.bufferSet.clear();
    }

    public Object clone() {
        DoubleQuantileEstimator doubleQuantileEstimator = (DoubleQuantileEstimator)super.clone();
        if (this.bufferSet != null) {
            doubleQuantileEstimator.bufferSet = (DoubleBufferSet)doubleQuantileEstimator.bufferSet.clone();
            if (this.currentBufferToFill != null) {
                int n = new ObjectArrayList(this.bufferSet.buffers).indexOf(this.currentBufferToFill, true);
                doubleQuantileEstimator.currentBufferToFill = doubleQuantileEstimator.bufferSet.buffers[n];
            }
        }
        return doubleQuantileEstimator;
    }

    protected void collapse() {
        DoubleBuffer[] doubleBufferArray = this.buffersToCollapse();
        DoubleBuffer doubleBuffer = this.bufferSet.collapse(doubleBufferArray);
        int n = doubleBufferArray[0].level();
        doubleBuffer.level(n + 1);
        this.postCollapse(doubleBufferArray);
    }

    public boolean contains(double d) {
        return this.bufferSet.contains(d);
    }

    public boolean forEach(DoubleProcedure doubleProcedure) {
        return this.bufferSet.forEach(doubleProcedure);
    }

    public long memory() {
        return this.bufferSet.memory();
    }

    protected abstract void newBuffer();

    public double phi(double d) {
        return this.bufferSet.phi(d);
    }

    protected abstract void postCollapse(DoubleBuffer[] var1);

    protected DoubleArrayList preProcessPhis(DoubleArrayList doubleArrayList) {
        return doubleArrayList;
    }

    public DoubleArrayList quantileElements(DoubleArrayList doubleArrayList) {
        doubleArrayList = this.preProcessPhis(doubleArrayList);
        long[] lArray = new long[doubleArrayList.size()];
        long l = this.bufferSet.totalSize();
        int n = doubleArrayList.size();
        while (--n >= 0) {
            lArray[n] = Utils.epsilonCeiling(doubleArrayList.get(n) * (double)l) - 1L;
        }
        DoubleBuffer[] doubleBufferArray = this.bufferSet._getFullOrPartialBuffers();
        double[] dArray = new double[doubleArrayList.size()];
        return new DoubleArrayList(this.bufferSet.getValuesAtPositions(doubleBufferArray, lArray));
    }

    protected abstract boolean sampleNextElement();

    protected void setUp(int n, int n2) {
        if (n < 2 || n2 < 1) {
            throw new IllegalArgumentException("Assertion: b>=2 && k>=1");
        }
        this.bufferSet = new DoubleBufferSet(n, n2);
        this.clear();
    }

    public long size() {
        return this.totalElementsFilled;
    }

    public String toString() {
        String string = this.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1);
        int n = this.bufferSet.b();
        int n2 = this.bufferSet.k();
        return string + "(mem=" + this.memory() + ", b=" + n + ", k=" + n2 + ", size=" + this.size() + ", totalSize=" + this.bufferSet.totalSize() + ")";
    }

    public long totalMemory() {
        return this.bufferSet.b() * this.bufferSet.k();
    }
}

