/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random.tfloat;

import cern.jet.random.tfloat.AbstractContinousFloatDistribution;
import cern.jet.random.tfloat.engine.FloatMersenneTwister;
import cern.jet.random.tfloat.engine.FloatRandomEngine;

public class FloatUniform
extends AbstractContinousFloatDistribution {
    protected float min;
    protected float max;
    protected static FloatUniform shared = new FloatUniform(FloatUniform.makeDefaultGenerator());

    public FloatUniform(float f, float f2, int n) {
        this(f, f2, new FloatMersenneTwister(n));
    }

    public FloatUniform(float f, float f2, FloatRandomEngine floatRandomEngine) {
        this.setRandomGenerator(floatRandomEngine);
        this.setState(f, f2);
    }

    public FloatUniform(FloatRandomEngine floatRandomEngine) {
        this(0.0f, 1.0f, floatRandomEngine);
    }

    public float cdf(float f) {
        if (f <= this.min) {
            return 0.0f;
        }
        if (f >= this.max) {
            return 1.0f;
        }
        return (f - this.min) / (this.max - this.min);
    }

    public boolean nextBoolean() {
        return (double)this.randomGenerator.raw() > 0.5;
    }

    public float nextFloat() {
        return this.min + (this.max - this.min) * this.randomGenerator.raw();
    }

    public float nextFloatFromTo(float f, float f2) {
        return f + (f2 - f) * this.randomGenerator.raw();
    }

    public int nextInt() {
        return this.nextIntFromTo(Math.round(this.min), Math.round(this.max));
    }

    public int nextIntFromTo(int n, int n2) {
        return (int)((long)n + (long)((float)(1L + (long)n2 - (long)n) * this.randomGenerator.raw()));
    }

    public long nextLongFromTo(long l, long l2) {
        long l3;
        if (l >= 0L && l2 < Long.MAX_VALUE) {
            return l + (long)this.nextFloatFromTo(0.0f, l2 - l + 1L);
        }
        float f = (float)l2 - (float)l + 1.0f;
        if (f <= 9.223372E18f) {
            return l + (long)this.nextFloatFromTo(0.0f, f);
        }
        if (l == Long.MIN_VALUE) {
            if (l2 == Long.MAX_VALUE) {
                int n = this.nextIntFromTo(Integer.MIN_VALUE, Integer.MAX_VALUE);
                int n2 = this.nextIntFromTo(Integer.MIN_VALUE, Integer.MAX_VALUE);
                return ((long)n & 0xFFFFFFFFL) << 32 | (long)n2 & 0xFFFFFFFFL;
            }
            l3 = Math.round(this.nextFloatFromTo(l, l2 + 1L));
            if (l3 > l2) {
                l3 = l;
            }
        } else {
            l3 = Math.round(this.nextFloatFromTo(l - 1L, l2));
            if (l3 < l) {
                l3 = l2;
            }
        }
        return l3;
    }

    public float pdf(float f) {
        if (f <= this.min || f >= this.max) {
            return 0.0f;
        }
        return (float)(1.0 / (double)(this.max - this.min));
    }

    public void setState(float f, float f2) {
        if (f2 < f) {
            this.setState(f2, f);
            return;
        }
        this.min = f;
        this.max = f2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean staticNextBoolean() {
        FloatUniform floatUniform = shared;
        synchronized (floatUniform) {
            return shared.nextBoolean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float staticNextFloat() {
        FloatUniform floatUniform = shared;
        synchronized (floatUniform) {
            return shared.nextFloat();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float staticNextFloatFromTo(float f, float f2) {
        FloatUniform floatUniform = shared;
        synchronized (floatUniform) {
            return shared.nextFloatFromTo(f, f2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int staticNextIntFromTo(int n, int n2) {
        FloatUniform floatUniform = shared;
        synchronized (floatUniform) {
            return shared.nextIntFromTo(n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long staticNextLongFromTo(long l, long l2) {
        FloatUniform floatUniform = shared;
        synchronized (floatUniform) {
            return shared.nextLongFromTo(l, l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void staticSetRandomEngine(FloatRandomEngine floatRandomEngine) {
        FloatUniform floatUniform = shared;
        synchronized (floatUniform) {
            shared.setRandomGenerator(floatRandomEngine);
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.min + "," + this.max + ")";
    }
}

