/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.colt.PersistentObject;
import cern.colt.Timer;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.jet.random.tdouble.AbstractDoubleDistribution;
import cern.jet.random.tdouble.Gamma;
import cern.jet.random.tdouble.Poisson;
import cern.jet.random.tdouble.engine.DoubleMersenneTwister;
import cern.jet.random.tdouble.engine.DoubleRandomEngine;
import hep.aida.tdouble.bin.DynamicDoubleBin1D;

public class Benchmark
extends PersistentObject {
    protected DoubleRandomEngine randomGenerator;

    protected Benchmark() {
        throw new RuntimeException("Non instantiable");
    }

    public static void demo1() {
        double d = 5.0;
        double d2 = 1.5;
        double d3 = d * d / d2;
        double d4 = 1.0 / (d2 / d);
        DoubleMersenneTwister doubleMersenneTwister = new DoubleMersenneTwister();
        Gamma gamma = new Gamma(d3, d4, doubleMersenneTwister);
        int n = 100000;
        DoubleArrayList doubleArrayList = new DoubleArrayList(n);
        for (int i = 0; i < n; ++i) {
            doubleArrayList.add(((AbstractDoubleDistribution)gamma).nextDouble());
        }
        DynamicDoubleBin1D dynamicDoubleBin1D = new DynamicDoubleBin1D();
        dynamicDoubleBin1D.addAllOf(doubleArrayList);
        System.out.println(dynamicDoubleBin1D);
    }

    public static void main(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        boolean bl = new Boolean(stringArray[1]);
        double d = new Double(stringArray[2]);
        String string = stringArray[3];
        Benchmark.random(n, bl, d, string);
    }

    public static void random(int n, boolean bl, double d, String string) {
        DoubleRandomEngine doubleRandomEngine;
        System.out.println("Generating " + n + " random numbers per distribution...\n");
        int n2 = 100;
        try {
            doubleRandomEngine = (DoubleRandomEngine)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw new InternalError(exception.getMessage());
        }
        Benchmark.randomInstance(n, bl, new Poisson(d, (DoubleRandomEngine)doubleRandomEngine.clone()));
    }

    public static void randomInstance(int n, boolean bl, AbstractDoubleDistribution abstractDoubleDistribution) {
        System.out.print("\n" + abstractDoubleDistribution + " ...");
        Timer timer = new Timer().start();
        int n2 = n;
        while (--n2 >= 0) {
            double d = abstractDoubleDistribution.nextDouble();
            if (!bl) continue;
            if ((n - n2 - 1) % 8 == 0) {
                System.out.println();
            }
            System.out.print((float)d + ", ");
        }
        timer.stop();
        System.out.println("\n" + timer);
    }

    public static void test(int n, AbstractDoubleDistribution abstractDoubleDistribution) {
        int n2 = 0;
        int n3 = n;
        while (--n3 >= 0) {
            System.out.print(" " + abstractDoubleDistribution.nextDouble());
            if (n2 % 8 == 7) {
                System.out.println();
            }
            ++n2;
        }
        System.out.println("\n\nGood bye.\n");
    }

    public static void test2(int n, AbstractDoubleDistribution abstractDoubleDistribution) {
        DynamicDoubleBin1D dynamicDoubleBin1D = new DynamicDoubleBin1D();
        int n2 = 0;
        int n3 = n;
        while (--n3 >= 0) {
            dynamicDoubleBin1D.add(abstractDoubleDistribution.nextDouble());
            ++n2;
        }
        System.out.println(dynamicDoubleBin1D);
        System.out.println("\n\nGood bye.\n");
    }

    public static void test2(int n, AbstractDoubleDistribution abstractDoubleDistribution, AbstractDoubleDistribution abstractDoubleDistribution2) {
        DynamicDoubleBin1D dynamicDoubleBin1D = new DynamicDoubleBin1D();
        DynamicDoubleBin1D dynamicDoubleBin1D2 = new DynamicDoubleBin1D();
        int n2 = 0;
        int n3 = n;
        while (--n3 >= 0) {
            dynamicDoubleBin1D.add(abstractDoubleDistribution.nextDouble());
            dynamicDoubleBin1D2.add(abstractDoubleDistribution2.nextDouble());
            ++n2;
        }
        System.out.println("\n\nBenchmarking frequencies...\n");
        IntArrayList intArrayList = new IntArrayList();
        DoubleArrayList doubleArrayList = new DoubleArrayList();
        Timer timer = new Timer();
        timer.reset();
        timer.start();
        dynamicDoubleBin1D.frequencies(doubleArrayList, intArrayList);
        timer.stop().display();
        System.out.println("\n\nGood bye.\n");
    }
}

