/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject.impl;

import cern.colt.function.tobject.ObjectFunction;
import cern.colt.function.tobject.ObjectObjectFunction;
import cern.colt.matrix.tobject.ObjectMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.impl.DenseObjectMatrix2D;
import cern.colt.matrix.tobject.impl.SelectedDenseObjectMatrix1D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class DenseObjectMatrix1D
extends ObjectMatrix1D {
    protected Object[] elements;

    public DenseObjectMatrix1D(Object[] objectArray) {
        this(objectArray.length);
        this.assign(objectArray);
    }

    public DenseObjectMatrix1D(int n) {
        this.setUp(n);
        this.elements = new Object[n];
    }

    protected DenseObjectMatrix1D(int n, Object[] objectArray, int n2, int n3) {
        this.setUp(n, n2, n3);
        this.elements = objectArray;
        this.isNoView = false;
    }

    public ObjectMatrix1D assign(Object[] objectArray) {
        if (this.isNoView) {
            if (objectArray.length != this.size) {
                throw new IllegalArgumentException("Must have same number of cells: length=" + objectArray.length + "size()=" + this.size());
            }
            System.arraycopy(objectArray, 0, this.elements, 0, objectArray.length);
        } else {
            super.assign(objectArray);
        }
        return this;
    }

    public ObjectMatrix1D assign(final ObjectFunction objectFunction) {
        if (this.elements == null) {
            throw new InternalError();
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = DenseObjectMatrix1D.this.zero + n3 * DenseObjectMatrix1D.this.stride;
                        for (int i = n3; i < n4; ++i) {
                            DenseObjectMatrix1D.this.elements[n] = objectFunction.apply(DenseObjectMatrix1D.this.elements[n]);
                            n += DenseObjectMatrix1D.this.stride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = this.zero;
            for (int i = 0; i < this.size; ++i) {
                this.elements[n5] = objectFunction.apply(this.elements[n5]);
                n5 += this.stride;
            }
        }
        return this;
    }

    public ObjectMatrix1D assign(ObjectMatrix1D objectMatrix1D) {
        Object[] objectArray;
        if (!(objectMatrix1D instanceof DenseObjectMatrix1D)) {
            return super.assign(objectMatrix1D);
        }
        DenseObjectMatrix1D denseObjectMatrix1D = (DenseObjectMatrix1D)objectMatrix1D;
        if (denseObjectMatrix1D == this) {
            return this;
        }
        this.checkSize(denseObjectMatrix1D);
        if (this.isNoView && denseObjectMatrix1D.isNoView) {
            System.arraycopy(denseObjectMatrix1D.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        if (this.haveSharedCells(denseObjectMatrix1D)) {
            objectArray = denseObjectMatrix1D.copy();
            if (!(objectArray instanceof DenseObjectMatrix1D)) {
                return super.assign(objectMatrix1D);
            }
            denseObjectMatrix1D = (DenseObjectMatrix1D)objectArray;
        }
        objectArray = denseObjectMatrix1D.elements;
        if (this.elements == null || objectArray == null) {
            throw new InternalError();
        }
        final int n = (int)denseObjectMatrix1D.index(0);
        final int n2 = denseObjectMatrix1D.stride;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n3];
            int n4 = this.size / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.size : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = DenseObjectMatrix1D.this.zero + n5 * DenseObjectMatrix1D.this.stride;
                        int n22 = n + n5 * n2;
                        for (int i = n5; i < n6; ++i) {
                            DenseObjectMatrix1D.this.elements[n3] = objectArray[n22];
                            n3 += DenseObjectMatrix1D.this.stride;
                            n22 += n2;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7 = this.zero;
            int n8 = n;
            for (int i = 0; i < this.size; ++i) {
                this.elements[n7] = objectArray[n8];
                n7 += this.stride;
                n8 += n2;
            }
        }
        return this;
    }

    public ObjectMatrix1D assign(ObjectMatrix1D objectMatrix1D, final ObjectObjectFunction objectObjectFunction) {
        if (!(objectMatrix1D instanceof DenseObjectMatrix1D)) {
            return super.assign(objectMatrix1D, objectObjectFunction);
        }
        final int n = (int)objectMatrix1D.index(0);
        final int n2 = objectMatrix1D.stride();
        final Object[] objectArray = (Object[])objectMatrix1D.elements();
        if (this.elements == null || objectArray == null) {
            throw new InternalError();
        }
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n3];
            int n4 = this.size / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.size : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = DenseObjectMatrix1D.this.zero + n5 * DenseObjectMatrix1D.this.stride;
                        int n22 = n + n5 * n2;
                        for (int i = n5; i < n6; ++i) {
                            DenseObjectMatrix1D.this.elements[n3] = objectObjectFunction.apply(DenseObjectMatrix1D.this.elements[n3], objectArray[n22]);
                            n3 += DenseObjectMatrix1D.this.stride;
                            n22 += n2;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7 = this.zero;
            int n8 = n;
            for (int i = 0; i < this.size; ++i) {
                this.elements[n7] = objectObjectFunction.apply(this.elements[n7], objectArray[n8]);
                n7 += this.stride;
                n8 += n2;
            }
        }
        return this;
    }

    public Object elements() {
        return this.elements;
    }

    public Object getQuick(int n) {
        return this.elements[this.zero + n * this.stride];
    }

    protected boolean haveSharedCellsRaw(ObjectMatrix1D objectMatrix1D) {
        if (objectMatrix1D instanceof SelectedDenseObjectMatrix1D) {
            SelectedDenseObjectMatrix1D selectedDenseObjectMatrix1D = (SelectedDenseObjectMatrix1D)objectMatrix1D;
            return this.elements == selectedDenseObjectMatrix1D.elements;
        }
        if (objectMatrix1D instanceof DenseObjectMatrix1D) {
            DenseObjectMatrix1D denseObjectMatrix1D = (DenseObjectMatrix1D)objectMatrix1D;
            return this.elements == denseObjectMatrix1D.elements;
        }
        return false;
    }

    public long index(int n) {
        return this.zero + n * this.stride;
    }

    public ObjectMatrix1D like(int n) {
        return new DenseObjectMatrix1D(n);
    }

    public ObjectMatrix2D like2D(int n, int n2) {
        return new DenseObjectMatrix2D(n, n2);
    }

    public void setQuick(int n, Object object) {
        this.elements[this.zero + n * this.stride] = object;
    }

    public void swap(ObjectMatrix1D objectMatrix1D) {
        DenseObjectMatrix1D denseObjectMatrix1D;
        if (!(objectMatrix1D instanceof DenseObjectMatrix1D)) {
            super.swap(objectMatrix1D);
        }
        if ((denseObjectMatrix1D = (DenseObjectMatrix1D)objectMatrix1D) == this) {
            return;
        }
        this.checkSize(denseObjectMatrix1D);
        final Object[] objectArray = (Object[])denseObjectMatrix1D.elements();
        if (this.elements == null || objectArray == null) {
            throw new InternalError();
        }
        final int n = (int)objectMatrix1D.index(0);
        final int n2 = objectMatrix1D.stride();
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n3];
            int n4 = this.size / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.size : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = DenseObjectMatrix1D.this.zero + n5 * DenseObjectMatrix1D.this.stride;
                        int n22 = n + n5 * n2;
                        for (int i = n5; i < n6; ++i) {
                            Object object = DenseObjectMatrix1D.this.elements[n3];
                            DenseObjectMatrix1D.this.elements[n3] = objectArray[n22];
                            objectArray[n22] = object;
                            n3 += DenseObjectMatrix1D.this.stride;
                            n22 += n2;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7 = this.zero;
            int n8 = n;
            for (int i = 0; i < this.size; ++i) {
                Object object = this.elements[n7];
                this.elements[n7] = objectArray[n8];
                objectArray[n8] = object;
                n7 += this.stride;
                n8 += n2;
            }
        }
    }

    public void toArray(Object[] objectArray) {
        if (objectArray.length < this.size) {
            throw new IllegalArgumentException("values too small");
        }
        if (this.isNoView) {
            System.arraycopy(this.elements, 0, objectArray, 0, this.elements.length);
        } else {
            super.toArray(objectArray);
        }
    }

    protected ObjectMatrix1D viewSelectionLike(int[] nArray) {
        return new SelectedDenseObjectMatrix1D(this.elements, nArray);
    }
}

