/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject.algo;

import cern.colt.GenericSorting;
import cern.colt.PersistentObject;
import cern.colt.Sorting;
import cern.colt.Swapper;
import cern.colt.function.tint.IntComparator;
import cern.colt.matrix.tobject.ObjectMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.ObjectMatrix3D;
import cern.colt.matrix.tobject.algo.ObjectFormatter;
import cern.colt.matrix.tobject.algo.ObjectMatrix1DComparator;
import cern.colt.matrix.tobject.algo.ObjectMatrix2DComparator;
import java.util.Comparator;

public class ObjectSorting
extends PersistentObject {
    public static final ObjectSorting quickSort = new ObjectSorting();
    public static final ObjectSorting mergeSort = new ObjectSorting(){

        protected void runSort(int[] nArray, int n, int n2, IntComparator intComparator) {
            Sorting.mergeSort(nArray, n, n2, intComparator);
        }

        protected void runSort(int n, int n2, IntComparator intComparator, Swapper swapper) {
            GenericSorting.mergeSort(n, n2, intComparator, swapper);
        }
    };

    protected ObjectSorting() {
    }

    protected void runSort(int[] nArray, int n, int n2, IntComparator intComparator) {
        Sorting.quickSort(nArray, n, n2, intComparator);
    }

    protected void runSort(int n, int n2, IntComparator intComparator, Swapper swapper) {
        GenericSorting.quickSort(n, n2, intComparator, swapper);
    }

    public ObjectMatrix1D sort(final ObjectMatrix1D objectMatrix1D) {
        int[] nArray = new int[objectMatrix1D.size()];
        int n = nArray.length;
        while (--n >= 0) {
            nArray[n] = n;
        }
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                Comparable comparable;
                Comparable comparable2 = (Comparable)objectMatrix1D.getQuick(n);
                int n3 = comparable2.compareTo(comparable = (Comparable)objectMatrix1D.getQuick(n2));
                return n3 < 0 ? -1 : (n3 > 0 ? 1 : 0);
            }
        };
        this.runSort(nArray, 0, nArray.length, intComparator);
        return objectMatrix1D.viewSelection(nArray);
    }

    public ObjectMatrix1D sort(final ObjectMatrix1D objectMatrix1D, final Comparator comparator) {
        int[] nArray = new int[objectMatrix1D.size()];
        int n = nArray.length;
        while (--n >= 0) {
            nArray[n] = n;
        }
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                return comparator.compare(objectMatrix1D.getQuick(n), objectMatrix1D.getQuick(n2));
            }
        };
        this.runSort(nArray, 0, nArray.length, intComparator);
        return objectMatrix1D.viewSelection(nArray);
    }

    public ObjectMatrix2D sort(ObjectMatrix2D objectMatrix2D, int n) {
        if (n < 0 || n >= objectMatrix2D.columns()) {
            throw new IndexOutOfBoundsException("column=" + n + ", matrix=" + ObjectFormatter.shape(objectMatrix2D));
        }
        int[] nArray = new int[objectMatrix2D.rows()];
        int n2 = nArray.length;
        while (--n2 >= 0) {
            nArray[n2] = n2;
        }
        final ObjectMatrix1D objectMatrix1D = objectMatrix2D.viewColumn(n);
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                Comparable comparable;
                Comparable comparable2 = (Comparable)objectMatrix1D.getQuick(n);
                int n3 = comparable2.compareTo(comparable = (Comparable)objectMatrix1D.getQuick(n2));
                return n3 < 0 ? -1 : (n3 > 0 ? 1 : 0);
            }
        };
        this.runSort(nArray, 0, nArray.length, intComparator);
        return objectMatrix2D.viewSelection(nArray, null);
    }

    public ObjectMatrix2D sort(ObjectMatrix2D objectMatrix2D, final ObjectMatrix1DComparator objectMatrix1DComparator) {
        int[] nArray = new int[objectMatrix2D.rows()];
        int n = nArray.length;
        while (--n >= 0) {
            nArray[n] = n;
        }
        final ObjectMatrix1D[] objectMatrix1DArray = new ObjectMatrix1D[objectMatrix2D.rows()];
        int n2 = objectMatrix1DArray.length;
        while (--n2 >= 0) {
            objectMatrix1DArray[n2] = objectMatrix2D.viewRow(n2);
        }
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                return objectMatrix1DComparator.compare(objectMatrix1DArray[n], objectMatrix1DArray[n2]);
            }
        };
        this.runSort(nArray, 0, nArray.length, intComparator);
        return objectMatrix2D.viewSelection(nArray, null);
    }

    public ObjectMatrix3D sort(ObjectMatrix3D objectMatrix3D, int n, int n2) {
        if (n < 0 || n >= objectMatrix3D.rows()) {
            throw new IndexOutOfBoundsException("row=" + n + ", matrix=" + ObjectFormatter.shape(objectMatrix3D));
        }
        if (n2 < 0 || n2 >= objectMatrix3D.columns()) {
            throw new IndexOutOfBoundsException("column=" + n2 + ", matrix=" + ObjectFormatter.shape(objectMatrix3D));
        }
        int[] nArray = new int[objectMatrix3D.slices()];
        int n3 = nArray.length;
        while (--n3 >= 0) {
            nArray[n3] = n3;
        }
        final ObjectMatrix1D objectMatrix1D = objectMatrix3D.viewRow(n).viewColumn(n2);
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                Comparable comparable;
                Comparable comparable2 = (Comparable)objectMatrix1D.getQuick(n);
                int n3 = comparable2.compareTo(comparable = (Comparable)objectMatrix1D.getQuick(n2));
                return n3 < 0 ? -1 : (n3 > 0 ? 1 : 0);
            }
        };
        this.runSort(nArray, 0, nArray.length, intComparator);
        return objectMatrix3D.viewSelection(nArray, null, null);
    }

    public ObjectMatrix3D sort(ObjectMatrix3D objectMatrix3D, final ObjectMatrix2DComparator objectMatrix2DComparator) {
        int[] nArray = new int[objectMatrix3D.slices()];
        int n = nArray.length;
        while (--n >= 0) {
            nArray[n] = n;
        }
        final ObjectMatrix2D[] objectMatrix2DArray = new ObjectMatrix2D[objectMatrix3D.slices()];
        int n2 = objectMatrix2DArray.length;
        while (--n2 >= 0) {
            objectMatrix2DArray[n2] = objectMatrix3D.viewSlice(n2);
        }
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                return objectMatrix2DComparator.compare(objectMatrix2DArray[n], objectMatrix2DArray[n2]);
            }
        };
        this.runSort(nArray, 0, nArray.length, intComparator);
        return objectMatrix3D.viewSelection(nArray, null, null);
    }
}

