/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject;

import cern.colt.function.tobject.ObjectFunction;
import cern.colt.function.tobject.ObjectObjectFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tobject.ObjectArrayList;
import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.ObjectMatrix2DProcedure;
import cern.colt.matrix.tobject.algo.ObjectFormatter;
import cern.colt.matrix.tobject.algo.ObjectSorting;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class ObjectMatrix3D
extends AbstractMatrix3D {
    protected ObjectMatrix3D() {
    }

    public Object aggregate(final ObjectObjectFunction objectObjectFunction, final ObjectFunction objectFunction) {
        if (this.size() == 0) {
            return null;
        }
        Object object = 0;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n];
            Object[] objectArray = new Object[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Object object = objectFunction.apply(ObjectMatrix3D.this.getQuick(n3, 0, 0));
                        int n = 1;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < ObjectMatrix3D.this.rows; ++j) {
                                for (int k = n; k < ObjectMatrix3D.this.columns; ++k) {
                                    object = objectObjectFunction.apply(object, objectFunction.apply(ObjectMatrix3D.this.getQuick(i, j, k)));
                                }
                                n = 0;
                            }
                        }
                        return object;
                    }
                });
            }
            object = ConcurrencyUtils.waitForCompletion(futureArray, objectObjectFunction);
        } else {
            object = objectFunction.apply(this.getQuick(0, 0, 0));
            int n5 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n5; k < this.columns; ++k) {
                        object = objectObjectFunction.apply(object, objectFunction.apply(this.getQuick(i, j, k)));
                    }
                    n5 = 0;
                }
            }
        }
        return object;
    }

    public Object aggregate(final ObjectMatrix3D objectMatrix3D, final ObjectObjectFunction objectObjectFunction, final ObjectObjectFunction objectObjectFunction2) {
        this.checkShape(objectMatrix3D);
        if (this.size() == 0) {
            return null;
        }
        Object object = 0;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n];
            Object[] objectArray = new Object[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Object object = objectObjectFunction2.apply(ObjectMatrix3D.this.getQuick(n3, 0, 0), objectMatrix3D.getQuick(n3, 0, 0));
                        int n = 1;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < ObjectMatrix3D.this.rows; ++j) {
                                for (int k = n; k < ObjectMatrix3D.this.columns; ++k) {
                                    object = objectObjectFunction.apply(object, objectObjectFunction2.apply(ObjectMatrix3D.this.getQuick(i, j, k), objectMatrix3D.getQuick(i, j, k)));
                                }
                                n = 0;
                            }
                        }
                        return object;
                    }
                });
            }
            object = ConcurrencyUtils.waitForCompletion(futureArray, objectObjectFunction);
        } else {
            object = objectObjectFunction2.apply(this.getQuick(0, 0, 0), objectMatrix3D.getQuick(0, 0, 0));
            int n5 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n5; k < this.columns; ++k) {
                        object = objectObjectFunction.apply(object, objectObjectFunction2.apply(this.getQuick(i, j, k), objectMatrix3D.getQuick(i, j, k)));
                    }
                    n5 = 0;
                }
            }
        }
        return object;
    }

    public ObjectMatrix3D assign(final Object[][][] objectArray) {
        if (objectArray.length != this.slices) {
            throw new IllegalArgumentException("Must have same number of slices: slices=" + objectArray.length + "slices()=" + this.slices());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            Object[][] objectArray3 = objectArray[i];
                            if (objectArray3.length != ObjectMatrix3D.this.rows) {
                                throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + objectArray3.length + "rows()=" + ObjectMatrix3D.this.rows());
                            }
                            for (int j = 0; j < ObjectMatrix3D.this.rows; ++j) {
                                Object[] objectArray2 = objectArray3[j];
                                if (objectArray2.length != ObjectMatrix3D.this.columns) {
                                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + objectArray2.length + "columns()=" + ObjectMatrix3D.this.columns());
                                }
                                for (int k = 0; k < ObjectMatrix3D.this.columns; ++k) {
                                    ObjectMatrix3D.this.setQuick(i, j, k, objectArray2[k]);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                Object[][] objectArray2 = objectArray[i];
                if (objectArray2.length != this.rows) {
                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + objectArray2.length + "rows()=" + this.rows());
                }
                for (int j = 0; j < this.rows; ++j) {
                    Object[] objectArray3 = objectArray2[j];
                    if (objectArray3.length != this.columns) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + objectArray3.length + "columns()=" + this.columns());
                    }
                    for (int k = 0; k < this.columns; ++k) {
                        this.setQuick(i, j, k, objectArray3[k]);
                    }
                }
            }
        }
        return this;
    }

    public ObjectMatrix3D assign(final ObjectFunction objectFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < ObjectMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < ObjectMatrix3D.this.columns; ++k) {
                                    ObjectMatrix3D.this.setQuick(i, j, k, objectFunction.apply(ObjectMatrix3D.this.getQuick(i, j, k)));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        this.setQuick(i, j, k, objectFunction.apply(this.getQuick(i, j, k)));
                    }
                }
            }
        }
        return this;
    }

    public ObjectMatrix3D assign(ObjectMatrix3D objectMatrix3D) {
        if (objectMatrix3D == this) {
            return this;
        }
        this.checkShape(objectMatrix3D);
        final ObjectMatrix3D objectMatrix3D2 = this.haveSharedCells(objectMatrix3D) ? objectMatrix3D.copy() : objectMatrix3D;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < ObjectMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < ObjectMatrix3D.this.columns; ++k) {
                                    ObjectMatrix3D.this.setQuick(i, j, k, objectMatrix3D2.getQuick(i, j, k));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        this.setQuick(i, j, k, objectMatrix3D2.getQuick(i, j, k));
                    }
                }
            }
        }
        return this;
    }

    public ObjectMatrix3D assign(final ObjectMatrix3D objectMatrix3D, final ObjectObjectFunction objectObjectFunction) {
        this.checkShape(objectMatrix3D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < ObjectMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < ObjectMatrix3D.this.columns; ++k) {
                                    ObjectMatrix3D.this.setQuick(i, j, k, objectObjectFunction.apply(ObjectMatrix3D.this.getQuick(i, j, k), objectMatrix3D.getQuick(i, j, k)));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        this.setQuick(i, j, k, objectObjectFunction.apply(this.getQuick(i, j, k), objectMatrix3D.getQuick(i, j, k)));
                    }
                }
            }
        }
        return this;
    }

    public ObjectMatrix3D assign(final Object object) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < ObjectMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < ObjectMatrix3D.this.columns; ++k) {
                                    ObjectMatrix3D.this.setQuick(i, j, k, object);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        this.setQuick(i, j, k, object);
                    }
                }
            }
        }
        return this;
    }

    public int cardinality() {
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n3;
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n4 = this.slices / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.slices : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        for (int i = n5; i < n6; ++i) {
                            for (int j = 0; j < ObjectMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < ObjectMatrix3D.this.columns; ++k) {
                                    if (ObjectMatrix3D.this.getQuick(i, j, k) == null) continue;
                                    ++n;
                                }
                            }
                        }
                        return n;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    integerArray[n3] = (Integer)futureArray[n3].get();
                }
                n = integerArray[0];
                for (n3 = 1; n3 < n2; ++n3) {
                    n += integerArray[n3].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        if (this.getQuick(i, j, k) == null) continue;
                        ++n;
                    }
                }
            }
        }
        return n;
    }

    public ObjectMatrix3D copy() {
        return this.like().assign(this);
    }

    public abstract Object elements();

    public boolean equals(Object object) {
        return this.equals(object, true);
    }

    public boolean equals(Object object, boolean bl) {
        if (!(object instanceof ObjectMatrix3D)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        ObjectMatrix3D objectMatrix3D = (ObjectMatrix3D)object;
        if (this.rows != objectMatrix3D.rows()) {
            return false;
        }
        if (this.columns != objectMatrix3D.columns()) {
            return false;
        }
        if (!bl) {
            int n = this.slices;
            while (--n >= 0) {
                int n2 = this.rows;
                while (--n2 >= 0) {
                    int n3 = this.columns;
                    while (--n3 >= 0) {
                        if (this.getQuick(n, n2, n3) == objectMatrix3D.getQuick(n, n2, n3)) continue;
                        return false;
                    }
                }
            }
        } else {
            int n = this.slices;
            while (--n >= 0) {
                int n4 = this.rows;
                while (--n4 >= 0) {
                    int n5 = this.columns;
                    while (--n5 >= 0) {
                        if (this.getQuick(n, n4, n5) != null ? this.getQuick(n, n4, n5).equals(objectMatrix3D.getQuick(n, n4, n5)) : objectMatrix3D.getQuick(n, n4, n5) == null) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public Object get(int n, int n2, int n3) {
        if (n < 0 || n >= this.slices || n2 < 0 || n2 >= this.rows || n3 < 0 || n3 >= this.columns) {
            throw new IndexOutOfBoundsException("slice:" + n + ", row:" + n2 + ", column:" + n3);
        }
        return this.getQuick(n, n2, n3);
    }

    protected ObjectMatrix3D getContent() {
        return this;
    }

    public void getNonZeros(IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3, ObjectArrayList objectArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        intArrayList3.clear();
        objectArrayList.clear();
        int n = this.slices;
        int n2 = this.rows;
        int n3 = this.columns;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    Object object = this.getQuick(i, j, k);
                    if (object == null) continue;
                    intArrayList.add(i);
                    intArrayList2.add(j);
                    intArrayList3.add(k);
                    objectArrayList.add(object);
                }
            }
        }
    }

    public abstract Object getQuick(int var1, int var2, int var3);

    protected boolean haveSharedCells(ObjectMatrix3D objectMatrix3D) {
        if (objectMatrix3D == null) {
            return false;
        }
        if (this == objectMatrix3D) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(objectMatrix3D.getContent());
    }

    protected boolean haveSharedCellsRaw(ObjectMatrix3D objectMatrix3D) {
        return false;
    }

    public ObjectMatrix3D like() {
        return this.like(this.slices, this.rows, this.columns);
    }

    public abstract ObjectMatrix3D like(int var1, int var2, int var3);

    protected abstract ObjectMatrix2D like2D(int var1, int var2, int var3, int var4, int var5, int var6);

    public void set(int n, int n2, int n3, Object object) {
        if (n < 0 || n >= this.slices || n2 < 0 || n2 >= this.rows || n3 < 0 || n3 >= this.columns) {
            throw new IndexOutOfBoundsException("slice:" + n + ", row:" + n2 + ", column:" + n3);
        }
        this.setQuick(n, n2, n3, object);
    }

    public abstract void setQuick(int var1, int var2, int var3, Object var4);

    public Object[][][] toArray() {
        final Object[][][] objectArray = new Object[this.slices][this.rows][this.columns];
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            Object[][] objectArray3 = objectArray[i];
                            for (int j = 0; j < ObjectMatrix3D.this.rows; ++j) {
                                Object[] objectArray2 = objectArray3[j];
                                for (int k = 0; k < ObjectMatrix3D.this.columns; ++k) {
                                    objectArray2[k] = ObjectMatrix3D.this.getQuick(i, j, k);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                Object[][] objectArray2 = objectArray[i];
                for (int j = 0; j < this.rows; ++j) {
                    Object[] objectArray3 = objectArray2[j];
                    for (int k = 0; k < this.columns; ++k) {
                        objectArray3[k] = this.getQuick(i, j, k);
                    }
                }
            }
        }
        return objectArray;
    }

    public String toString() {
        return new ObjectFormatter().toString(this);
    }

    protected ObjectMatrix3D view() {
        return (ObjectMatrix3D)this.clone();
    }

    public ObjectMatrix2D viewColumn(int n) {
        this.checkColumn(n);
        int n2 = this.slices;
        int n3 = this.rows;
        int n4 = this.sliceZero;
        int n5 = this.rowZero + this._columnOffset(this._columnRank(n));
        int n6 = this.sliceStride;
        int n7 = this.rowStride;
        return this.like2D(n2, n3, n4, n5, n6, n7);
    }

    public ObjectMatrix3D viewColumnFlip() {
        return (ObjectMatrix3D)this.view().vColumnFlip();
    }

    public ObjectMatrix3D viewDice(int n, int n2, int n3) {
        return (ObjectMatrix3D)this.view().vDice(n, n2, n3);
    }

    public ObjectMatrix3D viewPart(int n, int n2, int n3, int n4, int n5, int n6) {
        return (ObjectMatrix3D)this.view().vPart(n, n2, n3, n4, n5, n6);
    }

    public ObjectMatrix2D viewRow(int n) {
        this.checkRow(n);
        int n2 = this.slices;
        int n3 = this.columns;
        int n4 = this.sliceZero;
        int n5 = this.columnZero + this._rowOffset(this._rowRank(n));
        int n6 = this.sliceStride;
        int n7 = this.columnStride;
        return this.like2D(n2, n3, n4, n5, n6, n7);
    }

    public ObjectMatrix3D viewRowFlip() {
        return (ObjectMatrix3D)this.view().vRowFlip();
    }

    public ObjectMatrix3D viewSelection(int[] nArray, int[] nArray2, int[] nArray3) {
        int n;
        if (nArray == null) {
            nArray = new int[this.slices];
            n = this.slices;
            while (--n >= 0) {
                nArray[n] = n;
            }
        }
        if (nArray2 == null) {
            nArray2 = new int[this.rows];
            n = this.rows;
            while (--n >= 0) {
                nArray2[n] = n;
            }
        }
        if (nArray3 == null) {
            nArray3 = new int[this.columns];
            n = this.columns;
            while (--n >= 0) {
                nArray3[n] = n;
            }
        }
        this.checkSliceIndexes(nArray);
        this.checkRowIndexes(nArray2);
        this.checkColumnIndexes(nArray3);
        int[] nArray4 = new int[nArray.length];
        int[] nArray5 = new int[nArray2.length];
        int[] nArray6 = new int[nArray3.length];
        int n2 = nArray.length;
        while (--n2 >= 0) {
            nArray4[n2] = this._sliceOffset(this._sliceRank(nArray[n2]));
        }
        n2 = nArray2.length;
        while (--n2 >= 0) {
            nArray5[n2] = this._rowOffset(this._rowRank(nArray2[n2]));
        }
        n2 = nArray3.length;
        while (--n2 >= 0) {
            nArray6[n2] = this._columnOffset(this._columnRank(nArray3[n2]));
        }
        return this.viewSelectionLike(nArray4, nArray5, nArray6);
    }

    public ObjectMatrix3D viewSelection(ObjectMatrix2DProcedure objectMatrix2DProcedure) {
        IntArrayList intArrayList = new IntArrayList();
        for (int i = 0; i < this.slices; ++i) {
            if (!objectMatrix2DProcedure.apply(this.viewSlice(i))) continue;
            intArrayList.add(i);
        }
        intArrayList.trimToSize();
        return this.viewSelection(intArrayList.elements(), null, null);
    }

    protected abstract ObjectMatrix3D viewSelectionLike(int[] var1, int[] var2, int[] var3);

    public ObjectMatrix2D viewSlice(int n) {
        this.checkSlice(n);
        int n2 = this.rows;
        int n3 = this.columns;
        int n4 = this.rowZero;
        int n5 = this.columnZero + this._sliceOffset(this._sliceRank(n));
        int n6 = this.rowStride;
        int n7 = this.columnStride;
        return this.like2D(n2, n3, n4, n5, n6, n7);
    }

    public ObjectMatrix3D viewSliceFlip() {
        return (ObjectMatrix3D)this.view().vSliceFlip();
    }

    public ObjectMatrix3D viewSorted(int n, int n2) {
        return ObjectSorting.mergeSort.sort(this, n, n2);
    }

    public ObjectMatrix3D viewStrides(int n, int n2, int n3) {
        return (ObjectMatrix3D)this.view().vStrides(n, n2, n3);
    }
}

