/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject;

import cern.colt.function.tobject.ObjectFunction;
import cern.colt.function.tobject.ObjectObjectFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tobject.ObjectArrayList;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.tobject.ObjectMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix1DProcedure;
import cern.colt.matrix.tobject.algo.ObjectFormatter;
import cern.colt.matrix.tobject.algo.ObjectSorting;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class ObjectMatrix2D
extends AbstractMatrix2D {
    protected ObjectMatrix2D() {
    }

    public Object aggregate(final ObjectObjectFunction objectObjectFunction, final ObjectFunction objectFunction) {
        if (this.size() == 0) {
            return null;
        }
        Object object = 0;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            Object[] objectArray = new Object[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Object object = objectFunction.apply(ObjectMatrix2D.this.getQuick(n3, 0));
                        int n = 1;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = n; j < ObjectMatrix2D.this.columns; ++j) {
                                object = objectObjectFunction.apply(object, objectFunction.apply(ObjectMatrix2D.this.getQuick(i, j)));
                            }
                            n = 0;
                        }
                        return object;
                    }
                });
            }
            object = ConcurrencyUtils.waitForCompletion(futureArray, objectObjectFunction);
        } else {
            object = objectFunction.apply(this.getQuick(0, 0));
            int n5 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n5; j < this.columns; ++j) {
                    object = objectObjectFunction.apply(object, objectFunction.apply(this.getQuick(i, j)));
                }
                n5 = 0;
            }
        }
        return object;
    }

    public Object aggregate(final ObjectMatrix2D objectMatrix2D, final ObjectObjectFunction objectObjectFunction, final ObjectObjectFunction objectObjectFunction2) {
        this.checkShape(objectMatrix2D);
        if (this.size() == 0) {
            return null;
        }
        Object object = 0;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            Object[] objectArray = new Object[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Object object = objectObjectFunction2.apply(ObjectMatrix2D.this.getQuick(n3, 0), objectMatrix2D.getQuick(n3, 0));
                        int n = 1;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = n; j < ObjectMatrix2D.this.columns; ++j) {
                                object = objectObjectFunction.apply(object, objectObjectFunction2.apply(ObjectMatrix2D.this.getQuick(i, j), objectMatrix2D.getQuick(i, j)));
                            }
                            n = 0;
                        }
                        return object;
                    }
                });
            }
            object = ConcurrencyUtils.waitForCompletion(futureArray, objectObjectFunction);
        } else {
            object = objectObjectFunction2.apply(this.getQuick(0, 0), objectMatrix2D.getQuick(0, 0));
            int n5 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n5; j < this.columns; ++j) {
                    object = objectObjectFunction.apply(object, objectObjectFunction2.apply(this.getQuick(i, j), objectMatrix2D.getQuick(i, j)));
                }
                n5 = 0;
            }
        }
        return object;
    }

    public ObjectMatrix2D assign(final Object[][] objectArray) {
        if (objectArray.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + objectArray.length + "rows()=" + this.rows());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            Object[] objectArray2 = objectArray[i];
                            if (objectArray2.length != ObjectMatrix2D.this.columns) {
                                throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + objectArray2.length + "columns()=" + ObjectMatrix2D.this.columns());
                            }
                            for (int j = 0; j < ObjectMatrix2D.this.columns; ++j) {
                                ObjectMatrix2D.this.setQuick(i, j, objectArray2[j]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                Object[] objectArray2 = objectArray[i];
                if (objectArray2.length != this.columns) {
                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + objectArray2.length + "columns()=" + this.columns());
                }
                for (int j = 0; j < this.columns; ++j) {
                    this.setQuick(i, j, objectArray2[j]);
                }
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(final ObjectFunction objectFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < ObjectMatrix2D.this.columns; ++j) {
                                ObjectMatrix2D.this.setQuick(i, j, objectFunction.apply(ObjectMatrix2D.this.getQuick(i, j)));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    this.setQuick(i, j, objectFunction.apply(this.getQuick(i, j)));
                }
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(ObjectMatrix2D objectMatrix2D) {
        if (objectMatrix2D == this) {
            return this;
        }
        this.checkShape(objectMatrix2D);
        final ObjectMatrix2D objectMatrix2D2 = this.haveSharedCells(objectMatrix2D) ? objectMatrix2D.copy() : objectMatrix2D;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < ObjectMatrix2D.this.columns; ++j) {
                                ObjectMatrix2D.this.setQuick(i, j, objectMatrix2D2.getQuick(i, j));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    this.setQuick(i, j, objectMatrix2D2.getQuick(i, j));
                }
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(final ObjectMatrix2D objectMatrix2D, final ObjectObjectFunction objectObjectFunction) {
        this.checkShape(objectMatrix2D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < ObjectMatrix2D.this.columns; ++j) {
                                ObjectMatrix2D.this.setQuick(i, j, objectObjectFunction.apply(ObjectMatrix2D.this.getQuick(i, j), objectMatrix2D.getQuick(i, j)));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    this.setQuick(i, j, objectObjectFunction.apply(this.getQuick(i, j), objectMatrix2D.getQuick(i, j)));
                }
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(final Object object) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < ObjectMatrix2D.this.columns; ++j) {
                                ObjectMatrix2D.this.setQuick(i, j, object);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    this.setQuick(i, j, object);
                }
            }
        }
        return this;
    }

    public int cardinality() {
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n3;
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n4 = this.rows / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.rows : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        for (int i = n5; i < n6; ++i) {
                            for (int j = 0; j < ObjectMatrix2D.this.columns; ++j) {
                                if (ObjectMatrix2D.this.getQuick(i, j) == null) continue;
                                ++n;
                            }
                        }
                        return n;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    integerArray[n3] = (Integer)futureArray[n3].get();
                }
                n = integerArray[0];
                for (n3 = 1; n3 < n2; ++n3) {
                    n += integerArray[n3].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    if (this.getQuick(i, j) == null) continue;
                    ++n;
                }
            }
        }
        return n;
    }

    public ObjectMatrix2D copy() {
        return this.like().assign(this);
    }

    public abstract Object elements();

    public boolean equals(Object object) {
        return this.equals(object, true);
    }

    public boolean equals(Object object, boolean bl) {
        if (!(object instanceof ObjectMatrix2D)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        ObjectMatrix2D objectMatrix2D = (ObjectMatrix2D)object;
        if (this.rows != objectMatrix2D.rows()) {
            return false;
        }
        if (this.columns != objectMatrix2D.columns()) {
            return false;
        }
        if (!bl) {
            int n = this.rows;
            while (--n >= 0) {
                int n2 = this.columns;
                while (--n2 >= 0) {
                    if (this.getQuick(n, n2) == objectMatrix2D.getQuick(n, n2)) continue;
                    return false;
                }
            }
        } else {
            int n = this.rows;
            while (--n >= 0) {
                int n3 = this.columns;
                while (--n3 >= 0) {
                    if (this.getQuick(n, n3) != null ? this.getQuick(n, n3).equals(objectMatrix2D.getQuick(n, n3)) : objectMatrix2D.getQuick(n, n3) == null) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public Object get(int n, int n2) {
        if (n2 < 0 || n2 >= this.columns || n < 0 || n >= this.rows) {
            throw new IndexOutOfBoundsException("row:" + n + ", column:" + n2);
        }
        return this.getQuick(n, n2);
    }

    protected ObjectMatrix2D getContent() {
        return this;
    }

    public void getNonZeros(IntArrayList intArrayList, IntArrayList intArrayList2, ObjectArrayList objectArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        objectArrayList.clear();
        int n = this.rows;
        int n2 = this.columns;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                Object object = this.getQuick(i, j);
                if (object == null) continue;
                intArrayList.add(i);
                intArrayList2.add(j);
                objectArrayList.add(object);
            }
        }
    }

    public abstract Object getQuick(int var1, int var2);

    protected boolean haveSharedCells(ObjectMatrix2D objectMatrix2D) {
        if (objectMatrix2D == null) {
            return false;
        }
        if (this == objectMatrix2D) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(objectMatrix2D.getContent());
    }

    protected boolean haveSharedCellsRaw(ObjectMatrix2D objectMatrix2D) {
        return false;
    }

    public ObjectMatrix2D like() {
        return this.like(this.rows, this.columns);
    }

    public abstract ObjectMatrix2D like(int var1, int var2);

    public abstract ObjectMatrix1D like1D(int var1);

    protected abstract ObjectMatrix1D like1D(int var1, int var2, int var3);

    public void set(int n, int n2, Object object) {
        if (n2 < 0 || n2 >= this.columns || n < 0 || n >= this.rows) {
            throw new IndexOutOfBoundsException("row:" + n + ", column:" + n2);
        }
        this.setQuick(n, n2, object);
    }

    public abstract void setQuick(int var1, int var2, Object var3);

    public Object[][] toArray() {
        final Object[][] objectArray = new Object[this.rows][this.columns];
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            Object[] objectArray2 = objectArray[i];
                            for (int j = 0; j < ObjectMatrix2D.this.columns; ++j) {
                                objectArray2[j] = ObjectMatrix2D.this.getQuick(i, j);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                Object[] objectArray2 = objectArray[i];
                for (int j = 0; j < this.columns; ++j) {
                    objectArray2[j] = this.getQuick(i, j);
                }
            }
        }
        return objectArray;
    }

    public String toString() {
        return new ObjectFormatter().toString(this);
    }

    protected ObjectMatrix2D view() {
        return (ObjectMatrix2D)this.clone();
    }

    public ObjectMatrix1D viewColumn(int n) {
        this.checkColumn(n);
        int n2 = this.rows;
        int n3 = (int)this.index(0, n);
        int n4 = this.rowStride;
        return this.like1D(n2, n3, n4);
    }

    public ObjectMatrix2D viewColumnFlip() {
        return (ObjectMatrix2D)this.view().vColumnFlip();
    }

    public ObjectMatrix2D viewDice() {
        return (ObjectMatrix2D)this.view().vDice();
    }

    public ObjectMatrix2D viewPart(int n, int n2, int n3, int n4) {
        return (ObjectMatrix2D)this.view().vPart(n, n2, n3, n4);
    }

    public ObjectMatrix1D viewRow(int n) {
        this.checkRow(n);
        int n2 = this.columns;
        int n3 = (int)this.index(n, 0);
        int n4 = this.columnStride;
        return this.like1D(n2, n3, n4);
    }

    public ObjectMatrix2D viewRowFlip() {
        return (ObjectMatrix2D)this.view().vRowFlip();
    }

    public ObjectMatrix2D viewSelection(int[] nArray, int[] nArray2) {
        int n;
        if (nArray == null) {
            nArray = new int[this.rows];
            n = this.rows;
            while (--n >= 0) {
                nArray[n] = n;
            }
        }
        if (nArray2 == null) {
            nArray2 = new int[this.columns];
            n = this.columns;
            while (--n >= 0) {
                nArray2[n] = n;
            }
        }
        this.checkRowIndexes(nArray);
        this.checkColumnIndexes(nArray2);
        int[] nArray3 = new int[nArray.length];
        int[] nArray4 = new int[nArray2.length];
        int n2 = nArray.length;
        while (--n2 >= 0) {
            nArray3[n2] = this._rowOffset(this._rowRank(nArray[n2]));
        }
        n2 = nArray2.length;
        while (--n2 >= 0) {
            nArray4[n2] = this._columnOffset(this._columnRank(nArray2[n2]));
        }
        return this.viewSelectionLike(nArray3, nArray4);
    }

    public ObjectMatrix2D viewSelection(ObjectMatrix1DProcedure objectMatrix1DProcedure) {
        IntArrayList intArrayList = new IntArrayList();
        for (int i = 0; i < this.rows; ++i) {
            if (!objectMatrix1DProcedure.apply(this.viewRow(i))) continue;
            intArrayList.add(i);
        }
        intArrayList.trimToSize();
        return this.viewSelection(intArrayList.elements(), null);
    }

    protected abstract ObjectMatrix2D viewSelectionLike(int[] var1, int[] var2);

    public ObjectMatrix2D viewSorted(int n) {
        return ObjectSorting.mergeSort.sort(this, n);
    }

    public ObjectMatrix2D viewStrides(int n, int n2) {
        return (ObjectMatrix2D)this.view().vStrides(n, n2);
    }
}

