/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject;

import cern.colt.function.tobject.ObjectFunction;
import cern.colt.function.tobject.ObjectObjectFunction;
import cern.colt.function.tobject.ObjectProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tobject.ObjectArrayList;
import cern.colt.matrix.AbstractMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.algo.ObjectFormatter;
import cern.colt.matrix.tobject.algo.ObjectSorting;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public abstract class ObjectMatrix1D
extends AbstractMatrix1D {
    protected ObjectMatrix1D() {
    }

    public Object aggregate(final ObjectObjectFunction objectObjectFunction, final ObjectFunction objectFunction) {
        if (this.size == 0) {
            return null;
        }
        Object object = objectFunction.apply(this.getQuick(0));
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n];
            Object[] objectArray = new Object[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Object object = objectFunction.apply(ObjectMatrix1D.this.getQuick(n3));
                        for (int i = n3 + 1; i < n4; ++i) {
                            object = objectObjectFunction.apply(object, objectFunction.apply(ObjectMatrix1D.this.getQuick(i)));
                        }
                        return object;
                    }
                });
            }
            object = ConcurrencyUtils.waitForCompletion(futureArray, objectObjectFunction);
        } else {
            for (int i = 1; i < this.size; ++i) {
                object = objectObjectFunction.apply(object, objectFunction.apply(this.getQuick(i)));
            }
        }
        return object;
    }

    public Object aggregate(final ObjectMatrix1D objectMatrix1D, final ObjectObjectFunction objectObjectFunction, final ObjectObjectFunction objectObjectFunction2) {
        this.checkSize(objectMatrix1D);
        if (this.size == 0) {
            return null;
        }
        Object object = objectObjectFunction2.apply(this.getQuick(0), objectMatrix1D.getQuick(0));
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n];
            Object[] objectArray = new Object[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Object object = objectObjectFunction2.apply(ObjectMatrix1D.this.getQuick(n3), objectMatrix1D.getQuick(n3));
                        for (int i = n3 + 1; i < n4; ++i) {
                            object = objectObjectFunction.apply(object, objectObjectFunction2.apply(ObjectMatrix1D.this.getQuick(i), objectMatrix1D.getQuick(i)));
                        }
                        return object;
                    }
                });
            }
            object = ConcurrencyUtils.waitForCompletion(futureArray, objectObjectFunction);
        } else {
            for (int i = 1; i < this.size; ++i) {
                object = objectObjectFunction.apply(object, objectObjectFunction2.apply(this.getQuick(i), objectMatrix1D.getQuick(i)));
            }
        }
        return object;
    }

    public ObjectMatrix1D assign(final Object[] objectArray) {
        if (objectArray.length != this.size) {
            throw new IllegalArgumentException("Must have same number of cells: length=" + objectArray.length + ", size()=" + this.size());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            ObjectMatrix1D.this.setQuick(i, objectArray[i]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, objectArray[i]);
            }
        }
        return this;
    }

    public ObjectMatrix1D assign(final ObjectFunction objectFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            ObjectMatrix1D.this.setQuick(i, objectFunction.apply(ObjectMatrix1D.this.getQuick(i)));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, objectFunction.apply(this.getQuick(i)));
            }
        }
        return this;
    }

    public ObjectMatrix1D assign(ObjectMatrix1D objectMatrix1D) {
        if (objectMatrix1D == this) {
            return this;
        }
        this.checkSize(objectMatrix1D);
        final ObjectMatrix1D objectMatrix1D2 = this.haveSharedCells(objectMatrix1D) ? objectMatrix1D.copy() : objectMatrix1D;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            ObjectMatrix1D.this.setQuick(i, objectMatrix1D2.getQuick(i));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, objectMatrix1D2.getQuick(i));
            }
        }
        return this;
    }

    public ObjectMatrix1D assign(final ObjectMatrix1D objectMatrix1D, final ObjectObjectFunction objectObjectFunction) {
        this.checkSize(objectMatrix1D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            ObjectMatrix1D.this.setQuick(i, objectObjectFunction.apply(ObjectMatrix1D.this.getQuick(i), objectMatrix1D.getQuick(i)));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, objectObjectFunction.apply(this.getQuick(i), objectMatrix1D.getQuick(i)));
            }
        }
        return this;
    }

    public ObjectMatrix1D assign(final Object object) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            ObjectMatrix1D.this.setQuick(i, object);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, object);
            }
        }
        return this;
    }

    public int cardinality() {
        int n = 0;
        int n2 = this.size;
        while (--n2 >= 0) {
            if (this.getQuick(n2) == null) continue;
            ++n;
        }
        return n;
    }

    public ObjectMatrix1D copy() {
        ObjectMatrix1D objectMatrix1D = this.like();
        objectMatrix1D.assign(this);
        return objectMatrix1D;
    }

    public abstract Object elements();

    public boolean equals(Object object) {
        return this.equals(object, true);
    }

    public boolean equals(Object object, boolean bl) {
        if (!(object instanceof ObjectMatrix1D)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        ObjectMatrix1D objectMatrix1D = (ObjectMatrix1D)object;
        if (this.size != objectMatrix1D.size()) {
            return false;
        }
        if (!bl) {
            int n = this.size;
            while (--n >= 0) {
                if (this.getQuick(n) == objectMatrix1D.getQuick(n)) continue;
                return false;
            }
        } else {
            int n = this.size;
            while (--n >= 0) {
                if (this.getQuick(n) != null ? this.getQuick(n).equals(objectMatrix1D.getQuick(n)) : objectMatrix1D.getQuick(n) == null) continue;
                return false;
            }
        }
        return true;
    }

    public Object get(int n) {
        if (n < 0 || n >= this.size) {
            this.checkIndex(n);
        }
        return this.getQuick(n);
    }

    protected ObjectMatrix1D getContent() {
        return this;
    }

    public void getNonZeros(IntArrayList intArrayList, ObjectArrayList objectArrayList) {
        boolean bl;
        boolean bl2 = intArrayList != null;
        boolean bl3 = bl = objectArrayList != null;
        if (bl2) {
            intArrayList.clear();
        }
        if (bl) {
            objectArrayList.clear();
        }
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            Object object = this.getQuick(i);
            if (object == null) continue;
            if (bl2) {
                intArrayList.add(i);
            }
            if (!bl) continue;
            objectArrayList.add(object);
        }
    }

    public abstract Object getQuick(int var1);

    protected boolean haveSharedCells(ObjectMatrix1D objectMatrix1D) {
        if (objectMatrix1D == null) {
            return false;
        }
        if (this == objectMatrix1D) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(objectMatrix1D.getContent());
    }

    protected boolean haveSharedCellsRaw(ObjectMatrix1D objectMatrix1D) {
        return false;
    }

    public ObjectMatrix1D like() {
        return this.like(this.size);
    }

    public abstract ObjectMatrix1D like(int var1);

    public abstract ObjectMatrix2D like2D(int var1, int var2);

    public void set(int n, Object object) {
        if (n < 0 || n >= this.size) {
            this.checkIndex(n);
        }
        this.setQuick(n, object);
    }

    public abstract void setQuick(int var1, Object var2);

    public void swap(final ObjectMatrix1D objectMatrix1D) {
        this.checkSize(objectMatrix1D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            Object object = ObjectMatrix1D.this.getQuick(i);
                            ObjectMatrix1D.this.setQuick(i, objectMatrix1D.getQuick(i));
                            objectMatrix1D.setQuick(i, object);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                Object object = this.getQuick(i);
                this.setQuick(i, objectMatrix1D.getQuick(i));
                objectMatrix1D.setQuick(i, object);
            }
        }
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.size];
        this.toArray(objectArray);
        return objectArray;
    }

    public void toArray(final Object[] objectArray) {
        if (objectArray.length < this.size) {
            throw new IllegalArgumentException("values too small");
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            objectArray[i] = ObjectMatrix1D.this.getQuick(i);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                objectArray[i] = this.getQuick(i);
            }
        }
    }

    public String toString() {
        return new ObjectFormatter().toString(this);
    }

    protected ObjectMatrix1D view() {
        return (ObjectMatrix1D)this.clone();
    }

    public ObjectMatrix1D viewFlip() {
        return (ObjectMatrix1D)this.view().vFlip();
    }

    public ObjectMatrix1D viewPart(int n, int n2) {
        return (ObjectMatrix1D)this.view().vPart(n, n2);
    }

    public ObjectMatrix1D viewSelection(int[] nArray) {
        if (nArray == null) {
            nArray = new int[this.size];
            int n = this.size;
            while (--n >= 0) {
                nArray[n] = n;
            }
        }
        this.checkIndexes(nArray);
        int[] nArray2 = new int[nArray.length];
        int n = nArray.length;
        while (--n >= 0) {
            nArray2[n] = (int)this.index(nArray[n]);
        }
        return this.viewSelectionLike(nArray2);
    }

    public ObjectMatrix1D viewSelection(ObjectProcedure objectProcedure) {
        IntArrayList intArrayList = new IntArrayList();
        for (int i = 0; i < this.size; ++i) {
            if (!objectProcedure.apply(this.getQuick(i))) continue;
            intArrayList.add(i);
        }
        intArrayList.trimToSize();
        return this.viewSelection(intArrayList.elements());
    }

    protected abstract ObjectMatrix1D viewSelectionLike(int[] var1);

    public ObjectMatrix1D viewSorted() {
        return ObjectSorting.mergeSort.sort(this);
    }

    public ObjectMatrix1D viewStrides(int n) {
        return (ObjectMatrix1D)this.view().vStrides(n);
    }
}

