/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.impl.DelegateIntMatrix1D;

public class WrapperIntMatrix2D
extends IntMatrix2D {
    protected IntMatrix2D content;

    public WrapperIntMatrix2D(IntMatrix2D intMatrix2D) {
        if (intMatrix2D != null) {
            this.setUp(intMatrix2D.rows(), intMatrix2D.columns());
        }
        this.content = intMatrix2D;
    }

    public Object elements() {
        return this.content.elements();
    }

    public int getQuick(int n, int n2) {
        return this.content.getQuick(n, n2);
    }

    public IntMatrix2D like(int n, int n2) {
        return this.content.like(n, n2);
    }

    public IntMatrix1D like1D(int n) {
        return this.content.like1D(n);
    }

    public void setQuick(int n, int n2, int n3) {
        this.content.setQuick(n, n2, n3);
    }

    public IntMatrix1D vectorize() {
        return this.content.vectorize();
    }

    public IntMatrix1D viewColumn(int n) {
        return this.viewDice().viewRow(n);
    }

    public IntMatrix2D viewColumnFlip() {
        if (this.columns == 0) {
            return this;
        }
        WrapperIntMatrix2D wrapperIntMatrix2D = new WrapperIntMatrix2D(this){

            public int getQuick(int n, int n2) {
                return this.content.get(n, this.columns - 1 - n2);
            }

            public void setQuick(int n, int n2, int n3) {
                this.content.set(n, this.columns - 1 - n2, n3);
            }
        };
        return wrapperIntMatrix2D;
    }

    public IntMatrix2D viewDice() {
        WrapperIntMatrix2D wrapperIntMatrix2D = new WrapperIntMatrix2D(this){

            public int getQuick(int n, int n2) {
                return this.content.get(n2, n);
            }

            public void setQuick(int n, int n2, int n3) {
                this.content.set(n2, n, n3);
            }
        };
        wrapperIntMatrix2D.setNrows(this.columns);
        wrapperIntMatrix2D.setNcolumns(this.rows);
        return wrapperIntMatrix2D;
    }

    public void setNcolumns(int n) {
        this.columns = n;
    }

    public void setNrows(int n) {
        this.rows = n;
    }

    public IntMatrix2D viewPart(final int n, final int n2, int n3, int n4) {
        this.checkBox(n, n2, n3, n4);
        WrapperIntMatrix2D wrapperIntMatrix2D = new WrapperIntMatrix2D(this){

            public int getQuick(int n3, int n22) {
                return this.content.get(n + n3, n2 + n22);
            }

            public void setQuick(int n4, int n22, int n3) {
                this.content.set(n + n4, n2 + n22, n3);
            }
        };
        wrapperIntMatrix2D.setNrows(n3);
        wrapperIntMatrix2D.setNcolumns(n4);
        return wrapperIntMatrix2D;
    }

    public IntMatrix1D viewRow(int n) {
        this.checkRow(n);
        return new DelegateIntMatrix1D(this, n);
    }

    public IntMatrix2D viewRowFlip() {
        if (this.rows == 0) {
            return this;
        }
        WrapperIntMatrix2D wrapperIntMatrix2D = new WrapperIntMatrix2D(this){

            public int getQuick(int n, int n2) {
                return this.content.get(this.rows - 1 - n, n2);
            }

            public void setQuick(int n, int n2, int n3) {
                this.content.set(this.rows - 1 - n, n2, n3);
            }
        };
        return wrapperIntMatrix2D;
    }

    public IntMatrix2D viewSelection(int[] nArray, int[] nArray2) {
        int n;
        if (nArray == null) {
            nArray = new int[this.rows];
            n = this.rows;
            while (--n >= 0) {
                nArray[n] = n;
            }
        }
        if (nArray2 == null) {
            nArray2 = new int[this.columns];
            n = this.columns;
            while (--n >= 0) {
                nArray2[n] = n;
            }
        }
        this.checkRowIndexes(nArray);
        this.checkColumnIndexes(nArray2);
        final int[] nArray3 = nArray;
        final int[] nArray4 = nArray2;
        WrapperIntMatrix2D wrapperIntMatrix2D = new WrapperIntMatrix2D(this){

            public int getQuick(int n, int n2) {
                return this.content.get(nArray3[n], nArray4[n2]);
            }

            public void setQuick(int n, int n2, int n3) {
                this.content.set(nArray3[n], nArray4[n2], n3);
            }
        };
        wrapperIntMatrix2D.setNrows(nArray.length);
        wrapperIntMatrix2D.setNcolumns(nArray2.length);
        return wrapperIntMatrix2D;
    }

    public IntMatrix2D viewStrides(final int n, final int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new IndexOutOfBoundsException("illegal stride");
        }
        WrapperIntMatrix2D wrapperIntMatrix2D = new WrapperIntMatrix2D(this){

            public int getQuick(int n3, int n22) {
                return this.content.get(n * n3, n2 * n22);
            }

            public void setQuick(int n4, int n22, int n3) {
                this.content.set(n * n4, n2 * n22, n3);
            }
        };
        wrapperIntMatrix2D.setNrows(this.rows);
        wrapperIntMatrix2D.setNcolumns(this.columns);
        if (this.rows != 0) {
            wrapperIntMatrix2D.setNrows((this.rows - 1) / n + 1);
        }
        if (this.columns != 0) {
            wrapperIntMatrix2D.setNcolumns((this.columns - 1) / n2 + 1);
        }
        return wrapperIntMatrix2D;
    }

    protected IntMatrix2D getContent() {
        return this.content;
    }

    protected IntMatrix1D like1D(int n, int n2, int n3) {
        throw new InternalError();
    }

    protected IntMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        throw new InternalError();
    }
}

