/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.IntMatrix3D;

public class WrapperIntMatrix1D
extends IntMatrix1D {
    protected IntMatrix1D content;

    public WrapperIntMatrix1D(IntMatrix1D intMatrix1D) {
        if (intMatrix1D != null) {
            this.setUp(intMatrix1D.size());
        }
        this.content = intMatrix1D;
    }

    protected IntMatrix1D getContent() {
        return this.content;
    }

    public int getQuick(int n) {
        return this.content.getQuick(n);
    }

    public Object elements() {
        return this.content.elements();
    }

    public IntMatrix1D like(int n) {
        return this.content.like(n);
    }

    public IntMatrix2D like2D(int n, int n2) {
        return this.content.like2D(n, n2);
    }

    public IntMatrix2D reshape(int n, int n2) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public IntMatrix3D reshape(int n, int n2, int n3) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public void setQuick(int n, int n2) {
        this.content.setQuick(n, n2);
    }

    public IntMatrix1D viewFlip() {
        WrapperIntMatrix1D wrapperIntMatrix1D = new WrapperIntMatrix1D(this){

            public int getQuick(int n) {
                return this.content.get(this.size - 1 - n);
            }

            public void setQuick(int n, int n2) {
                this.content.set(this.size - 1 - n, n2);
            }
        };
        return wrapperIntMatrix1D;
    }

    public IntMatrix1D viewPart(final int n, int n2) {
        this.checkRange(n, n2);
        WrapperIntMatrix1D wrapperIntMatrix1D = new WrapperIntMatrix1D(this){

            public int getQuick(int n2) {
                return this.content.get(n + n2);
            }

            public void setQuick(int n3, int n2) {
                this.content.set(n + n3, n2);
            }
        };
        wrapperIntMatrix1D.setSize(n2);
        return wrapperIntMatrix1D;
    }

    public IntMatrix1D viewSelection(int[] nArray) {
        if (nArray == null) {
            nArray = new int[this.size];
            int n = this.size;
            while (--n >= 0) {
                nArray[n] = n;
            }
        }
        this.checkIndexes(nArray);
        final int[] nArray2 = nArray;
        WrapperIntMatrix1D wrapperIntMatrix1D = new WrapperIntMatrix1D(this){

            public int getQuick(int n) {
                return this.content.get(nArray2[n]);
            }

            public void setQuick(int n, int n2) {
                this.content.set(nArray2[n], n2);
            }
        };
        wrapperIntMatrix1D.setSize(nArray.length);
        return wrapperIntMatrix1D;
    }

    protected IntMatrix1D viewSelectionLike(int[] nArray) {
        throw new InternalError();
    }

    public IntMatrix1D viewStrides(final int n) {
        if (this.stride <= 0) {
            throw new IndexOutOfBoundsException("illegal stride: " + this.stride);
        }
        WrapperIntMatrix1D wrapperIntMatrix1D = new WrapperIntMatrix1D(this){

            public int getQuick(int n2) {
                return this.content.get(n2 * n);
            }

            public void setQuick(int n3, int n2) {
                this.content.set(n3 * n, n2);
            }
        };
        wrapperIntMatrix1D.setSize(this.size);
        if (this.size != 0) {
            wrapperIntMatrix1D.setSize((this.size - 1) / n + 1);
        }
        return wrapperIntMatrix1D;
    }
}

