/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.map.tint.AbstractIntIntMap;
import cern.colt.map.tint.OpenIntIntHashMap;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.IntMatrix3D;
import cern.colt.matrix.tint.impl.SelectedSparseIntMatrix3D;
import cern.colt.matrix.tint.impl.SparseIntMatrix2D;

public class SparseIntMatrix3D
extends IntMatrix3D {
    protected AbstractIntIntMap elements;

    public SparseIntMatrix3D(int[][][] nArray) {
        this(nArray.length, nArray.length == 0 ? 0 : nArray[0].length, nArray.length == 0 ? 0 : (nArray[0].length == 0 ? 0 : nArray[0][0].length));
        this.assign(nArray);
    }

    public SparseIntMatrix3D(int n, int n2, int n3) {
        this(n, n2, n3, n * n2 * (n3 / 1000), 0.2, 0.5);
    }

    public SparseIntMatrix3D(int n, int n2, int n3, int n4, double d, double d2) {
        this.setUp(n, n2, n3);
        this.elements = new OpenIntIntHashMap(n4, d, d2);
    }

    protected SparseIntMatrix3D(int n, int n2, int n3, AbstractIntIntMap abstractIntIntMap, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.setUp(n, n2, n3, n4, n5, n6, n7, n8, n9);
        this.elements = abstractIntIntMap;
        this.isNoView = false;
    }

    public IntMatrix3D assign(int n) {
        if (this.isNoView && n == 0) {
            this.elements.clear();
        } else {
            super.assign(n);
        }
        return this;
    }

    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    public AbstractIntIntMap elements() {
        return this.elements;
    }

    public void ensureCapacity(int n) {
        this.elements.ensureCapacity(n);
    }

    public int getQuick(int n, int n2, int n3) {
        return this.elements.get(this.sliceZero + n * this.sliceStride + this.rowZero + n2 * this.rowStride + this.columnZero + n3 * this.columnStride);
    }

    public long index(int n, int n2, int n3) {
        return this.sliceZero + n * this.sliceStride + this.rowZero + n2 * this.rowStride + this.columnZero + n3 * this.columnStride;
    }

    public IntMatrix3D like(int n, int n2, int n3) {
        return new SparseIntMatrix3D(n, n2, n3);
    }

    public synchronized void setQuick(int n, int n2, int n3, int n4) {
        int n5 = this.sliceZero + n * this.sliceStride + this.rowZero + n2 * this.rowStride + this.columnZero + n3 * this.columnStride;
        if (n4 == 0) {
            this.elements.removeKey(n5);
        } else {
            this.elements.put(n5, n4);
        }
    }

    public void trimToSize() {
        this.elements.trimToSize();
    }

    public IntMatrix1D vectorize() {
        throw new IllegalArgumentException("This method is not supported.");
    }

    protected boolean haveSharedCellsRaw(IntMatrix3D intMatrix3D) {
        if (intMatrix3D instanceof SelectedSparseIntMatrix3D) {
            SelectedSparseIntMatrix3D selectedSparseIntMatrix3D = (SelectedSparseIntMatrix3D)intMatrix3D;
            return this.elements == selectedSparseIntMatrix3D.elements;
        }
        if (intMatrix3D instanceof SparseIntMatrix3D) {
            SparseIntMatrix3D sparseIntMatrix3D = (SparseIntMatrix3D)intMatrix3D;
            return this.elements == sparseIntMatrix3D.elements;
        }
        return false;
    }

    protected IntMatrix2D like2D(int n, int n2, int n3, int n4, int n5, int n6) {
        return new SparseIntMatrix2D(n, n2, this.elements, n3, n4, n5, n6);
    }

    protected IntMatrix3D viewSelectionLike(int[] nArray, int[] nArray2, int[] nArray3) {
        return new SelectedSparseIntMatrix3D(this.elements, nArray, nArray2, nArray3, 0);
    }
}

