/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.function.tint.IntFunction;
import cern.colt.function.tint.IntIntFunction;
import cern.colt.function.tint.IntIntIntFunction;
import cern.colt.function.tint.IntIntProcedure;
import cern.colt.map.tint.AbstractIntIntMap;
import cern.colt.map.tint.OpenIntIntHashMap;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.impl.DenseIntMatrix1D;
import cern.colt.matrix.tint.impl.DenseIntMatrix2D;
import cern.colt.matrix.tint.impl.SelectedSparseIntMatrix2D;
import cern.colt.matrix.tint.impl.SparseIntMatrix1D;
import cern.jet.math.tint.IntFunctions;
import cern.jet.math.tint.IntMult;
import cern.jet.math.tint.IntPlusMultSecond;

public class SparseIntMatrix2D
extends IntMatrix2D {
    protected AbstractIntIntMap elements;
    protected int dummy;

    public SparseIntMatrix2D(int[][] nArray) {
        this(nArray.length, nArray.length == 0 ? 0 : nArray[0].length);
        this.assign(nArray);
    }

    public SparseIntMatrix2D(int n, int n2) {
        this(n, n2, n * (n2 / 1000), 0.2, 0.5);
    }

    public SparseIntMatrix2D(int n, int n2, int n3, double d, double d2) {
        this.setUp(n, n2);
        this.elements = new OpenIntIntHashMap(n3, d, d2);
    }

    protected SparseIntMatrix2D(int n, int n2, AbstractIntIntMap abstractIntIntMap, int n3, int n4, int n5, int n6) {
        this.setUp(n, n2, n3, n4, n5, n6);
        this.elements = abstractIntIntMap;
        this.isNoView = false;
    }

    public IntMatrix2D assign(IntFunction intFunction) {
        if (this.isNoView && intFunction instanceof IntMult) {
            this.elements.assign(intFunction);
        } else {
            super.assign(intFunction);
        }
        return this;
    }

    public IntMatrix2D assign(int n) {
        if (this.isNoView && n == 0) {
            this.elements.clear();
        } else {
            super.assign(n);
        }
        return this;
    }

    public IntMatrix2D assign(IntMatrix2D intMatrix2D) {
        if (!(intMatrix2D instanceof SparseIntMatrix2D)) {
            return super.assign(intMatrix2D);
        }
        SparseIntMatrix2D sparseIntMatrix2D = (SparseIntMatrix2D)intMatrix2D;
        if (sparseIntMatrix2D == this) {
            return this;
        }
        this.checkShape(sparseIntMatrix2D);
        if (this.isNoView && sparseIntMatrix2D.isNoView) {
            this.elements.assign(sparseIntMatrix2D.elements);
            return this;
        }
        return super.assign(intMatrix2D);
    }

    public IntMatrix2D assign(final IntMatrix2D intMatrix2D, IntIntFunction intIntFunction) {
        if (!this.isNoView) {
            return super.assign(intMatrix2D, intIntFunction);
        }
        this.checkShape(intMatrix2D);
        if (intIntFunction instanceof IntPlusMultSecond) {
            final int n = ((IntPlusMultSecond)intIntFunction).multiplicator;
            if (n == 0) {
                return this;
            }
            intMatrix2D.forEachNonZero(new IntIntIntFunction(){

                public int apply(int n4, int n2, int n3) {
                    SparseIntMatrix2D.this.setQuick(n4, n2, SparseIntMatrix2D.this.getQuick(n4, n2) + n * n3);
                    return n3;
                }
            });
            return this;
        }
        if (intIntFunction == IntFunctions.mult) {
            this.elements.forEachPair(new IntIntProcedure(){

                public boolean apply(int n, int n2) {
                    int n3;
                    int n4 = n / SparseIntMatrix2D.this.columns;
                    int n5 = n2 * intMatrix2D.getQuick(n4, n3 = n % SparseIntMatrix2D.this.columns);
                    if (n5 != n2) {
                        SparseIntMatrix2D.this.elements.put(n, n5);
                    }
                    return true;
                }
            });
        }
        if (intIntFunction == IntFunctions.div) {
            this.elements.forEachPair(new IntIntProcedure(){

                public boolean apply(int n, int n2) {
                    int n3;
                    int n4 = n / SparseIntMatrix2D.this.columns;
                    int n5 = n2 / intMatrix2D.getQuick(n4, n3 = n % SparseIntMatrix2D.this.columns);
                    if (n5 != n2) {
                        SparseIntMatrix2D.this.elements.put(n, n5);
                    }
                    return true;
                }
            });
        }
        return super.assign(intMatrix2D, intIntFunction);
    }

    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    public AbstractIntIntMap elements() {
        return this.elements;
    }

    public void ensureCapacity(int n) {
        this.elements.ensureCapacity(n);
    }

    public IntMatrix2D forEachNonZero(final IntIntIntFunction intIntIntFunction) {
        if (this.isNoView) {
            this.elements.forEachPair(new IntIntProcedure(){

                public boolean apply(int n, int n2) {
                    int n3;
                    int n4 = n / SparseIntMatrix2D.this.columns;
                    int n5 = intIntIntFunction.apply(n4, n3 = n % SparseIntMatrix2D.this.columns, n2);
                    if (n5 != n2) {
                        SparseIntMatrix2D.this.elements.put(n, n5);
                    }
                    return true;
                }
            });
        } else {
            super.forEachNonZero(intIntIntFunction);
        }
        return this;
    }

    public int getQuick(int n, int n2) {
        return this.elements.get(this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride);
    }

    public long index(int n, int n2) {
        return this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride;
    }

    public IntMatrix2D like(int n, int n2) {
        return new SparseIntMatrix2D(n, n2);
    }

    public IntMatrix1D like1D(int n) {
        return new SparseIntMatrix1D(n);
    }

    public synchronized void setQuick(int n, int n2, int n3) {
        int n4 = this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride;
        if (n3 == 0) {
            this.elements.removeKey(n4);
        } else {
            this.elements.put(n4, n3);
        }
    }

    public void trimToSize() {
        this.elements.trimToSize();
    }

    public IntMatrix1D vectorize() {
        SparseIntMatrix1D sparseIntMatrix1D = new SparseIntMatrix1D(this.size());
        int n = 0;
        for (int i = 0; i < this.columns; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                sparseIntMatrix1D.setQuick(n++, this.getQuick(i, j));
            }
        }
        return sparseIntMatrix1D;
    }

    public IntMatrix1D zMult(IntMatrix1D intMatrix1D, IntMatrix1D intMatrix1D2, int n, int n2, final boolean bl) {
        boolean bl2;
        int n3 = this.rows;
        int n4 = this.columns;
        if (bl) {
            n3 = this.columns;
            n4 = this.rows;
        }
        boolean bl3 = bl2 = intMatrix1D2 == null;
        if (intMatrix1D2 == null) {
            intMatrix1D2 = new DenseIntMatrix1D(n3);
        }
        if (!(this.isNoView && intMatrix1D instanceof DenseIntMatrix1D && intMatrix1D2 instanceof DenseIntMatrix1D)) {
            return super.zMult(intMatrix1D, intMatrix1D2, n, n2, bl);
        }
        if (n4 != intMatrix1D.size() || n3 > intMatrix1D2.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (bl ? this.viewDice() : this).toStringShort() + ", " + intMatrix1D.toStringShort() + ", " + intMatrix1D2.toStringShort());
        }
        if (!bl2) {
            intMatrix1D2.assign(IntFunctions.mult(n2 / n));
        }
        DenseIntMatrix1D denseIntMatrix1D = (DenseIntMatrix1D)intMatrix1D2;
        final int[] nArray = denseIntMatrix1D.elements;
        final int n5 = denseIntMatrix1D.stride();
        final int n6 = (int)intMatrix1D2.index(0);
        DenseIntMatrix1D denseIntMatrix1D2 = (DenseIntMatrix1D)intMatrix1D;
        final int[] nArray2 = denseIntMatrix1D2.elements;
        final int n7 = denseIntMatrix1D2.stride();
        final int n8 = (int)intMatrix1D.index(0);
        if (nArray2 == null || nArray == null) {
            throw new InternalError();
        }
        this.elements.forEachPair(new IntIntProcedure(){

            public boolean apply(int n, int n2) {
                int n3 = n / SparseIntMatrix2D.this.columns;
                int n4 = n % SparseIntMatrix2D.this.columns;
                if (bl) {
                    int n52 = n3;
                    n3 = n4;
                    n4 = n52;
                }
                int n62 = n6 + n5 * n3;
                nArray[n62] = nArray[n62] + n2 * nArray2[n8 + n7 * n4];
                return true;
            }
        });
        if (n != 1) {
            intMatrix1D2.assign(IntFunctions.mult(n));
        }
        return intMatrix1D2;
    }

    public IntMatrix2D zMult(IntMatrix2D intMatrix2D, IntMatrix2D intMatrix2D2, final int n, int n2, final boolean bl, boolean bl2) {
        boolean bl3;
        if (!this.isNoView) {
            return super.zMult(intMatrix2D, intMatrix2D2, n, n2, bl, bl2);
        }
        if (bl2) {
            intMatrix2D = intMatrix2D.viewDice();
        }
        int n3 = this.rows;
        int n4 = this.columns;
        if (bl) {
            n3 = this.columns;
            n4 = this.rows;
        }
        int n5 = intMatrix2D.columns();
        boolean bl4 = bl3 = intMatrix2D2 == null;
        if (intMatrix2D2 == null) {
            intMatrix2D2 = new DenseIntMatrix2D(n3, n5);
        }
        if (intMatrix2D.rows() != n4) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + (bl2 ? intMatrix2D.viewDice() : intMatrix2D).toStringShort());
        }
        if (intMatrix2D2.rows() != n3 || intMatrix2D2.columns() != n5) {
            throw new IllegalArgumentException("Incompatibel result matrix: " + this.toStringShort() + ", " + (bl2 ? intMatrix2D.viewDice() : intMatrix2D).toStringShort() + ", " + intMatrix2D2.toStringShort());
        }
        if (this == intMatrix2D2 || intMatrix2D == intMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!bl3) {
            intMatrix2D2.assign(IntFunctions.mult(n2));
        }
        final IntMatrix1D[] intMatrix1DArray = new IntMatrix1D[n4];
        int n6 = n4;
        while (--n6 >= 0) {
            intMatrix1DArray[n6] = intMatrix2D.viewRow(n6);
        }
        final IntMatrix1D[] intMatrix1DArray2 = new IntMatrix1D[n3];
        int n7 = n3;
        while (--n7 >= 0) {
            intMatrix1DArray2[n7] = intMatrix2D2.viewRow(n7);
        }
        final IntPlusMultSecond intPlusMultSecond = IntPlusMultSecond.plusMult(0);
        this.elements.forEachPair(new IntIntProcedure(){

            public boolean apply(int n5, int n2) {
                int n3 = n5 / SparseIntMatrix2D.this.columns;
                int n4 = n5 % SparseIntMatrix2D.this.columns;
                intPlusMultSecond.multiplicator = n2 * n;
                if (!bl) {
                    intMatrix1DArray2[n3].assign(intMatrix1DArray[n4], intPlusMultSecond);
                } else {
                    intMatrix1DArray2[n4].assign(intMatrix1DArray[n3], intPlusMultSecond);
                }
                return true;
            }
        });
        return intMatrix2D2;
    }

    protected boolean haveSharedCellsRaw(IntMatrix2D intMatrix2D) {
        if (intMatrix2D instanceof SelectedSparseIntMatrix2D) {
            SelectedSparseIntMatrix2D selectedSparseIntMatrix2D = (SelectedSparseIntMatrix2D)intMatrix2D;
            return this.elements == selectedSparseIntMatrix2D.elements;
        }
        if (intMatrix2D instanceof SparseIntMatrix2D) {
            SparseIntMatrix2D sparseIntMatrix2D = (SparseIntMatrix2D)intMatrix2D;
            return this.elements == sparseIntMatrix2D.elements;
        }
        return false;
    }

    protected IntMatrix1D like1D(int n, int n2, int n3) {
        return new SparseIntMatrix1D(n, this.elements, n2, n3);
    }

    protected IntMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        return new SelectedSparseIntMatrix2D(this.elements, nArray, nArray2, 0);
    }
}

