/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.map.tint.AbstractIntIntMap;
import cern.colt.map.tint.OpenIntIntHashMap;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.IntMatrix3D;
import cern.colt.matrix.tint.impl.SelectedSparseIntMatrix1D;
import cern.colt.matrix.tint.impl.SparseIntMatrix2D;

public class SparseIntMatrix1D
extends IntMatrix1D {
    protected AbstractIntIntMap elements;

    public SparseIntMatrix1D(int[] nArray) {
        this(nArray.length);
        this.assign(nArray);
    }

    public SparseIntMatrix1D(int n) {
        this(n, n / 1000, 0.2, 0.5);
    }

    public SparseIntMatrix1D(int n, int n2, double d, double d2) {
        this.setUp(n);
        this.elements = new OpenIntIntHashMap(n2, d, d2);
    }

    protected SparseIntMatrix1D(int n, AbstractIntIntMap abstractIntIntMap, int n2, int n3) {
        this.setUp(n, n2, n3);
        this.elements = abstractIntIntMap;
        this.isNoView = false;
    }

    public IntMatrix1D assign(int n) {
        if (this.isNoView && n == 0) {
            this.elements.clear();
        } else {
            super.assign(n);
        }
        return this;
    }

    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    public void dct(boolean bl) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public void dht() {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public void dst(boolean bl) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public AbstractIntIntMap elements() {
        return this.elements;
    }

    public void ensureCapacity(int n) {
        this.elements.ensureCapacity(n);
    }

    public int getQuick(int n) {
        return this.elements.get(this.zero + n * this.stride);
    }

    public long index(int n) {
        return this.zero + n * this.stride;
    }

    public IntMatrix1D like(int n) {
        return new SparseIntMatrix1D(n);
    }

    public IntMatrix2D like2D(int n, int n2) {
        return new SparseIntMatrix2D(n, n2);
    }

    public IntMatrix2D reshape(int n, int n2) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public IntMatrix3D reshape(int n, int n2, int n3) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public synchronized void setQuick(int n, int n2) {
        int n3 = this.zero + n * this.stride;
        if (n2 == 0) {
            this.elements.removeKey(n3);
        } else {
            this.elements.put(n3, n2);
        }
    }

    public void trimToSize() {
        this.elements.trimToSize();
    }

    protected boolean haveSharedCellsRaw(IntMatrix1D intMatrix1D) {
        if (intMatrix1D instanceof SelectedSparseIntMatrix1D) {
            SelectedSparseIntMatrix1D selectedSparseIntMatrix1D = (SelectedSparseIntMatrix1D)intMatrix1D;
            return this.elements == selectedSparseIntMatrix1D.elements;
        }
        if (intMatrix1D instanceof SparseIntMatrix1D) {
            SparseIntMatrix1D sparseIntMatrix1D = (SparseIntMatrix1D)intMatrix1D;
            return this.elements == sparseIntMatrix1D.elements;
        }
        return false;
    }

    protected IntMatrix1D viewSelectionLike(int[] nArray) {
        return new SelectedSparseIntMatrix1D(this.elements, nArray);
    }
}

