/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.map.tint.AbstractIntIntMap;
import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.IntMatrix3D;
import cern.colt.matrix.tint.impl.SelectedSparseIntMatrix2D;
import cern.colt.matrix.tint.impl.SparseIntMatrix3D;

class SelectedSparseIntMatrix3D
extends IntMatrix3D {
    protected AbstractIntIntMap elements;
    protected int[] sliceOffsets;
    protected int[] rowOffsets;
    protected int[] columnOffsets;
    protected int offset;

    protected SelectedSparseIntMatrix3D(AbstractIntIntMap abstractIntIntMap, int[] nArray, int[] nArray2, int[] nArray3, int n) {
        int n2 = nArray.length;
        int n3 = nArray2.length;
        int n4 = nArray3.length;
        this.setUp(n2, n3, n4);
        this.elements = abstractIntIntMap;
        this.sliceOffsets = nArray;
        this.rowOffsets = nArray2;
        this.columnOffsets = nArray3;
        this.offset = n;
        this.isNoView = false;
    }

    public AbstractIntIntMap elements() {
        return this.elements;
    }

    public int getQuick(int n, int n2, int n3) {
        return this.elements.get(this.offset + this.sliceOffsets[this.sliceZero + n * this.sliceStride] + this.rowOffsets[this.rowZero + n2 * this.rowStride] + this.columnOffsets[this.columnZero + n3 * this.columnStride]);
    }

    public long index(int n, int n2, int n3) {
        return this.offset + this.sliceOffsets[this.sliceZero + n * this.sliceStride] + this.rowOffsets[this.rowZero + n2 * this.rowStride] + this.columnOffsets[this.columnZero + n3 * this.columnStride];
    }

    public IntMatrix3D like(int n, int n2, int n3) {
        return new SparseIntMatrix3D(n, n2, n3);
    }

    public void setQuick(int n, int n2, int n3, int n4) {
        int n5 = this.offset + this.sliceOffsets[this.sliceZero + n * this.sliceStride] + this.rowOffsets[this.rowZero + n2 * this.rowStride] + this.columnOffsets[this.columnZero + n3 * this.columnStride];
        if (n4 == 0) {
            this.elements.removeKey(n5);
        } else {
            this.elements.put(n5, n4);
        }
    }

    public IntMatrix1D vectorize() {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public IntMatrix2D viewColumn(int n) {
        this.checkColumn(n);
        int n2 = this.slices;
        int n3 = this.rows;
        int n4 = this.sliceZero;
        int n5 = this.rowZero;
        int n6 = this.offset + this._columnOffset(this._columnRank(n));
        int n7 = this.sliceStride;
        int n8 = this.rowStride;
        int[] nArray = this.sliceOffsets;
        int[] nArray2 = this.rowOffsets;
        return new SelectedSparseIntMatrix2D(n2, n3, this.elements, n4, n5, n7, n8, nArray, nArray2, n6);
    }

    public IntMatrix2D viewRow(int n) {
        this.checkRow(n);
        int n2 = this.slices;
        int n3 = this.columns;
        int n4 = this.sliceZero;
        int n5 = this.columnZero;
        int n6 = this.offset + this._rowOffset(this._rowRank(n));
        int n7 = this.sliceStride;
        int n8 = this.columnStride;
        int[] nArray = this.sliceOffsets;
        int[] nArray2 = this.columnOffsets;
        return new SelectedSparseIntMatrix2D(n2, n3, this.elements, n4, n5, n7, n8, nArray, nArray2, n6);
    }

    public IntMatrix2D viewSlice(int n) {
        this.checkSlice(n);
        int n2 = this.rows;
        int n3 = this.columns;
        int n4 = this.rowZero;
        int n5 = this.columnZero;
        int n6 = this.offset + this._sliceOffset(this._sliceRank(n));
        int n7 = this.rowStride;
        int n8 = this.columnStride;
        int[] nArray = this.rowOffsets;
        int[] nArray2 = this.columnOffsets;
        return new SelectedSparseIntMatrix2D(n2, n3, this.elements, n4, n5, n7, n8, nArray, nArray2, n6);
    }

    protected int _columnOffset(int n) {
        return this.columnOffsets[n];
    }

    protected int _rowOffset(int n) {
        return this.rowOffsets[n];
    }

    protected int _sliceOffset(int n) {
        return this.sliceOffsets[n];
    }

    protected boolean haveSharedCellsRaw(IntMatrix3D intMatrix3D) {
        if (intMatrix3D instanceof SelectedSparseIntMatrix3D) {
            SelectedSparseIntMatrix3D selectedSparseIntMatrix3D = (SelectedSparseIntMatrix3D)intMatrix3D;
            return this.elements == selectedSparseIntMatrix3D.elements;
        }
        if (intMatrix3D instanceof SparseIntMatrix3D) {
            SparseIntMatrix3D sparseIntMatrix3D = (SparseIntMatrix3D)intMatrix3D;
            return this.elements == sparseIntMatrix3D.elements;
        }
        return false;
    }

    protected IntMatrix2D like2D(int n, int n2, int n3, int n4, int n5, int n6) {
        throw new InternalError();
    }

    protected void setUp(int n, int n2, int n3) {
        super.setUp(n, n2, n3);
        this.sliceStride = 1;
        this.rowStride = 1;
        this.columnStride = 1;
        this.offset = 0;
    }

    protected AbstractMatrix3D vDice(int n, int n2, int n3) {
        super.vDice(n, n2, n3);
        int[][] nArrayArray = new int[][]{this.sliceOffsets, this.rowOffsets, this.columnOffsets};
        this.sliceOffsets = nArrayArray[n];
        this.rowOffsets = nArrayArray[n2];
        this.columnOffsets = nArrayArray[n3];
        return this;
    }

    protected IntMatrix3D viewSelectionLike(int[] nArray, int[] nArray2, int[] nArray3) {
        return new SelectedSparseIntMatrix3D(this.elements, nArray, nArray2, nArray3, this.offset);
    }
}

