/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.map.tint.AbstractIntIntMap;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.impl.SelectedSparseIntMatrix1D;
import cern.colt.matrix.tint.impl.SparseIntMatrix1D;
import cern.colt.matrix.tint.impl.SparseIntMatrix2D;

class SelectedSparseIntMatrix2D
extends IntMatrix2D {
    protected AbstractIntIntMap elements;
    protected int[] rowOffsets;
    protected int[] columnOffsets;
    protected int offset;

    protected SelectedSparseIntMatrix2D(AbstractIntIntMap abstractIntIntMap, int[] nArray, int[] nArray2, int n) {
        this(nArray.length, nArray2.length, abstractIntIntMap, 0, 0, 1, 1, nArray, nArray2, n);
    }

    protected SelectedSparseIntMatrix2D(int n, int n2, AbstractIntIntMap abstractIntIntMap, int n3, int n4, int n5, int n6, int[] nArray, int[] nArray2, int n7) {
        this.setUp(n, n2, n3, n4, n5, n6);
        this.elements = abstractIntIntMap;
        this.rowOffsets = nArray;
        this.columnOffsets = nArray2;
        this.offset = n7;
        this.isNoView = false;
    }

    public AbstractIntIntMap elements() {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public int getQuick(int n, int n2) {
        return this.elements.get(this.offset + this.rowOffsets[this.rowZero + n * this.rowStride] + this.columnOffsets[this.columnZero + n2 * this.columnStride]);
    }

    public long index(int n, int n2) {
        return this.offset + this.rowOffsets[this.rowZero + n * this.rowStride] + this.columnOffsets[this.columnZero + n2 * this.columnStride];
    }

    public IntMatrix2D like(int n, int n2) {
        return new SparseIntMatrix2D(n, n2);
    }

    public IntMatrix1D like1D(int n) {
        return new SparseIntMatrix1D(n);
    }

    public void setQuick(int n, int n2, int n3) {
        int n4 = this.offset + this.rowOffsets[this.rowZero + n * this.rowStride] + this.columnOffsets[this.columnZero + n2 * this.columnStride];
        if (n3 == 0) {
            this.elements.removeKey(n4);
        } else {
            this.elements.put(n4, n3);
        }
    }

    public IntMatrix1D vectorize() {
        SparseIntMatrix1D sparseIntMatrix1D = new SparseIntMatrix1D(this.size());
        int n = 0;
        for (int i = 0; i < this.columns; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                sparseIntMatrix1D.setQuick(n++, this.getQuick(i, j));
            }
        }
        return sparseIntMatrix1D;
    }

    public IntMatrix1D viewColumn(int n) {
        this.checkColumn(n);
        int n2 = this.rows;
        int n3 = this.rowZero;
        int n4 = this.rowStride;
        int[] nArray = this.rowOffsets;
        int n5 = this.offset + this._columnOffset(this._columnRank(n));
        return new SelectedSparseIntMatrix1D(n2, this.elements, n3, n4, nArray, n5);
    }

    public IntMatrix1D viewRow(int n) {
        this.checkRow(n);
        int n2 = this.columns;
        int n3 = this.columnZero;
        int n4 = this.columnStride;
        int[] nArray = this.columnOffsets;
        int n5 = this.offset + this._rowOffset(this._rowRank(n));
        return new SelectedSparseIntMatrix1D(n2, this.elements, n3, n4, nArray, n5);
    }

    protected int _columnOffset(int n) {
        return this.columnOffsets[n];
    }

    protected int _rowOffset(int n) {
        return this.rowOffsets[n];
    }

    protected boolean haveSharedCellsRaw(IntMatrix2D intMatrix2D) {
        if (intMatrix2D instanceof SelectedSparseIntMatrix2D) {
            SelectedSparseIntMatrix2D selectedSparseIntMatrix2D = (SelectedSparseIntMatrix2D)intMatrix2D;
            return this.elements == selectedSparseIntMatrix2D.elements;
        }
        if (intMatrix2D instanceof SparseIntMatrix2D) {
            SparseIntMatrix2D sparseIntMatrix2D = (SparseIntMatrix2D)intMatrix2D;
            return this.elements == sparseIntMatrix2D.elements;
        }
        return false;
    }

    protected IntMatrix1D like1D(int n, int n2, int n3) {
        throw new InternalError();
    }

    protected void setUp(int n, int n2) {
        super.setUp(n, n2);
        this.rowStride = 1;
        this.columnStride = 1;
        this.offset = 0;
    }

    protected AbstractMatrix2D vDice() {
        super.vDice();
        int[] nArray = this.rowOffsets;
        this.rowOffsets = this.columnOffsets;
        this.columnOffsets = nArray;
        this.isNoView = false;
        return this;
    }

    protected IntMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        return new SelectedSparseIntMatrix2D(this.elements, nArray, nArray2, this.offset);
    }
}

