/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.map.tint.AbstractIntIntMap;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.IntMatrix3D;
import cern.colt.matrix.tint.impl.SparseIntMatrix1D;
import cern.colt.matrix.tint.impl.SparseIntMatrix2D;

class SelectedSparseIntMatrix1D
extends IntMatrix1D {
    protected AbstractIntIntMap elements;
    protected int[] offsets;
    protected int offset;

    protected SelectedSparseIntMatrix1D(AbstractIntIntMap abstractIntIntMap, int[] nArray) {
        this(nArray.length, abstractIntIntMap, 0, 1, nArray, 0);
    }

    protected SelectedSparseIntMatrix1D(int n, AbstractIntIntMap abstractIntIntMap, int n2, int n3, int[] nArray, int n4) {
        this.setUp(n, n2, n3);
        this.elements = abstractIntIntMap;
        this.offsets = nArray;
        this.offset = n4;
        this.isNoView = false;
    }

    public AbstractIntIntMap elements() {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public int getQuick(int n) {
        return this.elements.get(this.offset + this.offsets[this.zero + n * this.stride]);
    }

    public long index(int n) {
        return this.offset + this.offsets[this.zero + n * this.stride];
    }

    public IntMatrix1D like(int n) {
        return new SparseIntMatrix1D(n);
    }

    public IntMatrix2D like2D(int n, int n2) {
        return new SparseIntMatrix2D(n, n2);
    }

    public IntMatrix2D reshape(int n, int n2) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public IntMatrix3D reshape(int n, int n2, int n3) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public void setQuick(int n, int n2) {
        int n3 = this.offset + this.offsets[this.zero + n * this.stride];
        if (n2 == 0) {
            this.elements.removeKey(n3);
        } else {
            this.elements.put(n3, n2);
        }
    }

    protected int _offset(int n) {
        return this.offsets[n];
    }

    protected boolean haveSharedCellsRaw(IntMatrix1D intMatrix1D) {
        if (intMatrix1D instanceof SelectedSparseIntMatrix1D) {
            SelectedSparseIntMatrix1D selectedSparseIntMatrix1D = (SelectedSparseIntMatrix1D)intMatrix1D;
            return this.elements == selectedSparseIntMatrix1D.elements;
        }
        if (intMatrix1D instanceof SparseIntMatrix1D) {
            SparseIntMatrix1D sparseIntMatrix1D = (SparseIntMatrix1D)intMatrix1D;
            return this.elements == sparseIntMatrix1D.elements;
        }
        return false;
    }

    protected void setUp(int n) {
        super.setUp(n);
        this.stride = 1;
        this.offset = 0;
    }

    protected IntMatrix1D viewSelectionLike(int[] nArray) {
        return new SelectedSparseIntMatrix1D(this.elements, nArray);
    }
}

