/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.function.tint.IntFunction;
import cern.colt.function.tint.IntIntFunction;
import cern.colt.function.tint.IntIntIntFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.impl.DenseIntMatrix1D;
import cern.colt.matrix.tint.impl.DenseIntMatrix2D;
import cern.colt.matrix.tint.impl.SparseIntMatrix1D;
import cern.colt.matrix.tint.impl.WrapperIntMatrix2D;
import cern.jet.math.tint.IntFunctions;
import cern.jet.math.tint.IntMult;
import cern.jet.math.tint.IntPlusMultFirst;
import cern.jet.math.tint.IntPlusMultSecond;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class RCIntMatrix2D
extends WrapperIntMatrix2D {
    protected IntArrayList columnIndexes;
    protected IntArrayList values;
    protected int[] rowPointers;

    public RCIntMatrix2D(int[][] nArray) {
        this(nArray.length, nArray.length == 0 ? 0 : nArray[0].length);
        this.assign(nArray);
    }

    public RCIntMatrix2D(int n, int n2, int[] nArray, IntArrayList intArrayList, IntArrayList intArrayList2) {
        block2: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.rowPointers = nArray;
        this.columnIndexes = intArrayList;
        this.values = intArrayList2;
    }

    public RCIntMatrix2D(int n, int n2) {
        block2: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.columnIndexes = new IntArrayList();
        this.values = new IntArrayList();
        this.rowPointers = new int[n + 1];
    }

    public RCIntMatrix2D(int n, int n2, int n3) {
        block2: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.columnIndexes = new IntArrayList(n3);
        this.values = new IntArrayList(n3);
        this.rowPointers = new int[n + 1];
    }

    public IntMatrix2D assign(int n) {
        if (n == 0) {
            this.columnIndexes.clear();
            this.values.clear();
            this.rowPointers = new int[this.rows + 1];
        } else {
            int n2 = this.cardinality();
            for (int i = 0; i < n2; ++i) {
                this.values.setQuick(i, n);
            }
        }
        return this;
    }

    public IntMatrix2D assign(final IntFunction intFunction) {
        if (intFunction instanceof IntMult) {
            final int n = ((IntMult)intFunction).multiplicator;
            if (n == 1) {
                return this;
            }
            if (n == 0) {
                return this.assign(0);
            }
            if (n != n) {
                return this.assign(n);
            }
            final int[] nArray = this.values.elements();
            int n2 = ConcurrencyUtils.getNumberOfThreads();
            if (n2 > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futureArray = new Future[n2];
                int n3 = nArray.length / n2;
                for (int i = 0; i < n2; ++i) {
                    final int n4 = i * n3;
                    final int n5 = i == n2 - 1 ? nArray.length : n4 + n3;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n3 = n4;
                            while (n3 < n5) {
                                int n2 = n3++;
                                nArray[n2] = nArray[n2] * n;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n6 = this.values.size();
                while (--n6 >= 0) {
                    int n7 = n6;
                    nArray[n7] = nArray[n7] * n;
                }
            }
        } else {
            this.forEachNonZero(new IntIntIntFunction(){

                public int apply(int n, int n2, int n3) {
                    return intFunction.apply(n3);
                }
            });
        }
        return this;
    }

    public IntMatrix2D assign(IntMatrix2D intMatrix2D) {
        if (intMatrix2D == this) {
            return this;
        }
        this.checkShape(intMatrix2D);
        if (!(intMatrix2D instanceof RCIntMatrix2D)) {
            this.assign(0);
            intMatrix2D.forEachNonZero(new IntIntIntFunction(){

                public int apply(int n, int n2, int n3) {
                    RCIntMatrix2D.this.setQuick(n, n2, n3);
                    return n3;
                }
            });
            return this;
        }
        RCIntMatrix2D rCIntMatrix2D = (RCIntMatrix2D)intMatrix2D;
        System.arraycopy(rCIntMatrix2D.rowPointers, 0, this.rowPointers, 0, this.rowPointers.length);
        int n = rCIntMatrix2D.columnIndexes.size();
        this.columnIndexes.setSize(n);
        this.values.setSize(n);
        this.columnIndexes.replaceFromToWithFrom(0, n - 1, rCIntMatrix2D.columnIndexes, 0);
        this.values.replaceFromToWithFrom(0, n - 1, rCIntMatrix2D.values, 0);
        return this;
    }

    public IntMatrix2D assign(final IntMatrix2D intMatrix2D, IntIntFunction intIntFunction) {
        this.checkShape(intMatrix2D);
        if (intIntFunction instanceof IntPlusMultSecond) {
            final int n = ((IntPlusMultSecond)intIntFunction).multiplicator;
            if (n == 0) {
                return this;
            }
            intMatrix2D.forEachNonZero(new IntIntIntFunction(){

                public int apply(int n4, int n2, int n3) {
                    RCIntMatrix2D.this.setQuick(n4, n2, RCIntMatrix2D.this.getQuick(n4, n2) + n * n3);
                    return n3;
                }
            });
            return this;
        }
        if (intIntFunction instanceof IntPlusMultFirst) {
            final int n = ((IntPlusMultFirst)intIntFunction).multiplicator;
            if (n == 0) {
                return this.assign(intMatrix2D);
            }
            intMatrix2D.forEachNonZero(new IntIntIntFunction(){

                public int apply(int n4, int n2, int n3) {
                    RCIntMatrix2D.this.setQuick(n4, n2, n * RCIntMatrix2D.this.getQuick(n4, n2) + n3);
                    return n3;
                }
            });
            return this;
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (intIntFunction == IntFunctions.mult) {
            final int[] nArray = this.columnIndexes.elements();
            final int[] nArray2 = this.values.elements();
            if (n > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futureArray = new Future[n];
                int n2 = (this.rowPointers.length - 1) / n;
                for (int i = 0; i < n; ++i) {
                    final int n3 = i * n2;
                    final int n4 = i == n - 1 ? this.rowPointers.length - 1 : n3 + n2;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            for (int i = n3; i < n4; ++i) {
                                int n = RCIntMatrix2D.this.rowPointers[i + 1];
                                for (int j = RCIntMatrix2D.this.rowPointers[i]; j < n; ++j) {
                                    int n2 = nArray[j];
                                    int n32 = j;
                                    nArray2[n32] = nArray2[n32] * intMatrix2D.getQuick(i, n2);
                                    if (nArray2[j] != 0) continue;
                                    RCIntMatrix2D.this.remove(i, n2);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n5 = this.rowPointers.length - 1;
                while (--n5 >= 0) {
                    int n6 = this.rowPointers[n5];
                    int n7 = this.rowPointers[n5 + 1];
                    while (--n7 >= n6) {
                        int n8 = nArray[n7];
                        int n9 = n7;
                        nArray2[n9] = nArray2[n9] * intMatrix2D.getQuick(n5, n8);
                        if (nArray2[n7] != 0) continue;
                        this.remove(n5, n8);
                    }
                }
            }
            return this;
        }
        if (intIntFunction == IntFunctions.div) {
            final int[] nArray = this.columnIndexes.elements();
            final int[] nArray3 = this.values.elements();
            if (n > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futureArray = new Future[n];
                int n10 = (this.rowPointers.length - 1) / n;
                for (int i = 0; i < n; ++i) {
                    final int n11 = i * n10;
                    final int n12 = i == n - 1 ? this.rowPointers.length - 1 : n11 + n10;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            for (int i = n11; i < n12; ++i) {
                                int n = RCIntMatrix2D.this.rowPointers[i + 1];
                                for (int j = RCIntMatrix2D.this.rowPointers[i]; j < n; ++j) {
                                    int n2 = nArray[j];
                                    int n3 = j;
                                    nArray3[n3] = nArray3[n3] / intMatrix2D.getQuick(i, n2);
                                    if (nArray3[j] != 0) continue;
                                    RCIntMatrix2D.this.remove(i, n2);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n13 = this.rowPointers.length - 1;
                while (--n13 >= 0) {
                    int n14 = this.rowPointers[n13];
                    int n15 = this.rowPointers[n13 + 1];
                    while (--n15 >= n14) {
                        int n16 = nArray[n15];
                        int n17 = n15;
                        nArray3[n17] = nArray3[n17] / intMatrix2D.getQuick(n13, n16);
                        if (nArray3[n15] != 0) continue;
                        this.remove(n13, n16);
                    }
                }
            }
            return this;
        }
        return super.assign(intMatrix2D, intIntFunction);
    }

    public IntMatrix2D forEachNonZero(final IntIntIntFunction intIntIntFunction) {
        final int[] nArray = this.columnIndexes.elements();
        final int[] nArray2 = this.values.elements();
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = (this.rowPointers.length - 1) / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rowPointers.length - 1 : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            int n = RCIntMatrix2D.this.rowPointers[i + 1];
                            for (int j = RCIntMatrix2D.this.rowPointers[i]; j < n; ++j) {
                                int n2 = nArray[j];
                                int n32 = nArray2[j];
                                int n42 = intIntIntFunction.apply(i, n2, n32);
                                if (n42 == n32) continue;
                                nArray2[j] = n42;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = this.rowPointers.length - 1;
            while (--n5 >= 0) {
                int n6 = this.rowPointers[n5];
                int n7 = this.rowPointers[n5 + 1];
                while (--n7 >= n6) {
                    int n8 = nArray[n7];
                    int n9 = nArray2[n7];
                    int n10 = intIntIntFunction.apply(n5, n8, n9);
                    if (n10 == n9) continue;
                    nArray2[n7] = n10;
                }
            }
        }
        return this;
    }

    protected IntMatrix2D getContent() {
        return this;
    }

    public IntArrayList getColumnindexes() {
        return this.columnIndexes;
    }

    public int[] getRowPointers() {
        return this.rowPointers;
    }

    public IntArrayList getValues() {
        return this.values;
    }

    public int getQuick(int n, int n2) {
        int n3 = this.columnIndexes.binarySearchFromTo(n2, this.rowPointers[n], this.rowPointers[n + 1] - 1);
        int n4 = 0;
        if (n3 >= 0) {
            n4 = this.values.getQuick(n3);
        }
        return n4;
    }

    protected synchronized void insert(int n, int n2, int n3, int n4) {
        this.columnIndexes.beforeInsert(n3, n2);
        this.values.beforeInsert(n3, n4);
        int n5 = this.rowPointers.length;
        while (--n5 > n) {
            int n6 = n5;
            this.rowPointers[n6] = this.rowPointers[n6] + 1;
        }
    }

    public IntMatrix2D like(int n, int n2) {
        return new RCIntMatrix2D(n, n2);
    }

    public IntMatrix1D like1D(int n) {
        return new SparseIntMatrix1D(n);
    }

    protected void remove(int n, int n2) {
        this.columnIndexes.remove(n2);
        this.values.remove(n2);
        int n3 = this.rowPointers.length;
        while (--n3 > n) {
            int n4 = n3;
            this.rowPointers[n4] = this.rowPointers[n4] - 1;
        }
    }

    public int cardinality() {
        return this.columnIndexes.size();
    }

    public synchronized void setQuick(int n, int n2, int n3) {
        int n4 = this.columnIndexes.binarySearchFromTo(n2, this.rowPointers[n], this.rowPointers[n + 1] - 1);
        if (n4 >= 0) {
            if (n3 == 0) {
                this.remove(n, n4);
            } else {
                this.values.setQuick(n4, n3);
            }
            return;
        }
        if (n3 != 0) {
            n4 = -n4 - 1;
            this.insert(n, n2, n4, n3);
        }
    }

    public DenseIntMatrix2D getFull() {
        final DenseIntMatrix2D denseIntMatrix2D = new DenseIntMatrix2D(this.rows, this.columns);
        this.forEachNonZero(new IntIntIntFunction(){

            public int apply(int n, int n2, int n3) {
                denseIntMatrix2D.setQuick(n, n2, RCIntMatrix2D.this.getQuick(n, n2));
                return n3;
            }
        });
        return denseIntMatrix2D;
    }

    public void trimToSize() {
        this.columnIndexes.trimToSize();
        this.values.trimToSize();
    }

    public IntMatrix1D zMult(IntMatrix1D intMatrix1D, IntMatrix1D intMatrix1D2) {
        int n = this.rows;
        int n2 = this.columns;
        if (intMatrix1D2 == null) {
            intMatrix1D2 = new DenseIntMatrix1D(n);
        }
        if (!(intMatrix1D instanceof DenseIntMatrix1D) || !(intMatrix1D2 instanceof DenseIntMatrix1D)) {
            return super.zMult(intMatrix1D, intMatrix1D2);
        }
        if (n2 != intMatrix1D.size() || n > intMatrix1D2.size()) {
            throw new IllegalArgumentException("Incompatible args: " + this.toStringShort() + ", " + intMatrix1D.toStringShort() + ", " + intMatrix1D2.toStringShort());
        }
        DenseIntMatrix1D denseIntMatrix1D = (DenseIntMatrix1D)intMatrix1D2;
        final int[] nArray = denseIntMatrix1D.elements;
        final int n3 = denseIntMatrix1D.stride();
        final int n4 = (int)intMatrix1D2.index(0);
        DenseIntMatrix1D denseIntMatrix1D2 = (DenseIntMatrix1D)intMatrix1D;
        final int[] nArray2 = denseIntMatrix1D2.elements;
        final int n5 = denseIntMatrix1D2.stride();
        final int n6 = (int)intMatrix1D.index(0);
        final int[] nArray3 = this.columnIndexes.elements();
        final int[] nArray4 = this.values.elements();
        int n7 = ConcurrencyUtils.getNumberOfThreads();
        if (n7 > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n7];
            int n8 = this.rowPointers.length / n7;
            for (int i = 0; i < n7; ++i) {
                final int n9 = i * n8;
                final int n10 = i == n7 - 1 ? this.rowPointers.length - 1 : n9 + n8;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4 + n9 * n3;
                        for (int i = n9; i < n10; ++i) {
                            int n2 = RCIntMatrix2D.this.rowPointers[i + 1];
                            int n32 = 0;
                            for (int j = RCIntMatrix2D.this.rowPointers[i]; j < n2; ++j) {
                                int n42 = nArray3[j];
                                n32 += nArray4[j] * nArray2[n6 + n5 * n42];
                            }
                            nArray[n] = n32;
                            n += n3;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n11 = this.rowPointers.length - 1;
            int n12 = n4;
            for (int i = 0; i < n11; ++i) {
                int n13 = this.rowPointers[i + 1];
                int n14 = 0;
                for (int j = this.rowPointers[i]; j < n13; ++j) {
                    int n15 = nArray3[j];
                    n14 += nArray4[j] * nArray2[n6 + n5 * n15];
                }
                nArray[n12] = n14;
                n12 += n3;
            }
        }
        return intMatrix1D2;
    }

    public IntMatrix1D zMult(IntMatrix1D intMatrix1D, IntMatrix1D intMatrix1D2, final int n, final int n2, final boolean bl) {
        boolean bl2;
        int n3 = this.rows;
        int n4 = this.columns;
        if (bl) {
            n3 = this.columns;
            n4 = this.rows;
        }
        boolean bl3 = bl2 = intMatrix1D2 == null || !bl;
        if (intMatrix1D2 == null) {
            intMatrix1D2 = new DenseIntMatrix1D(n3);
        }
        if (!(intMatrix1D instanceof DenseIntMatrix1D) || !(intMatrix1D2 instanceof DenseIntMatrix1D)) {
            return super.zMult(intMatrix1D, intMatrix1D2, n, n2, bl);
        }
        if (n4 != intMatrix1D.size() || n3 > intMatrix1D2.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (bl ? this.viewDice() : this).toStringShort() + ", " + intMatrix1D.toStringShort() + ", " + intMatrix1D2.toStringShort());
        }
        DenseIntMatrix1D denseIntMatrix1D = (DenseIntMatrix1D)intMatrix1D2;
        final int[] nArray = denseIntMatrix1D.elements;
        final int n5 = denseIntMatrix1D.stride();
        final int n6 = (int)intMatrix1D2.index(0);
        DenseIntMatrix1D denseIntMatrix1D2 = (DenseIntMatrix1D)intMatrix1D;
        final int[] nArray2 = denseIntMatrix1D2.elements;
        final int n7 = denseIntMatrix1D2.stride();
        final int n8 = (int)intMatrix1D.index(0);
        if (bl && !bl2 && (double)n2 != 1.0) {
            intMatrix1D2.assign(IntFunctions.mult(n2));
        }
        final int[] nArray3 = this.columnIndexes.elements();
        final int[] nArray4 = this.values.elements();
        int n9 = this.rowPointers.length - 1;
        int n10 = ConcurrencyUtils.getNumberOfThreads();
        if (n10 > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n10];
            int n11 = this.rowPointers.length / n10;
            for (int i = 0; i < n10; ++i) {
                final int n12 = i * n11;
                final int n13 = i == n10 - 1 ? this.rowPointers.length - 1 : n12 + n11;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n14 = n6 + n12 * n5;
                        if (!bl) {
                            if ((double)n2 == 0.0) {
                                for (int i = n12; i < n13; ++i) {
                                    int n22 = RCIntMatrix2D.this.rowPointers[i + 1];
                                    int n3 = 0;
                                    for (int j = RCIntMatrix2D.this.rowPointers[i]; j < n22; ++j) {
                                        int n4 = nArray3[j];
                                        n3 += nArray4[j] * nArray2[n8 + n7 * n4];
                                    }
                                    nArray[n14] = n * n3;
                                    n14 += n5;
                                }
                            } else {
                                for (int i = n12; i < n13; ++i) {
                                    int n52 = RCIntMatrix2D.this.rowPointers[i + 1];
                                    int n62 = 0;
                                    for (int j = RCIntMatrix2D.this.rowPointers[i]; j < n52; ++j) {
                                        int n72 = nArray3[j];
                                        n62 += nArray4[j] * nArray2[n8 + n7 * n72];
                                    }
                                    nArray[n14] = n * n62 + n2 * nArray[n14];
                                    n14 += n5;
                                }
                            }
                        } else {
                            for (int i = n12; i < n13; ++i) {
                                int n82 = RCIntMatrix2D.this.rowPointers[i + 1];
                                int n9 = n * nArray2[n8 + n7 * i];
                                for (int j = RCIntMatrix2D.this.rowPointers[i]; j < n82; ++j) {
                                    int n10 = nArray3[j];
                                    int n11 = n6 + n5 * n10;
                                    nArray[n11] = nArray[n11] + nArray4[j] * n9;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n14 = n6;
            if (!bl) {
                if ((double)n2 == 0.0) {
                    for (int i = 0; i < n9; ++i) {
                        int n15 = this.rowPointers[i + 1];
                        int n16 = 0;
                        for (int j = this.rowPointers[i]; j < n15; ++j) {
                            int n17 = nArray3[j];
                            n16 += nArray4[j] * nArray2[n8 + n7 * n17];
                        }
                        nArray[n14] = n * n16;
                        n14 += n5;
                    }
                } else {
                    for (int i = 0; i < n9; ++i) {
                        int n18 = this.rowPointers[i + 1];
                        int n19 = 0;
                        for (int j = this.rowPointers[i]; j < n18; ++j) {
                            int n20 = nArray3[j];
                            n19 += nArray4[j] * nArray2[n8 + n7 * n20];
                        }
                        nArray[n14] = n * n19 + n2 * nArray[n14];
                        n14 += n5;
                    }
                }
            } else {
                for (int i = 0; i < n9; ++i) {
                    int n21 = this.rowPointers[i + 1];
                    int n22 = n * nArray2[n8 + n7 * i];
                    for (int j = this.rowPointers[i]; j < n21; ++j) {
                        int n23 = nArray3[j];
                        int n24 = n6 + n5 * n23;
                        nArray[n24] = nArray[n24] + nArray4[j] * n22;
                    }
                }
            }
        }
        return intMatrix1D2;
    }

    public IntMatrix2D zMult(IntMatrix2D intMatrix2D, IntMatrix2D intMatrix2D2) {
        int n = this.rows;
        int n2 = this.columns;
        int n3 = intMatrix2D.columns();
        if (intMatrix2D2 == null) {
            intMatrix2D2 = new DenseIntMatrix2D(n, n3);
        }
        if (intMatrix2D.rows() != n2) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + intMatrix2D.toStringShort());
        }
        if (intMatrix2D2.rows() != n || intMatrix2D2.columns() != n3) {
            throw new IllegalArgumentException("Incompatible result matrix: " + this.toStringShort() + ", " + intMatrix2D.toStringShort() + ", " + intMatrix2D2.toStringShort());
        }
        if (this == intMatrix2D2 || intMatrix2D == intMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        IntMatrix1D[] intMatrix1DArray = new IntMatrix1D[n2];
        int n4 = n2;
        while (--n4 >= 0) {
            intMatrix1DArray[n4] = intMatrix2D.viewRow(n4);
        }
        IntMatrix1D[] intMatrix1DArray2 = new IntMatrix1D[n];
        int n5 = n;
        while (--n5 >= 0) {
            intMatrix1DArray2[n5] = intMatrix2D2.viewRow(n5);
        }
        IntPlusMultSecond intPlusMultSecond = IntPlusMultSecond.plusMult(0);
        int[] nArray = this.columnIndexes.elements();
        int[] nArray2 = this.values.elements();
        int n6 = this.rowPointers.length - 1;
        while (--n6 >= 0) {
            int n7 = this.rowPointers[n6];
            int n8 = this.rowPointers[n6 + 1];
            while (--n8 >= n7) {
                int n9 = nArray[n8];
                intPlusMultSecond.multiplicator = nArray2[n8];
                intMatrix1DArray2[n6].assign(intMatrix1DArray[n9], intPlusMultSecond);
            }
        }
        return intMatrix2D2;
    }

    public IntMatrix2D zMult(IntMatrix2D intMatrix2D, IntMatrix2D intMatrix2D2, int n, int n2, boolean bl, boolean bl2) {
        boolean bl3;
        if (bl2) {
            intMatrix2D = intMatrix2D.viewDice();
        }
        int n3 = this.rows;
        int n4 = this.columns;
        if (bl) {
            n3 = this.columns;
            n4 = this.rows;
        }
        int n5 = intMatrix2D.columns();
        boolean bl4 = bl3 = intMatrix2D2 == null;
        if (intMatrix2D2 == null) {
            intMatrix2D2 = new DenseIntMatrix2D(n3, n5);
        }
        if (intMatrix2D.rows() != n4) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + (bl2 ? intMatrix2D.viewDice() : intMatrix2D).toStringShort());
        }
        if (intMatrix2D2.rows() != n3 || intMatrix2D2.columns() != n5) {
            throw new IllegalArgumentException("Incompatible result matrix: " + this.toStringShort() + ", " + (bl2 ? intMatrix2D.viewDice() : intMatrix2D).toStringShort() + ", " + intMatrix2D2.toStringShort());
        }
        if (this == intMatrix2D2 || intMatrix2D == intMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!bl3) {
            intMatrix2D2.assign(IntFunctions.mult(n2));
        }
        IntMatrix1D[] intMatrix1DArray = new IntMatrix1D[n4];
        int n6 = n4;
        while (--n6 >= 0) {
            intMatrix1DArray[n6] = intMatrix2D.viewRow(n6);
        }
        IntMatrix1D[] intMatrix1DArray2 = new IntMatrix1D[n3];
        int n7 = n3;
        while (--n7 >= 0) {
            intMatrix1DArray2[n7] = intMatrix2D2.viewRow(n7);
        }
        IntPlusMultSecond intPlusMultSecond = IntPlusMultSecond.plusMult(0);
        int[] nArray = this.columnIndexes.elements();
        int[] nArray2 = this.values.elements();
        int n8 = this.rowPointers.length - 1;
        while (--n8 >= 0) {
            int n9 = this.rowPointers[n8];
            int n10 = this.rowPointers[n8 + 1];
            while (--n10 >= n9) {
                int n11 = nArray[n10];
                intPlusMultSecond.multiplicator = nArray2[n10] * n;
                if (!bl) {
                    intMatrix1DArray2[n8].assign(intMatrix1DArray[n11], intPlusMultSecond);
                    continue;
                }
                intMatrix1DArray2[n11].assign(intMatrix1DArray[n8], intPlusMultSecond);
            }
        }
        return intMatrix2D2;
    }
}

