/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.function.tint.IntFunction;
import cern.colt.function.tint.IntIntFunction;
import cern.colt.function.tint.IntProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.IntMatrix3D;
import cern.colt.matrix.tint.impl.DenseIntMatrix1D;
import cern.colt.matrix.tint.impl.DenseIntMatrix2D;
import cern.colt.matrix.tint.impl.SelectedDenseIntMatrix3D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DenseIntMatrix3D
extends IntMatrix3D {
    private static final long serialVersionUID = 5711401505315728697L;
    protected int[] elements;

    public DenseIntMatrix3D(int[][][] nArray) {
        this(nArray.length, nArray.length == 0 ? 0 : nArray[0].length, nArray.length == 0 ? 0 : (nArray[0].length == 0 ? 0 : nArray[0][0].length));
        this.assign(nArray);
    }

    public DenseIntMatrix3D(int n, int n2, int n3) {
        this.setUp(n, n2, n3);
        this.elements = new int[n * n2 * n3];
    }

    public DenseIntMatrix3D(int n, int n2, int n3, int[] nArray, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl) {
        this.setUp(n, n2, n3, n4, n5, n6, n7, n8, n9);
        this.elements = nArray;
        this.isNoView = !bl;
    }

    public int aggregate(final IntIntFunction intIntFunction, final IntFunction intFunction) {
        if (this.size() == 0) {
            throw new IllegalArgumentException("size == 0");
        }
        int n = 0;
        final int n2 = (int)this.index(0, 0, 0);
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n3];
            Integer[] integerArray = new Integer[n3];
            int n4 = this.slices / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.slices : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = intFunction.apply(DenseIntMatrix3D.this.elements[n2 + n5 * DenseIntMatrix3D.this.sliceStride]);
                        int n22 = 1;
                        for (int i = n5; i < n6; ++i) {
                            for (int j = 0; j < DenseIntMatrix3D.this.rows; ++j) {
                                for (int k = n22; k < DenseIntMatrix3D.this.columns; ++k) {
                                    n = intIntFunction.apply(n, intFunction.apply(DenseIntMatrix3D.this.elements[n2 + i * DenseIntMatrix3D.this.sliceStride + j * DenseIntMatrix3D.this.rowStride + k * DenseIntMatrix3D.this.columnStride]));
                                }
                                n22 = 0;
                            }
                        }
                        return n;
                    }
                });
            }
            n = ConcurrencyUtils.waitForCompletion(futureArray, intIntFunction);
        } else {
            n = intFunction.apply(this.elements[n2]);
            int n7 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n7; k < this.columns; ++k) {
                        n = intIntFunction.apply(n, intFunction.apply(this.elements[n2 + i * this.sliceStride + j * this.rowStride + k * this.columnStride]));
                    }
                    n7 = 0;
                }
            }
        }
        return n;
    }

    public int aggregate(final IntIntFunction intIntFunction, final IntFunction intFunction, final IntProcedure intProcedure) {
        if (this.size() == 0) {
            throw new IllegalArgumentException("size == 0");
        }
        int n = 0;
        final int n2 = (int)this.index(0, 0, 0);
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n3];
            Integer[] integerArray = new Integer[n3];
            int n4 = this.slices / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.slices : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = DenseIntMatrix3D.this.elements[n2 + n5 * DenseIntMatrix3D.this.sliceStride];
                        int n22 = 0;
                        if (intProcedure.apply(n)) {
                            n22 = intIntFunction.apply(n22, intFunction.apply(n));
                        }
                        int n3 = 1;
                        for (int i = n5; i < n6; ++i) {
                            for (int j = 0; j < DenseIntMatrix3D.this.rows; ++j) {
                                for (int k = n3; k < DenseIntMatrix3D.this.columns; ++k) {
                                    n = DenseIntMatrix3D.this.elements[n2 + i * DenseIntMatrix3D.this.sliceStride + j * DenseIntMatrix3D.this.rowStride + k * DenseIntMatrix3D.this.columnStride];
                                    if (intProcedure.apply(n)) {
                                        n22 = intIntFunction.apply(n22, intFunction.apply(n));
                                    }
                                    n3 = 0;
                                }
                            }
                        }
                        return n22;
                    }
                });
            }
            n = ConcurrencyUtils.waitForCompletion(futureArray, intIntFunction);
        } else {
            int n7 = this.elements[n2];
            if (intProcedure.apply(n7)) {
                n = intIntFunction.apply(n, intFunction.apply(n7));
            }
            int n8 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n8; k < this.columns; ++k) {
                        n7 = this.elements[n2 + i * this.sliceStride + j * this.rowStride + k * this.columnStride];
                        if (intProcedure.apply(n7)) {
                            n = intIntFunction.apply(n, intFunction.apply(n7));
                        }
                        n8 = 0;
                    }
                }
            }
        }
        return n;
    }

    public int aggregate(final IntIntFunction intIntFunction, final IntFunction intFunction, IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3) {
        if (this.size() == 0) {
            throw new IllegalArgumentException("size == 0");
        }
        if (intArrayList.size() == 0 || intArrayList2.size() == 0 || intArrayList3.size() == 0) {
            throw new IllegalArgumentException("size == 0");
        }
        int n = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        final int[] nArray3 = intArrayList3.elements();
        final int n2 = (int)this.index(0, 0, 0);
        int n3 = 0;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n4];
            Integer[] integerArray = new Integer[n4];
            int n5 = n / n4;
            for (int i = 0; i < n4; ++i) {
                final int n6 = i * n5;
                final int n7 = i == n4 - 1 ? n : n6 + n5;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = intFunction.apply(DenseIntMatrix3D.this.elements[n2 + nArray[n6] * DenseIntMatrix3D.this.sliceStride + nArray2[n6] * DenseIntMatrix3D.this.rowStride + nArray3[n6] * DenseIntMatrix3D.this.columnStride]);
                        for (int i = n6 + 1; i < n7; ++i) {
                            int n22 = DenseIntMatrix3D.this.elements[n2 + nArray[i] * DenseIntMatrix3D.this.sliceStride + nArray2[i] * DenseIntMatrix3D.this.rowStride + nArray3[i] * DenseIntMatrix3D.this.columnStride];
                            n = intIntFunction.apply(n, intFunction.apply(n22));
                        }
                        return n;
                    }
                });
            }
            n3 = ConcurrencyUtils.waitForCompletion(futureArray, intIntFunction);
        } else {
            n3 = intFunction.apply(this.elements[n2 + nArray[0] * this.sliceStride + nArray2[0] * this.rowStride + nArray3[0] * this.columnStride]);
            for (int i = 1; i < n; ++i) {
                int n8 = this.elements[n2 + nArray[i] * this.sliceStride + nArray2[i] * this.rowStride + nArray3[i] * this.columnStride];
                n3 = intIntFunction.apply(n3, intFunction.apply(n8));
            }
        }
        return n3;
    }

    public int aggregate(IntMatrix3D intMatrix3D, final IntIntFunction intIntFunction, final IntIntFunction intIntFunction2) {
        if (!(intMatrix3D instanceof DenseIntMatrix3D)) {
            return super.aggregate(intMatrix3D, intIntFunction, intIntFunction2);
        }
        this.checkShape(intMatrix3D);
        if (this.size() == 0) {
            throw new IllegalArgumentException("size == 0");
        }
        int n = 0;
        final int n2 = (int)this.index(0, 0, 0);
        final int n3 = (int)intMatrix3D.index(0, 0, 0);
        final int n4 = intMatrix3D.sliceStride();
        final int n5 = intMatrix3D.rowStride();
        final int n6 = intMatrix3D.columnStride();
        final int[] nArray = (int[])intMatrix3D.elements();
        int n7 = ConcurrencyUtils.getNumberOfThreads();
        if (n7 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n7];
            Integer[] integerArray = new Integer[n7];
            int n8 = this.slices / n7;
            for (int i = 0; i < n7; ++i) {
                final int n9 = i * n8;
                final int n10 = i == n7 - 1 ? this.slices : n9 + n8;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = n2 + n9 * DenseIntMatrix3D.this.sliceStride;
                        int n22 = n3 + n9 * n4;
                        int n32 = intIntFunction2.apply(DenseIntMatrix3D.this.elements[n], nArray[n22]);
                        int n42 = 1;
                        for (int i = n9; i < n10; ++i) {
                            for (int j = 0; j < DenseIntMatrix3D.this.rows; ++j) {
                                for (int k = n42; k < DenseIntMatrix3D.this.columns; ++k) {
                                    n = n2 + i * DenseIntMatrix3D.this.sliceStride + j * DenseIntMatrix3D.this.rowStride + k * DenseIntMatrix3D.this.columnStride;
                                    n22 = n3 + i * n4 + j * n5 + k * n6;
                                    n32 = intIntFunction.apply(n32, intIntFunction2.apply(DenseIntMatrix3D.this.elements[n], nArray[n22]));
                                }
                                n42 = 0;
                            }
                        }
                        return n32;
                    }
                });
            }
            n = ConcurrencyUtils.waitForCompletion(futureArray, intIntFunction);
        } else {
            n = intIntFunction2.apply(this.getQuick(0, 0, 0), intMatrix3D.getQuick(0, 0, 0));
            int n11 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n11; k < this.columns; ++k) {
                        int n12 = n2 + i * this.sliceStride + j * this.rowStride + k * this.columnStride;
                        int n13 = n3 + i * n4 + j * n5 + k * n6;
                        n = intIntFunction.apply(n, intIntFunction2.apply(this.elements[n12], nArray[n13]));
                    }
                    n11 = 0;
                }
            }
        }
        return n;
    }

    public IntMatrix3D assign(final IntFunction intFunction) {
        final int n = (int)this.index(0, 0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < DenseIntMatrix3D.this.rows; ++j) {
                                int n2 = n + i * DenseIntMatrix3D.this.sliceStride + j * DenseIntMatrix3D.this.rowStride;
                                for (int k = 0; k < DenseIntMatrix3D.this.columns; ++k) {
                                    DenseIntMatrix3D.this.elements[n2] = intFunction.apply(DenseIntMatrix3D.this.elements[n2]);
                                    n2 += DenseIntMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n6 = n + i * this.sliceStride + j * this.rowStride;
                    for (int k = 0; k < this.columns; ++k) {
                        this.elements[n6] = intFunction.apply(this.elements[n6]);
                        n6 += this.columnStride;
                    }
                }
            }
        }
        return this;
    }

    public IntMatrix3D assign(final int n) {
        final int n2 = (int)this.index(0, 0, 0);
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n3];
            int n4 = this.slices / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.slices : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n5; i < n6; ++i) {
                            for (int j = 0; j < DenseIntMatrix3D.this.rows; ++j) {
                                int n3 = n2 + i * DenseIntMatrix3D.this.sliceStride + j * DenseIntMatrix3D.this.rowStride;
                                for (int k = 0; k < DenseIntMatrix3D.this.columns; ++k) {
                                    DenseIntMatrix3D.this.elements[n3] = n;
                                    n3 += DenseIntMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n7 = n2 + i * this.sliceStride + j * this.rowStride;
                    for (int k = 0; k < this.columns; ++k) {
                        this.elements[n7] = n;
                        n7 += this.columnStride;
                    }
                }
            }
        }
        return this;
    }

    public IntMatrix3D assign(final int[] nArray) {
        if (nArray.length != this.size()) {
            throw new IllegalArgumentException("Must have same length: length=" + nArray.length + "slices()*rows()*columns()=" + this.slices() * this.rows() * this.columns());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
                Future[] futureArray = new Future[n];
                int n2 = this.size() / n;
                for (int i = 0; i < n; ++i) {
                    final int n3 = i * n2;
                    final int n4 = i == n - 1 ? this.size() - n3 : n2;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            System.arraycopy(nArray, n3, DenseIntMatrix3D.this.elements, n3, n4);
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                System.arraycopy(nArray, 0, this.elements, 0, nArray.length);
            }
        } else {
            final int n5 = (int)this.index(0, 0, 0);
            if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
                Future[] futureArray = new Future[n];
                int n6 = this.slices / n;
                for (int i = 0; i < n; ++i) {
                    final int n7 = i * n6;
                    final int n8 = i * n6 * this.rows * this.columns;
                    final int n9 = i == n - 1 ? this.slices : n7 + n6;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n8;
                            for (int i = n7; i < n9; ++i) {
                                for (int j = 0; j < DenseIntMatrix3D.this.rows; ++j) {
                                    int n2 = n5 + i * DenseIntMatrix3D.this.sliceStride + j * DenseIntMatrix3D.this.rowStride;
                                    for (int k = 0; k < DenseIntMatrix3D.this.columns; ++k) {
                                        DenseIntMatrix3D.this.elements[n2] = nArray[n++];
                                        n2 += DenseIntMatrix3D.this.columnStride;
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n10 = 0;
                for (int i = 0; i < this.slices; ++i) {
                    for (int j = 0; j < this.rows; ++j) {
                        int n11 = n5 + i * this.sliceStride + j * this.rowStride;
                        for (int k = 0; k < this.columns; ++k) {
                            this.elements[n11] = nArray[n10++];
                            n11 += this.columnStride;
                        }
                    }
                }
            }
        }
        return this;
    }

    public IntMatrix3D assign(final int[][][] nArray) {
        if (nArray.length != this.slices) {
            throw new IllegalArgumentException("Must have same number of slices: slices=" + nArray.length + "slices()=" + this.slices());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
                Future[] futureArray = new Future[n];
                int n2 = this.slices / n;
                for (int i = 0; i < n; ++i) {
                    final int n3 = i * n2;
                    final int n4 = i == n - 1 ? this.slices : n3 + n2;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n3 * DenseIntMatrix3D.this.sliceStride;
                            for (int i = n3; i < n4; ++i) {
                                int[][] nArray3 = nArray[i];
                                if (nArray3.length != DenseIntMatrix3D.this.rows) {
                                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + nArray3.length + "rows()=" + DenseIntMatrix3D.this.rows());
                                }
                                for (int j = 0; j < DenseIntMatrix3D.this.rows; ++j) {
                                    int[] nArray2 = nArray3[j];
                                    if (nArray2.length != DenseIntMatrix3D.this.columns) {
                                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + nArray2.length + "columns()=" + DenseIntMatrix3D.this.columns());
                                    }
                                    System.arraycopy(nArray2, 0, DenseIntMatrix3D.this.elements, n, DenseIntMatrix3D.this.columns);
                                    n += DenseIntMatrix3D.this.columns;
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n5 = 0;
                for (int i = 0; i < this.slices; ++i) {
                    int[][] nArray2 = nArray[i];
                    if (nArray2.length != this.rows) {
                        throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + nArray2.length + "rows()=" + this.rows());
                    }
                    for (int j = 0; j < this.rows; ++j) {
                        int[] nArray3 = nArray2[j];
                        if (nArray3.length != this.columns) {
                            throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + nArray3.length + "columns()=" + this.columns());
                        }
                        System.arraycopy(nArray3, 0, this.elements, n5, this.columns);
                        n5 += this.columns;
                    }
                }
            }
        } else {
            final int n6 = (int)this.index(0, 0, 0);
            if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
                Future[] futureArray = new Future[n];
                int n7 = this.slices / n;
                for (int i = 0; i < n; ++i) {
                    final int n8 = i * n7;
                    final int n9 = i == n - 1 ? this.slices : n8 + n7;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            for (int i = n8; i < n9; ++i) {
                                int[][] nArray3 = nArray[i];
                                if (nArray3.length != DenseIntMatrix3D.this.rows) {
                                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + nArray3.length + "rows()=" + DenseIntMatrix3D.this.rows());
                                }
                                for (int j = 0; j < DenseIntMatrix3D.this.rows; ++j) {
                                    int n = n6 + i * DenseIntMatrix3D.this.sliceStride + j * DenseIntMatrix3D.this.rowStride;
                                    int[] nArray2 = nArray3[j];
                                    if (nArray2.length != DenseIntMatrix3D.this.columns) {
                                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + nArray2.length + "columns()=" + DenseIntMatrix3D.this.columns());
                                    }
                                    for (int k = 0; k < DenseIntMatrix3D.this.columns; ++k) {
                                        DenseIntMatrix3D.this.elements[n] = nArray2[k];
                                        n += DenseIntMatrix3D.this.columnStride;
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (int i = 0; i < this.slices; ++i) {
                    int[][] nArray4 = nArray[i];
                    if (nArray4.length != this.rows) {
                        throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + nArray4.length + "rows()=" + this.rows());
                    }
                    for (int j = 0; j < this.rows; ++j) {
                        int n10 = n6 + i * this.sliceStride + j * this.rowStride;
                        int[] nArray5 = nArray4[j];
                        if (nArray5.length != this.columns) {
                            throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + nArray5.length + "columns()=" + this.columns());
                        }
                        for (int k = 0; k < this.columns; ++k) {
                            this.elements[n10] = nArray5[k];
                            n10 += this.columnStride;
                        }
                    }
                }
            }
        }
        return this;
    }

    public IntMatrix3D assign(final IntProcedure intProcedure, final IntFunction intFunction) {
        final int n = (int)this.index(0, 0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < DenseIntMatrix3D.this.rows; ++j) {
                                int n3 = n + i * DenseIntMatrix3D.this.sliceStride + j * DenseIntMatrix3D.this.rowStride;
                                for (int k = 0; k < DenseIntMatrix3D.this.columns; ++k) {
                                    int n2 = DenseIntMatrix3D.this.elements[n3];
                                    if (intProcedure.apply(n2)) {
                                        DenseIntMatrix3D.this.elements[n3] = intFunction.apply(n2);
                                    }
                                    n3 += DenseIntMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n6 = n + i * this.sliceStride + j * this.rowStride;
                    for (int k = 0; k < this.columns; ++k) {
                        int n7 = this.elements[n6];
                        if (intProcedure.apply(n7)) {
                            this.elements[n6] = intFunction.apply(n7);
                        }
                        n6 += this.columnStride;
                    }
                }
            }
        }
        return this;
    }

    public IntMatrix3D assign(final IntProcedure intProcedure, final int n) {
        final int n2 = (int)this.index(0, 0, 0);
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n3];
            int n4 = this.slices / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.slices : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n5; i < n6; ++i) {
                            for (int j = 0; j < DenseIntMatrix3D.this.rows; ++j) {
                                int n3 = n2 + i * DenseIntMatrix3D.this.sliceStride + j * DenseIntMatrix3D.this.rowStride;
                                for (int k = 0; k < DenseIntMatrix3D.this.columns; ++k) {
                                    int n22 = DenseIntMatrix3D.this.elements[n3];
                                    if (intProcedure.apply(n22)) {
                                        DenseIntMatrix3D.this.elements[n3] = n;
                                    }
                                    n3 += DenseIntMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n7 = n2 + i * this.sliceStride + j * this.rowStride;
                    for (int k = 0; k < this.columns; ++k) {
                        int n8 = this.elements[n7];
                        if (intProcedure.apply(n8)) {
                            this.elements[n7] = n;
                        }
                        n7 += this.columnStride;
                    }
                }
            }
        }
        return this;
    }

    public IntMatrix3D assign(IntMatrix3D intMatrix3D) {
        IntMatrix3D intMatrix3D2;
        if (!(intMatrix3D instanceof DenseIntMatrix3D)) {
            super.assign(intMatrix3D);
            return this;
        }
        DenseIntMatrix3D denseIntMatrix3D = (DenseIntMatrix3D)intMatrix3D;
        if (denseIntMatrix3D == this) {
            return this;
        }
        this.checkShape(denseIntMatrix3D);
        if (this.haveSharedCells(denseIntMatrix3D)) {
            intMatrix3D2 = denseIntMatrix3D.copy();
            if (!(intMatrix3D2 instanceof DenseIntMatrix3D)) {
                super.assign(intMatrix3D);
                return this;
            }
            denseIntMatrix3D = intMatrix3D2;
        }
        intMatrix3D2 = denseIntMatrix3D;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView && denseIntMatrix3D.isNoView) {
            if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
                Future[] futureArray = new Future[n];
                int n2 = this.size() / n;
                for (int i = 0; i < n; ++i) {
                    int n3 = i * n2;
                    int n4 = i == n - 1 ? this.size() - n3 : n2;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable((DenseIntMatrix3D)intMatrix3D2, n3, n4){
                        final /* synthetic */ DenseIntMatrix3D val$other_final;
                        final /* synthetic */ int val$startidx;
                        final /* synthetic */ int val$length;
                        {
                            this.val$other_final = denseIntMatrix3D2;
                            this.val$startidx = n;
                            this.val$length = n2;
                        }

                        public void run() {
                            System.arraycopy(this.val$other_final.elements, this.val$startidx, DenseIntMatrix3D.this.elements, this.val$startidx, this.val$length);
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                System.arraycopy(((DenseIntMatrix3D)intMatrix3D2).elements, 0, this.elements, 0, this.elements.length);
            }
            return this;
        }
        final int n5 = (int)this.index(0, 0, 0);
        final int n6 = (int)((DenseIntMatrix3D)intMatrix3D2).index(0, 0, 0);
        final int n7 = ((DenseIntMatrix3D)intMatrix3D2).sliceStride;
        final int n8 = ((DenseIntMatrix3D)intMatrix3D2).rowStride;
        final int n9 = ((DenseIntMatrix3D)intMatrix3D2).columnStride;
        final int[] nArray = ((DenseIntMatrix3D)intMatrix3D2).elements;
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n];
            int n10 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n11 = i * n10;
                final int n12 = i == n - 1 ? this.slices : n11 + n10;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n11; i < n12; ++i) {
                            for (int j = 0; j < DenseIntMatrix3D.this.rows; ++j) {
                                int n = n5 + i * DenseIntMatrix3D.this.sliceStride + j * DenseIntMatrix3D.this.rowStride;
                                int n2 = n6 + i * n7 + j * n8;
                                for (int k = 0; k < DenseIntMatrix3D.this.columns; ++k) {
                                    DenseIntMatrix3D.this.elements[n] = nArray[n2];
                                    n += DenseIntMatrix3D.this.columnStride;
                                    n2 += n9;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n13 = n5 + i * this.sliceStride + j * this.rowStride;
                    int n14 = n6 + i * n7 + j * n8;
                    for (int k = 0; k < this.columns; ++k) {
                        this.elements[n13] = nArray[n14];
                        n13 += this.columnStride;
                        n14 += n9;
                    }
                }
            }
        }
        return this;
    }

    public IntMatrix3D assign(IntMatrix3D intMatrix3D, final IntIntFunction intIntFunction) {
        if (!(intMatrix3D instanceof DenseIntMatrix3D)) {
            super.assign(intMatrix3D, intIntFunction);
            return this;
        }
        this.checkShape(intMatrix3D);
        final int n = (int)this.index(0, 0, 0);
        final int n2 = (int)intMatrix3D.index(0, 0, 0);
        final int n3 = intMatrix3D.sliceStride();
        final int n4 = intMatrix3D.rowStride();
        final int n5 = intMatrix3D.columnStride();
        final int[] nArray = (int[])intMatrix3D.elements();
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n6];
            int n7 = this.slices / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n6 - 1 ? this.slices : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n8; i < n9; ++i) {
                            for (int j = 0; j < DenseIntMatrix3D.this.rows; ++j) {
                                int n6 = n + i * DenseIntMatrix3D.this.sliceStride + j * DenseIntMatrix3D.this.rowStride;
                                int n22 = n2 + i * n3 + j * n4;
                                for (int k = 0; k < DenseIntMatrix3D.this.columns; ++k) {
                                    DenseIntMatrix3D.this.elements[n6] = intIntFunction.apply(DenseIntMatrix3D.this.elements[n6], nArray[n22]);
                                    n6 += DenseIntMatrix3D.this.columnStride;
                                    n22 += n5;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n10 = n + i * this.sliceStride + j * this.rowStride;
                    int n11 = n2 + i * n3 + j * n4;
                    for (int k = 0; k < this.columns; ++k) {
                        this.elements[n10] = intIntFunction.apply(this.elements[n10], nArray[n11]);
                        n10 += this.columnStride;
                        n11 += n5;
                    }
                }
            }
        }
        return this;
    }

    public IntMatrix3D assign(IntMatrix3D intMatrix3D, final IntIntFunction intIntFunction, IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3) {
        if (!(intMatrix3D instanceof DenseIntMatrix3D)) {
            super.assign(intMatrix3D, intIntFunction);
            return this;
        }
        this.checkShape(intMatrix3D);
        final int n = (int)this.index(0, 0, 0);
        final int n2 = (int)intMatrix3D.index(0, 0, 0);
        final int n3 = intMatrix3D.sliceStride();
        final int n4 = intMatrix3D.rowStride();
        final int n5 = intMatrix3D.columnStride();
        final int[] nArray = (int[])intMatrix3D.elements();
        int n6 = intArrayList.size();
        final int[] nArray2 = intArrayList.elements();
        final int[] nArray3 = intArrayList2.elements();
        final int[] nArray4 = intArrayList3.elements();
        int n7 = ConcurrencyUtils.getNumberOfThreads();
        if (n7 > 1 && n6 >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n7];
            int n8 = n6 / n7;
            for (int i = 0; i < n7; ++i) {
                final int n9 = i * n8;
                final int n10 = i == n7 - 1 ? n6 : n9 + n8;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n9; i < n10; ++i) {
                            int n6 = n + nArray2[i] * DenseIntMatrix3D.this.sliceStride + nArray3[i] * DenseIntMatrix3D.this.rowStride + nArray4[i] * DenseIntMatrix3D.this.columnStride;
                            int n22 = n2 + nArray2[i] * n3 + nArray3[i] * n4 + nArray4[i] * n5;
                            DenseIntMatrix3D.this.elements[n6] = intIntFunction.apply(DenseIntMatrix3D.this.elements[n6], nArray[n22]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < n6; ++i) {
                int n11 = n + nArray2[i] * this.sliceStride + nArray3[i] * this.rowStride + nArray4[i] * this.columnStride;
                int n12 = n2 + nArray2[i] * n3 + nArray3[i] * n4 + nArray4[i] * n5;
                this.elements[n11] = intIntFunction.apply(this.elements[n11], nArray[n12]);
            }
        }
        return this;
    }

    public int cardinality() {
        int n = 0;
        final int n2 = (int)this.index(0, 0, 0);
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n4;
            Future[] futureArray = new Future[n3];
            Integer[] integerArray = new Integer[n3];
            int n5 = this.slices / n3;
            for (n4 = 0; n4 < n3; ++n4) {
                final int n6 = n4 * n5;
                final int n7 = n4 == n3 - 1 ? this.slices : n6 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        for (int i = n6; i < n7; ++i) {
                            for (int j = 0; j < DenseIntMatrix3D.this.rows; ++j) {
                                int n22 = n2 + i * DenseIntMatrix3D.this.sliceStride + j * DenseIntMatrix3D.this.rowStride;
                                for (int k = 0; k < DenseIntMatrix3D.this.columns; ++k) {
                                    if (DenseIntMatrix3D.this.elements[n22] != 0) {
                                        ++n;
                                    }
                                    n22 += DenseIntMatrix3D.this.columnStride;
                                }
                            }
                        }
                        return n;
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n3; ++n4) {
                    integerArray[n4] = (Integer)futureArray[n4].get();
                }
                n = integerArray[0];
                for (n4 = 1; n4 < n3; ++n4) {
                    n += integerArray[n4].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n8 = n2 + i * this.sliceStride + j * this.rowStride;
                    for (int k = 0; k < this.columns; ++k) {
                        if (this.elements[n8] != 0) {
                            ++n;
                        }
                        n8 += this.columnStride;
                    }
                }
            }
        }
        return n;
    }

    public int[] elements() {
        return this.elements;
    }

    public void getNegativeValues(IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3, IntArrayList intArrayList4) {
        intArrayList.clear();
        intArrayList2.clear();
        intArrayList3.clear();
        intArrayList4.clear();
        int n = (int)this.index(0, 0, 0);
        for (int i = 0; i < this.slices; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                int n2 = n + i * this.sliceStride + j * this.rowStride;
                for (int k = 0; k < this.columns; ++k) {
                    int n3 = this.elements[n2];
                    if (n3 < 0) {
                        intArrayList.add(i);
                        intArrayList2.add(j);
                        intArrayList3.add(k);
                        intArrayList4.add(n3);
                    }
                    n2 += this.columnStride;
                }
            }
        }
    }

    public void getNonZeros(IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3, IntArrayList intArrayList4) {
        intArrayList.clear();
        intArrayList2.clear();
        intArrayList3.clear();
        intArrayList4.clear();
        int n = (int)this.index(0, 0, 0);
        for (int i = 0; i < this.slices; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                int n2 = n + i * this.sliceStride + j * this.rowStride;
                for (int k = 0; k < this.columns; ++k) {
                    int n3 = this.elements[n2];
                    if (n3 != 0) {
                        intArrayList.add(i);
                        intArrayList2.add(j);
                        intArrayList3.add(k);
                        intArrayList4.add(n3);
                    }
                    n2 += this.columnStride;
                }
            }
        }
    }

    public void getPositiveValues(IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3, IntArrayList intArrayList4) {
        intArrayList.clear();
        intArrayList2.clear();
        intArrayList3.clear();
        intArrayList4.clear();
        int n = (int)this.index(0, 0, 0);
        for (int i = 0; i < this.slices; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                int n2 = n + i * this.sliceStride + j * this.rowStride;
                for (int k = 0; k < this.columns; ++k) {
                    int n3 = this.elements[n2];
                    if (n3 > 0) {
                        intArrayList.add(i);
                        intArrayList2.add(j);
                        intArrayList3.add(k);
                        intArrayList4.add(n3);
                    }
                    n2 += this.columnStride;
                }
            }
        }
    }

    public int getQuick(int n, int n2, int n3) {
        return this.elements[this.sliceZero + n * this.sliceStride + this.rowZero + n2 * this.rowStride + this.columnZero + n3 * this.columnStride];
    }

    public long index(int n, int n2, int n3) {
        return this.sliceZero + n * this.sliceStride + this.rowZero + n2 * this.rowStride + this.columnZero + n3 * this.columnStride;
    }

    public IntMatrix3D like(int n, int n2, int n3) {
        return new DenseIntMatrix3D(n, n2, n3);
    }

    public int[] getMaxLocation() {
        final int n = (int)this.index(0, 0, 0);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n7;
            Future[] futureArray = new Future[n6];
            int[][] nArray = new int[n6][2];
            int n8 = this.slices / n6;
            for (n7 = 0; n7 < n6; ++n7) {
                final int n9 = n7 * n8;
                final int n10 = n7 == n6 - 1 ? this.slices : n9 + n8;
                futureArray[n7] = ConcurrencyUtils.submit(new Callable<int[]>(){

                    @Override
                    public int[] call() throws Exception {
                        int n7 = n9;
                        int n2 = 0;
                        int n3 = 0;
                        int n4 = DenseIntMatrix3D.this.elements[n + n9 * DenseIntMatrix3D.this.sliceStride];
                        int n5 = 1;
                        for (int i = n9; i < n10; ++i) {
                            for (int j = 0; j < DenseIntMatrix3D.this.rows; ++j) {
                                for (int k = n5; k < DenseIntMatrix3D.this.columns; ++k) {
                                    int n6 = DenseIntMatrix3D.this.elements[n + i * DenseIntMatrix3D.this.sliceStride + j * DenseIntMatrix3D.this.rowStride + k * DenseIntMatrix3D.this.columnStride];
                                    if (n4 >= n6) continue;
                                    n4 = n6;
                                    n7 = i;
                                    n2 = j;
                                    n3 = k;
                                }
                                n5 = 0;
                            }
                        }
                        return new int[]{n4, n7, n2, n3};
                    }
                });
            }
            try {
                for (n7 = 0; n7 < n6; ++n7) {
                    nArray[n7] = (int[])futureArray[n7].get();
                }
                n5 = nArray[0][0];
                n2 = nArray[0][1];
                n3 = nArray[0][2];
                n4 = nArray[0][3];
                for (n7 = 1; n7 < n6; ++n7) {
                    if (n5 >= nArray[n7][0]) continue;
                    n5 = nArray[n7][0];
                    n2 = nArray[n7][1];
                    n3 = nArray[n7][2];
                    n4 = nArray[n7][3];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            n5 = this.elements[n];
            int n11 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n11; k < this.columns; ++k) {
                        int n12 = this.elements[n + i * this.sliceStride + j * this.rowStride + k * this.columnStride];
                        if (n5 >= n12) continue;
                        n5 = n12;
                        n2 = i;
                        n3 = j;
                        n4 = k;
                    }
                    n11 = 0;
                }
            }
        }
        return new int[]{n5, n2, n3, n4};
    }

    public int[] getMinLocation() {
        final int n = (int)this.index(0, 0, 0);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n7;
            Future[] futureArray = new Future[n6];
            int[][] nArray = new int[n6][2];
            int n8 = this.slices / n6;
            for (n7 = 0; n7 < n6; ++n7) {
                final int n9 = n7 * n8;
                final int n10 = n7 == n6 - 1 ? this.slices : n9 + n8;
                futureArray[n7] = ConcurrencyUtils.submit(new Callable<int[]>(){

                    @Override
                    public int[] call() throws Exception {
                        int n7 = n9;
                        int n2 = 0;
                        int n3 = 0;
                        int n4 = DenseIntMatrix3D.this.elements[n + n7 * DenseIntMatrix3D.this.sliceStride];
                        int n5 = 1;
                        for (int i = n9; i < n10; ++i) {
                            for (int j = 0; j < DenseIntMatrix3D.this.rows; ++j) {
                                for (int k = n5; k < DenseIntMatrix3D.this.columns; ++k) {
                                    int n6 = DenseIntMatrix3D.this.elements[n + i * DenseIntMatrix3D.this.sliceStride + j * DenseIntMatrix3D.this.rowStride + k * DenseIntMatrix3D.this.columnStride];
                                    if (n4 <= n6) continue;
                                    n4 = n6;
                                    n7 = i;
                                    n2 = j;
                                    n3 = k;
                                }
                                n5 = 0;
                            }
                        }
                        return new int[]{n4, n7, n2, n3};
                    }
                });
            }
            try {
                for (n7 = 0; n7 < n6; ++n7) {
                    nArray[n7] = (int[])futureArray[n7].get();
                }
                n5 = nArray[0][0];
                n2 = nArray[0][1];
                n3 = nArray[0][2];
                n4 = nArray[0][3];
                for (n7 = 1; n7 < n6; ++n7) {
                    if (n5 <= nArray[n7][0]) continue;
                    n5 = nArray[n7][0];
                    n2 = nArray[n7][1];
                    n3 = nArray[n7][2];
                    n4 = nArray[n7][3];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            n5 = this.elements[n];
            int n11 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n11; k < this.columns; ++k) {
                        int n12 = this.elements[n + i * this.sliceStride + j * this.rowStride + k * this.columnStride];
                        if (n5 <= n12) continue;
                        n5 = n12;
                        n2 = i;
                        n3 = j;
                        n4 = k;
                    }
                    n11 = 0;
                }
            }
        }
        return new int[]{n5, n2, n3, n4};
    }

    public void setQuick(int n, int n2, int n3, int n4) {
        this.elements[this.sliceZero + n * this.sliceStride + this.rowZero + n2 * this.rowStride + this.columnZero + n3 * this.columnStride] = n4;
    }

    public int[][][] toArray() {
        final int[][][] nArray = new int[this.slices][this.rows][this.columns];
        int n = ConcurrencyUtils.getNumberOfThreads();
        final int n2 = (int)this.index(0, 0, 0);
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n];
            int n3 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            int[][] nArray3 = nArray[i];
                            for (int j = 0; j < DenseIntMatrix3D.this.rows; ++j) {
                                int n = n2 + i * DenseIntMatrix3D.this.sliceStride + j * DenseIntMatrix3D.this.rowStride;
                                int[] nArray2 = nArray3[j];
                                for (int k = 0; k < DenseIntMatrix3D.this.columns; ++k) {
                                    nArray2[k] = DenseIntMatrix3D.this.elements[n];
                                    n += DenseIntMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                int[][] nArray2 = nArray[i];
                for (int j = 0; j < this.rows; ++j) {
                    int n6 = n2 + i * this.sliceStride + j * this.rowStride;
                    int[] nArray3 = nArray2[j];
                    for (int k = 0; k < this.columns; ++k) {
                        nArray3[k] = this.elements[n6];
                        n6 += this.columnStride;
                    }
                }
            }
        }
        return nArray;
    }

    public IntMatrix1D vectorize() {
        DenseIntMatrix1D denseIntMatrix1D = new DenseIntMatrix1D(this.size());
        int n = this.rows * this.columns;
        for (int i = 0; i < this.slices; ++i) {
            denseIntMatrix1D.viewPart(i * n, n).assign(this.viewSlice(i).vectorize());
        }
        return denseIntMatrix1D;
    }

    public int zSum() {
        int n = 0;
        final int n2 = (int)this.index(0, 0, 0);
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n4;
            Future[] futureArray = new Future[n3];
            int n5 = this.slices / n3;
            for (n4 = 0; n4 < n3; ++n4) {
                final int n6 = n4 * n5;
                final int n7 = n4 == n3 - 1 ? this.slices : n6 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        for (int i = n6; i < n7; ++i) {
                            for (int j = 0; j < DenseIntMatrix3D.this.rows; ++j) {
                                int n22 = n2 + i * DenseIntMatrix3D.this.sliceStride + j * DenseIntMatrix3D.this.rowStride;
                                for (int k = 0; k < DenseIntMatrix3D.this.columns; ++k) {
                                    n += DenseIntMatrix3D.this.elements[n22];
                                    n22 += DenseIntMatrix3D.this.columnStride;
                                }
                            }
                        }
                        return n;
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n3; ++n4) {
                    n += ((Integer)futureArray[n4].get()).intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n8 = n2 + i * this.sliceStride + j * this.rowStride;
                    for (int k = 0; k < this.columns; ++k) {
                        n += this.elements[n8];
                        n8 += this.columnStride;
                    }
                }
            }
        }
        return n;
    }

    protected boolean haveSharedCellsRaw(IntMatrix3D intMatrix3D) {
        if (intMatrix3D instanceof SelectedDenseIntMatrix3D) {
            SelectedDenseIntMatrix3D selectedDenseIntMatrix3D = (SelectedDenseIntMatrix3D)intMatrix3D;
            return this.elements == selectedDenseIntMatrix3D.elements;
        }
        if (intMatrix3D instanceof DenseIntMatrix3D) {
            DenseIntMatrix3D denseIntMatrix3D = (DenseIntMatrix3D)intMatrix3D;
            return this.elements == denseIntMatrix3D.elements;
        }
        return false;
    }

    protected IntMatrix2D like2D(int n, int n2, int n3, int n4, int n5, int n6) {
        return new DenseIntMatrix2D(n, n2, this.elements, n3, n4, n5, n6, true);
    }

    protected IntMatrix3D viewSelectionLike(int[] nArray, int[] nArray2, int[] nArray3) {
        return new SelectedDenseIntMatrix3D(this.elements, nArray, nArray2, nArray3, 0);
    }
}

