/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.function.tint.IntFunction;
import cern.colt.function.tint.IntIntFunction;
import cern.colt.function.tint.IntIntIntFunction;
import cern.colt.function.tint.IntProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.impl.DenseIntMatrix1D;
import cern.colt.matrix.tint.impl.RCIntMatrix2D;
import cern.colt.matrix.tint.impl.SelectedDenseIntMatrix2D;
import cern.colt.matrix.tint.impl.SparseIntMatrix2D;
import cern.jet.math.tint.IntFunctions;
import cern.jet.math.tint.IntMult;
import cern.jet.math.tint.IntPlusMultSecond;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;

public class DenseIntMatrix2D
extends IntMatrix2D {
    static final long serialVersionUID = 1020177651L;
    protected int[] elements;

    public DenseIntMatrix2D(int[][] nArray) {
        this(nArray.length, nArray.length == 0 ? 0 : nArray[0].length);
        this.assign(nArray);
    }

    public DenseIntMatrix2D(int n, int n2) {
        this.setUp(n, n2);
        this.elements = new int[n * n2];
    }

    public DenseIntMatrix2D(int n, int n2, int[] nArray, int n3, int n4, int n5, int n6, boolean bl) {
        this.setUp(n, n2, n3, n4, n5, n6);
        this.elements = nArray;
        this.isNoView = !bl;
    }

    public int aggregate(final IntIntFunction intIntFunction, final IntFunction intFunction) {
        if (this.size() == 0) {
            throw new IllegalArgumentException("size == 0");
        }
        final int n = (int)this.index(0, 0);
        int n2 = 0;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n3];
            Integer[] integerArray = new Integer[n3];
            int n4 = this.rows / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.rows : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n3 = intFunction.apply(DenseIntMatrix2D.this.elements[n + n5 * DenseIntMatrix2D.this.rowStride]);
                        int n2 = 1;
                        for (int i = n5; i < n6; ++i) {
                            for (int j = n2; j < DenseIntMatrix2D.this.columns; ++j) {
                                n3 = intIntFunction.apply(n3, intFunction.apply(DenseIntMatrix2D.this.elements[n + i * DenseIntMatrix2D.this.rowStride + j * DenseIntMatrix2D.this.columnStride]));
                            }
                            n2 = 0;
                        }
                        return n3;
                    }
                });
            }
            n2 = ConcurrencyUtils.waitForCompletion(futureArray, intIntFunction);
        } else {
            n2 = intFunction.apply(this.elements[n]);
            int n7 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n7; j < this.columns; ++j) {
                    n2 = intIntFunction.apply(n2, intFunction.apply(this.elements[n + i * this.rowStride + j * this.columnStride]));
                }
                n7 = 0;
            }
        }
        return n2;
    }

    public int aggregate(final IntIntFunction intIntFunction, final IntFunction intFunction, final IntProcedure intProcedure) {
        if (this.size() == 0) {
            throw new IllegalArgumentException("size == 0");
        }
        final int n = (int)this.index(0, 0);
        int n2 = 0;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n3];
            Integer[] integerArray = new Integer[n3];
            int n4 = this.rows / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.rows : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n4 = DenseIntMatrix2D.this.elements[n + n5 * DenseIntMatrix2D.this.rowStride];
                        int n2 = 0;
                        if (intProcedure.apply(n4)) {
                            n2 = intFunction.apply(n4);
                        }
                        int n3 = 1;
                        for (int i = n5; i < n6; ++i) {
                            for (int j = n3; j < DenseIntMatrix2D.this.columns; ++j) {
                                n4 = DenseIntMatrix2D.this.elements[n + i * DenseIntMatrix2D.this.rowStride + j * DenseIntMatrix2D.this.columnStride];
                                if (!intProcedure.apply(n4)) continue;
                                n2 = intIntFunction.apply(n2, intFunction.apply(n4));
                            }
                            n3 = 0;
                        }
                        return n2;
                    }
                });
            }
            n2 = ConcurrencyUtils.waitForCompletion(futureArray, intIntFunction);
        } else {
            int n7 = this.elements[n];
            if (intProcedure.apply(n7)) {
                n2 = intFunction.apply(this.elements[n]);
            }
            int n8 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n8; j < this.columns; ++j) {
                    n7 = this.elements[n + i * this.rowStride + j * this.columnStride];
                    if (!intProcedure.apply(n7)) continue;
                    n2 = intIntFunction.apply(n2, intFunction.apply(n7));
                }
                n8 = 0;
            }
        }
        return n2;
    }

    public int aggregate(final IntIntFunction intIntFunction, final IntFunction intFunction, IntArrayList intArrayList, IntArrayList intArrayList2) {
        if (this.size() == 0) {
            throw new IllegalArgumentException("size == 0");
        }
        final int n = (int)this.index(0, 0);
        int n2 = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        int n3 = 0;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n4];
            Integer[] integerArray = new Integer[n4];
            int n5 = n2 / n4;
            for (int i = 0; i < n4; ++i) {
                final int n6 = i * n5;
                final int n7 = i == n4 - 1 ? n2 : n6 + n5;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n3 = intFunction.apply(DenseIntMatrix2D.this.elements[n + nArray[n6] * DenseIntMatrix2D.this.rowStride + nArray2[n6] * DenseIntMatrix2D.this.columnStride]);
                        for (int i = n6 + 1; i < n7; ++i) {
                            int n2 = DenseIntMatrix2D.this.elements[n + nArray[i] * DenseIntMatrix2D.this.rowStride + nArray2[i] * DenseIntMatrix2D.this.columnStride];
                            n3 = intIntFunction.apply(n3, intFunction.apply(n2));
                        }
                        return n3;
                    }
                });
            }
            n3 = ConcurrencyUtils.waitForCompletion(futureArray, intIntFunction);
        } else {
            n3 = intFunction.apply(this.elements[n + nArray[0] * this.rowStride + nArray2[0] * this.columnStride]);
            for (int i = 1; i < n2; ++i) {
                int n8 = this.elements[n + nArray[i] * this.rowStride + nArray2[i] * this.columnStride];
                n3 = intIntFunction.apply(n3, intFunction.apply(n8));
            }
        }
        return n3;
    }

    public int aggregate(IntMatrix2D intMatrix2D, final IntIntFunction intIntFunction, final IntIntFunction intIntFunction2) {
        if (!(intMatrix2D instanceof DenseIntMatrix2D)) {
            return super.aggregate(intMatrix2D, intIntFunction, intIntFunction2);
        }
        this.checkShape(intMatrix2D);
        if (this.size() == 0) {
            throw new IllegalArgumentException("size == 0");
        }
        final int n = (int)this.index(0, 0);
        final int n2 = (int)intMatrix2D.index(0, 0);
        final int n3 = intMatrix2D.rowStride();
        final int n4 = intMatrix2D.columnStride();
        final int[] nArray = (int[])intMatrix2D.elements();
        int n5 = 0;
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n6];
            Integer[] integerArray = new Integer[n6];
            int n7 = this.rows / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n6 - 1 ? this.rows : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n5 = intIntFunction2.apply(DenseIntMatrix2D.this.elements[n + n8 * DenseIntMatrix2D.this.rowStride], nArray[n2 + n8 * n3]);
                        int n22 = 1;
                        for (int i = n8; i < n9; ++i) {
                            for (int j = n22; j < DenseIntMatrix2D.this.columns; ++j) {
                                n5 = intIntFunction.apply(n5, intIntFunction2.apply(DenseIntMatrix2D.this.elements[n + i * DenseIntMatrix2D.this.rowStride + j * DenseIntMatrix2D.this.columnStride], nArray[n2 + i * n3 + j * n4]));
                            }
                            n22 = 0;
                        }
                        return n5;
                    }
                });
            }
            n5 = ConcurrencyUtils.waitForCompletion(futureArray, intIntFunction);
        } else {
            int n10 = 1;
            n5 = intIntFunction2.apply(this.elements[n], nArray[n2]);
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n10; j < this.columns; ++j) {
                    n5 = intIntFunction.apply(n5, intIntFunction2.apply(this.elements[n + i * this.rowStride + j * this.columnStride], nArray[n2 + i * n3 + j * n4]));
                }
                n10 = 0;
            }
        }
        return n5;
    }

    public IntMatrix2D assign(final IntFunction intFunction) {
        final int[] nArray = this.elements;
        if (nArray == null) {
            throw new InternalError();
        }
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            if (intFunction instanceof IntMult) {
                int n3 = ((IntMult)intFunction).multiplicator;
                if (n3 == 1) {
                    return this;
                }
                if (n3 == 0) {
                    return this.assign(0);
                }
            }
            Future[] futureArray = new Future[n2];
            int n4 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n2 - 1 ? this.rows : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n7 = n + n5 * DenseIntMatrix2D.this.rowStride;
                        if (intFunction instanceof IntMult) {
                            int n2 = ((IntMult)intFunction).multiplicator;
                            if (n2 == 1) {
                                return;
                            }
                            for (int i = n5; i < n6; ++i) {
                                int n3 = n7;
                                for (int j = 0; j < DenseIntMatrix2D.this.columns; ++j) {
                                    int n4 = n3;
                                    nArray[n4] = nArray[n4] * n2;
                                    n3 += DenseIntMatrix2D.this.columnStride;
                                }
                                n7 += DenseIntMatrix2D.this.rowStride;
                            }
                        } else {
                            for (int i = n5; i < n6; ++i) {
                                int n52 = n7;
                                for (int j = 0; j < DenseIntMatrix2D.this.columns; ++j) {
                                    nArray[n52] = intFunction.apply(nArray[n52]);
                                    n52 += DenseIntMatrix2D.this.columnStride;
                                }
                                n7 += DenseIntMatrix2D.this.rowStride;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7 = n;
            if (intFunction instanceof IntMult) {
                int n8 = ((IntMult)intFunction).multiplicator;
                if (n8 == 1) {
                    return this;
                }
                if (n8 == 0) {
                    return this.assign(0);
                }
                for (int i = 0; i < this.rows; ++i) {
                    int n9 = n7;
                    for (int j = 0; j < this.columns; ++j) {
                        int n10 = n9;
                        nArray[n10] = nArray[n10] * n8;
                        n9 += this.columnStride;
                    }
                    n7 += this.rowStride;
                }
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    int n11 = n7;
                    for (int j = 0; j < this.columns; ++j) {
                        nArray[n11] = intFunction.apply(nArray[n11]);
                        n11 += this.columnStride;
                    }
                    n7 += this.rowStride;
                }
            }
        }
        return this;
    }

    public IntMatrix2D assign(final IntProcedure intProcedure, final IntFunction intFunction) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n6 = n + n4 * DenseIntMatrix2D.this.rowStride;
                        for (int i = n4; i < n5; ++i) {
                            int n2 = n6;
                            for (int j = 0; j < DenseIntMatrix2D.this.columns; ++j) {
                                int n3 = DenseIntMatrix2D.this.elements[n2];
                                if (intProcedure.apply(n3)) {
                                    DenseIntMatrix2D.this.elements[n2] = intFunction.apply(n3);
                                }
                                n2 += DenseIntMatrix2D.this.columnStride;
                            }
                            n6 += DenseIntMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n7 = n6;
                for (int j = 0; j < this.columns; ++j) {
                    int n8 = this.elements[n7];
                    if (intProcedure.apply(n8)) {
                        this.elements[n7] = intFunction.apply(n8);
                    }
                    n7 += this.columnStride;
                }
                n6 += this.rowStride;
            }
        }
        return this;
    }

    public IntMatrix2D assign(final IntProcedure intProcedure, final int n) {
        final int n2 = (int)this.index(0, 0);
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n3];
            int n4 = this.rows / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.rows : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n4 = n2 + n5 * DenseIntMatrix2D.this.rowStride;
                        for (int i = n5; i < n6; ++i) {
                            int n22 = n4;
                            for (int j = 0; j < DenseIntMatrix2D.this.columns; ++j) {
                                int n3 = DenseIntMatrix2D.this.elements[n22];
                                if (intProcedure.apply(n3)) {
                                    DenseIntMatrix2D.this.elements[n22] = n;
                                }
                                n22 += DenseIntMatrix2D.this.columnStride;
                            }
                            n4 += DenseIntMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7 = n2;
            for (int i = 0; i < this.rows; ++i) {
                int n8 = n7;
                for (int j = 0; j < this.columns; ++j) {
                    int n9 = this.elements[n8];
                    if (intProcedure.apply(n9)) {
                        this.elements[n8] = n;
                    }
                    n8 += this.columnStride;
                }
                n7 += this.rowStride;
            }
        }
        return this;
    }

    public IntMatrix2D assign(final int n) {
        final int[] nArray = this.elements;
        final int n2 = (int)this.index(0, 0);
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n3];
            int n4 = this.rows / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.rows : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = n2 + n5 * DenseIntMatrix2D.this.rowStride;
                        for (int i = n5; i < n6; ++i) {
                            int n22 = n3;
                            for (int j = 0; j < DenseIntMatrix2D.this.columns; ++j) {
                                nArray[n22] = n;
                                n22 += DenseIntMatrix2D.this.columnStride;
                            }
                            n3 += DenseIntMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7 = n2;
            for (int i = 0; i < this.rows; ++i) {
                int n8 = n7;
                for (int j = 0; j < this.columns; ++j) {
                    nArray[n8] = n;
                    n8 += this.columnStride;
                }
                n7 += this.rowStride;
            }
        }
        return this;
    }

    public IntMatrix2D assign(final int[] nArray) {
        if (nArray.length != this.size()) {
            throw new IllegalArgumentException("Must have same length: length=" + nArray.length + " rows()*columns()=" + this.rows() * this.columns());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futureArray = new Future[n];
                int n2 = this.size() / n;
                for (int i = 0; i < n; ++i) {
                    final int n3 = i * n2;
                    final int n4 = i == n - 1 ? this.size() - n3 : n2;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            System.arraycopy(nArray, n3, DenseIntMatrix2D.this.elements, n3, n4);
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                System.arraycopy(nArray, 0, this.elements, 0, nArray.length);
            }
        } else {
            final int n5 = (int)this.index(0, 0);
            if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futureArray = new Future[n];
                int n6 = this.rows / n;
                for (int i = 0; i < n; ++i) {
                    final int n7 = i * n6;
                    final int n8 = i * n6 * this.columns;
                    final int n9 = i == n - 1 ? this.rows : n7 + n6;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n8;
                            int n2 = n5 + n7 * DenseIntMatrix2D.this.rowStride;
                            for (int i = n7; i < n9; ++i) {
                                int n3 = n2;
                                for (int j = 0; j < DenseIntMatrix2D.this.columns; ++j) {
                                    DenseIntMatrix2D.this.elements[n3] = nArray[n++];
                                    n3 += DenseIntMatrix2D.this.columnStride;
                                }
                                n2 += DenseIntMatrix2D.this.rowStride;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n10 = 0;
                int n11 = n5;
                for (int i = 0; i < this.rows; ++i) {
                    int n12 = n11;
                    for (int j = 0; j < this.columns; ++j) {
                        this.elements[n12] = nArray[n10++];
                        n12 += this.columnStride;
                    }
                    n11 += this.rowStride;
                }
            }
        }
        return this;
    }

    public IntMatrix2D assign(final int[][] nArray) {
        if (nArray.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + nArray.length + "rows()=" + this.rows());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futureArray = new Future[n];
                int n2 = this.rows / n;
                for (int i = 0; i < n; ++i) {
                    final int n3 = i * n2;
                    final int n4 = i == n - 1 ? this.rows : n3 + n2;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n3 * DenseIntMatrix2D.this.rowStride;
                            for (int i = n3; i < n4; ++i) {
                                int[] nArray2 = nArray[i];
                                if (nArray2.length != DenseIntMatrix2D.this.columns) {
                                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + nArray2.length + "columns()=" + DenseIntMatrix2D.this.columns());
                                }
                                System.arraycopy(nArray2, 0, DenseIntMatrix2D.this.elements, n, DenseIntMatrix2D.this.columns);
                                n += DenseIntMatrix2D.this.columns;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n5 = 0;
                for (int i = 0; i < this.rows; ++i) {
                    int[] nArray2 = nArray[i];
                    if (nArray2.length != this.columns) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + nArray2.length + "columns()=" + this.columns());
                    }
                    System.arraycopy(nArray2, 0, this.elements, n5, this.columns);
                    n5 += this.columns;
                }
            }
        } else {
            final int n6 = (int)this.index(0, 0);
            if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futureArray = new Future[n];
                int n7 = this.rows / n;
                for (int i = 0; i < n; ++i) {
                    final int n8 = i * n7;
                    final int n9 = i == n - 1 ? this.rows : n8 + n7;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n6 + n8 * DenseIntMatrix2D.this.rowStride;
                            for (int i = n8; i < n9; ++i) {
                                int[] nArray2 = nArray[i];
                                if (nArray2.length != DenseIntMatrix2D.this.columns) {
                                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + nArray2.length + "columns()=" + DenseIntMatrix2D.this.columns());
                                }
                                int n2 = n;
                                for (int j = 0; j < DenseIntMatrix2D.this.columns; ++j) {
                                    DenseIntMatrix2D.this.elements[n2] = nArray2[j];
                                    n2 += DenseIntMatrix2D.this.columnStride;
                                }
                                n += DenseIntMatrix2D.this.rowStride;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n10 = n6;
                for (int i = 0; i < this.rows; ++i) {
                    int[] nArray3 = nArray[i];
                    if (nArray3.length != this.columns) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + nArray3.length + "columns()=" + this.columns());
                    }
                    int n11 = n10;
                    for (int j = 0; j < this.columns; ++j) {
                        this.elements[n11] = nArray3[j];
                        n11 += this.columnStride;
                    }
                    n10 += this.rowStride;
                }
            }
            return this;
        }
        return this;
    }

    public IntMatrix2D assign(IntMatrix2D intMatrix2D) {
        Object object;
        if (!(intMatrix2D instanceof DenseIntMatrix2D)) {
            super.assign(intMatrix2D);
            return this;
        }
        final DenseIntMatrix2D denseIntMatrix2D = (DenseIntMatrix2D)intMatrix2D;
        if (denseIntMatrix2D == this) {
            return this;
        }
        this.checkShape(denseIntMatrix2D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView && denseIntMatrix2D.isNoView) {
            if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futureArray = new Future[n];
                int n2 = this.size() / n;
                for (int i = 0; i < n; ++i) {
                    final int n3 = i * n2;
                    final int n4 = i == n - 1 ? this.size() - n3 : n2;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            System.arraycopy(denseIntMatrix2D.elements, n3, DenseIntMatrix2D.this.elements, n3, n4);
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                System.arraycopy(denseIntMatrix2D.elements, 0, this.elements, 0, this.elements.length);
            }
            return this;
        }
        DenseIntMatrix2D denseIntMatrix2D2 = (DenseIntMatrix2D)intMatrix2D;
        if (this.haveSharedCells(denseIntMatrix2D2)) {
            object = denseIntMatrix2D2.copy();
            if (!(object instanceof DenseIntMatrix2D)) {
                super.assign(denseIntMatrix2D2);
                return this;
            }
            denseIntMatrix2D2 = (DenseIntMatrix2D)object;
        }
        object = denseIntMatrix2D2.elements;
        if (this.elements == null || object == null) {
            throw new InternalError();
        }
        final int n5 = (int)denseIntMatrix2D2.index(0, 0);
        final int n6 = (int)this.index(0, 0);
        int n7 = denseIntMatrix2D2.columnStride;
        final int n8 = denseIntMatrix2D2.rowStride;
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n9 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n10 = i * n9;
                final int n11 = i == n - 1 ? this.rows : n10 + n9;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable((int[])object, n7){
                    final /* synthetic */ int[] val$elemsOther;
                    final /* synthetic */ int val$columnStrideOther;
                    {
                        this.val$elemsOther = nArray;
                        this.val$columnStrideOther = n62;
                    }

                    public void run() {
                        int n = n6 + n10 * DenseIntMatrix2D.this.rowStride;
                        int n2 = n5 + n10 * n8;
                        for (int i = n10; i < n11; ++i) {
                            int n3 = n;
                            int n4 = n2;
                            for (int j = 0; j < DenseIntMatrix2D.this.columns; ++j) {
                                DenseIntMatrix2D.this.elements[n3] = this.val$elemsOther[n4];
                                n3 += DenseIntMatrix2D.this.columnStride;
                                n4 += this.val$columnStrideOther;
                            }
                            n += DenseIntMatrix2D.this.rowStride;
                            n2 += n8;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n12 = n6;
            int n13 = n5;
            for (int i = 0; i < this.rows; ++i) {
                int n14 = n12;
                int n15 = n13;
                for (int j = 0; j < this.columns; ++j) {
                    this.elements[n14] = (int)object[n15];
                    n14 += this.columnStride;
                    n15 += n7;
                }
                n12 += this.rowStride;
                n13 += n8;
            }
        }
        return this;
    }

    public IntMatrix2D assign(IntMatrix2D intMatrix2D, final IntIntFunction intIntFunction) {
        if (!(intMatrix2D instanceof DenseIntMatrix2D)) {
            super.assign(intMatrix2D, intIntFunction);
            return this;
        }
        DenseIntMatrix2D denseIntMatrix2D = (DenseIntMatrix2D)intMatrix2D;
        this.checkShape(intMatrix2D);
        final int[] nArray = denseIntMatrix2D.elements;
        if (this.elements == null || nArray == null) {
            throw new InternalError();
        }
        final int n = (int)denseIntMatrix2D.index(0, 0);
        final int n2 = (int)this.index(0, 0);
        final int n3 = denseIntMatrix2D.columnStride;
        final int n4 = denseIntMatrix2D.rowStride;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n6;
            if (intIntFunction instanceof IntPlusMultSecond && (n6 = ((IntPlusMultSecond)intIntFunction).multiplicator) == 0) {
                return this;
            }
            Future[] futureArray = new Future[n5];
            int n7 = this.rows / n5;
            for (int i = 0; i < n5; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n5 - 1 ? this.rows : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        if (intIntFunction == IntFunctions.mult) {
                            int n28 = n2 + n8 * DenseIntMatrix2D.this.rowStride;
                            int n29 = n + n8 * n4;
                            for (int i = n8; i < n9; ++i) {
                                int n32 = n28;
                                int n42 = n29;
                                for (int j = 0; j < DenseIntMatrix2D.this.columns; ++j) {
                                    int n5 = n32;
                                    DenseIntMatrix2D.this.elements[n5] = DenseIntMatrix2D.this.elements[n5] * nArray[n42];
                                    n32 += DenseIntMatrix2D.this.columnStride;
                                    n42 += n3;
                                }
                                n28 += DenseIntMatrix2D.this.rowStride;
                                n29 += n4;
                            }
                        } else if (intIntFunction == IntFunctions.div) {
                            int n30 = n2 + n8 * DenseIntMatrix2D.this.rowStride;
                            int n6 = n + n8 * n4;
                            for (int i = n8; i < n9; ++i) {
                                int n7 = n30;
                                int n82 = n6;
                                for (int j = 0; j < DenseIntMatrix2D.this.columns; ++j) {
                                    int n92 = n7;
                                    DenseIntMatrix2D.this.elements[n92] = DenseIntMatrix2D.this.elements[n92] / nArray[n82];
                                    n7 += DenseIntMatrix2D.this.columnStride;
                                    n82 += n3;
                                }
                                n30 += DenseIntMatrix2D.this.rowStride;
                                n6 += n4;
                            }
                        } else if (intIntFunction instanceof IntPlusMultSecond) {
                            int n31 = ((IntPlusMultSecond)intIntFunction).multiplicator;
                            if (n31 == 1) {
                                int n10 = n2 + n8 * DenseIntMatrix2D.this.rowStride;
                                int n11 = n + n8 * n4;
                                for (int i = n8; i < n9; ++i) {
                                    int n12 = n10;
                                    int n13 = n11;
                                    for (int j = 0; j < DenseIntMatrix2D.this.columns; ++j) {
                                        int n14 = n12;
                                        DenseIntMatrix2D.this.elements[n14] = DenseIntMatrix2D.this.elements[n14] + nArray[n13];
                                        n12 += DenseIntMatrix2D.this.columnStride;
                                        n13 += n3;
                                    }
                                    n10 += DenseIntMatrix2D.this.rowStride;
                                    n11 += n4;
                                }
                            } else if (n31 == -1) {
                                int n15 = n2 + n8 * DenseIntMatrix2D.this.rowStride;
                                int n16 = n + n8 * n4;
                                for (int i = n8; i < n9; ++i) {
                                    int n17 = n15;
                                    int n18 = n16;
                                    for (int j = 0; j < DenseIntMatrix2D.this.columns; ++j) {
                                        int n19 = n17;
                                        DenseIntMatrix2D.this.elements[n19] = DenseIntMatrix2D.this.elements[n19] - nArray[n18];
                                        n17 += DenseIntMatrix2D.this.columnStride;
                                        n18 += n3;
                                    }
                                    n15 += DenseIntMatrix2D.this.rowStride;
                                    n16 += n4;
                                }
                            } else {
                                int n20 = n2 + n8 * DenseIntMatrix2D.this.rowStride;
                                int n21 = n + n8 * n4;
                                for (int i = n8; i < n9; ++i) {
                                    int n22 = n20;
                                    int n23 = n21;
                                    for (int j = 0; j < DenseIntMatrix2D.this.columns; ++j) {
                                        int n24 = n22;
                                        DenseIntMatrix2D.this.elements[n24] = DenseIntMatrix2D.this.elements[n24] + n31 * nArray[n23];
                                        n22 += DenseIntMatrix2D.this.columnStride;
                                        n23 += n3;
                                    }
                                    n20 += DenseIntMatrix2D.this.rowStride;
                                    n21 += n4;
                                }
                            }
                        } else {
                            int n33 = n2 + n8 * DenseIntMatrix2D.this.rowStride;
                            int n25 = n + n8 * n4;
                            for (int i = n8; i < n9; ++i) {
                                int n26 = n33;
                                int n27 = n25;
                                for (int j = 0; j < DenseIntMatrix2D.this.columns; ++j) {
                                    DenseIntMatrix2D.this.elements[n26] = intIntFunction.apply(DenseIntMatrix2D.this.elements[n26], nArray[n27]);
                                    n26 += DenseIntMatrix2D.this.columnStride;
                                    n27 += n3;
                                }
                                n33 += DenseIntMatrix2D.this.rowStride;
                                n25 += n4;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else if (intIntFunction == IntFunctions.mult) {
            int n10 = n2;
            int n11 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n12 = n10;
                int n13 = n11;
                for (int j = 0; j < this.columns; ++j) {
                    int n14 = n12;
                    this.elements[n14] = this.elements[n14] * nArray[n13];
                    n12 += this.columnStride;
                    n13 += n3;
                }
                n10 += this.rowStride;
                n11 += n4;
            }
        } else if (intIntFunction == IntFunctions.div) {
            int n15 = n2;
            int n16 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n17 = n15;
                int n18 = n16;
                for (int j = 0; j < this.columns; ++j) {
                    int n19 = n17;
                    this.elements[n19] = this.elements[n19] / nArray[n18];
                    n17 += this.columnStride;
                    n18 += n3;
                }
                n15 += this.rowStride;
                n16 += n4;
            }
        } else if (intIntFunction instanceof IntPlusMultSecond) {
            int n20 = ((IntPlusMultSecond)intIntFunction).multiplicator;
            if (n20 == 0) {
                return this;
            }
            if (n20 == 1) {
                int n21 = n2;
                int n22 = n;
                for (int i = 0; i < this.rows; ++i) {
                    int n23 = n21;
                    int n24 = n22;
                    for (int j = 0; j < this.columns; ++j) {
                        int n25 = n23;
                        this.elements[n25] = this.elements[n25] + nArray[n24];
                        n23 += this.columnStride;
                        n24 += n3;
                    }
                    n21 += this.rowStride;
                    n22 += n4;
                }
            } else if (n20 == -1) {
                int n26 = n2;
                int n27 = n;
                for (int i = 0; i < this.rows; ++i) {
                    int n28 = n26;
                    int n29 = n27;
                    for (int j = 0; j < this.columns; ++j) {
                        int n30 = n28;
                        this.elements[n30] = this.elements[n30] - nArray[n29];
                        n28 += this.columnStride;
                        n29 += n3;
                    }
                    n26 += this.rowStride;
                    n27 += n4;
                }
            } else {
                int n31 = n2;
                int n32 = n;
                for (int i = 0; i < this.rows; ++i) {
                    int n33 = n31;
                    int n34 = n32;
                    for (int j = 0; j < this.columns; ++j) {
                        int n35 = n33;
                        this.elements[n35] = this.elements[n35] + n20 * nArray[n34];
                        n33 += this.columnStride;
                        n34 += n3;
                    }
                    n31 += this.rowStride;
                    n32 += n4;
                }
            }
        } else {
            int n36 = n2;
            int n37 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n38 = n36;
                int n39 = n37;
                for (int j = 0; j < this.columns; ++j) {
                    this.elements[n38] = intIntFunction.apply(this.elements[n38], nArray[n39]);
                    n38 += this.columnStride;
                    n39 += n3;
                }
                n36 += this.rowStride;
                n37 += n4;
            }
        }
        return this;
    }

    public IntMatrix2D assign(IntMatrix2D intMatrix2D, final IntIntFunction intIntFunction, IntArrayList intArrayList, IntArrayList intArrayList2) {
        this.checkShape(intMatrix2D);
        int n = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        final int[] nArray3 = (int[])intMatrix2D.elements();
        final int n2 = (int)intMatrix2D.index(0, 0);
        final int n3 = (int)this.index(0, 0);
        final int n4 = intMatrix2D.columnStride();
        final int n5 = intMatrix2D.rowStride();
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n6];
            int n7 = n / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n6 - 1 ? n : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n8; i < n9; ++i) {
                            int n = n3 + nArray[i] * DenseIntMatrix2D.this.rowStride + nArray2[i] * DenseIntMatrix2D.this.columnStride;
                            int n22 = n2 + nArray[i] * n5 + nArray2[i] * n4;
                            DenseIntMatrix2D.this.elements[n] = intIntFunction.apply(DenseIntMatrix2D.this.elements[n], nArray3[n22]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < n; ++i) {
                int n10 = n3 + nArray[i] * this.rowStride + nArray2[i] * this.columnStride;
                int n11 = n2 + nArray[i] * n5 + nArray2[i] * n4;
                this.elements[n10] = intIntFunction.apply(this.elements[n10], nArray3[n11]);
            }
        }
        return this;
    }

    public int cardinality() {
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        final int n3 = (int)this.index(0, 0);
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n4;
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n5 = this.rows / n2;
            for (n4 = 0; n4 < n2; ++n4) {
                final int n6 = n4 * n5;
                final int n7 = n4 == n2 - 1 ? this.rows : n6 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        int n2 = n3 + n6 * DenseIntMatrix2D.this.rowStride;
                        for (int i = n6; i < n7; ++i) {
                            int n32 = n2;
                            for (int j = 0; j < DenseIntMatrix2D.this.columns; ++j) {
                                if (DenseIntMatrix2D.this.elements[n32] != 0) {
                                    ++n;
                                }
                                n32 += DenseIntMatrix2D.this.columnStride;
                            }
                            n2 += DenseIntMatrix2D.this.rowStride;
                        }
                        return n;
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n2; ++n4) {
                    integerArray[n4] = (Integer)futureArray[n4].get();
                }
                n = integerArray[0];
                for (n4 = 1; n4 < n2; ++n4) {
                    n += integerArray[n4].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            int n8 = n3;
            for (int i = 0; i < this.rows; ++i) {
                int n9 = n8;
                for (int j = 0; j < this.columns; ++j) {
                    if (this.elements[n9] != 0) {
                        ++n;
                    }
                    n9 += this.columnStride;
                }
                n8 += this.rowStride;
            }
        }
        return n;
    }

    public int[] elements() {
        return this.elements;
    }

    public IntMatrix2D forEachNonZero(final IntIntIntFunction intIntIntFunction) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n6 = n + n4 * DenseIntMatrix2D.this.rowStride;
                        for (int i = n4; i < n5; ++i) {
                            int n2 = n6;
                            for (int j = 0; j < DenseIntMatrix2D.this.columns; ++j) {
                                int n3 = DenseIntMatrix2D.this.elements[n2];
                                if (n3 != 0) {
                                    DenseIntMatrix2D.this.elements[n2] = intIntIntFunction.apply(i, j, n3);
                                }
                                n2 += DenseIntMatrix2D.this.columnStride;
                            }
                            n6 += DenseIntMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n7 = n6;
                for (int j = 0; j < this.columns; ++j) {
                    int n8 = this.elements[n7];
                    if (n8 != 0) {
                        this.elements[n7] = intIntIntFunction.apply(i, j, n8);
                    }
                    n7 += this.columnStride;
                }
                n6 += this.rowStride;
            }
        }
        return this;
    }

    public void getNegativeValues(IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3) {
        intArrayList.clear();
        intArrayList2.clear();
        intArrayList3.clear();
        int n = (int)this.index(0, 0);
        for (int i = 0; i < this.rows; ++i) {
            int n2 = n;
            for (int j = 0; j < this.columns; ++j) {
                int n3 = this.elements[n2];
                if (n3 < 0) {
                    intArrayList.add(i);
                    intArrayList2.add(j);
                    intArrayList3.add(n3);
                }
                n2 += this.columnStride;
            }
            n += this.rowStride;
        }
    }

    public void getNonZeros(IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3) {
        intArrayList.clear();
        intArrayList2.clear();
        intArrayList3.clear();
        int n = (int)this.index(0, 0);
        for (int i = 0; i < this.rows; ++i) {
            int n2 = n;
            for (int j = 0; j < this.columns; ++j) {
                int n3 = this.elements[n2];
                if (n3 != 0) {
                    intArrayList.add(i);
                    intArrayList2.add(j);
                    intArrayList3.add(n3);
                }
                n2 += this.columnStride;
            }
            n += this.rowStride;
        }
    }

    public void getPositiveValues(IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3) {
        intArrayList.clear();
        intArrayList2.clear();
        intArrayList3.clear();
        int n = (int)this.index(0, 0);
        for (int i = 0; i < this.rows; ++i) {
            int n2 = n;
            for (int j = 0; j < this.columns; ++j) {
                int n3 = this.elements[n2];
                if (n3 > 0) {
                    intArrayList.add(i);
                    intArrayList2.add(j);
                    intArrayList3.add(n3);
                }
                n2 += this.columnStride;
            }
            n += this.rowStride;
        }
    }

    public int getQuick(int n, int n2) {
        return this.elements[this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride];
    }

    public long index(int n, int n2) {
        return this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride;
    }

    public IntMatrix2D like(int n, int n2) {
        return new DenseIntMatrix2D(n, n2);
    }

    public IntMatrix1D like1D(int n) {
        return new DenseIntMatrix1D(n);
    }

    public int[] getMaxLocation() {
        int n = 0;
        int n2 = 0;
        final int n3 = (int)this.index(0, 0);
        int n4 = 0;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n6;
            Future[] futureArray = new Future[n5];
            int[][] nArray = new int[n5][2];
            int n7 = this.rows / n5;
            for (n6 = 0; n6 < n5; ++n6) {
                final int n8 = n6 * n7;
                final int n9 = n6 == n5 - 1 ? this.rows : n8 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Callable<int[]>(){

                    @Override
                    public int[] call() throws Exception {
                        int n = DenseIntMatrix2D.this.elements[n3 + n8 * DenseIntMatrix2D.this.rowStride];
                        int n2 = n8;
                        int n32 = 0;
                        int n4 = 1;
                        for (int i = n8; i < n9; ++i) {
                            for (int j = n4; j < DenseIntMatrix2D.this.columns; ++j) {
                                int n5 = DenseIntMatrix2D.this.elements[n3 + i * DenseIntMatrix2D.this.rowStride + j * DenseIntMatrix2D.this.columnStride];
                                if (n >= n5) continue;
                                n = n5;
                                n2 = i;
                                n32 = j;
                            }
                            n4 = 0;
                        }
                        return new int[]{n, n2, n32};
                    }
                });
            }
            try {
                for (n6 = 0; n6 < n5; ++n6) {
                    nArray[n6] = (int[])futureArray[n6].get();
                }
                n4 = nArray[0][0];
                n = nArray[0][1];
                n2 = nArray[0][2];
                for (n6 = 1; n6 < n5; ++n6) {
                    if (n4 >= nArray[n6][0]) continue;
                    n4 = nArray[n6][0];
                    n = nArray[n6][1];
                    n2 = nArray[n6][2];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            n4 = this.elements[n3];
            int n10 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n10; j < this.columns; ++j) {
                    int n11 = this.elements[n3 + i * this.rowStride + j * this.columnStride];
                    if (n4 >= n11) continue;
                    n4 = n11;
                    n = i;
                    n2 = j;
                }
                n10 = 0;
            }
        }
        return new int[]{n4, n, n2};
    }

    public int[] getMinLocation() {
        int n = 0;
        int n2 = 0;
        final int n3 = (int)this.index(0, 0);
        int n4 = 0;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n6;
            Future[] futureArray = new Future[n5];
            int[][] nArray = new int[n5][2];
            int n7 = this.rows / n5;
            for (n6 = 0; n6 < n5; ++n6) {
                final int n8 = n6 * n7;
                final int n9 = n6 == n5 - 1 ? this.rows : n8 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Callable<int[]>(){

                    @Override
                    public int[] call() throws Exception {
                        int n = n8;
                        int n2 = 0;
                        int n32 = DenseIntMatrix2D.this.elements[n3 + n8 * DenseIntMatrix2D.this.rowStride];
                        int n4 = 1;
                        for (int i = n8; i < n9; ++i) {
                            for (int j = n4; j < DenseIntMatrix2D.this.columns; ++j) {
                                int n5 = DenseIntMatrix2D.this.elements[n3 + i * DenseIntMatrix2D.this.rowStride + j * DenseIntMatrix2D.this.columnStride];
                                if (n32 <= n5) continue;
                                n32 = n5;
                                n = i;
                                n2 = j;
                            }
                            n4 = 0;
                        }
                        return new int[]{n32, n, n2};
                    }
                });
            }
            try {
                for (n6 = 0; n6 < n5; ++n6) {
                    nArray[n6] = (int[])futureArray[n6].get();
                }
                n4 = nArray[0][0];
                n = nArray[0][1];
                n2 = nArray[0][2];
                for (n6 = 1; n6 < n5; ++n6) {
                    if (n4 <= nArray[n6][0]) continue;
                    n4 = nArray[n6][0];
                    n = nArray[n6][1];
                    n2 = nArray[n6][2];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            n4 = this.elements[n3];
            int n10 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n10; j < this.columns; ++j) {
                    int n11 = this.elements[n3 + i * this.rowStride + j * this.columnStride];
                    if (n4 <= n11) continue;
                    n4 = n11;
                    n = i;
                    n2 = j;
                }
                n10 = 0;
            }
        }
        return new int[]{n4, n, n2};
    }

    public void setQuick(int n, int n2, int n3) {
        this.elements[this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride] = n3;
    }

    public int[][] toArray() {
        final int[][] nArray = new int[this.rows][this.columns];
        int n = ConcurrencyUtils.getNumberOfThreads();
        final int n2 = (int)this.index(0, 0);
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n3 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n2 + n4 * DenseIntMatrix2D.this.rowStride;
                        for (int i = n4; i < n5; ++i) {
                            int[] nArray2 = nArray[i];
                            int n22 = n;
                            for (int j = 0; j < DenseIntMatrix2D.this.columns; ++j) {
                                nArray2[j] = DenseIntMatrix2D.this.elements[n22];
                                n22 += DenseIntMatrix2D.this.columnStride;
                            }
                            n += DenseIntMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n2;
            for (int i = 0; i < this.rows; ++i) {
                int[] nArray2 = nArray[i];
                int n7 = n6;
                for (int j = 0; j < this.columns; ++j) {
                    nArray2[j] = this.elements[n7];
                    n7 += this.columnStride;
                }
                n6 += this.rowStride;
            }
        }
        return nArray;
    }

    public IntMatrix1D vectorize() {
        DenseIntMatrix1D denseIntMatrix1D = new DenseIntMatrix1D(this.size());
        final int n = (int)this.index(0, 0);
        final int n2 = (int)denseIntMatrix1D.index(0);
        final int n3 = denseIntMatrix1D.stride();
        final int[] nArray = denseIntMatrix1D.elements();
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n4];
            int n5 = this.columns / n4;
            for (int i = 0; i < n4; ++i) {
                final int n6 = i * n5;
                final int n7 = i * n5 * this.rows;
                final int n8 = i == n4 - 1 ? this.columns : n6 + n5;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n4 = 0;
                        int n22 = n2 + n7 * n3;
                        for (int i = n6; i < n8; ++i) {
                            n4 = n + i * DenseIntMatrix2D.this.columnStride;
                            for (int j = 0; j < DenseIntMatrix2D.this.rows; ++j) {
                                nArray[n22] = DenseIntMatrix2D.this.elements[n4];
                                n4 += DenseIntMatrix2D.this.rowStride;
                                n22 += n3;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n;
            int n10 = n2;
            for (int i = 0; i < this.columns; ++i) {
                n9 = n + i * this.columnStride;
                for (int j = 0; j < this.rows; ++j) {
                    nArray[n10] = this.elements[n9];
                    n9 += this.rowStride;
                    n10 += n3;
                }
            }
        }
        return denseIntMatrix1D;
    }

    public IntMatrix1D zMult(IntMatrix1D intMatrix1D, IntMatrix1D intMatrix1D2) {
        IntMatrix1D intMatrix1D3 = intMatrix1D2 == null ? new DenseIntMatrix1D(this.rows) : intMatrix1D2;
        if (!(intMatrix1D instanceof DenseIntMatrix1D) || !(intMatrix1D3 instanceof DenseIntMatrix1D)) {
            return super.zMult(intMatrix1D, intMatrix1D3);
        }
        if (this.columns != intMatrix1D.size() || this.rows > intMatrix1D3.size()) {
            throw new IllegalArgumentException("Incompatible args: " + this.toStringShort() + ", " + intMatrix1D.toStringShort() + ", " + intMatrix1D3.toStringShort());
        }
        final int[] nArray = (int[])intMatrix1D.elements();
        final int[] nArray2 = (int[])intMatrix1D3.elements();
        final int n = (int)this.index(0, 0);
        final int n2 = (int)intMatrix1D.index(0);
        final int n3 = (int)intMatrix1D3.index(0);
        final int n4 = intMatrix1D.stride();
        final int n5 = intMatrix1D3.stride();
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n6];
            final AtomicInteger atomicInteger = new AtomicInteger();
            for (int i = 0; i < n6; ++i) {
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n6 = atomicInteger.getAndIncrement();
                        while (n6 < DenseIntMatrix2D.this.rows) {
                            int n22 = 0;
                            int n32 = n + n6 * DenseIntMatrix2D.this.rowStride;
                            int n42 = n2;
                            for (int i = 0; i < DenseIntMatrix2D.this.columns; ++i) {
                                n22 += DenseIntMatrix2D.this.elements[n32] * nArray[n42];
                                n32 += DenseIntMatrix2D.this.columnStride;
                                n42 += n4;
                            }
                            nArray2[n3 + n6 * n5] = n22;
                            n6 = atomicInteger.getAndIncrement();
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7 = n;
            int n8 = n3;
            for (int i = 0; i < this.rows; ++i) {
                int n9 = 0;
                int n10 = n7;
                int n11 = n2;
                for (int j = 0; j < this.columns; ++j) {
                    n9 += this.elements[n10] * nArray[n11];
                    n10 += this.columnStride;
                    n11 += n4;
                }
                nArray2[n8] = n9;
                n7 += this.rowStride;
                n8 += n5;
            }
        }
        intMatrix1D2 = intMatrix1D3;
        return intMatrix1D3;
    }

    public IntMatrix1D zMultOld(IntMatrix1D intMatrix1D, IntMatrix1D intMatrix1D2) {
        IntMatrix1D intMatrix1D3 = intMatrix1D2 == null ? new DenseIntMatrix1D(this.rows) : intMatrix1D2;
        if (!(intMatrix1D instanceof DenseIntMatrix1D) || !(intMatrix1D3 instanceof DenseIntMatrix1D)) {
            return super.zMult(intMatrix1D, intMatrix1D3);
        }
        if (this.columns != intMatrix1D.size() || this.rows > intMatrix1D3.size()) {
            throw new IllegalArgumentException("Incompatible args: " + this.toStringShort() + ", " + intMatrix1D.toStringShort() + ", " + intMatrix1D3.toStringShort());
        }
        final int[] nArray = (int[])intMatrix1D.elements();
        final int[] nArray2 = (int[])intMatrix1D3.elements();
        final int n = (int)this.index(0, 0);
        final int n2 = (int)intMatrix1D.index(0);
        final int n3 = (int)intMatrix1D3.index(0);
        final int n4 = intMatrix1D.stride();
        final int n5 = intMatrix1D3.stride();
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n6];
            int n7 = this.rows / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n6 - 1 ? this.rows : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n6 = n + n8 * DenseIntMatrix2D.this.rowStride;
                        int n22 = n3 + n8 * n5;
                        for (int i = n8; i < n9; ++i) {
                            int n32 = 0;
                            int n42 = n6;
                            int n52 = n2;
                            for (int j = 0; j < DenseIntMatrix2D.this.columns; ++j) {
                                n32 += DenseIntMatrix2D.this.elements[n42] * nArray[n52];
                                n42 += DenseIntMatrix2D.this.columnStride;
                                n52 += n4;
                            }
                            nArray2[n22] = n32;
                            n6 += DenseIntMatrix2D.this.rowStride;
                            n22 += n5;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n10 = n;
            int n11 = n3;
            for (int i = 0; i < this.rows; ++i) {
                int n12 = 0;
                int n13 = n10;
                int n14 = n2;
                for (int j = 0; j < this.columns; ++j) {
                    n12 += this.elements[n13] * nArray[n14];
                    n13 += this.columnStride;
                    n14 += n4;
                }
                nArray2[n11] = n12;
                n10 += this.rowStride;
                n11 += n5;
            }
        }
        intMatrix1D2 = intMatrix1D3;
        return intMatrix1D3;
    }

    public IntMatrix1D zMult(IntMatrix1D intMatrix1D, IntMatrix1D intMatrix1D2, final int n, final int n2, boolean bl) {
        IntMatrix1D intMatrix1D3 = intMatrix1D2 == null ? new DenseIntMatrix1D(this.rows) : intMatrix1D2;
        if (bl) {
            return this.viewDice().zMult(intMatrix1D, intMatrix1D3, n, n2, false);
        }
        if (!(intMatrix1D instanceof DenseIntMatrix1D) || !(intMatrix1D3 instanceof DenseIntMatrix1D)) {
            return super.zMult(intMatrix1D, intMatrix1D3, n, n2, bl);
        }
        if (this.columns != intMatrix1D.size() || this.rows > intMatrix1D3.size()) {
            throw new IllegalArgumentException("Incompatible args: " + this.toStringShort() + ", " + intMatrix1D.toStringShort() + ", " + intMatrix1D3.toStringShort());
        }
        final int[] nArray = (int[])intMatrix1D.elements();
        final int[] nArray2 = (int[])intMatrix1D3.elements();
        if (this.elements == null || nArray == null || nArray2 == null) {
            throw new InternalError();
        }
        final int n3 = intMatrix1D.stride();
        final int n4 = intMatrix1D3.stride();
        final int n5 = (int)this.index(0, 0);
        final int n6 = (int)intMatrix1D.index(0);
        final int n7 = (int)intMatrix1D3.index(0);
        int n8 = ConcurrencyUtils.getNumberOfThreads();
        if (n8 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n8];
            int n9 = this.rows / n8;
            for (int i = 0; i < n8; ++i) {
                final int n10 = i * n9;
                final int n11 = i == n8 - 1 ? this.rows : n10 + n9;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n8 = n5 + n10 * DenseIntMatrix2D.this.rowStride;
                        int n22 = n7 + n10 * n4;
                        for (int i = n10; i < n11; ++i) {
                            int n32 = 0;
                            int n42 = n8;
                            int n52 = n6;
                            for (int j = 0; j < DenseIntMatrix2D.this.columns; ++j) {
                                n32 += DenseIntMatrix2D.this.elements[n42] * nArray[n52];
                                n42 += DenseIntMatrix2D.this.columnStride;
                                n52 += n3;
                            }
                            nArray2[n22] = n * n32 + n2 * nArray2[n22];
                            n8 += DenseIntMatrix2D.this.rowStride;
                            n22 += n4;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n12 = n5;
            int n13 = n7;
            for (int i = 0; i < this.rows; ++i) {
                int n14 = 0;
                int n15 = n12;
                int n16 = n6;
                for (int j = 0; j < this.columns; ++j) {
                    n14 += this.elements[n15] * nArray[n16];
                    n15 += this.columnStride;
                    n16 += n3;
                }
                nArray2[n13] = n * n14 + n2 * nArray2[n13];
                n12 += this.rowStride;
                n13 += n4;
            }
        }
        intMatrix1D2 = intMatrix1D3;
        return intMatrix1D2;
    }

    public IntMatrix2D zMult(IntMatrix2D intMatrix2D, IntMatrix2D intMatrix2D2) {
        int n;
        int n2 = this.rows;
        int n3 = this.columns;
        int n4 = intMatrix2D.columns();
        if (intMatrix2D2 == null) {
            intMatrix2D2 = new DenseIntMatrix2D(n2, n4);
        }
        if (!(intMatrix2D2 instanceof DenseIntMatrix2D)) {
            return super.zMult(intMatrix2D, intMatrix2D2);
        }
        if (intMatrix2D.rows() != n3) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + intMatrix2D.toStringShort());
        }
        if (intMatrix2D2.rows() != n2 || intMatrix2D2.columns() != n4) {
            throw new IllegalArgumentException("Incompatibe result matrix: " + this.toStringShort() + ", " + intMatrix2D.toStringShort() + ", " + intMatrix2D2.toStringShort());
        }
        if (this == intMatrix2D2 || intMatrix2D == intMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        long l = 2L * (long)n2 * (long)n3 * (long)n4;
        int n5 = (int)Math.min(l / 30000L, (long)ConcurrencyUtils.getNumberOfThreads());
        boolean bl = n4 >= n5;
        int n6 = bl ? n4 : n2;
        n5 = Math.min(n6, n5);
        if (n5 < 2) {
            return this.zMultSeq(intMatrix2D, intMatrix2D2);
        }
        int n7 = n6 / n5;
        Future[] futureArray = new Future[n5];
        for (n = 0; n < n5; ++n) {
            IntMatrix2D intMatrix2D3;
            IntMatrix2D intMatrix2D4;
            IntMatrix2D intMatrix2D5;
            int n8 = n * n7;
            if (n == n5 - 1) {
                n7 = n6 - n7 * n;
            }
            if (bl) {
                intMatrix2D5 = this;
                intMatrix2D4 = intMatrix2D.viewPart(0, n8, n3, n7);
                intMatrix2D3 = intMatrix2D2.viewPart(0, n8, n2, n7);
            } else {
                intMatrix2D5 = this.viewPart(n8, 0, n7, n3);
                intMatrix2D4 = intMatrix2D;
                intMatrix2D3 = intMatrix2D2.viewPart(n8, 0, n7, n4);
            }
            futureArray[n] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    ((DenseIntMatrix2D)intMatrix2D5).zMultSeq(intMatrix2D4, intMatrix2D3);
                }
            });
        }
        try {
            for (n = 0; n < n5; ++n) {
                futureArray[n].get();
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return intMatrix2D2;
    }

    public IntMatrix2D zMult(IntMatrix2D intMatrix2D, IntMatrix2D intMatrix2D2, final int n, final int n2, final boolean bl, final boolean bl2) {
        int n3;
        int n4 = this.rows;
        int n5 = this.columns;
        int n6 = intMatrix2D.columns();
        if (intMatrix2D2 == null) {
            intMatrix2D2 = new DenseIntMatrix2D(n4, n6);
        }
        if (bl) {
            return this.viewDice().zMult(intMatrix2D, intMatrix2D2, n, n2, false, bl2);
        }
        if (intMatrix2D instanceof SparseIntMatrix2D || intMatrix2D instanceof RCIntMatrix2D) {
            if (intMatrix2D2 == null) {
                return intMatrix2D.zMult(this, null, n, n2, !bl2, true).viewDice();
            }
            intMatrix2D.zMult(this, intMatrix2D2.viewDice(), n, n2, !bl2, true);
            return intMatrix2D2;
        }
        if (bl2) {
            return this.zMult(intMatrix2D.viewDice(), intMatrix2D2, n, n2, bl, false);
        }
        if (!(intMatrix2D2 instanceof DenseIntMatrix2D)) {
            return super.zMult(intMatrix2D, intMatrix2D2, n, n2, bl, bl2);
        }
        if (intMatrix2D.rows() != n5) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + intMatrix2D.toStringShort());
        }
        if (intMatrix2D2.rows() != n4 || intMatrix2D2.columns() != n6) {
            throw new IllegalArgumentException("Incompatibe result matrix: " + this.toStringShort() + ", " + intMatrix2D.toStringShort() + ", " + intMatrix2D2.toStringShort());
        }
        if (this == intMatrix2D2 || intMatrix2D == intMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        long l = 2L * (long)n4 * (long)n5 * (long)n6;
        int n7 = (int)Math.min(l / 30000L, (long)ConcurrencyUtils.getNumberOfThreads());
        boolean bl3 = n6 >= n7;
        int n8 = bl3 ? n6 : n4;
        n7 = Math.min(n8, n7);
        if (n7 < 2) {
            return this.zMultSeq(intMatrix2D, intMatrix2D2, n, n2, bl, bl2);
        }
        int n9 = n8 / n7;
        Future[] futureArray = new Future[n7];
        for (n3 = 0; n3 < n7; ++n3) {
            IntMatrix2D intMatrix2D3;
            IntMatrix2D intMatrix2D4;
            IntMatrix2D intMatrix2D5;
            int n10 = n3 * n9;
            if (n3 == n7 - 1) {
                n9 = n8 - n9 * n3;
            }
            if (bl3) {
                intMatrix2D5 = this;
                intMatrix2D4 = intMatrix2D.viewPart(0, n10, n5, n9);
                intMatrix2D3 = intMatrix2D2.viewPart(0, n10, n4, n9);
            } else {
                intMatrix2D5 = this.viewPart(n10, 0, n9, n5);
                intMatrix2D4 = intMatrix2D;
                intMatrix2D3 = intMatrix2D2.viewPart(n10, 0, n9, n6);
            }
            futureArray[n3] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    ((DenseIntMatrix2D)intMatrix2D5).zMultSeq(intMatrix2D4, intMatrix2D3, n, n2, bl, bl2);
                }
            });
        }
        try {
            for (n3 = 0; n3 < n7; ++n3) {
                futureArray[n3].get();
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return intMatrix2D2;
    }

    public int zSum() {
        int n = 0;
        if (this.elements == null) {
            throw new InternalError();
        }
        final int n2 = (int)this.index(0, 0);
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n4;
            Future[] futureArray = new Future[n3];
            int n5 = this.rows / n3;
            for (n4 = 0; n4 < n3; ++n4) {
                final int n6 = n4 * n5;
                final int n7 = n4 == n3 - 1 ? this.rows : n6 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        int n22 = n2 + n6 * DenseIntMatrix2D.this.rowStride;
                        for (int i = n6; i < n7; ++i) {
                            int n3 = n22;
                            for (int j = 0; j < DenseIntMatrix2D.this.columns; ++j) {
                                n += DenseIntMatrix2D.this.elements[n3];
                                n3 += DenseIntMatrix2D.this.columnStride;
                            }
                            n22 += DenseIntMatrix2D.this.rowStride;
                        }
                        return n;
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n3; ++n4) {
                    n += ((Integer)futureArray[n4].get()).intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            int n8 = n2;
            for (int i = 0; i < this.rows; ++i) {
                int n9 = n8;
                for (int j = 0; j < this.columns; ++j) {
                    n += this.elements[n9];
                    n9 += this.columnStride;
                }
                n8 += this.rowStride;
            }
        }
        return n;
    }

    protected boolean haveSharedCellsRaw(IntMatrix2D intMatrix2D) {
        if (intMatrix2D instanceof SelectedDenseIntMatrix2D) {
            SelectedDenseIntMatrix2D selectedDenseIntMatrix2D = (SelectedDenseIntMatrix2D)intMatrix2D;
            return this.elements == selectedDenseIntMatrix2D.elements;
        }
        if (intMatrix2D instanceof DenseIntMatrix2D) {
            DenseIntMatrix2D denseIntMatrix2D = (DenseIntMatrix2D)intMatrix2D;
            return this.elements == denseIntMatrix2D.elements;
        }
        return false;
    }

    protected IntMatrix1D like1D(int n, int n2, int n3) {
        return new DenseIntMatrix1D(n, this.elements, n2, n3, true);
    }

    protected IntMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        return new SelectedDenseIntMatrix2D(this.elements, nArray, nArray2, 0);
    }

    private IntMatrix2D zMultSeq(IntMatrix2D intMatrix2D, IntMatrix2D intMatrix2D2) {
        int n = this.rows;
        int n2 = this.columns;
        int n3 = intMatrix2D.columns();
        if (intMatrix2D2 == null) {
            intMatrix2D2 = new DenseIntMatrix2D(n, n3);
        }
        if (!(intMatrix2D2 instanceof DenseIntMatrix2D)) {
            return super.zMult(intMatrix2D, intMatrix2D2);
        }
        if (intMatrix2D.rows() != n2) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + intMatrix2D.toStringShort());
        }
        if (intMatrix2D2.rows() != n || intMatrix2D2.columns() != n3) {
            throw new IllegalArgumentException("Incompatibel result matrix: " + this.toStringShort() + ", " + intMatrix2D.toStringShort() + ", " + intMatrix2D2.toStringShort());
        }
        if (this == intMatrix2D2 || intMatrix2D == intMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        DenseIntMatrix2D denseIntMatrix2D = (DenseIntMatrix2D)intMatrix2D;
        DenseIntMatrix2D denseIntMatrix2D2 = (DenseIntMatrix2D)intMatrix2D2;
        int[] nArray = this.elements;
        int[] nArray2 = denseIntMatrix2D.elements;
        int[] nArray3 = denseIntMatrix2D2.elements;
        int n4 = this.columnStride;
        int n5 = denseIntMatrix2D.columnStride;
        int n6 = denseIntMatrix2D2.columnStride;
        int n7 = this.rowStride;
        int n8 = denseIntMatrix2D.rowStride;
        int n9 = denseIntMatrix2D2.rowStride;
        int n10 = (30000 - n2) / (n2 + 1);
        if (n10 <= 0) {
            n10 = 1;
        }
        int n11 = n / n10;
        int n12 = 0;
        if (n % n10 != 0) {
            ++n11;
        }
        while (--n11 >= 0) {
            int n13 = (int)denseIntMatrix2D.index(0, 0);
            int n14 = (int)this.index(n12, 0);
            int n15 = (int)denseIntMatrix2D2.index(n12, 0);
            n12 += n10;
            if (n11 == 0) {
                n10 += n - n12;
            }
            int n16 = n3;
            while (--n16 >= 0) {
                int n17 = n14;
                int n18 = n15;
                int n19 = n10;
                while (--n19 >= 0) {
                    int n20 = n17;
                    int n21 = n13;
                    int n22 = 0;
                    n20 -= n4;
                    n21 -= n8;
                    int n23 = n2 % 4;
                    while (--n23 >= 0) {
                        n22 += nArray[n20 += n4] * nArray2[n21 += n8];
                    }
                    n23 = n2 / 4;
                    while (--n23 >= 0) {
                        int n24 = n20 + n4;
                        n20 = n24;
                        int n25 = n21 + n8;
                        n21 = n25;
                        int n26 = n20 + n4;
                        n20 = n26;
                        int n27 = n21 + n8;
                        n21 = n27;
                        n20 = n20 + n4;
                        n21 = n21 + n8;
                        n22 += nArray[n24] * nArray2[n25] + nArray[n26] * nArray2[n27] + nArray[n20] * nArray2[n21] + nArray[n20 += n4] * nArray2[n21 += n8];
                    }
                    nArray3[n18] = n22;
                    n17 += n7;
                    n18 += n9;
                }
                n13 += n5;
                n15 += n6;
            }
        }
        return intMatrix2D2;
    }

    private IntMatrix2D zMultSeq(IntMatrix2D intMatrix2D, IntMatrix2D intMatrix2D2, int n, int n2, boolean bl, boolean bl2) {
        if (bl) {
            return this.viewDice().zMult(intMatrix2D, intMatrix2D2, n, n2, false, bl2);
        }
        if (intMatrix2D instanceof SparseIntMatrix2D || intMatrix2D instanceof RCIntMatrix2D) {
            if (intMatrix2D2 == null) {
                return intMatrix2D.zMult(this, null, n, n2, !bl2, true).viewDice();
            }
            intMatrix2D.zMult(this, intMatrix2D2.viewDice(), n, n2, !bl2, true);
            return intMatrix2D2;
        }
        if (bl2) {
            return this.zMult(intMatrix2D.viewDice(), intMatrix2D2, n, n2, bl, false);
        }
        int n3 = this.rows;
        int n4 = this.columns;
        int n5 = intMatrix2D.columns();
        if (intMatrix2D2 == null) {
            intMatrix2D2 = new DenseIntMatrix2D(n3, n5);
        }
        if (!(intMatrix2D2 instanceof DenseIntMatrix2D)) {
            return super.zMult(intMatrix2D, intMatrix2D2, n, n2, bl, bl2);
        }
        if (intMatrix2D.rows() != n4) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + intMatrix2D.toStringShort());
        }
        if (intMatrix2D2.rows() != n3 || intMatrix2D2.columns() != n5) {
            throw new IllegalArgumentException("Incompatibel result matrix: " + this.toStringShort() + ", " + intMatrix2D.toStringShort() + ", " + intMatrix2D2.toStringShort());
        }
        if (this == intMatrix2D2 || intMatrix2D == intMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        DenseIntMatrix2D denseIntMatrix2D = (DenseIntMatrix2D)intMatrix2D;
        DenseIntMatrix2D denseIntMatrix2D2 = (DenseIntMatrix2D)intMatrix2D2;
        int[] nArray = this.elements;
        int[] nArray2 = denseIntMatrix2D.elements;
        int[] nArray3 = denseIntMatrix2D2.elements;
        if (nArray == null || nArray2 == null || nArray3 == null) {
            throw new InternalError();
        }
        int n6 = this.columnStride;
        int n7 = denseIntMatrix2D.columnStride;
        int n8 = denseIntMatrix2D2.columnStride;
        int n9 = this.rowStride;
        int n10 = denseIntMatrix2D.rowStride;
        int n11 = denseIntMatrix2D2.rowStride;
        int n12 = (30000 - n4) / (n4 + 1);
        if (n12 <= 0) {
            n12 = 1;
        }
        int n13 = n3 / n12;
        int n14 = 0;
        if (n3 % n12 != 0) {
            ++n13;
        }
        while (--n13 >= 0) {
            int n15 = (int)denseIntMatrix2D.index(0, 0);
            int n16 = (int)this.index(n14, 0);
            int n17 = (int)denseIntMatrix2D2.index(n14, 0);
            n14 += n12;
            if (n13 == 0) {
                n12 += n3 - n14;
            }
            int n18 = n5;
            while (--n18 >= 0) {
                int n19 = n16;
                int n20 = n17;
                int n21 = n12;
                while (--n21 >= 0) {
                    int n22 = n19;
                    int n23 = n15;
                    int n24 = 0;
                    n22 -= n6;
                    n23 -= n10;
                    int n25 = n4 % 4;
                    while (--n25 >= 0) {
                        n24 += nArray[n22 += n6] * nArray2[n23 += n10];
                    }
                    n25 = n4 / 4;
                    while (--n25 >= 0) {
                        int n26 = n22 + n6;
                        n22 = n26;
                        int n27 = n23 + n10;
                        n23 = n27;
                        int n28 = n22 + n6;
                        n22 = n28;
                        int n29 = n23 + n10;
                        n23 = n29;
                        n22 = n22 + n6;
                        n23 = n23 + n10;
                        n24 += nArray[n26] * nArray2[n27] + nArray[n28] * nArray2[n29] + nArray[n22] * nArray2[n23] + nArray[n22 += n6] * nArray2[n23 += n10];
                    }
                    nArray3[n20] = n * n24 + n2 * nArray3[n20];
                    n19 += n9;
                    n20 += n11;
                }
                n15 += n7;
                n17 += n8;
            }
        }
        return intMatrix2D2;
    }
}

