/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.FloatProperty;
import cern.colt.matrix.tfloat.impl.DelegateFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.DiagonalFloatMatrix2D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class WrapperFloatMatrix2D
extends FloatMatrix2D {
    protected FloatMatrix2D content;

    public WrapperFloatMatrix2D(FloatMatrix2D floatMatrix2D) {
        if (floatMatrix2D != null) {
            this.setUp(floatMatrix2D.rows(), floatMatrix2D.columns());
        }
        this.content = floatMatrix2D;
    }

    public Object elements() {
        return this.content.elements();
    }

    public float getQuick(int n, int n2) {
        return this.content.getQuick(n, n2);
    }

    public boolean equals(float f) {
        if (this.content instanceof DiagonalFloatMatrix2D) {
            float f2 = FloatProperty.DEFAULT.tolerance();
            float[] fArray = (float[])this.content.elements();
            for (int i = 0; i < fArray.length; ++i) {
                float f3 = fArray[i];
                float f4 = Math.abs(f - f3);
                if (f4 != f4 && (f != f && f3 != f3 || f == f3)) {
                    f4 = 0.0f;
                }
                if (f4 <= f2) continue;
                return false;
            }
            return true;
        }
        return super.equals(f);
    }

    public boolean equals(Object object) {
        if (this.content instanceof DiagonalFloatMatrix2D && object instanceof DiagonalFloatMatrix2D) {
            float f = FloatProperty.DEFAULT.tolerance();
            if (this == object) {
                return true;
            }
            if (this == null || object == null) {
                return false;
            }
            DiagonalFloatMatrix2D diagonalFloatMatrix2D = (DiagonalFloatMatrix2D)this.content;
            DiagonalFloatMatrix2D diagonalFloatMatrix2D2 = (DiagonalFloatMatrix2D)object;
            if (diagonalFloatMatrix2D.columns() != diagonalFloatMatrix2D2.columns() || diagonalFloatMatrix2D.rows() != diagonalFloatMatrix2D2.rows() || diagonalFloatMatrix2D.dindex() != diagonalFloatMatrix2D2.dindex() || diagonalFloatMatrix2D.dlength() != diagonalFloatMatrix2D2.dlength()) {
                return false;
            }
            float[] fArray = diagonalFloatMatrix2D.elements();
            float[] fArray2 = diagonalFloatMatrix2D2.elements();
            for (int i = 0; i < fArray.length; ++i) {
                float f2 = fArray2[i];
                float f3 = fArray[i];
                float f4 = Math.abs(f2 - f3);
                if (f4 != f4 && (f2 != f2 && f3 != f3 || f2 == f3)) {
                    f4 = 0.0f;
                }
                if (f4 <= f) continue;
                return false;
            }
            return true;
        }
        return super.equals(object);
    }

    public FloatMatrix2D like(int n, int n2) {
        return this.content.like(n, n2);
    }

    public FloatMatrix1D like1D(int n) {
        return this.content.like1D(n);
    }

    public void setQuick(int n, int n2, float f) {
        this.content.setQuick(n, n2, f);
    }

    public FloatMatrix1D vectorize() {
        final DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(this.size());
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i * n2 * this.rows;
                final int n5 = i == n - 1 ? this.columns : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4;
                        for (int i = n3; i < n5; ++i) {
                            for (int j = 0; j < WrapperFloatMatrix2D.this.rows; ++j) {
                                denseFloatMatrix1D.setQuick(n++, WrapperFloatMatrix2D.this.getQuick(j, i));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = 0;
            for (int i = 0; i < this.columns; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    denseFloatMatrix1D.setQuick(n6++, this.getQuick(j, i));
                }
            }
        }
        return denseFloatMatrix1D;
    }

    public FloatMatrix1D viewColumn(int n) {
        return this.viewDice().viewRow(n);
    }

    public FloatMatrix2D viewColumnFlip() {
        if (this.columns == 0) {
            return this;
        }
        WrapperFloatMatrix2D wrapperFloatMatrix2D = new WrapperFloatMatrix2D(this){

            public float getQuick(int n, int n2) {
                return this.content.getQuick(n, this.columns - 1 - n2);
            }

            public void setQuick(int n, int n2, float f) {
                this.content.setQuick(n, this.columns - 1 - n2, f);
            }

            public float get(int n, int n2) {
                return this.content.get(n, this.columns - 1 - n2);
            }

            public void set(int n, int n2, float f) {
                this.content.set(n, this.columns - 1 - n2, f);
            }
        };
        return wrapperFloatMatrix2D;
    }

    public FloatMatrix2D viewDice() {
        WrapperFloatMatrix2D wrapperFloatMatrix2D = new WrapperFloatMatrix2D(this){

            public float getQuick(int n, int n2) {
                return this.content.getQuick(n2, n);
            }

            public void setQuick(int n, int n2, float f) {
                this.content.setQuick(n2, n, f);
            }

            public float get(int n, int n2) {
                return this.content.get(n2, n);
            }

            public void set(int n, int n2, float f) {
                this.content.set(n2, n, f);
            }
        };
        wrapperFloatMatrix2D.setNrows(this.columns);
        wrapperFloatMatrix2D.setNcolumns(this.rows);
        return wrapperFloatMatrix2D;
    }

    public void setNcolumns(int n) {
        this.columns = n;
    }

    public void setNrows(int n) {
        this.rows = n;
    }

    public FloatMatrix2D viewPart(final int n, final int n2, int n3, int n4) {
        this.checkBox(n, n2, n3, n4);
        WrapperFloatMatrix2D wrapperFloatMatrix2D = new WrapperFloatMatrix2D(this){

            public float getQuick(int n3, int n22) {
                return this.content.getQuick(n + n3, n2 + n22);
            }

            public void setQuick(int n3, int n22, float f) {
                this.content.setQuick(n + n3, n2 + n22, f);
            }

            public float get(int n3, int n22) {
                return this.content.get(n + n3, n2 + n22);
            }

            public void set(int n3, int n22, float f) {
                this.content.set(n + n3, n2 + n22, f);
            }
        };
        wrapperFloatMatrix2D.setNrows(n3);
        wrapperFloatMatrix2D.setNcolumns(n4);
        return wrapperFloatMatrix2D;
    }

    public FloatMatrix1D viewRow(int n) {
        this.checkRow(n);
        return new DelegateFloatMatrix1D(this, n);
    }

    public FloatMatrix2D viewRowFlip() {
        if (this.rows == 0) {
            return this;
        }
        WrapperFloatMatrix2D wrapperFloatMatrix2D = new WrapperFloatMatrix2D(this){

            public float getQuick(int n, int n2) {
                return this.content.getQuick(this.rows - 1 - n, n2);
            }

            public void setQuick(int n, int n2, float f) {
                this.content.setQuick(this.rows - 1 - n, n2, f);
            }

            public float get(int n, int n2) {
                return this.content.get(this.rows - 1 - n, n2);
            }

            public void set(int n, int n2, float f) {
                this.content.set(this.rows - 1 - n, n2, f);
            }
        };
        return wrapperFloatMatrix2D;
    }

    public FloatMatrix2D viewSelection(int[] nArray, int[] nArray2) {
        int n;
        if (nArray == null) {
            nArray = new int[this.rows];
            n = this.rows;
            while (--n >= 0) {
                nArray[n] = n;
            }
        }
        if (nArray2 == null) {
            nArray2 = new int[this.columns];
            n = this.columns;
            while (--n >= 0) {
                nArray2[n] = n;
            }
        }
        this.checkRowIndexes(nArray);
        this.checkColumnIndexes(nArray2);
        final int[] nArray3 = nArray;
        final int[] nArray4 = nArray2;
        WrapperFloatMatrix2D wrapperFloatMatrix2D = new WrapperFloatMatrix2D(this){

            public float getQuick(int n, int n2) {
                return this.content.getQuick(nArray3[n], nArray4[n2]);
            }

            public void setQuick(int n, int n2, float f) {
                this.content.setQuick(nArray3[n], nArray4[n2], f);
            }

            public float get(int n, int n2) {
                return this.content.get(nArray3[n], nArray4[n2]);
            }

            public void set(int n, int n2, float f) {
                this.content.set(nArray3[n], nArray4[n2], f);
            }
        };
        wrapperFloatMatrix2D.setNrows(nArray.length);
        wrapperFloatMatrix2D.setNcolumns(nArray2.length);
        return wrapperFloatMatrix2D;
    }

    public FloatMatrix2D viewStrides(final int n, final int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new IndexOutOfBoundsException("illegal stride");
        }
        WrapperFloatMatrix2D wrapperFloatMatrix2D = new WrapperFloatMatrix2D(this){

            public float getQuick(int n3, int n22) {
                return this.content.getQuick(n * n3, n2 * n22);
            }

            public void setQuick(int n3, int n22, float f) {
                this.content.setQuick(n * n3, n2 * n22, f);
            }

            public float get(int n3, int n22) {
                return this.content.get(n * n3, n2 * n22);
            }

            public void set(int n3, int n22, float f) {
                this.content.set(n * n3, n2 * n22, f);
            }
        };
        wrapperFloatMatrix2D.setNrows(this.rows);
        wrapperFloatMatrix2D.setNcolumns(this.columns);
        if (this.rows != 0) {
            wrapperFloatMatrix2D.setNrows((this.rows - 1) / n + 1);
        }
        if (this.columns != 0) {
            wrapperFloatMatrix2D.setNcolumns((this.columns - 1) / n2 + 1);
        }
        return wrapperFloatMatrix2D;
    }

    protected FloatMatrix2D getContent() {
        return this.content;
    }

    protected FloatMatrix1D like1D(int n, int n2, int n3) {
        throw new InternalError();
    }

    protected FloatMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        throw new InternalError();
    }
}

