/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix2DTest;
import cern.colt.matrix.tfloat.impl.CCFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.CCMFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.RCFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.RCMFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix2D;
import cern.jet.math.tfloat.FloatFunctions;

public class SparseFloatMatrix2DTest
extends FloatMatrix2DTest {
    public SparseFloatMatrix2DTest(String string) {
        super(string);
    }

    protected void createMatrices() throws Exception {
        this.A = new SparseFloatMatrix2D(this.NROWS, this.NCOLUMNS);
        this.B = new SparseFloatMatrix2D(this.NROWS, this.NCOLUMNS);
        this.Bt = new SparseFloatMatrix2D(this.NCOLUMNS, this.NROWS);
    }

    public void testConvertToRCFloatMatrix2D() {
        int n = this.NROWS * this.NCOLUMNS;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = (int)(Math.random() * (double)this.NROWS);
            nArray2[i] = (int)(Math.random() * (double)this.NCOLUMNS);
            fArray[i] = (float)Math.random();
        }
        SparseFloatMatrix2D sparseFloatMatrix2D = new SparseFloatMatrix2D(this.NROWS, this.NCOLUMNS, nArray, nArray2, fArray);
        RCFloatMatrix2D rCFloatMatrix2D = sparseFloatMatrix2D.convertToRCFloatMatrix2D();
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                SparseFloatMatrix2DTest.assertEquals((Object)Float.valueOf(sparseFloatMatrix2D.getQuick(i, j)), (Object)Float.valueOf(rCFloatMatrix2D.getQuick(i, j)));
            }
        }
    }

    public void testConvertToRCMFloatMatrix2D() {
        int n = this.NROWS * this.NCOLUMNS;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = (int)((float)Math.random() * (float)this.NROWS);
            nArray2[i] = (int)((float)Math.random() * (float)this.NCOLUMNS);
            fArray[i] = (float)Math.random();
        }
        SparseFloatMatrix2D sparseFloatMatrix2D = new SparseFloatMatrix2D(this.NROWS, this.NCOLUMNS, nArray, nArray2, fArray);
        RCMFloatMatrix2D rCMFloatMatrix2D = sparseFloatMatrix2D.convertToRCMFloatMatrix2D();
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                SparseFloatMatrix2DTest.assertEquals((Object)Float.valueOf(sparseFloatMatrix2D.getQuick(i, j)), (Object)Float.valueOf(rCMFloatMatrix2D.getQuick(i, j)));
            }
        }
    }

    public void testConvertToCCFloatMatrix2D() {
        int n = this.NROWS * this.NCOLUMNS;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = (int)((float)Math.random() * (float)this.NROWS);
            nArray2[i] = (int)((float)Math.random() * (float)this.NCOLUMNS);
            fArray[i] = (float)Math.random();
        }
        SparseFloatMatrix2D sparseFloatMatrix2D = new SparseFloatMatrix2D(this.NROWS, this.NCOLUMNS, nArray, nArray2, fArray);
        CCFloatMatrix2D cCFloatMatrix2D = sparseFloatMatrix2D.convertToCCFloatMatrix2D();
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                SparseFloatMatrix2DTest.assertEquals((Object)Float.valueOf(sparseFloatMatrix2D.getQuick(i, j)), (Object)Float.valueOf(cCFloatMatrix2D.getQuick(i, j)));
            }
        }
    }

    public void testConvertToCCMFloatMatrix2D() {
        int n = this.NROWS * this.NCOLUMNS;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = (int)((float)Math.random() * (float)this.NROWS);
            nArray2[i] = (int)((float)Math.random() * (float)this.NCOLUMNS);
            fArray[i] = (float)Math.random();
        }
        SparseFloatMatrix2D sparseFloatMatrix2D = new SparseFloatMatrix2D(this.NROWS, this.NCOLUMNS, nArray, nArray2, fArray);
        CCMFloatMatrix2D cCMFloatMatrix2D = sparseFloatMatrix2D.convertToCCMFloatMatrix2D();
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                SparseFloatMatrix2DTest.assertEquals((Object)Float.valueOf(sparseFloatMatrix2D.getQuick(i, j)), (Object)Float.valueOf(cCMFloatMatrix2D.getQuick(i, j)));
            }
        }
    }

    public void testAssignIntArrayIntArrayFloatArrayFloatFloatFunction() {
        int n = this.NROWS * this.NCOLUMNS;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        float[] fArray = new float[n];
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(this.NROWS, this.NCOLUMNS);
        for (int i = 0; i < n; ++i) {
            nArray[i] = i % this.NROWS;
            nArray2[i] = i % this.NCOLUMNS;
            fArray[i] = (float)Math.random();
            ((FloatMatrix2D)denseFloatMatrix2D).setQuick(nArray[i], nArray2[i], fArray[i]);
        }
        SparseFloatMatrix2D sparseFloatMatrix2D = new SparseFloatMatrix2D(this.NROWS, this.NCOLUMNS, nArray, nArray2, fArray);
        sparseFloatMatrix2D.assign(nArray, nArray2, fArray, FloatFunctions.plus);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                SparseFloatMatrix2DTest.assertEquals((Object)Float.valueOf(2.0f * ((FloatMatrix2D)denseFloatMatrix2D).getQuick(i, j)), (Object)Float.valueOf(sparseFloatMatrix2D.getQuick(i, j)));
            }
        }
    }
}

