/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.map.tfloat.AbstractLongFloatMap;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SelectedSparseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix2D;

class SelectedSparseFloatMatrix2D
extends FloatMatrix2D {
    protected AbstractLongFloatMap elements;
    protected int[] rowOffsets;
    protected int[] columnOffsets;
    protected int offset;

    protected SelectedSparseFloatMatrix2D(AbstractLongFloatMap abstractLongFloatMap, int[] nArray, int[] nArray2, int n) {
        this(nArray.length, nArray2.length, abstractLongFloatMap, 0, 0, 1, 1, nArray, nArray2, n);
    }

    protected SelectedSparseFloatMatrix2D(int n, int n2, AbstractLongFloatMap abstractLongFloatMap, int n3, int n4, int n5, int n6, int[] nArray, int[] nArray2, int n7) {
        this.setUp(n, n2, n3, n4, n5, n6);
        this.elements = abstractLongFloatMap;
        this.rowOffsets = nArray;
        this.columnOffsets = nArray2;
        this.offset = n7;
        this.isNoView = false;
    }

    public AbstractLongFloatMap elements() {
        return this.elements;
    }

    public float getQuick(int n, int n2) {
        return this.elements.get(this.offset + this.rowOffsets[this.rowZero + n * this.rowStride] + this.columnOffsets[this.columnZero + n2 * this.columnStride]);
    }

    public long index(int n, int n2) {
        return this.offset + this.rowOffsets[this.rowZero + n * this.rowStride] + this.columnOffsets[this.columnZero + n2 * this.columnStride];
    }

    public FloatMatrix2D like(int n, int n2) {
        return new SparseFloatMatrix2D(n, n2);
    }

    public FloatMatrix1D like1D(int n) {
        return new SparseFloatMatrix1D(n);
    }

    public void setQuick(int n, int n2, float f) {
        int n3 = this.offset + this.rowOffsets[this.rowZero + n * this.rowStride] + this.columnOffsets[this.columnZero + n2 * this.columnStride];
        if (f == 0.0f) {
            this.elements.removeKey(n3);
        } else {
            this.elements.put(n3, f);
        }
    }

    public FloatMatrix1D vectorize() {
        SparseFloatMatrix1D sparseFloatMatrix1D = new SparseFloatMatrix1D(this.size());
        int n = 0;
        for (int i = 0; i < this.columns; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                sparseFloatMatrix1D.setQuick(n++, this.getQuick(i, j));
            }
        }
        return sparseFloatMatrix1D;
    }

    public FloatMatrix1D viewColumn(int n) {
        this.checkColumn(n);
        int n2 = this.rows;
        int n3 = this.rowZero;
        int n4 = this.rowStride;
        int[] nArray = this.rowOffsets;
        int n5 = this.offset + this._columnOffset(this._columnRank(n));
        return new SelectedSparseFloatMatrix1D(n2, this.elements, n3, n4, nArray, n5);
    }

    public FloatMatrix1D viewRow(int n) {
        this.checkRow(n);
        int n2 = this.columns;
        int n3 = this.columnZero;
        int n4 = this.columnStride;
        int[] nArray = this.columnOffsets;
        int n5 = this.offset + this._rowOffset(this._rowRank(n));
        return new SelectedSparseFloatMatrix1D(n2, this.elements, n3, n4, nArray, n5);
    }

    protected int _columnOffset(int n) {
        return this.columnOffsets[n];
    }

    protected int _rowOffset(int n) {
        return this.rowOffsets[n];
    }

    protected boolean haveSharedCellsRaw(FloatMatrix2D floatMatrix2D) {
        if (floatMatrix2D instanceof SelectedSparseFloatMatrix2D) {
            SelectedSparseFloatMatrix2D selectedSparseFloatMatrix2D = (SelectedSparseFloatMatrix2D)floatMatrix2D;
            return this.elements == selectedSparseFloatMatrix2D.elements;
        }
        if (floatMatrix2D instanceof SparseFloatMatrix2D) {
            SparseFloatMatrix2D sparseFloatMatrix2D = (SparseFloatMatrix2D)floatMatrix2D;
            return this.elements == sparseFloatMatrix2D.elements;
        }
        return false;
    }

    protected FloatMatrix1D like1D(int n, int n2, int n3) {
        throw new InternalError();
    }

    protected void setUp(int n, int n2) {
        super.setUp(n, n2);
        this.rowStride = 1;
        this.columnStride = 1;
        this.offset = 0;
    }

    protected AbstractMatrix2D vDice() {
        super.vDice();
        int[] nArray = this.rowOffsets;
        this.rowOffsets = this.columnOffsets;
        this.columnOffsets = nArray;
        this.isNoView = false;
        return this;
    }

    protected FloatMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        return new SelectedSparseFloatMatrix2D(this.elements, nArray, nArray2, this.offset);
    }
}

