/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix3D;
import cern.colt.matrix.tfloat.impl.SelectedDenseFloatMatrix2D;

class SelectedDenseFloatMatrix3D
extends FloatMatrix3D {
    protected float[] elements;
    protected int[] sliceOffsets;
    protected int[] rowOffsets;
    protected int[] columnOffsets;
    protected int offset;

    protected SelectedDenseFloatMatrix3D(float[] fArray, int[] nArray, int[] nArray2, int[] nArray3, int n) {
        int n2 = nArray.length;
        int n3 = nArray2.length;
        int n4 = nArray3.length;
        this.setUp(n2, n3, n4);
        this.elements = fArray;
        this.sliceOffsets = nArray;
        this.rowOffsets = nArray2;
        this.columnOffsets = nArray3;
        this.offset = n;
        this.isNoView = false;
    }

    public float[] elements() {
        return this.elements;
    }

    public float getQuick(int n, int n2, int n3) {
        return this.elements[this.offset + this.sliceOffsets[this.sliceZero + n * this.sliceStride] + this.rowOffsets[this.rowZero + n2 * this.rowStride] + this.columnOffsets[this.columnZero + n3 * this.columnStride]];
    }

    public long index(int n, int n2, int n3) {
        return this.offset + this.sliceOffsets[this.sliceZero + n * this.sliceStride] + this.rowOffsets[this.rowZero + n2 * this.rowStride] + this.columnOffsets[this.columnZero + n3 * this.columnStride];
    }

    public FloatMatrix3D like(int n, int n2, int n3) {
        return new DenseFloatMatrix3D(n, n2, n3);
    }

    public void setQuick(int n, int n2, int n3, float f) {
        this.elements[this.offset + this.sliceOffsets[this.sliceZero + n * this.sliceStride] + this.rowOffsets[this.rowZero + n2 * this.rowStride] + this.columnOffsets[this.columnZero + n3 * this.columnStride]] = f;
    }

    public FloatMatrix1D vectorize() {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public FloatMatrix2D viewColumn(int n) {
        this.checkColumn(n);
        int n2 = this.slices;
        int n3 = this.rows;
        int n4 = this.sliceZero;
        int n5 = this.rowZero;
        int n6 = this.offset + this._columnOffset(this._columnRank(n));
        int n7 = this.sliceStride;
        int n8 = this.rowStride;
        int[] nArray = this.sliceOffsets;
        int[] nArray2 = this.rowOffsets;
        return new SelectedDenseFloatMatrix2D(n2, n3, this.elements, n4, n5, n7, n8, nArray, nArray2, n6);
    }

    public FloatMatrix2D viewRow(int n) {
        this.checkRow(n);
        int n2 = this.slices;
        int n3 = this.columns;
        int n4 = this.sliceZero;
        int n5 = this.columnZero;
        int n6 = this.offset + this._rowOffset(this._rowRank(n));
        int n7 = this.sliceStride;
        int n8 = this.columnStride;
        int[] nArray = this.sliceOffsets;
        int[] nArray2 = this.columnOffsets;
        return new SelectedDenseFloatMatrix2D(n2, n3, this.elements, n4, n5, n7, n8, nArray, nArray2, n6);
    }

    public FloatMatrix2D viewSlice(int n) {
        this.checkSlice(n);
        int n2 = this.rows;
        int n3 = this.columns;
        int n4 = this.rowZero;
        int n5 = this.columnZero;
        int n6 = this.offset + this._sliceOffset(this._sliceRank(n));
        int n7 = this.rowStride;
        int n8 = this.columnStride;
        int[] nArray = this.rowOffsets;
        int[] nArray2 = this.columnOffsets;
        return new SelectedDenseFloatMatrix2D(n2, n3, this.elements, n4, n5, n7, n8, nArray, nArray2, n6);
    }

    protected int _columnOffset(int n) {
        return this.columnOffsets[n];
    }

    protected int _rowOffset(int n) {
        return this.rowOffsets[n];
    }

    protected int _sliceOffset(int n) {
        return this.sliceOffsets[n];
    }

    protected boolean haveSharedCellsRaw(FloatMatrix3D floatMatrix3D) {
        if (floatMatrix3D instanceof SelectedDenseFloatMatrix3D) {
            SelectedDenseFloatMatrix3D selectedDenseFloatMatrix3D = (SelectedDenseFloatMatrix3D)floatMatrix3D;
            return this.elements == selectedDenseFloatMatrix3D.elements;
        }
        if (floatMatrix3D instanceof DenseFloatMatrix3D) {
            DenseFloatMatrix3D denseFloatMatrix3D = (DenseFloatMatrix3D)floatMatrix3D;
            return this.elements == denseFloatMatrix3D.elements;
        }
        return false;
    }

    protected FloatMatrix2D like2D(int n, int n2, int n3, int n4, int n5, int n6) {
        throw new InternalError();
    }

    protected void setUp(int n, int n2, int n3) {
        super.setUp(n, n2, n3);
        this.sliceStride = 1;
        this.rowStride = 1;
        this.columnStride = 1;
        this.offset = 0;
    }

    protected AbstractMatrix3D vDice(int n, int n2, int n3) {
        super.vDice(n, n2, n3);
        int[][] nArrayArray = new int[][]{this.sliceOffsets, this.rowOffsets, this.columnOffsets};
        this.sliceOffsets = nArrayArray[n];
        this.rowOffsets = nArrayArray[n2];
        this.columnOffsets = nArrayArray[n3];
        return this;
    }

    protected FloatMatrix3D viewSelectionLike(int[] nArray, int[] nArray2, int[] nArray3) {
        return new SelectedDenseFloatMatrix3D(this.elements, nArray, nArray2, nArray3, this.offset);
    }
}

