/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseColFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.SelectedDenseFloatMatrix1D;

class SelectedDenseColFloatMatrix2D
extends FloatMatrix2D {
    protected float[] elements;
    protected int[] rowOffsets;
    protected int[] columnOffsets;
    protected int offset;

    protected SelectedDenseColFloatMatrix2D(float[] fArray, int[] nArray, int[] nArray2, int n) {
        this(nArray.length, nArray2.length, fArray, 0, 0, 1, 1, nArray, nArray2, n);
    }

    protected SelectedDenseColFloatMatrix2D(int n, int n2, float[] fArray, int n3, int n4, int n5, int n6, int[] nArray, int[] nArray2, int n7) {
        this.setUp(n, n2, n3, n4, n5, n6);
        this.elements = fArray;
        this.rowOffsets = nArray;
        this.columnOffsets = nArray2;
        this.offset = n7;
        this.isNoView = false;
    }

    public float[] elements() {
        return this.elements;
    }

    public float getQuick(int n, int n2) {
        return this.elements[this.offset + this.rowOffsets[this.rowZero + n * this.rowStride] + this.columnOffsets[this.columnZero + n2 * this.columnStride]];
    }

    public long index(int n, int n2) {
        return this.offset + this.rowOffsets[this.rowZero + n * this.rowStride] + this.columnOffsets[this.columnZero + n2 * this.columnStride];
    }

    public FloatMatrix2D like(int n, int n2) {
        return new DenseColFloatMatrix2D(n, n2);
    }

    public FloatMatrix1D like1D(int n) {
        return new DenseFloatMatrix1D(n);
    }

    public void setQuick(int n, int n2, float f) {
        this.elements[this.offset + this.rowOffsets[this.rowZero + n * this.rowStride] + this.columnOffsets[this.columnZero + n2 * this.columnStride]] = f;
    }

    public FloatMatrix1D vectorize() {
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(this.size());
        int n = 0;
        for (int i = 0; i < this.columns; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                denseFloatMatrix1D.setQuick(n++, this.getQuick(i, j));
            }
        }
        return denseFloatMatrix1D;
    }

    public FloatMatrix1D viewColumn(int n) {
        this.checkColumn(n);
        int n2 = this.rows;
        int n3 = this.rowZero;
        int n4 = this.rowStride;
        int[] nArray = this.rowOffsets;
        int n5 = this.offset + this._columnOffset(this._columnRank(n));
        return new SelectedDenseFloatMatrix1D(n2, this.elements, n3, n4, nArray, n5);
    }

    public FloatMatrix1D viewRow(int n) {
        this.checkRow(n);
        int n2 = this.columns;
        int n3 = this.columnZero;
        int n4 = this.columnStride;
        int[] nArray = this.columnOffsets;
        int n5 = this.offset + this._rowOffset(this._rowRank(n));
        return new SelectedDenseFloatMatrix1D(n2, this.elements, n3, n4, nArray, n5);
    }

    protected int _columnOffset(int n) {
        return this.columnOffsets[n];
    }

    protected int _rowOffset(int n) {
        return this.rowOffsets[n];
    }

    protected boolean haveSharedCellsRaw(FloatMatrix2D floatMatrix2D) {
        if (floatMatrix2D instanceof SelectedDenseColFloatMatrix2D) {
            SelectedDenseColFloatMatrix2D selectedDenseColFloatMatrix2D = (SelectedDenseColFloatMatrix2D)floatMatrix2D;
            return this.elements == selectedDenseColFloatMatrix2D.elements;
        }
        if (floatMatrix2D instanceof DenseColFloatMatrix2D) {
            DenseColFloatMatrix2D denseColFloatMatrix2D = (DenseColFloatMatrix2D)floatMatrix2D;
            return this.elements == denseColFloatMatrix2D.elements;
        }
        return false;
    }

    protected FloatMatrix1D like1D(int n, int n2, int n3) {
        throw new InternalError();
    }

    protected void setUp(int n, int n2) {
        super.setUp(n, n2);
        this.rowStride = 1;
        this.columnStride = 1;
        this.offset = 0;
    }

    protected AbstractMatrix2D vDice() {
        super.vDice();
        int[] nArray = this.rowOffsets;
        this.rowOffsets = this.columnOffsets;
        this.columnOffsets = nArray;
        this.isNoView = false;
        return this;
    }

    protected FloatMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        return new SelectedDenseColFloatMatrix2D(this.elements, nArray, nArray2, this.offset);
    }
}

