/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix1DProcedure;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix2DTest;
import cern.colt.matrix.tfloat.impl.DiagonalFloatMatrix2D;
import cern.jet.math.tfloat.FloatFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;

public class DiagonalFloatMatrix2DTest
extends FloatMatrix2DTest {
    protected int DLENGTH;
    protected int DINDEX;

    public DiagonalFloatMatrix2DTest(String string) {
        super(string);
    }

    protected void createMatrices() throws Exception {
        this.DINDEX = 3;
        this.A = new DiagonalFloatMatrix2D(this.NROWS, this.NCOLUMNS, this.DINDEX);
        this.B = new DiagonalFloatMatrix2D(this.NROWS, this.NCOLUMNS, this.DINDEX);
        this.Bt = new DiagonalFloatMatrix2D(this.NCOLUMNS, this.NROWS, -this.DINDEX);
        this.DLENGTH = ((DiagonalFloatMatrix2D)this.A).dlength();
    }

    protected void populateMatrices() {
        ConcurrencyUtils.setThreadsBeginN_2D(1);
        if (this.DINDEX >= 0) {
            int n;
            for (n = 0; n < this.DLENGTH; ++n) {
                this.A.setQuick(n, n + this.DINDEX, (float)Math.random());
            }
            for (n = 0; n < this.DLENGTH; ++n) {
                this.B.setQuick(n, n + this.DINDEX, (float)Math.random());
            }
            for (n = 0; n < this.DLENGTH; ++n) {
                this.Bt.setQuick(n - this.DINDEX, n, (float)Math.random());
            }
        } else {
            int n;
            for (n = 0; n < this.DLENGTH; ++n) {
                this.A.setQuick(n - this.DINDEX, n, (float)Math.random());
            }
            for (n = 0; n < this.DLENGTH; ++n) {
                this.B.setQuick(n - this.DINDEX, n, (float)Math.random());
            }
            for (n = 0; n < this.DLENGTH; ++n) {
                this.Bt.setQuick(n, n + this.DINDEX, (float)Math.random());
            }
        }
    }

    public void testAssignFloat() {
        float f = (float)Math.random();
        this.A.assign(f);
        if (this.DINDEX >= 0) {
            for (int i = 0; i < this.DLENGTH; ++i) {
                DiagonalFloatMatrix2DTest.assertEquals((float)f, (float)this.A.getQuick(i, i + this.DINDEX), (float)this.TOL);
            }
        } else {
            for (int i = 0; i < this.DLENGTH; ++i) {
                DiagonalFloatMatrix2DTest.assertEquals((float)f, (float)this.A.getQuick(i - this.DINDEX, i), (float)this.TOL);
            }
        }
    }

    public void testAssignFloatArrayArray() {
        int n;
        float[][] fArray = new float[this.NROWS][this.NCOLUMNS];
        for (n = 0; n < this.NROWS; ++n) {
            for (int i = 0; i < this.NCOLUMNS; ++i) {
                fArray[n][i] = (float)Math.random();
            }
        }
        this.A.assign(fArray);
        if (this.DINDEX >= 0) {
            for (n = 0; n < this.DLENGTH; ++n) {
                DiagonalFloatMatrix2DTest.assertEquals((float)fArray[n][n + this.DINDEX], (float)this.A.getQuick(n, n + this.DINDEX), (float)this.TOL);
            }
        } else {
            for (n = 0; n < this.DLENGTH; ++n) {
                DiagonalFloatMatrix2DTest.assertEquals((float)fArray[n - this.DINDEX][n], (float)this.A.getQuick(n - this.DINDEX, n), (float)this.TOL);
            }
        }
    }

    public void testAssignFloatFunction() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        this.A.assign(FloatFunctions.acos);
        if (this.DINDEX >= 0) {
            for (int i = 0; i < this.DLENGTH; ++i) {
                float f = (float)Math.acos(floatMatrix2D.getQuick(i, i + this.DINDEX));
                DiagonalFloatMatrix2DTest.assertEquals((float)f, (float)this.A.getQuick(i, i + this.DINDEX), (float)this.TOL);
            }
        } else {
            for (int i = 0; i < this.DLENGTH; ++i) {
                float f = (float)Math.acos(floatMatrix2D.getQuick(i - this.DINDEX, i));
                DiagonalFloatMatrix2DTest.assertEquals((float)f, (float)this.A.getQuick(i - this.DINDEX, i), (float)this.TOL);
            }
        }
    }

    public void testAssignFloatMatrix2DFloatFloatFunction() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        this.A.assign(this.B, FloatFunctions.div);
        if (this.DINDEX >= 0) {
            for (int i = 0; i < this.DLENGTH; ++i) {
                DiagonalFloatMatrix2DTest.assertEquals((float)(floatMatrix2D.getQuick(i, i + this.DINDEX) / this.B.getQuick(i, i + this.DINDEX)), (float)this.A.getQuick(i, i + this.DINDEX), (float)this.TOL);
            }
        } else {
            for (int i = 0; i < this.DLENGTH; ++i) {
                DiagonalFloatMatrix2DTest.assertEquals((float)(floatMatrix2D.getQuick(i - this.DINDEX, i) / this.B.getQuick(i - this.DINDEX, i)), (float)this.A.getQuick(i - this.DINDEX, i), (float)this.TOL);
            }
        }
    }

    public void testAssignFloatMatrix2DFloatFloatFunctionIntArrayListIntArrayList() {
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        if (this.DINDEX >= 0) {
            for (int i = 0; i < this.DLENGTH; ++i) {
                intArrayList.add(i);
                intArrayList2.add(i + this.DINDEX);
            }
            FloatMatrix2D floatMatrix2D = this.A.copy();
            this.A.assign(this.B, FloatFunctions.div, intArrayList, intArrayList2);
            for (int i = 0; i < this.DLENGTH; ++i) {
                DiagonalFloatMatrix2DTest.assertEquals((float)(floatMatrix2D.getQuick(i, i + this.DINDEX) / this.B.getQuick(i, i + this.DINDEX)), (float)this.A.getQuick(i, i + this.DINDEX), (float)this.TOL);
            }
        } else {
            for (int i = 0; i < this.DLENGTH; ++i) {
                intArrayList.add(i - this.DINDEX);
                intArrayList2.add(i);
            }
            FloatMatrix2D floatMatrix2D = this.A.copy();
            this.A.assign(this.B, FloatFunctions.div, intArrayList, intArrayList2);
            for (int i = 0; i < this.DLENGTH; ++i) {
                DiagonalFloatMatrix2DTest.assertEquals((float)(floatMatrix2D.getQuick(i - this.DINDEX, i) / this.B.getQuick(i - this.DINDEX, i)), (float)this.A.getQuick(i - this.DINDEX, i), (float)this.TOL);
            }
        }
    }

    public void testCardinality() {
        int n = this.A.cardinality();
        DiagonalFloatMatrix2DTest.assertEquals((int)this.DLENGTH, (int)n);
    }

    public void testMaxLocation() {
        this.A.assign(0.0f);
        if (this.DINDEX >= 0) {
            this.A.setQuick(this.NROWS / 3, this.NROWS / 3 + this.DINDEX, 0.7f);
            this.A.setQuick(this.NROWS / 2, this.NROWS / 2 + this.DINDEX, 0.1f);
            float[] fArray = this.A.getMaxLocation();
            DiagonalFloatMatrix2DTest.assertEquals((float)0.7f, (float)fArray[0], (float)this.TOL);
            DiagonalFloatMatrix2DTest.assertEquals((int)(this.NROWS / 3), (int)((int)fArray[1]));
            DiagonalFloatMatrix2DTest.assertEquals((int)(this.NROWS / 3 + this.DINDEX), (int)((int)fArray[2]));
        } else {
            this.A.setQuick(this.NROWS / 3 - this.DINDEX, this.NROWS / 3, 0.7f);
            this.A.setQuick(this.NROWS / 2 - this.DINDEX, this.NROWS / 2, 0.1f);
            float[] fArray = this.A.getMaxLocation();
            DiagonalFloatMatrix2DTest.assertEquals((float)0.7f, (float)fArray[0], (float)this.TOL);
            DiagonalFloatMatrix2DTest.assertEquals((int)(this.NROWS / 3 - this.DINDEX), (int)((int)fArray[1]));
            DiagonalFloatMatrix2DTest.assertEquals((int)(this.NROWS / 3), (int)((int)fArray[2]));
        }
    }

    public void testMinLocation() {
        this.A.assign(0.0f);
        if (this.DINDEX >= 0) {
            this.A.setQuick(this.NROWS / 3, this.NROWS / 3 + this.DINDEX, -0.7f);
            this.A.setQuick(this.NROWS / 2, this.NROWS / 2 + this.DINDEX, -0.1f);
            float[] fArray = this.A.getMinLocation();
            DiagonalFloatMatrix2DTest.assertEquals((float)-0.7f, (float)fArray[0], (float)this.TOL);
            DiagonalFloatMatrix2DTest.assertEquals((int)(this.NROWS / 3), (int)((int)fArray[1]));
            DiagonalFloatMatrix2DTest.assertEquals((int)(this.NROWS / 3 + this.DINDEX), (int)((int)fArray[2]));
        } else {
            this.A.setQuick(this.NROWS / 3 - this.DINDEX, this.NROWS / 3, -0.7f);
            this.A.setQuick(this.NROWS / 2 - this.DINDEX, this.NROWS / 2, -0.1f);
            float[] fArray = this.A.getMinLocation();
            DiagonalFloatMatrix2DTest.assertEquals((float)-0.7f, (float)fArray[0], (float)this.TOL);
            DiagonalFloatMatrix2DTest.assertEquals((int)(this.NROWS / 3 - this.DINDEX), (int)((int)fArray[1]));
            DiagonalFloatMatrix2DTest.assertEquals((int)(this.NROWS / 3), (int)((int)fArray[2]));
        }
    }

    public void testGetNegativeValues() {
        this.A.assign(0.0f);
        if (this.DINDEX >= 0) {
            this.A.setQuick(this.NROWS / 3, this.NROWS / 3 + this.DINDEX, -0.7f);
            this.A.setQuick(this.NROWS / 2, this.NROWS / 2 + this.DINDEX, -0.1f);
            IntArrayList intArrayList = new IntArrayList();
            IntArrayList intArrayList2 = new IntArrayList();
            FloatArrayList floatArrayList = new FloatArrayList();
            this.A.getNegativeValues(intArrayList, intArrayList2, floatArrayList);
            DiagonalFloatMatrix2DTest.assertEquals((int)2, (int)intArrayList.size());
            DiagonalFloatMatrix2DTest.assertEquals((int)2, (int)intArrayList2.size());
            DiagonalFloatMatrix2DTest.assertEquals((int)2, (int)floatArrayList.size());
            DiagonalFloatMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 3));
            DiagonalFloatMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 2));
            DiagonalFloatMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.NROWS / 3 + this.DINDEX));
            DiagonalFloatMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.NROWS / 2 + this.DINDEX));
            DiagonalFloatMatrix2DTest.assertTrue((boolean)floatArrayList.contains(-0.7f));
            DiagonalFloatMatrix2DTest.assertTrue((boolean)floatArrayList.contains(-0.1f));
        } else {
            this.A.setQuick(this.NROWS / 3 - this.DINDEX, this.NROWS / 3, -0.7f);
            this.A.setQuick(this.NROWS / 2 - this.DINDEX, this.NROWS / 2, -0.1f);
            IntArrayList intArrayList = new IntArrayList();
            IntArrayList intArrayList3 = new IntArrayList();
            FloatArrayList floatArrayList = new FloatArrayList();
            this.A.getNegativeValues(intArrayList, intArrayList3, floatArrayList);
            DiagonalFloatMatrix2DTest.assertEquals((int)2, (int)intArrayList.size());
            DiagonalFloatMatrix2DTest.assertEquals((int)2, (int)intArrayList3.size());
            DiagonalFloatMatrix2DTest.assertEquals((int)2, (int)floatArrayList.size());
            DiagonalFloatMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 3 - this.DINDEX));
            DiagonalFloatMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 2 - this.DINDEX));
            DiagonalFloatMatrix2DTest.assertTrue((boolean)intArrayList3.contains(this.NROWS / 3));
            DiagonalFloatMatrix2DTest.assertTrue((boolean)intArrayList3.contains(this.NROWS / 2));
            DiagonalFloatMatrix2DTest.assertTrue((boolean)floatArrayList.contains(-0.7f));
            DiagonalFloatMatrix2DTest.assertTrue((boolean)floatArrayList.contains(-0.1f));
        }
    }

    public void testGetNonZeros() {
        this.A.assign(0.0f);
        if (this.DINDEX >= 0) {
            this.A.setQuick(this.NROWS / 3, this.NROWS / 3 + this.DINDEX, 0.7f);
            this.A.setQuick(this.NROWS / 2, this.NROWS / 2 + this.DINDEX, 0.1f);
            IntArrayList intArrayList = new IntArrayList();
            IntArrayList intArrayList2 = new IntArrayList();
            FloatArrayList floatArrayList = new FloatArrayList();
            this.A.getNonZeros(intArrayList, intArrayList2, floatArrayList);
            DiagonalFloatMatrix2DTest.assertEquals((int)2, (int)intArrayList.size());
            DiagonalFloatMatrix2DTest.assertEquals((int)2, (int)intArrayList2.size());
            DiagonalFloatMatrix2DTest.assertEquals((int)2, (int)floatArrayList.size());
            DiagonalFloatMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 3));
            DiagonalFloatMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 2));
            DiagonalFloatMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.NROWS / 3 + this.DINDEX));
            DiagonalFloatMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.NROWS / 2 + this.DINDEX));
            DiagonalFloatMatrix2DTest.assertTrue((boolean)floatArrayList.contains(0.7f));
            DiagonalFloatMatrix2DTest.assertTrue((boolean)floatArrayList.contains(0.1f));
        } else {
            this.A.setQuick(this.NROWS / 3 - this.DINDEX, this.NROWS / 3, 0.7f);
            this.A.setQuick(this.NROWS / 2 - this.DINDEX, this.NROWS / 2, 0.1f);
            IntArrayList intArrayList = new IntArrayList();
            IntArrayList intArrayList3 = new IntArrayList();
            FloatArrayList floatArrayList = new FloatArrayList();
            this.A.getNonZeros(intArrayList, intArrayList3, floatArrayList);
            DiagonalFloatMatrix2DTest.assertEquals((int)2, (int)intArrayList.size());
            DiagonalFloatMatrix2DTest.assertEquals((int)2, (int)intArrayList3.size());
            DiagonalFloatMatrix2DTest.assertEquals((int)2, (int)floatArrayList.size());
            DiagonalFloatMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 3 - this.DINDEX));
            DiagonalFloatMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 2 - this.DINDEX));
            DiagonalFloatMatrix2DTest.assertTrue((boolean)intArrayList3.contains(this.NROWS / 3));
            DiagonalFloatMatrix2DTest.assertTrue((boolean)intArrayList3.contains(this.NROWS / 2));
            DiagonalFloatMatrix2DTest.assertTrue((boolean)floatArrayList.contains(0.7f));
            DiagonalFloatMatrix2DTest.assertTrue((boolean)floatArrayList.contains(0.1f));
        }
    }

    public void testGetPositiveValues() {
        this.A.assign(0.0f);
        if (this.DINDEX >= 0) {
            this.A.setQuick(this.NROWS / 3, this.NROWS / 3 + this.DINDEX, 0.7f);
            this.A.setQuick(this.NROWS / 2, this.NROWS / 2 + this.DINDEX, 0.1f);
            IntArrayList intArrayList = new IntArrayList();
            IntArrayList intArrayList2 = new IntArrayList();
            FloatArrayList floatArrayList = new FloatArrayList();
            this.A.getPositiveValues(intArrayList, intArrayList2, floatArrayList);
            DiagonalFloatMatrix2DTest.assertEquals((int)2, (int)intArrayList.size());
            DiagonalFloatMatrix2DTest.assertEquals((int)2, (int)intArrayList2.size());
            DiagonalFloatMatrix2DTest.assertEquals((int)2, (int)floatArrayList.size());
            DiagonalFloatMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 3));
            DiagonalFloatMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 2));
            DiagonalFloatMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.NROWS / 3 + this.DINDEX));
            DiagonalFloatMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.NROWS / 2 + this.DINDEX));
            DiagonalFloatMatrix2DTest.assertTrue((boolean)floatArrayList.contains(0.7f));
            DiagonalFloatMatrix2DTest.assertTrue((boolean)floatArrayList.contains(0.1f));
        } else {
            this.A.setQuick(this.NROWS / 3 - this.DINDEX, this.NROWS / 3, 0.7f);
            this.A.setQuick(this.NROWS / 2 - this.DINDEX, this.NROWS / 2, 0.1f);
            IntArrayList intArrayList = new IntArrayList();
            IntArrayList intArrayList3 = new IntArrayList();
            FloatArrayList floatArrayList = new FloatArrayList();
            this.A.getPositiveValues(intArrayList, intArrayList3, floatArrayList);
            DiagonalFloatMatrix2DTest.assertEquals((int)2, (int)intArrayList.size());
            DiagonalFloatMatrix2DTest.assertEquals((int)2, (int)intArrayList3.size());
            DiagonalFloatMatrix2DTest.assertEquals((int)2, (int)floatArrayList.size());
            DiagonalFloatMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 3 - this.DINDEX));
            DiagonalFloatMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 2 - this.DINDEX));
            DiagonalFloatMatrix2DTest.assertTrue((boolean)intArrayList3.contains(this.NROWS / 3));
            DiagonalFloatMatrix2DTest.assertTrue((boolean)intArrayList3.contains(this.NROWS / 2));
            DiagonalFloatMatrix2DTest.assertTrue((boolean)floatArrayList.contains(0.7f));
            DiagonalFloatMatrix2DTest.assertTrue((boolean)floatArrayList.contains(0.1f));
        }
    }

    public void testToArray() {
        float[][] fArray = this.A.toArray();
        DiagonalFloatMatrix2DTest.assertTrue((this.NROWS == fArray.length ? 1 : 0) != 0);
        for (int i = 0; i < this.NROWS; ++i) {
            DiagonalFloatMatrix2DTest.assertTrue((this.NCOLUMNS == fArray[i].length ? 1 : 0) != 0);
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                DiagonalFloatMatrix2DTest.assertEquals((float)fArray[i][j], (float)this.A.getQuick(i, j), (float)this.TOL);
            }
        }
    }

    public void testVectorize() {
        FloatMatrix1D floatMatrix1D = this.A.vectorize();
        int n = 0;
        for (int i = 0; i < this.NCOLUMNS; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                DiagonalFloatMatrix2DTest.assertEquals((float)this.A.getQuick(j, i), (float)floatMatrix1D.getQuick(n++), (float)this.TOL);
            }
        }
    }

    public void testViewColumn() {
        FloatMatrix1D floatMatrix1D = this.A.viewColumn(this.NCOLUMNS / 2);
        DiagonalFloatMatrix2DTest.assertEquals((int)this.NROWS, (int)floatMatrix1D.size());
        for (int i = 0; i < this.NROWS; ++i) {
            DiagonalFloatMatrix2DTest.assertEquals((float)this.A.getQuick(i, this.NCOLUMNS / 2), (float)floatMatrix1D.getQuick(i), (float)this.TOL);
        }
    }

    public void testViewColumnFlip() {
        FloatMatrix2D floatMatrix2D = this.A.viewColumnFlip();
        DiagonalFloatMatrix2DTest.assertEquals((int)this.A.size(), (int)floatMatrix2D.size());
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                DiagonalFloatMatrix2DTest.assertEquals((float)this.A.getQuick(i, this.NCOLUMNS - 1 - j), (float)floatMatrix2D.getQuick(i, j), (float)this.TOL);
            }
        }
    }

    public void testViewDice() {
        FloatMatrix2D floatMatrix2D = this.A.viewDice();
        DiagonalFloatMatrix2DTest.assertEquals((int)this.NROWS, (int)floatMatrix2D.columns());
        DiagonalFloatMatrix2DTest.assertEquals((int)this.NCOLUMNS, (int)floatMatrix2D.rows());
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                DiagonalFloatMatrix2DTest.assertEquals((float)this.A.getQuick(i, j), (float)floatMatrix2D.getQuick(j, i), (float)this.TOL);
            }
        }
    }

    public void testViewPart() {
        FloatMatrix2D floatMatrix2D = this.A.viewPart(this.NROWS / 2, this.NCOLUMNS / 2, this.NROWS / 3, this.NCOLUMNS / 3);
        DiagonalFloatMatrix2DTest.assertEquals((int)(this.NROWS / 3), (int)floatMatrix2D.rows());
        DiagonalFloatMatrix2DTest.assertEquals((int)(this.NCOLUMNS / 3), (int)floatMatrix2D.columns());
        for (int i = 0; i < this.NROWS / 3; ++i) {
            for (int j = 0; j < this.NCOLUMNS / 3; ++j) {
                DiagonalFloatMatrix2DTest.assertEquals((float)this.A.getQuick(this.NROWS / 2 + i, this.NCOLUMNS / 2 + j), (float)floatMatrix2D.getQuick(i, j), (float)this.TOL);
            }
        }
    }

    public void testViewRow() {
        FloatMatrix1D floatMatrix1D = this.A.viewRow(this.NROWS / 2);
        DiagonalFloatMatrix2DTest.assertEquals((int)this.NCOLUMNS, (int)floatMatrix1D.size());
        for (int i = 0; i < this.NCOLUMNS; ++i) {
            DiagonalFloatMatrix2DTest.assertEquals((float)this.A.getQuick(this.NROWS / 2, i), (float)floatMatrix1D.getQuick(i), (float)this.TOL);
        }
    }

    public void testViewRowFlip() {
        FloatMatrix2D floatMatrix2D = this.A.viewRowFlip();
        DiagonalFloatMatrix2DTest.assertEquals((int)this.A.size(), (int)floatMatrix2D.size());
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                DiagonalFloatMatrix2DTest.assertEquals((float)this.A.getQuick(this.NROWS - 1 - i, j), (float)floatMatrix2D.getQuick(i, j), (float)this.TOL);
            }
        }
    }

    public void testViewSelectionFloatMatrix1DProcedure() {
        this.A.assign(0.0f);
        if (this.DINDEX >= 0) {
            this.A.setQuick(this.NROWS / 4, this.NROWS / 4 + this.DINDEX, 2.0f);
            this.A.setQuick(this.NROWS / 2, this.NROWS / 2 + this.DINDEX, 2.0f);
            FloatMatrix2D floatMatrix2D = this.A.viewSelection(new FloatMatrix1DProcedure(){

                public boolean apply(FloatMatrix1D floatMatrix1D) {
                    return Math.abs(floatMatrix1D.getQuick(DiagonalFloatMatrix2DTest.this.NROWS / 4 + DiagonalFloatMatrix2DTest.this.DINDEX) - 2.0f) < DiagonalFloatMatrix2DTest.this.TOL;
                }
            });
            DiagonalFloatMatrix2DTest.assertEquals((int)1, (int)floatMatrix2D.rows());
            DiagonalFloatMatrix2DTest.assertEquals((int)this.NCOLUMNS, (int)floatMatrix2D.columns());
            DiagonalFloatMatrix2DTest.assertEquals((float)this.A.getQuick(this.NROWS / 4, this.NROWS / 4 + this.DINDEX), (float)floatMatrix2D.getQuick(0, this.NROWS / 4 + this.DINDEX), (float)this.TOL);
        } else {
            this.A.setQuick(this.NROWS / 4 - this.DINDEX, this.NROWS / 4, 2.0f);
            this.A.setQuick(this.NROWS / 2 - this.DINDEX, this.NROWS / 2, 2.0f);
            FloatMatrix2D floatMatrix2D = this.A.viewSelection(new FloatMatrix1DProcedure(){

                public boolean apply(FloatMatrix1D floatMatrix1D) {
                    return Math.abs(floatMatrix1D.getQuick(DiagonalFloatMatrix2DTest.this.NROWS / 4) - 2.0f) < DiagonalFloatMatrix2DTest.this.TOL;
                }
            });
            DiagonalFloatMatrix2DTest.assertEquals((int)1, (int)floatMatrix2D.rows());
            DiagonalFloatMatrix2DTest.assertEquals((int)this.NCOLUMNS, (int)floatMatrix2D.columns());
            DiagonalFloatMatrix2DTest.assertEquals((float)this.A.getQuick(this.NROWS / 4 - this.DINDEX, this.NROWS / 4), (float)floatMatrix2D.getQuick(0, this.NROWS / 4), (float)this.TOL);
        }
    }

    public void testViewSelectionIntArrayIntArray() {
        int[] nArray = new int[]{this.NROWS / 6, this.NROWS / 5, this.NROWS / 4, this.NROWS / 3, this.NROWS / 2};
        int[] nArray2 = new int[]{this.NROWS / 6, this.NROWS / 5, this.NROWS / 4, this.NROWS / 3, this.NROWS / 2, this.NROWS - 1};
        FloatMatrix2D floatMatrix2D = this.A.viewSelection(nArray, nArray2);
        DiagonalFloatMatrix2DTest.assertEquals((int)nArray.length, (int)floatMatrix2D.rows());
        DiagonalFloatMatrix2DTest.assertEquals((int)nArray2.length, (int)floatMatrix2D.columns());
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                DiagonalFloatMatrix2DTest.assertEquals((float)this.A.getQuick(nArray[i], nArray2[j]), (float)floatMatrix2D.getQuick(i, j), (float)this.TOL);
            }
        }
    }

    public void testViewSorted() {
        FloatMatrix2D floatMatrix2D = this.A.viewSorted(1);
        for (int i = 0; i < this.NROWS - 1; ++i) {
            DiagonalFloatMatrix2DTest.assertTrue((floatMatrix2D.getQuick(i + 1, 1) >= floatMatrix2D.getQuick(i, 1) ? 1 : 0) != 0);
        }
    }

    public void testViewStrides() {
        int n = 3;
        int n2 = 5;
        FloatMatrix2D floatMatrix2D = this.A.viewStrides(n, n2);
        for (int i = 0; i < floatMatrix2D.rows(); ++i) {
            for (int j = 0; j < floatMatrix2D.columns(); ++j) {
                DiagonalFloatMatrix2DTest.assertEquals((float)this.A.getQuick(i * n, j * n2), (float)floatMatrix2D.getQuick(i, j), (float)this.TOL);
            }
        }
    }

    public void testZMultFloatMatrix2DFloatMatrix2DFloatFloatBooleanBoolean() {
        int n;
        float f;
        int n2;
        int n3;
        float f2 = 3.0f;
        float f3 = 5.0f;
        FloatMatrix2D floatMatrix2D = new DiagonalFloatMatrix2D(this.NROWS, this.NROWS, 0);
        for (int i = 0; i < this.DLENGTH; ++i) {
            floatMatrix2D.setQuick(i, i, (float)Math.random());
        }
        float[][] fArray = floatMatrix2D.toArray();
        floatMatrix2D = this.A.zMult(this.Bt, floatMatrix2D, f2, f3, false, false);
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                f = 0.0f;
                for (n = 0; n < this.NCOLUMNS; ++n) {
                    f += this.A.getQuick(n2, n) * this.Bt.getQuick(n, n3);
                }
                fArray[n2][n3] = f * f2 + fArray[n2][n3] * f3;
            }
        }
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                DiagonalFloatMatrix2DTest.assertEquals((float)fArray[n3][n2], (float)floatMatrix2D.getQuick(n3, n2), (float)this.TOL);
            }
        }
        floatMatrix2D = null;
        floatMatrix2D = this.A.zMult(this.Bt, floatMatrix2D, f2, f3, false, false);
        fArray = new float[this.NROWS][this.NROWS];
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                f = 0.0f;
                for (n = 0; n < this.NCOLUMNS; ++n) {
                    f += this.A.getQuick(n2, n) * this.Bt.getQuick(n, n3);
                }
                fArray[n2][n3] = f * f2;
            }
        }
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                DiagonalFloatMatrix2DTest.assertEquals((float)fArray[n3][n2], (float)floatMatrix2D.getQuick(n3, n2), (float)this.TOL);
            }
        }
        floatMatrix2D = new DiagonalFloatMatrix2D(this.NCOLUMNS, this.NCOLUMNS, 0);
        for (n3 = 0; n3 < this.DLENGTH; ++n3) {
            floatMatrix2D.setQuick(n3, n3, (float)Math.random());
        }
        fArray = floatMatrix2D.toArray();
        floatMatrix2D = this.A.zMult(this.B, floatMatrix2D, f2, f3, true, false);
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                f = 0.0f;
                for (n = 0; n < this.NROWS; ++n) {
                    f += this.A.getQuick(n, n2) * this.B.getQuick(n, n3);
                }
                fArray[n2][n3] = f * f2 + fArray[n2][n3] * f3;
            }
        }
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                DiagonalFloatMatrix2DTest.assertEquals((float)fArray[n3][n2], (float)floatMatrix2D.getQuick(n3, n2), (float)this.TOL);
            }
        }
        floatMatrix2D = null;
        floatMatrix2D = this.A.zMult(this.B, floatMatrix2D, f2, f3, true, false);
        fArray = new float[this.NCOLUMNS][this.NCOLUMNS];
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                f = 0.0f;
                for (n = 0; n < this.NROWS; ++n) {
                    f += this.A.getQuick(n, n2) * this.B.getQuick(n, n3);
                }
                fArray[n2][n3] = f * f2;
            }
        }
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                DiagonalFloatMatrix2DTest.assertEquals((float)fArray[n3][n2], (float)floatMatrix2D.getQuick(n3, n2), (float)this.TOL);
            }
        }
        floatMatrix2D = new DiagonalFloatMatrix2D(this.NROWS, this.NROWS, 0);
        for (n3 = 0; n3 < this.DLENGTH; ++n3) {
            floatMatrix2D.setQuick(n3, n3, (float)Math.random());
        }
        fArray = floatMatrix2D.toArray();
        floatMatrix2D = this.A.zMult(this.B, floatMatrix2D, f2, f3, false, true);
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                f = 0.0f;
                for (n = 0; n < this.NCOLUMNS; ++n) {
                    f += this.A.getQuick(n2, n) * this.B.getQuick(n3, n);
                }
                fArray[n2][n3] = f * f2 + fArray[n2][n3] * f3;
            }
        }
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                DiagonalFloatMatrix2DTest.assertEquals((float)fArray[n3][n2], (float)floatMatrix2D.getQuick(n3, n2), (float)this.TOL);
            }
        }
        floatMatrix2D = null;
        floatMatrix2D = this.A.zMult(this.B, floatMatrix2D, f2, f3, false, true);
        fArray = new float[this.NROWS][this.NROWS];
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                f = 0.0f;
                for (n = 0; n < this.NCOLUMNS; ++n) {
                    f += this.A.getQuick(n2, n) * this.B.getQuick(n3, n);
                }
                fArray[n2][n3] = f * f2;
            }
        }
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                DiagonalFloatMatrix2DTest.assertEquals((float)fArray[n3][n2], (float)floatMatrix2D.getQuick(n3, n2), (float)this.TOL);
            }
        }
        floatMatrix2D = new DiagonalFloatMatrix2D(this.NCOLUMNS, this.NCOLUMNS, 0);
        for (n3 = 0; n3 < this.DLENGTH; ++n3) {
            floatMatrix2D.setQuick(n3, n3, (float)Math.random());
        }
        fArray = floatMatrix2D.toArray();
        floatMatrix2D = this.A.zMult(this.Bt, floatMatrix2D, f2, f3, true, true);
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                f = 0.0f;
                for (n = 0; n < this.NROWS; ++n) {
                    f += this.A.getQuick(n, n2) * this.Bt.getQuick(n3, n);
                }
                fArray[n2][n3] = f * f2 + fArray[n2][n3] * f3;
            }
        }
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                DiagonalFloatMatrix2DTest.assertEquals((float)fArray[n3][n2], (float)floatMatrix2D.getQuick(n3, n2), (float)this.TOL);
            }
        }
        floatMatrix2D = null;
        floatMatrix2D = this.A.zMult(this.Bt, floatMatrix2D, f2, f3, true, true);
        fArray = new float[this.NCOLUMNS][this.NCOLUMNS];
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                f = 0.0f;
                for (n = 0; n < this.NROWS; ++n) {
                    f += this.A.getQuick(n, n2) * this.Bt.getQuick(n3, n);
                }
                fArray[n2][n3] = f * f2;
            }
        }
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                DiagonalFloatMatrix2DTest.assertEquals((float)fArray[n3][n2], (float)floatMatrix2D.getQuick(n3, n2), (float)this.TOL);
            }
        }
    }
}

