/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.matrix.tfcomplex.FComplexMatrix3D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix3D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.colt.matrix.tfloat.FloatMatrix3DTest;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix3D;

public class DenseFloatMatrix3DTest
extends FloatMatrix3DTest {
    public DenseFloatMatrix3DTest(String string) {
        super(string);
    }

    protected void createMatrices() throws Exception {
        this.A = new DenseFloatMatrix3D(this.NSLICES, this.NROWS, this.NCOLUMNS);
        this.B = new DenseFloatMatrix3D(this.NSLICES, this.NROWS, this.NCOLUMNS);
    }

    public void testDct3() {
        FloatMatrix3D floatMatrix3D = this.A.copy();
        ((DenseFloatMatrix3D)this.A).dct3(true);
        ((DenseFloatMatrix3D)this.A).idct3(true);
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    DenseFloatMatrix3DTest.assertEquals((float)0.0f, (float)Math.abs(floatMatrix3D.getQuick(i, j, k) - this.A.getQuick(i, j, k)), (float)this.TOL);
                }
            }
        }
    }

    public void testDst3() {
        FloatMatrix3D floatMatrix3D = this.A.copy();
        ((DenseFloatMatrix3D)this.A).dst3(true);
        ((DenseFloatMatrix3D)this.A).idst3(true);
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    DenseFloatMatrix3DTest.assertEquals((float)0.0f, (float)Math.abs(floatMatrix3D.getQuick(i, j, k) - this.A.getQuick(i, j, k)), (float)this.TOL);
                }
            }
        }
    }

    public void testDht3() {
        FloatMatrix3D floatMatrix3D = this.A.copy();
        ((DenseFloatMatrix3D)this.A).dht3();
        ((DenseFloatMatrix3D)this.A).idht3(true);
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    DenseFloatMatrix3DTest.assertEquals((float)0.0f, (float)Math.abs(floatMatrix3D.getQuick(i, j, k) - this.A.getQuick(i, j, k)), (float)this.TOL);
                }
            }
        }
    }

    public void testFft3() {
        int n = 16;
        int n2 = 32;
        int n3 = 64;
        DenseFloatMatrix3D denseFloatMatrix3D = new DenseFloatMatrix3D(n, n2, n3);
        FloatMatrix3D floatMatrix3D = denseFloatMatrix3D.copy();
        denseFloatMatrix3D.fft3();
        denseFloatMatrix3D.ifft3(true);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    DenseFloatMatrix3DTest.assertEquals((float)0.0f, (float)Math.abs(floatMatrix3D.getQuick(i, j, k) - ((FloatMatrix3D)denseFloatMatrix3D).getQuick(i, j, k)), (float)this.TOL);
                }
            }
        }
    }

    public void testDct2Slices() {
        FloatMatrix3D floatMatrix3D = this.A.copy();
        ((DenseFloatMatrix3D)this.A).dct2Slices(true);
        ((DenseFloatMatrix3D)this.A).idct2Slices(true);
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    DenseFloatMatrix3DTest.assertEquals((float)0.0f, (float)Math.abs(floatMatrix3D.getQuick(i, j, k) - this.A.getQuick(i, j, k)), (float)this.TOL);
                }
            }
        }
    }

    public void testDst2Slices() {
        FloatMatrix3D floatMatrix3D = this.A.copy();
        ((DenseFloatMatrix3D)this.A).dst2Slices(true);
        ((DenseFloatMatrix3D)this.A).idst2Slices(true);
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    DenseFloatMatrix3DTest.assertEquals((float)0.0f, (float)Math.abs(floatMatrix3D.getQuick(i, j, k) - this.A.getQuick(i, j, k)), (float)this.TOL);
                }
            }
        }
    }

    public void testDft2Slices() {
        FloatMatrix3D floatMatrix3D = this.A.copy();
        ((DenseFloatMatrix3D)this.A).dht2Slices();
        ((DenseFloatMatrix3D)this.A).idht2Slices(true);
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    DenseFloatMatrix3DTest.assertEquals((float)0.0f, (float)Math.abs(floatMatrix3D.getQuick(i, j, k) - this.A.getQuick(i, j, k)), (float)this.TOL);
                }
            }
        }
    }

    public void testGetFft3() {
        DenseFComplexMatrix3D denseFComplexMatrix3D = ((DenseFloatMatrix3D)this.A).getFft3();
        denseFComplexMatrix3D.ifft3(true);
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    float[] fArray = ((FComplexMatrix3D)denseFComplexMatrix3D).getQuick(i, j, k);
                    DenseFloatMatrix3DTest.assertEquals((float)this.A.getQuick(i, j, k), (float)fArray[0], (float)this.TOL);
                    DenseFloatMatrix3DTest.assertEquals((float)0.0f, (float)fArray[1], (float)this.TOL);
                }
            }
        }
    }

    public void testGetIfft3() {
        DenseFComplexMatrix3D denseFComplexMatrix3D = ((DenseFloatMatrix3D)this.A).getIfft3(true);
        denseFComplexMatrix3D.fft3();
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    float[] fArray = ((FComplexMatrix3D)denseFComplexMatrix3D).getQuick(i, j, k);
                    DenseFloatMatrix3DTest.assertEquals((float)this.A.getQuick(i, j, k), (float)fArray[0], (float)this.TOL);
                    DenseFloatMatrix3DTest.assertEquals((float)0.0f, (float)fArray[1], (float)this.TOL);
                }
            }
        }
    }

    public void testGetFft2Slices() {
        DenseFComplexMatrix3D denseFComplexMatrix3D = ((DenseFloatMatrix3D)this.A).getFft2Slices();
        denseFComplexMatrix3D.ifft2Slices(true);
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    float[] fArray = ((FComplexMatrix3D)denseFComplexMatrix3D).getQuick(i, j, k);
                    DenseFloatMatrix3DTest.assertEquals((float)0.0f, (float)Math.abs(this.A.getQuick(i, j, k) - fArray[0]), (float)this.TOL);
                    DenseFloatMatrix3DTest.assertEquals((float)0.0f, (float)fArray[1], (float)this.TOL);
                }
            }
        }
    }

    public void testGetIfft2Slices() {
        DenseFComplexMatrix3D denseFComplexMatrix3D = ((DenseFloatMatrix3D)this.A).getIfft2Slices(true);
        denseFComplexMatrix3D.fft2Slices();
        for (int i = 0; i < this.NSLICES; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                for (int k = 0; k < this.NCOLUMNS; ++k) {
                    float[] fArray = ((FComplexMatrix3D)denseFComplexMatrix3D).getQuick(i, j, k);
                    DenseFloatMatrix3DTest.assertEquals((float)0.0f, (float)Math.abs(this.A.getQuick(i, j, k) - fArray[0]), (float)this.TOL);
                    DenseFloatMatrix3DTest.assertEquals((float)0.0f, (float)fArray[1], (float)this.TOL);
                }
            }
        }
    }
}

