/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.Timer;
import cern.colt.function.tfloat.FloatProcedure;
import cern.colt.function.tfloat.IntIntFloatFunction;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.BenchmarkMatrixKernel;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.jet.math.tfloat.FloatFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.Random;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.JUnitCore;

public class BenchmarkDenseFloatMatrix2D {
    private static Timer t = new Timer();
    private static final String outputFile = "BenchmarkDenseFloatMatrix2D.txt";
    private static float[][] a_2d;
    private static float[][] b_2d;
    private static float[] a_1d;
    private static float[] b_1d;
    private static double[] noViewTimes;
    private static double[] viewTimes;

    public static void main(String[] stringArray) {
        JUnitCore.main((String[])new String[]{"cern.colt.matrix.tfloat.impl.BenchmarkDenseFloatMatrix2D"});
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        int n;
        int n2;
        BenchmarkMatrixKernel.readSettings2D();
        Random random = new Random(0L);
        ConcurrencyUtils.setThreadsBeginN_2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[0] * BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]);
        a_1d = new float[BenchmarkMatrixKernel.MATRIX_SIZE_2D[0] * BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]];
        a_2d = new float[BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]][BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]];
        int n3 = 0;
        for (n2 = 0; n2 < BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]; ++n2) {
            for (n = 0; n < BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]; ++n) {
                BenchmarkDenseFloatMatrix2D.a_2d[n2][n] = random.nextFloat();
                BenchmarkDenseFloatMatrix2D.a_1d[n3++] = a_2d[n2][n];
            }
        }
        b_1d = new float[BenchmarkMatrixKernel.MATRIX_SIZE_2D[0] * BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]];
        b_2d = new float[BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]][BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]];
        n3 = 0;
        for (n2 = 0; n2 < BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]; ++n2) {
            for (n = 0; n < BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]; ++n) {
                BenchmarkDenseFloatMatrix2D.b_2d[n2][n] = random.nextFloat();
                BenchmarkDenseFloatMatrix2D.b_1d[n3++] = b_2d[n2][n];
            }
        }
        BenchmarkMatrixKernel.writePropertiesToFile(outputFile, BenchmarkMatrixKernel.MATRIX_SIZE_2D);
        BenchmarkMatrixKernel.displayProperties(BenchmarkMatrixKernel.MATRIX_SIZE_2D);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        a_1d = null;
        a_2d = null;
        b_1d = null;
        b_2d = null;
        ConcurrencyUtils.resetThreadsBeginN();
        System.gc();
    }

    @Before
    public void setUpBefore() {
        noViewTimes = new double[BenchmarkMatrixKernel.NTHREADS.length];
        viewTimes = new double[BenchmarkMatrixKernel.NTHREADS.length];
    }

    @Test
    public void testZMultFloatMatrix2DFloatMatrix2D() {
        int n = BenchmarkMatrixKernel.NITERS;
        BenchmarkMatrixKernel.NITERS = 10;
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(b_2d);
        floatMatrix2D = floatMatrix2D.viewDice().copy();
        DenseFloatMatrix2D denseFloatMatrix2D2 = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[0], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFloatMatrix2D.zMult(floatMatrix2D, denseFloatMatrix2D2);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((FloatMatrix2D)denseFloatMatrix2D2).assign(0.0f);
                t.reset().start();
                denseFloatMatrix2D.zMult(floatMatrix2D, denseFloatMatrix2D2);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        FloatMatrix2D floatMatrix2D2 = denseFloatMatrix2D.viewDice();
        floatMatrix2D = new DenseFloatMatrix2D(b_2d);
        floatMatrix2D = floatMatrix2D.viewDice().copy();
        FloatMatrix2D floatMatrix2D3 = floatMatrix2D.viewDice();
        denseFloatMatrix2D2 = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]);
        FloatMatrix2D floatMatrix2D4 = denseFloatMatrix2D2.viewDice();
        int n5 = 0;
        while (n5 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n5]);
            floatMatrix2D2.zMult(floatMatrix2D3, floatMatrix2D4);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                floatMatrix2D4.assign(0.0f);
                t.reset().start();
                floatMatrix2D2.zMult(floatMatrix2D3, floatMatrix2D4);
                t.stop();
                int n6 = n5;
                viewTimes[n6] = viewTimes[n6] + t.millis();
            }
            int n7 = n5++;
            viewTimes[n7] = viewTimes[n7] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "zMult(FloatMatrix2D, FloatMatrix2D)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.NITERS = n;
    }

    @Test
    public void testZMultFloatMatrix1DFloatMatrix1D() {
        int n;
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(denseFloatMatrix2D.columns());
        for (int i = 0; i < denseFloatMatrix1D.size(); ++i) {
            denseFloatMatrix1D.set(i, (float)Math.random());
        }
        DenseFloatMatrix1D denseFloatMatrix1D2 = new DenseFloatMatrix1D(denseFloatMatrix2D.rows());
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFloatMatrix2D.zMult(denseFloatMatrix1D, denseFloatMatrix1D2);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((FloatMatrix1D)denseFloatMatrix1D2).assign(0.0f);
                t.reset().start();
                denseFloatMatrix2D.zMult(denseFloatMatrix1D, denseFloatMatrix1D2);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            floatMatrix2D.zMult(denseFloatMatrix1D, denseFloatMatrix1D2);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((FloatMatrix1D)denseFloatMatrix1D2).assign(0.0f);
                t.reset().start();
                floatMatrix2D.zMult(denseFloatMatrix1D, denseFloatMatrix1D2);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "zMult(FloatMatrix1D, FloatMatrix1D)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAggregateFloatFloatFunctionFloatFunction() {
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            float f = ((FloatMatrix2D)denseFloatMatrix2D).aggregate(FloatFunctions.plus, FloatFunctions.square);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                f = ((FloatMatrix2D)denseFloatMatrix2D).aggregate(FloatFunctions.plus, FloatFunctions.square);
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            float f = floatMatrix2D.aggregate(FloatFunctions.plus, FloatFunctions.square);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                f = floatMatrix2D.aggregate(FloatFunctions.plus, FloatFunctions.square);
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "aggregate(FloatFloatFunction, FloatFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAggregateFloatFloatFunctionFloatFunctionFloatProcedure() {
        FloatProcedure floatProcedure = new FloatProcedure(){

            public boolean apply(float f) {
                return (double)Math.abs(f) > 0.2;
            }
        };
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            float f = ((FloatMatrix2D)denseFloatMatrix2D).aggregate(FloatFunctions.plus, FloatFunctions.square, floatProcedure);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                f = ((FloatMatrix2D)denseFloatMatrix2D).aggregate(FloatFunctions.plus, FloatFunctions.square, floatProcedure);
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            float f = floatMatrix2D.aggregate(FloatFunctions.plus, FloatFunctions.square, floatProcedure);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                f = floatMatrix2D.aggregate(FloatFunctions.plus, FloatFunctions.square, floatProcedure);
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "aggregate(FloatFloatFunction, FloatFunction, FloatProcedure)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAggregateFloatFloatFunctionFloatFunctionIntArrayListIntArrayList() {
        int n;
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        for (n = 0; n < BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]; ++n) {
            for (int i = 0; i < BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]; ++i) {
                intArrayList.add(n);
                intArrayList2.add(i);
            }
        }
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            float f = ((FloatMatrix2D)denseFloatMatrix2D).aggregate(FloatFunctions.plus, FloatFunctions.square, intArrayList, intArrayList2);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                f = ((FloatMatrix2D)denseFloatMatrix2D).aggregate(FloatFunctions.plus, FloatFunctions.square, intArrayList, intArrayList2);
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            float f = floatMatrix2D.aggregate(FloatFunctions.plus, FloatFunctions.square, intArrayList, intArrayList2);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                f = floatMatrix2D.aggregate(FloatFunctions.plus, FloatFunctions.square, intArrayList, intArrayList2);
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "aggregate(FloatFloatFunction, FloatFunction, IntArrayList, IntArrayList)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAggregateFloatMatrix2DFloatFloatFunctionFloatFloatFunction() {
        int n;
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        DenseFloatMatrix2D denseFloatMatrix2D2 = new DenseFloatMatrix2D(b_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            float f = ((FloatMatrix2D)denseFloatMatrix2D).aggregate(denseFloatMatrix2D2, FloatFunctions.plus, FloatFunctions.mult);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                t.reset().start();
                f = ((FloatMatrix2D)denseFloatMatrix2D).aggregate(denseFloatMatrix2D2, FloatFunctions.plus, FloatFunctions.mult);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        FloatMatrix2D floatMatrix2D2 = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(b_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            float f = floatMatrix2D.aggregate(floatMatrix2D2, FloatFunctions.plus, FloatFunctions.mult);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                f = floatMatrix2D.aggregate(floatMatrix2D2, FloatFunctions.plus, FloatFunctions.mult);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "aggregate(FloatMatrix2D, FloatFloatFunction, FloatFloatFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignFloat() {
        int n;
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[0], BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]);
        float f = (float)Math.random();
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((FloatMatrix2D)denseFloatMatrix2D).assign(f);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((FloatMatrix2D)denseFloatMatrix2D).assign(0.0f);
                t.reset().start();
                ((FloatMatrix2D)denseFloatMatrix2D).assign(f);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice();
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            floatMatrix2D.assign(f);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                floatMatrix2D.assign(0.0f);
                t.reset().start();
                floatMatrix2D.assign(f);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(float)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignFloatArray() {
        int n;
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[0], BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((FloatMatrix2D)denseFloatMatrix2D).assign(a_1d);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((FloatMatrix2D)denseFloatMatrix2D).assign(0.0f);
                t.reset().start();
                ((FloatMatrix2D)denseFloatMatrix2D).assign(a_1d);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice();
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            floatMatrix2D.assign(a_1d);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                floatMatrix2D.assign(0.0f);
                t.reset().start();
                floatMatrix2D.assign(a_1d);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(float[])";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignFloatArrayArray() {
        int n;
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[0], BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((FloatMatrix2D)denseFloatMatrix2D).assign(a_2d);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((FloatMatrix2D)denseFloatMatrix2D).assign(0.0f);
                t.reset().start();
                ((FloatMatrix2D)denseFloatMatrix2D).assign(a_2d);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice();
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            floatMatrix2D.assign(a_2d);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                floatMatrix2D.assign(0.0f);
                t.reset().start();
                floatMatrix2D.assign(a_2d);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(float[][])";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignFloatFunction() {
        int n;
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((FloatMatrix2D)denseFloatMatrix2D).assign(FloatFunctions.square);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((FloatMatrix2D)denseFloatMatrix2D).assign(a_2d);
                t.reset().start();
                ((FloatMatrix2D)denseFloatMatrix2D).assign(FloatFunctions.square);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            floatMatrix2D.assign(FloatFunctions.square);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                floatMatrix2D.assign(a_2d);
                t.reset().start();
                floatMatrix2D.assign(FloatFunctions.square);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(FloatFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignFloatMatrix2D() {
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[0], BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]);
        DenseFloatMatrix2D denseFloatMatrix2D2 = new DenseFloatMatrix2D(a_2d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((FloatMatrix2D)denseFloatMatrix2D).assign(denseFloatMatrix2D2);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((FloatMatrix2D)denseFloatMatrix2D).assign(0.0f);
                t.reset().start();
                ((FloatMatrix2D)denseFloatMatrix2D).assign(denseFloatMatrix2D2);
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        denseFloatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[0], BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]);
        FloatMatrix2D floatMatrix2D = denseFloatMatrix2D.viewDice();
        denseFloatMatrix2D2 = new DenseFloatMatrix2D(a_2d);
        FloatMatrix2D floatMatrix2D2 = denseFloatMatrix2D2.viewDice();
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            floatMatrix2D.assign(floatMatrix2D2);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                floatMatrix2D.assign(0.0f);
                t.reset().start();
                floatMatrix2D.assign(floatMatrix2D2);
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(FloatMatrix2D)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignFloatMatrix2DFloatFloatFunction() {
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        DenseFloatMatrix2D denseFloatMatrix2D2 = new DenseFloatMatrix2D(b_2d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((FloatMatrix2D)denseFloatMatrix2D).assign(denseFloatMatrix2D2, FloatFunctions.div);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((FloatMatrix2D)denseFloatMatrix2D).assign(a_2d);
                t.reset().start();
                ((FloatMatrix2D)denseFloatMatrix2D).assign(denseFloatMatrix2D2, FloatFunctions.div);
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        FloatMatrix2D floatMatrix2D2 = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(b_2d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            floatMatrix2D.assign(floatMatrix2D2, FloatFunctions.div);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                floatMatrix2D.assign(a_2d);
                t.reset().start();
                floatMatrix2D.assign(floatMatrix2D2, FloatFunctions.div);
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(FloatMatrix2D, FloatFloatFuction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignFloatMatrix2DFloatFloatFunctionIntArrayListIntArrayList() {
        int n;
        int n2;
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        DenseFloatMatrix2D denseFloatMatrix2D2 = new DenseFloatMatrix2D(b_2d);
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        for (n2 = 0; n2 < BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]; ++n2) {
            for (n = 0; n < BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]; ++n) {
                intArrayList.add(n2);
                intArrayList2.add(n);
            }
        }
        n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((FloatMatrix2D)denseFloatMatrix2D).assign(denseFloatMatrix2D2, FloatFunctions.div, intArrayList, intArrayList2);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((FloatMatrix2D)denseFloatMatrix2D).assign(a_2d);
                t.reset().start();
                ((FloatMatrix2D)denseFloatMatrix2D).assign(denseFloatMatrix2D2, FloatFunctions.div, intArrayList, intArrayList2);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        FloatMatrix2D floatMatrix2D2 = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(b_2d);
        int n5 = 0;
        while (n5 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n5]);
            floatMatrix2D.assign(floatMatrix2D2, FloatFunctions.div, intArrayList, intArrayList2);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                floatMatrix2D.assign(a_2d);
                t.reset().start();
                floatMatrix2D.assign(floatMatrix2D2, FloatFunctions.div, intArrayList, intArrayList2);
                t.stop();
                int n6 = n5;
                viewTimes[n6] = viewTimes[n6] + t.millis();
            }
            int n7 = n5++;
            viewTimes[n7] = viewTimes[n7] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(FloatMatrix2D, FloatFloatFuction, IntArrayList, IntArrayList)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignFloatProcedureFloat() {
        int n;
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        FloatProcedure floatProcedure = new FloatProcedure(){

            public boolean apply(float f) {
                return (double)Math.abs(f) > 0.1;
            }
        };
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((FloatMatrix2D)denseFloatMatrix2D).assign(floatProcedure, -1.0f);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((FloatMatrix2D)denseFloatMatrix2D).assign(a_2d);
                t.reset().start();
                ((FloatMatrix2D)denseFloatMatrix2D).assign(floatProcedure, -1.0f);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            floatMatrix2D.assign(floatProcedure, -1.0f);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                floatMatrix2D.assign(a_2d);
                t.reset().start();
                floatMatrix2D.assign(floatProcedure, -1.0f);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(FloatProcedure, float)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignFloatProcedureFloatFunction() {
        int n;
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        FloatProcedure floatProcedure = new FloatProcedure(){

            public boolean apply(float f) {
                return (double)Math.abs(f) > 0.1;
            }
        };
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((FloatMatrix2D)denseFloatMatrix2D).assign(floatProcedure, FloatFunctions.square);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((FloatMatrix2D)denseFloatMatrix2D).assign(a_2d);
                t.reset().start();
                ((FloatMatrix2D)denseFloatMatrix2D).assign(floatProcedure, FloatFunctions.square);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            floatMatrix2D.assign(floatProcedure, FloatFunctions.square);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                floatMatrix2D.assign(a_2d);
                t.reset().start();
                floatMatrix2D.assign(floatProcedure, FloatFunctions.square);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(FloatProcedure, FloatFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testCardinality() {
        int n;
        int n2;
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        int n3 = 0;
        while (n3 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n3]);
            n2 = ((FloatMatrix2D)denseFloatMatrix2D).cardinality();
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                t.reset().start();
                n2 = ((FloatMatrix2D)denseFloatMatrix2D).cardinality();
                t.stop();
                int n4 = n3;
                noViewTimes[n4] = noViewTimes[n4] + t.millis();
            }
            int n5 = n3++;
            noViewTimes[n5] = noViewTimes[n5] / (double)BenchmarkMatrixKernel.NITERS;
        }
        denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        FloatMatrix2D floatMatrix2D = denseFloatMatrix2D.viewDice();
        n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            n = floatMatrix2D.cardinality();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                n = floatMatrix2D.cardinality();
                t.stop();
                int n6 = n2;
                viewTimes[n6] = viewTimes[n6] + t.millis();
            }
            int n7 = n2++;
            viewTimes[n7] = viewTimes[n7] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "cardinality()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testDct2() {
        int n;
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFloatMatrix2D.dct2(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFloatMatrix2D.assign(a_2d);
                t.reset().start();
                denseFloatMatrix2D.dct2(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseFloatMatrix2D)floatMatrix2D).dct2(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseFloatMatrix2D)floatMatrix2D).assign(a_2d);
                t.reset().start();
                ((DenseFloatMatrix2D)floatMatrix2D).dct2(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "dct2(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testDctColumns() {
        int n;
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFloatMatrix2D.dctColumns(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFloatMatrix2D.assign(a_2d);
                t.reset().start();
                denseFloatMatrix2D.dctColumns(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseFloatMatrix2D)floatMatrix2D).dctColumns(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseFloatMatrix2D)floatMatrix2D).assign(a_2d);
                t.reset().start();
                ((DenseFloatMatrix2D)floatMatrix2D).dctColumns(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "dctColumns(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testDctRows() {
        int n;
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFloatMatrix2D.dctRows(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFloatMatrix2D.assign(a_2d);
                t.reset().start();
                denseFloatMatrix2D.dctRows(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseFloatMatrix2D)floatMatrix2D).dctRows(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseFloatMatrix2D)floatMatrix2D).assign(a_2d);
                t.reset().start();
                ((DenseFloatMatrix2D)floatMatrix2D).dctRows(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "dctRows(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testDht2() {
        int n;
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFloatMatrix2D.dct2(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFloatMatrix2D.assign(a_2d);
                t.reset().start();
                denseFloatMatrix2D.dct2(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseFloatMatrix2D)floatMatrix2D).dht2();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseFloatMatrix2D)floatMatrix2D).assign(a_2d);
                t.reset().start();
                ((DenseFloatMatrix2D)floatMatrix2D).dht2();
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "dht2()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testDhtColumns() {
        int n;
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFloatMatrix2D.dhtColumns();
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFloatMatrix2D.assign(a_2d);
                t.reset().start();
                denseFloatMatrix2D.dhtColumns();
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseFloatMatrix2D)floatMatrix2D).dhtColumns();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseFloatMatrix2D)floatMatrix2D).assign(a_2d);
                t.reset().start();
                ((DenseFloatMatrix2D)floatMatrix2D).dhtColumns();
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "dhtColumns()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testDhtRows() {
        int n;
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFloatMatrix2D.dhtRows();
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFloatMatrix2D.assign(a_2d);
                t.reset().start();
                denseFloatMatrix2D.dhtRows();
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseFloatMatrix2D)floatMatrix2D).dhtRows();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseFloatMatrix2D)floatMatrix2D).assign(a_2d);
                t.reset().start();
                ((DenseFloatMatrix2D)floatMatrix2D).dhtRows();
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "dhtRows()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testDst2() {
        int n;
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFloatMatrix2D.dst2(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFloatMatrix2D.assign(a_2d);
                t.reset().start();
                denseFloatMatrix2D.dst2(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseFloatMatrix2D)floatMatrix2D).dst2(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseFloatMatrix2D)floatMatrix2D).assign(a_2d);
                t.reset().start();
                ((DenseFloatMatrix2D)floatMatrix2D).dst2(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "dst2(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testDstColumns() {
        int n;
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFloatMatrix2D.dstColumns(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFloatMatrix2D.assign(a_2d);
                t.reset().start();
                denseFloatMatrix2D.dstColumns(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseFloatMatrix2D)floatMatrix2D).dstColumns(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseFloatMatrix2D)floatMatrix2D).assign(a_2d);
                t.reset().start();
                ((DenseFloatMatrix2D)floatMatrix2D).dstColumns(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "dstColumns(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testDstRows() {
        int n;
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFloatMatrix2D.dstRows(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFloatMatrix2D.assign(a_2d);
                t.reset().start();
                denseFloatMatrix2D.dstRows(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseFloatMatrix2D)floatMatrix2D).dstRows(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseFloatMatrix2D)floatMatrix2D).assign(a_2d);
                t.reset().start();
                ((DenseFloatMatrix2D)floatMatrix2D).dstRows(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "dstRows(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testFft2() {
        int n;
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFloatMatrix2D.fft2();
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFloatMatrix2D.assign(a_2d);
                t.reset().start();
                denseFloatMatrix2D.fft2();
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseFloatMatrix2D)floatMatrix2D).fft2();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseFloatMatrix2D)floatMatrix2D).assign(a_2d);
                t.reset().start();
                ((DenseFloatMatrix2D)floatMatrix2D).fft2();
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "fft2()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testForEachNonZero() {
        int n;
        IntIntFloatFunction intIntFloatFunction = new IntIntFloatFunction(){

            public float apply(int n, int n2, float f) {
                return (float)Math.sqrt(f);
            }
        };
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFloatMatrix2D.forEachNonZero(intIntFloatFunction);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                t.reset().start();
                denseFloatMatrix2D.forEachNonZero(intIntFloatFunction);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(a_2d).viewDice();
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseFloatMatrix2D)floatMatrix2D).forEachNonZero(intIntFloatFunction);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                ((DenseFloatMatrix2D)floatMatrix2D).forEachNonZero(intIntFloatFunction);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "forEachNonZero(IntIntFloatFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetFft2() {
        int n;
        DenseFComplexMatrix2D denseFComplexMatrix2D;
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFComplexMatrix2D = denseFloatMatrix2D.getFft2();
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFloatMatrix2D.assign(a_2d);
                t.reset().start();
                denseFComplexMatrix2D = denseFloatMatrix2D.getFft2();
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            denseFComplexMatrix2D = ((DenseFloatMatrix2D)floatMatrix2D).getFft2();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseFloatMatrix2D)floatMatrix2D).assign(a_2d);
                t.reset().start();
                denseFComplexMatrix2D = ((DenseFloatMatrix2D)floatMatrix2D).getFft2();
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getFft2()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetFftColumns() {
        int n;
        DenseFComplexMatrix2D denseFComplexMatrix2D;
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFComplexMatrix2D = denseFloatMatrix2D.getFftColumns();
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFloatMatrix2D.assign(a_2d);
                t.reset().start();
                denseFComplexMatrix2D = denseFloatMatrix2D.getFftColumns();
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            denseFComplexMatrix2D = ((DenseFloatMatrix2D)floatMatrix2D).getFftColumns();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseFloatMatrix2D)floatMatrix2D).assign(a_2d);
                t.reset().start();
                denseFComplexMatrix2D = ((DenseFloatMatrix2D)floatMatrix2D).getFftColumns();
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getFftColumns()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetFftRows() {
        int n;
        DenseFComplexMatrix2D denseFComplexMatrix2D;
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFComplexMatrix2D = denseFloatMatrix2D.getFftRows();
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFloatMatrix2D.assign(a_2d);
                t.reset().start();
                denseFComplexMatrix2D = denseFloatMatrix2D.getFftRows();
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            denseFComplexMatrix2D = ((DenseFloatMatrix2D)floatMatrix2D).getFftRows();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseFloatMatrix2D)floatMatrix2D).assign(a_2d);
                t.reset().start();
                denseFComplexMatrix2D = ((DenseFloatMatrix2D)floatMatrix2D).getFftRows();
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getFftRows()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetIfft2() {
        int n;
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFloatMatrix2D.ifft2(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFloatMatrix2D.assign(a_2d);
                t.reset().start();
                denseFloatMatrix2D.ifft2(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseFloatMatrix2D)floatMatrix2D).ifft2(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseFloatMatrix2D)floatMatrix2D).assign(a_2d);
                t.reset().start();
                ((DenseFloatMatrix2D)floatMatrix2D).ifft2(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getIfft2(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetIfftColumns() {
        int n;
        DenseFComplexMatrix2D denseFComplexMatrix2D;
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFComplexMatrix2D = denseFloatMatrix2D.getIfftColumns(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFloatMatrix2D.assign(a_2d);
                t.reset().start();
                denseFComplexMatrix2D = denseFloatMatrix2D.getIfftColumns(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            denseFComplexMatrix2D = ((DenseFloatMatrix2D)floatMatrix2D).getIfftColumns(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseFloatMatrix2D)floatMatrix2D).assign(a_2d);
                t.reset().start();
                denseFComplexMatrix2D = ((DenseFloatMatrix2D)floatMatrix2D).getIfftColumns(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getIfftColumns(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetIfftRows() {
        int n;
        DenseFComplexMatrix2D denseFComplexMatrix2D;
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFComplexMatrix2D = denseFloatMatrix2D.getIfftRows(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFloatMatrix2D.assign(a_2d);
                t.reset().start();
                denseFComplexMatrix2D = denseFloatMatrix2D.getIfftRows(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            denseFComplexMatrix2D = ((DenseFloatMatrix2D)floatMatrix2D).getIfftRows(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseFloatMatrix2D)floatMatrix2D).assign(a_2d);
                t.reset().start();
                denseFComplexMatrix2D = ((DenseFloatMatrix2D)floatMatrix2D).getIfftRows(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getIfftRows(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetNonZerosIntArrayListIntArrayListFloatArrayList() {
        int n;
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        FloatArrayList floatArrayList = new FloatArrayList();
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFloatMatrix2D.getNonZeros(intArrayList, intArrayList2, floatArrayList);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                intArrayList.clear();
                intArrayList2.clear();
                floatArrayList.clear();
                t.reset().start();
                denseFloatMatrix2D.getNonZeros(intArrayList, intArrayList2, floatArrayList);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(a_2d).viewDice();
        intArrayList.clear();
        intArrayList2.clear();
        floatArrayList.clear();
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseFloatMatrix2D)floatMatrix2D).getNonZeros(intArrayList, intArrayList2, floatArrayList);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                intArrayList.clear();
                intArrayList2.clear();
                floatArrayList.clear();
                t.reset().start();
                ((DenseFloatMatrix2D)floatMatrix2D).getNonZeros(intArrayList, intArrayList2, floatArrayList);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getNonZeros(IntArrayList, IntArrayList, FloatArrayList)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetPositiveValuesIntArrayListIntArrayListFloatArrayList() {
        int n;
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        FloatArrayList floatArrayList = new FloatArrayList();
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFloatMatrix2D.getPositiveValues(intArrayList, intArrayList2, floatArrayList);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                intArrayList.clear();
                intArrayList2.clear();
                floatArrayList.clear();
                t.reset().start();
                denseFloatMatrix2D.getPositiveValues(intArrayList, intArrayList2, floatArrayList);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(a_2d).viewDice();
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseFloatMatrix2D)floatMatrix2D).getPositiveValues(intArrayList, intArrayList2, floatArrayList);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                intArrayList.clear();
                intArrayList2.clear();
                floatArrayList.clear();
                t.reset().start();
                ((DenseFloatMatrix2D)floatMatrix2D).getPositiveValues(intArrayList, intArrayList2, floatArrayList);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getPositiveValues(IntArrayList, IntArrayList, FloatArrayList)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetNegativeValuesIntArrayListIntArrayListFloatArrayList() {
        int n;
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        denseFloatMatrix2D.assign(FloatFunctions.mult(-1.0f));
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        FloatArrayList floatArrayList = new FloatArrayList();
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFloatMatrix2D.getNegativeValues(intArrayList, intArrayList2, floatArrayList);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                intArrayList.clear();
                intArrayList2.clear();
                floatArrayList.clear();
                t.reset().start();
                denseFloatMatrix2D.getNegativeValues(intArrayList, intArrayList2, floatArrayList);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(a_2d).viewDice();
        ((DenseFloatMatrix2D)floatMatrix2D).assign(FloatFunctions.mult(-1.0f));
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseFloatMatrix2D)floatMatrix2D).getNegativeValues(intArrayList, intArrayList2, floatArrayList);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                intArrayList.clear();
                intArrayList2.clear();
                floatArrayList.clear();
                t.reset().start();
                ((DenseFloatMatrix2D)floatMatrix2D).getNegativeValues(intArrayList, intArrayList2, floatArrayList);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getNegativeValues(IntArrayList, IntArrayList, FloatArrayList)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIdct2() {
        int n;
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFloatMatrix2D.idct2(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFloatMatrix2D.assign(a_2d);
                t.reset().start();
                denseFloatMatrix2D.idct2(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseFloatMatrix2D)floatMatrix2D).idct2(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseFloatMatrix2D)floatMatrix2D).assign(a_2d);
                t.reset().start();
                ((DenseFloatMatrix2D)floatMatrix2D).idct2(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "idct2(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIdctColumns() {
        int n;
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFloatMatrix2D.idctColumns(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFloatMatrix2D.assign(a_2d);
                t.reset().start();
                denseFloatMatrix2D.idctColumns(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseFloatMatrix2D)floatMatrix2D).idctColumns(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseFloatMatrix2D)floatMatrix2D).assign(a_2d);
                t.reset().start();
                ((DenseFloatMatrix2D)floatMatrix2D).idctColumns(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "idctColumns(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIdctRows() {
        int n;
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFloatMatrix2D.idctRows(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFloatMatrix2D.assign(a_2d);
                t.reset().start();
                denseFloatMatrix2D.idctRows(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseFloatMatrix2D)floatMatrix2D).idctRows(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseFloatMatrix2D)floatMatrix2D).assign(a_2d);
                t.reset().start();
                ((DenseFloatMatrix2D)floatMatrix2D).idctRows(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "idctRows(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIdht2() {
        int n;
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFloatMatrix2D.idht2(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFloatMatrix2D.assign(a_2d);
                t.reset().start();
                denseFloatMatrix2D.idht2(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseFloatMatrix2D)floatMatrix2D).idht2(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseFloatMatrix2D)floatMatrix2D).assign(a_2d);
                t.reset().start();
                ((DenseFloatMatrix2D)floatMatrix2D).idht2(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "idht2(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIdhtColumns() {
        int n;
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFloatMatrix2D.idhtColumns(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFloatMatrix2D.assign(a_2d);
                t.reset().start();
                denseFloatMatrix2D.idhtColumns(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseFloatMatrix2D)floatMatrix2D).idhtColumns(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseFloatMatrix2D)floatMatrix2D).assign(a_2d);
                t.reset().start();
                ((DenseFloatMatrix2D)floatMatrix2D).idhtColumns(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "idhtColumns(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIdhtRows() {
        int n;
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFloatMatrix2D.idhtRows(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFloatMatrix2D.assign(a_2d);
                t.reset().start();
                denseFloatMatrix2D.idhtRows(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseFloatMatrix2D)floatMatrix2D).idhtRows(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseFloatMatrix2D)floatMatrix2D).assign(a_2d);
                t.reset().start();
                ((DenseFloatMatrix2D)floatMatrix2D).idhtRows(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "idhtRows(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIdst2() {
        int n;
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFloatMatrix2D.idst2(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFloatMatrix2D.assign(a_2d);
                t.reset().start();
                denseFloatMatrix2D.idst2(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseFloatMatrix2D)floatMatrix2D).idst2(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseFloatMatrix2D)floatMatrix2D).assign(a_2d);
                t.reset().start();
                ((DenseFloatMatrix2D)floatMatrix2D).idst2(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "idst2(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIdstColumns() {
        int n;
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFloatMatrix2D.idstColumns(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFloatMatrix2D.assign(a_2d);
                t.reset().start();
                denseFloatMatrix2D.idstColumns(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseFloatMatrix2D)floatMatrix2D).idstColumns(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseFloatMatrix2D)floatMatrix2D).assign(a_2d);
                t.reset().start();
                ((DenseFloatMatrix2D)floatMatrix2D).idstColumns(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "idstColumns(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIdstRows() {
        int n;
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFloatMatrix2D.idstRows(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFloatMatrix2D.assign(a_2d);
                t.reset().start();
                denseFloatMatrix2D.idstRows(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseFloatMatrix2D)floatMatrix2D).idstRows(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseFloatMatrix2D)floatMatrix2D).assign(a_2d);
                t.reset().start();
                ((DenseFloatMatrix2D)floatMatrix2D).idstRows(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "idstRows(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIfft2() {
        int n;
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFloatMatrix2D.ifft2(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFloatMatrix2D.assign(a_2d);
                t.reset().start();
                denseFloatMatrix2D.ifft2(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseFloatMatrix2D)floatMatrix2D).ifft2(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseFloatMatrix2D)floatMatrix2D).assign(a_2d);
                t.reset().start();
                ((DenseFloatMatrix2D)floatMatrix2D).ifft2(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "ifft2(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testMaxLocation() {
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            float[] fArray = denseFloatMatrix2D.getMaxLocation();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                fArray = denseFloatMatrix2D.getMaxLocation();
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(a_2d).viewDice();
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            float[] fArray = ((DenseFloatMatrix2D)floatMatrix2D).getMaxLocation();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                fArray = ((DenseFloatMatrix2D)floatMatrix2D).getMaxLocation();
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "maxLocation()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testMinLocation() {
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            float[] fArray = denseFloatMatrix2D.getMinLocation();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                fArray = denseFloatMatrix2D.getMinLocation();
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(a_2d).viewDice();
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            float[] fArray = ((DenseFloatMatrix2D)floatMatrix2D).getMinLocation();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                fArray = ((DenseFloatMatrix2D)floatMatrix2D).getMinLocation();
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "minLocation()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testSum() {
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            float f = denseFloatMatrix2D.zSum();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                f = denseFloatMatrix2D.zSum();
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            float f = ((DenseFloatMatrix2D)floatMatrix2D).zSum();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                f = ((DenseFloatMatrix2D)floatMatrix2D).zSum();
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "zSum()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testToArray() {
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            float[][] fArray = denseFloatMatrix2D.toArray();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                fArray = denseFloatMatrix2D.toArray();
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            float[][] fArray = ((DenseFloatMatrix2D)floatMatrix2D).toArray();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                fArray = ((DenseFloatMatrix2D)floatMatrix2D).toArray();
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "toArray()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testVectorize() {
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            FloatMatrix1D floatMatrix1D = denseFloatMatrix2D.vectorize();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                floatMatrix1D = denseFloatMatrix2D.vectorize();
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            FloatMatrix1D floatMatrix1D = ((DenseFloatMatrix2D)floatMatrix2D).vectorize();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                floatMatrix1D = ((DenseFloatMatrix2D)floatMatrix2D).vectorize();
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "vectorize()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testZMultFloatMatrix1DFloatMatrix1DFloatFloatBoolean() {
        int n;
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(denseFloatMatrix2D.columns());
        float f = 3.0f;
        float f2 = 5.0f;
        for (int i = 0; i < denseFloatMatrix1D.size(); ++i) {
            denseFloatMatrix1D.set(i, (float)Math.random());
        }
        DenseFloatMatrix1D denseFloatMatrix1D2 = new DenseFloatMatrix1D(denseFloatMatrix2D.rows());
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFloatMatrix2D.zMult(denseFloatMatrix1D, denseFloatMatrix1D2, f, f2, false);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((FloatMatrix1D)denseFloatMatrix1D2).assign(0.0f);
                t.reset().start();
                denseFloatMatrix2D.zMult(denseFloatMatrix1D, denseFloatMatrix1D2, f, f2, false);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseFloatMatrix2D)floatMatrix2D).zMult(denseFloatMatrix1D, denseFloatMatrix1D2, f, f2, false);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((FloatMatrix1D)denseFloatMatrix1D2).assign(0.0f);
                t.reset().start();
                ((DenseFloatMatrix2D)floatMatrix2D).zMult(denseFloatMatrix1D, denseFloatMatrix1D2, f, f2, false);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "zMult(FloatMatrix1D, FloatMatrix1D, float, float, boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testZMultFloatMatrix2DFloatMatrix2DFloatFloatBooleanBoolean() {
        int n = BenchmarkMatrixKernel.NITERS;
        BenchmarkMatrixKernel.NITERS = 10;
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(b_2d);
        floatMatrix2D = floatMatrix2D.viewDice().copy();
        DenseFloatMatrix2D denseFloatMatrix2D2 = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[0], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]);
        float f = 3.0f;
        float f2 = 5.0f;
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFloatMatrix2D.zMult(floatMatrix2D, denseFloatMatrix2D2, f, f2, false, false);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((FloatMatrix2D)denseFloatMatrix2D2).assign(0.0f);
                t.reset().start();
                denseFloatMatrix2D.zMult(floatMatrix2D, denseFloatMatrix2D2, f, f2, false, false);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        denseFloatMatrix2D = new DenseFloatMatrix2D(a_2d);
        FloatMatrix2D floatMatrix2D2 = denseFloatMatrix2D.viewDice();
        floatMatrix2D = new DenseFloatMatrix2D(b_2d);
        floatMatrix2D = floatMatrix2D.viewDice().copy();
        FloatMatrix2D floatMatrix2D3 = floatMatrix2D.viewDice();
        denseFloatMatrix2D2 = new DenseFloatMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]);
        FloatMatrix2D floatMatrix2D4 = denseFloatMatrix2D2.viewDice();
        int n5 = 0;
        while (n5 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n5]);
            ((DenseFloatMatrix2D)floatMatrix2D2).zMult(floatMatrix2D3, floatMatrix2D4, f, f2, false, false);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                floatMatrix2D4.assign(0.0f);
                t.reset().start();
                ((DenseFloatMatrix2D)floatMatrix2D2).zMult(floatMatrix2D3, floatMatrix2D4, f, f2, false, false);
                t.stop();
                int n6 = n5;
                viewTimes[n6] = viewTimes[n6] + t.millis();
            }
            int n7 = n5++;
            viewTimes[n7] = viewTimes[n7] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "zMult(FloatMatrix2D, FloatMatrix2D, float, float, boolean, boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.NITERS = n;
    }
}

