/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.Timer;
import cern.colt.function.tfloat.FloatFunction;
import cern.colt.function.tfloat.FloatProcedure;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.BenchmarkMatrixKernel;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.jet.math.tfloat.FloatFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.Random;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.JUnitCore;

public class BenchmarkDenseFloatMatrix1D {
    private static final Timer t = new Timer();
    private static final String outputFile = "BenchmarkDenseFloatMatrix1D.txt";
    private static double[] noViewTimes;
    private static double[] viewTimes;
    private static float[] a;
    private static float[] b;
    private static final long millis = 5000L;

    public static void main(String[] stringArray) {
        JUnitCore.main((String[])new String[]{"cern.colt.matrix.tfloat.impl.BenchmarkDenseFloatMatrix1D"});
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        int n;
        BenchmarkMatrixKernel.readSettings1D();
        Random random = new Random(0L);
        ConcurrencyUtils.setThreadsBeginN_1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D);
        a = new float[BenchmarkMatrixKernel.MATRIX_SIZE_1D];
        for (n = 0; n < BenchmarkMatrixKernel.MATRIX_SIZE_1D; ++n) {
            BenchmarkDenseFloatMatrix1D.a[n] = random.nextFloat();
        }
        b = new float[BenchmarkMatrixKernel.MATRIX_SIZE_1D];
        for (n = 0; n < BenchmarkMatrixKernel.MATRIX_SIZE_1D; ++n) {
            BenchmarkDenseFloatMatrix1D.b[n] = random.nextFloat();
        }
        BenchmarkMatrixKernel.writePropertiesToFile(outputFile, new int[]{BenchmarkMatrixKernel.MATRIX_SIZE_1D});
        BenchmarkMatrixKernel.displayProperties(new int[]{BenchmarkMatrixKernel.MATRIX_SIZE_1D});
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        a = null;
        b = null;
        ConcurrencyUtils.resetThreadsBeginN();
        System.gc();
    }

    @Before
    public void setUpBefore() {
        noViewTimes = new double[BenchmarkMatrixKernel.NTHREADS.length];
        viewTimes = new double[BenchmarkMatrixKernel.NTHREADS.length];
    }

    @Test
    public void testAggregateFloatFloatFunctionFloatFunction() {
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(a);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            float f = ((FloatMatrix1D)denseFloatMatrix1D).aggregate(FloatFunctions.plus, FloatFunctions.square);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                f = ((FloatMatrix1D)denseFloatMatrix1D).aggregate(FloatFunctions.plus, FloatFunctions.square);
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
            ConcurrencyUtils.sleep(5000L);
        }
        FloatMatrix1D floatMatrix1D = new DenseFloatMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            float f = floatMatrix1D.aggregate(FloatFunctions.plus, FloatFunctions.square);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                f = floatMatrix1D.aggregate(FloatFunctions.plus, FloatFunctions.square);
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
            ConcurrencyUtils.sleep(5000L);
        }
        String string = "aggregate(FloatFloatFunction, FloatFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignFloatMatrix1D() {
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D);
        DenseFloatMatrix1D denseFloatMatrix1D2 = new DenseFloatMatrix1D(a);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((FloatMatrix1D)denseFloatMatrix1D).assign(denseFloatMatrix1D2);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((FloatMatrix1D)denseFloatMatrix1D).assign(0.0f);
                t.reset().start();
                ((FloatMatrix1D)denseFloatMatrix1D).assign(denseFloatMatrix1D2);
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        denseFloatMatrix1D = new DenseFloatMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D);
        FloatMatrix1D floatMatrix1D = denseFloatMatrix1D.viewFlip();
        denseFloatMatrix1D2 = new DenseFloatMatrix1D(a);
        FloatMatrix1D floatMatrix1D2 = denseFloatMatrix1D2.viewFlip();
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            floatMatrix1D.assign(floatMatrix1D2);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                floatMatrix1D.assign(0.0f);
                t.reset().start();
                floatMatrix1D.assign(floatMatrix1D2);
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(FloatMatrix1D)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testZDotProductFloatMatrix1D() {
        int n;
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(a);
        DenseFloatMatrix1D denseFloatMatrix1D2 = new DenseFloatMatrix1D(b);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            float f = denseFloatMatrix1D.zDotProduct(denseFloatMatrix1D2);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                t.reset().start();
                f = denseFloatMatrix1D.zDotProduct(denseFloatMatrix1D2);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        denseFloatMatrix1D = new DenseFloatMatrix1D(a);
        FloatMatrix1D floatMatrix1D = denseFloatMatrix1D.viewFlip();
        denseFloatMatrix1D2 = new DenseFloatMatrix1D(b);
        FloatMatrix1D floatMatrix1D2 = denseFloatMatrix1D2.viewFlip();
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            float f = floatMatrix1D.zDotProduct(floatMatrix1D2);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                f = floatMatrix1D.zDotProduct(floatMatrix1D2);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "zDotProduct(FloatMatrix1D, int, int)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignFloatFunction() {
        int n;
        FloatFunction floatFunction = FloatFunctions.mult(2.5f);
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(a);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((FloatMatrix1D)denseFloatMatrix1D).assign(floatFunction);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((FloatMatrix1D)denseFloatMatrix1D).assign(a);
                t.reset().start();
                ((FloatMatrix1D)denseFloatMatrix1D).assign(floatFunction);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix1D floatMatrix1D = new DenseFloatMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            floatMatrix1D.assign(floatFunction);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                floatMatrix1D.assign(a);
                t.reset().start();
                floatMatrix1D.assign(floatFunction);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(FloatFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignFloatMatrix1DFloatFloatFunction() {
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(a);
        DenseFloatMatrix1D denseFloatMatrix1D2 = new DenseFloatMatrix1D(b);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((FloatMatrix1D)denseFloatMatrix1D).assign(denseFloatMatrix1D2, FloatFunctions.div);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((FloatMatrix1D)denseFloatMatrix1D).assign(a);
                t.reset().start();
                ((FloatMatrix1D)denseFloatMatrix1D).assign(denseFloatMatrix1D2, FloatFunctions.div);
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix1D floatMatrix1D = new DenseFloatMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        FloatMatrix1D floatMatrix1D2 = new DenseFloatMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(b);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            floatMatrix1D.assign(floatMatrix1D2, FloatFunctions.div);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                floatMatrix1D.assign(a);
                t.reset().start();
                floatMatrix1D.assign(floatMatrix1D2, FloatFunctions.div);
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(FloatMatrix1D, FloatFloatFuction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAggregateFloatMatrix1DFloatFloatFunctionFloatFloatFunction() {
        int n;
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(a);
        DenseFloatMatrix1D denseFloatMatrix1D2 = new DenseFloatMatrix1D(b);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            float f = ((FloatMatrix1D)denseFloatMatrix1D).aggregate(denseFloatMatrix1D2, FloatFunctions.plus, FloatFunctions.mult);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                t.reset().start();
                f = ((FloatMatrix1D)denseFloatMatrix1D).aggregate(denseFloatMatrix1D2, FloatFunctions.plus, FloatFunctions.mult);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix1D floatMatrix1D = new DenseFloatMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        FloatMatrix1D floatMatrix1D2 = new DenseFloatMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(b);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            float f = floatMatrix1D.aggregate(floatMatrix1D2, FloatFunctions.plus, FloatFunctions.mult);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                f = floatMatrix1D.aggregate(floatMatrix1D2, FloatFunctions.plus, FloatFunctions.mult);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "aggregate(FloatMatrix1D, FloatFloatFunction, FloatFloatFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignFloat() {
        int n;
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D);
        float f = (float)Math.random();
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((FloatMatrix1D)denseFloatMatrix1D).assign(f);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((FloatMatrix1D)denseFloatMatrix1D).assign(0.0f);
                t.reset().start();
                ((FloatMatrix1D)denseFloatMatrix1D).assign(f);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix1D floatMatrix1D = new DenseFloatMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip();
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            floatMatrix1D.assign(f);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                floatMatrix1D.assign(0.0f);
                t.reset().start();
                floatMatrix1D.assign(f);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(float)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignFloatArray() {
        int n;
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((FloatMatrix1D)denseFloatMatrix1D).assign(a);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((FloatMatrix1D)denseFloatMatrix1D).assign(0.0f);
                t.reset().start();
                ((FloatMatrix1D)denseFloatMatrix1D).assign(a);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix1D floatMatrix1D = new DenseFloatMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip();
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            floatMatrix1D.assign(a);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                floatMatrix1D.assign(0.0f);
                t.reset().start();
                floatMatrix1D.assign(a);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(float[])";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignFloatProcedureFloat() {
        int n;
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(a);
        FloatProcedure floatProcedure = new FloatProcedure(){

            public boolean apply(float f) {
                return (double)Math.abs(f) > 0.1;
            }
        };
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((FloatMatrix1D)denseFloatMatrix1D).assign(floatProcedure, -1.0f);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((FloatMatrix1D)denseFloatMatrix1D).assign(a);
                t.reset().start();
                ((FloatMatrix1D)denseFloatMatrix1D).assign(floatProcedure, -1.0f);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix1D floatMatrix1D = new DenseFloatMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            floatMatrix1D.assign(floatProcedure, -1.0f);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                floatMatrix1D.assign(a);
                t.reset().start();
                floatMatrix1D.assign(floatProcedure, -1.0f);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(FloatProcedure, float)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignFloatProcedureFloatFunction() {
        int n;
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(a);
        FloatProcedure floatProcedure = new FloatProcedure(){

            public boolean apply(float f) {
                return (double)Math.abs(f) > 0.1;
            }
        };
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((FloatMatrix1D)denseFloatMatrix1D).assign(floatProcedure, FloatFunctions.square);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((FloatMatrix1D)denseFloatMatrix1D).assign(a);
                t.reset().start();
                ((FloatMatrix1D)denseFloatMatrix1D).assign(floatProcedure, FloatFunctions.square);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix1D floatMatrix1D = new DenseFloatMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            floatMatrix1D.assign(floatProcedure, FloatFunctions.square);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                floatMatrix1D.assign(a);
                t.reset().start();
                floatMatrix1D.assign(floatProcedure, FloatFunctions.square);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(FloatProcedure, FloatFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testCardinality() {
        int n;
        int n2;
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(a);
        int n3 = 0;
        while (n3 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n3]);
            n2 = ((FloatMatrix1D)denseFloatMatrix1D).cardinality();
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                t.reset().start();
                n2 = ((FloatMatrix1D)denseFloatMatrix1D).cardinality();
                t.stop();
                int n4 = n3;
                noViewTimes[n4] = noViewTimes[n4] + t.millis();
            }
            int n5 = n3++;
            noViewTimes[n5] = noViewTimes[n5] / (double)BenchmarkMatrixKernel.NITERS;
        }
        denseFloatMatrix1D = new DenseFloatMatrix1D(a);
        FloatMatrix1D floatMatrix1D = denseFloatMatrix1D.viewFlip();
        n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            n = floatMatrix1D.cardinality();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                n = floatMatrix1D.cardinality();
                t.stop();
                int n6 = n2;
                viewTimes[n6] = viewTimes[n6] + t.millis();
            }
            int n7 = n2++;
            viewTimes[n7] = viewTimes[n7] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "cardinality()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testFft() {
        int n;
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(a);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ConcurrencyUtils.setThreadsBeginN_1D(1);
            switch (BenchmarkMatrixKernel.NTHREADS[n2]) {
                case 1: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                case 2: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                default: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(1);
                }
            }
            denseFloatMatrix1D.fft();
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFloatMatrix1D.assign(a);
                t.reset().start();
                denseFloatMatrix1D.fft();
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix1D floatMatrix1D = new DenseFloatMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ConcurrencyUtils.setThreadsBeginN_1D(1);
            switch (BenchmarkMatrixKernel.NTHREADS[n]) {
                case 1: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                case 2: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                default: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(1);
                }
            }
            ((DenseFloatMatrix1D)floatMatrix1D).fft();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseFloatMatrix1D)floatMatrix1D).assign(a);
                t.reset().start();
                ((DenseFloatMatrix1D)floatMatrix1D).fft();
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "fft()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testDct() {
        int n;
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(a);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ConcurrencyUtils.setThreadsBeginN_1D(1);
            switch (BenchmarkMatrixKernel.NTHREADS[n2]) {
                case 1: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                case 2: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                default: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(1);
                }
            }
            denseFloatMatrix1D.dct(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFloatMatrix1D.assign(a);
                t.reset().start();
                denseFloatMatrix1D.dct(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix1D floatMatrix1D = new DenseFloatMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ConcurrencyUtils.setThreadsBeginN_1D(1);
            switch (BenchmarkMatrixKernel.NTHREADS[n]) {
                case 1: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                case 2: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                default: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(1);
                }
            }
            ((DenseFloatMatrix1D)floatMatrix1D).dct(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseFloatMatrix1D)floatMatrix1D).assign(a);
                t.reset().start();
                ((DenseFloatMatrix1D)floatMatrix1D).dct(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "dct(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testDht() {
        int n;
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(a);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ConcurrencyUtils.setThreadsBeginN_1D(1);
            switch (BenchmarkMatrixKernel.NTHREADS[n2]) {
                case 1: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                case 2: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                default: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(1);
                }
            }
            denseFloatMatrix1D.dht();
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFloatMatrix1D.assign(a);
                t.reset().start();
                denseFloatMatrix1D.dht();
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix1D floatMatrix1D = new DenseFloatMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ConcurrencyUtils.setThreadsBeginN_1D(1);
            switch (BenchmarkMatrixKernel.NTHREADS[n]) {
                case 1: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                case 2: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                default: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(1);
                }
            }
            ((DenseFloatMatrix1D)floatMatrix1D).dht();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseFloatMatrix1D)floatMatrix1D).assign(a);
                t.reset().start();
                ((DenseFloatMatrix1D)floatMatrix1D).dht();
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "dht()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testDst() {
        int n;
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(a);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ConcurrencyUtils.setThreadsBeginN_1D(1);
            switch (BenchmarkMatrixKernel.NTHREADS[n2]) {
                case 1: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                case 2: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                default: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(1);
                }
            }
            denseFloatMatrix1D.dst(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFloatMatrix1D.assign(a);
                t.reset().start();
                denseFloatMatrix1D.dst(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix1D floatMatrix1D = new DenseFloatMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ConcurrencyUtils.setThreadsBeginN_1D(1);
            switch (BenchmarkMatrixKernel.NTHREADS[n]) {
                case 1: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                case 2: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                default: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(1);
                }
            }
            ((DenseFloatMatrix1D)floatMatrix1D).dst(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseFloatMatrix1D)floatMatrix1D).assign(a);
                t.reset().start();
                ((DenseFloatMatrix1D)floatMatrix1D).dst(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "dst(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetFft() {
        int n;
        DenseFComplexMatrix1D denseFComplexMatrix1D;
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(a);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ConcurrencyUtils.setThreadsBeginN_1D(1);
            switch (BenchmarkMatrixKernel.NTHREADS[n2]) {
                case 1: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                case 2: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                default: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(1);
                }
            }
            denseFComplexMatrix1D = denseFloatMatrix1D.getFft();
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFloatMatrix1D.assign(a);
                t.reset().start();
                denseFComplexMatrix1D = denseFloatMatrix1D.getFft();
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix1D floatMatrix1D = new DenseFloatMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ConcurrencyUtils.setThreadsBeginN_1D(1);
            switch (BenchmarkMatrixKernel.NTHREADS[n]) {
                case 1: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                case 2: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                default: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(1);
                }
            }
            denseFComplexMatrix1D = ((DenseFloatMatrix1D)floatMatrix1D).getFft();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseFloatMatrix1D)floatMatrix1D).assign(a);
                t.reset().start();
                denseFComplexMatrix1D = ((DenseFloatMatrix1D)floatMatrix1D).getFft();
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getFft()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetIfft() {
        int n;
        DenseFComplexMatrix1D denseFComplexMatrix1D;
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(a);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ConcurrencyUtils.setThreadsBeginN_1D(1);
            switch (BenchmarkMatrixKernel.NTHREADS[n2]) {
                case 1: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                case 2: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                default: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(1);
                }
            }
            denseFComplexMatrix1D = denseFloatMatrix1D.getIfft(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFloatMatrix1D.assign(a);
                t.reset().start();
                denseFComplexMatrix1D = denseFloatMatrix1D.getIfft(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix1D floatMatrix1D = new DenseFloatMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ConcurrencyUtils.setThreadsBeginN_1D(1);
            switch (BenchmarkMatrixKernel.NTHREADS[n]) {
                case 1: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                case 2: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                default: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(1);
                }
            }
            denseFComplexMatrix1D = ((DenseFloatMatrix1D)floatMatrix1D).getIfft(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseFloatMatrix1D)floatMatrix1D).assign(a);
                t.reset().start();
                denseFComplexMatrix1D = ((DenseFloatMatrix1D)floatMatrix1D).getIfft(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getIfft(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetPositiveValuesIntArrayListFloatArrayList() {
        int n;
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(a);
        IntArrayList intArrayList = new IntArrayList();
        FloatArrayList floatArrayList = new FloatArrayList();
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFloatMatrix1D.getPositiveValues(intArrayList, floatArrayList);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                intArrayList.clear();
                floatArrayList.clear();
                t.reset().start();
                denseFloatMatrix1D.getPositiveValues(intArrayList, floatArrayList);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix1D floatMatrix1D = new DenseFloatMatrix1D(a).viewFlip();
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseFloatMatrix1D)floatMatrix1D).getPositiveValues(intArrayList, floatArrayList);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                intArrayList.clear();
                floatArrayList.clear();
                t.reset().start();
                ((DenseFloatMatrix1D)floatMatrix1D).getPositiveValues(intArrayList, floatArrayList);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getPositiveValues(IntArrayList, FloatArrayList)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetNegativeValuesIntArrayListFloatArrayList() {
        int n;
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(a);
        denseFloatMatrix1D.assign(FloatFunctions.mult(-1.0f));
        IntArrayList intArrayList = new IntArrayList();
        FloatArrayList floatArrayList = new FloatArrayList();
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFloatMatrix1D.getNegativeValues(intArrayList, floatArrayList);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                intArrayList.clear();
                floatArrayList.clear();
                t.reset().start();
                denseFloatMatrix1D.getNegativeValues(intArrayList, floatArrayList);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix1D floatMatrix1D = new DenseFloatMatrix1D(a).viewFlip();
        ((DenseFloatMatrix1D)floatMatrix1D).assign(FloatFunctions.mult(-1.0f));
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseFloatMatrix1D)floatMatrix1D).getNegativeValues(intArrayList, floatArrayList);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                intArrayList.clear();
                floatArrayList.clear();
                t.reset().start();
                ((DenseFloatMatrix1D)floatMatrix1D).getNegativeValues(intArrayList, floatArrayList);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getNegativeValues(IntArrayList, FloatArrayList)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIdct() {
        int n;
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(a);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ConcurrencyUtils.setThreadsBeginN_1D(1);
            switch (BenchmarkMatrixKernel.NTHREADS[n2]) {
                case 1: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                case 2: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                default: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(1);
                }
            }
            denseFloatMatrix1D.idct(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFloatMatrix1D.assign(a);
                t.reset().start();
                denseFloatMatrix1D.idct(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix1D floatMatrix1D = new DenseFloatMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ConcurrencyUtils.setThreadsBeginN_1D(1);
            switch (BenchmarkMatrixKernel.NTHREADS[n]) {
                case 1: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                case 2: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                default: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(1);
                }
            }
            ((DenseFloatMatrix1D)floatMatrix1D).idct(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseFloatMatrix1D)floatMatrix1D).assign(a);
                t.reset().start();
                ((DenseFloatMatrix1D)floatMatrix1D).idct(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "idct(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIdht() {
        int n;
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(a);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ConcurrencyUtils.setThreadsBeginN_1D(1);
            switch (BenchmarkMatrixKernel.NTHREADS[n2]) {
                case 1: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                case 2: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                default: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(1);
                }
            }
            denseFloatMatrix1D.idht(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFloatMatrix1D.assign(a);
                t.reset().start();
                denseFloatMatrix1D.idht(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix1D floatMatrix1D = new DenseFloatMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ConcurrencyUtils.setThreadsBeginN_1D(1);
            switch (BenchmarkMatrixKernel.NTHREADS[n]) {
                case 1: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                case 2: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                default: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(1);
                }
            }
            ((DenseFloatMatrix1D)floatMatrix1D).idht(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseFloatMatrix1D)floatMatrix1D).assign(a);
                t.reset().start();
                ((DenseFloatMatrix1D)floatMatrix1D).idht(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "idht(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIdst() {
        int n;
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(a);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ConcurrencyUtils.setThreadsBeginN_1D(1);
            switch (BenchmarkMatrixKernel.NTHREADS[n2]) {
                case 1: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                case 2: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                default: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(1);
                }
            }
            denseFloatMatrix1D.idst(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFloatMatrix1D.assign(a);
                t.reset().start();
                denseFloatMatrix1D.idst(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix1D floatMatrix1D = new DenseFloatMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ConcurrencyUtils.setThreadsBeginN_1D(1);
            switch (BenchmarkMatrixKernel.NTHREADS[n]) {
                case 1: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                case 2: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                default: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(1);
                }
            }
            ((DenseFloatMatrix1D)floatMatrix1D).idst(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseFloatMatrix1D)floatMatrix1D).assign(a);
                t.reset().start();
                ((DenseFloatMatrix1D)floatMatrix1D).idst(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "idst(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIfft() {
        int n;
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(a);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ConcurrencyUtils.setThreadsBeginN_1D(1);
            switch (BenchmarkMatrixKernel.NTHREADS[n2]) {
                case 1: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                case 2: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                default: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(1);
                }
            }
            denseFloatMatrix1D.ifft(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFloatMatrix1D.assign(a);
                t.reset().start();
                denseFloatMatrix1D.ifft(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix1D floatMatrix1D = new DenseFloatMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ConcurrencyUtils.setThreadsBeginN_1D(1);
            switch (BenchmarkMatrixKernel.NTHREADS[n]) {
                case 1: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                case 2: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                default: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(1);
                }
            }
            ((DenseFloatMatrix1D)floatMatrix1D).ifft(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DenseFloatMatrix1D)floatMatrix1D).assign(a);
                t.reset().start();
                ((DenseFloatMatrix1D)floatMatrix1D).ifft(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "ifft(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testMaxLocation() {
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(a);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            float[] fArray = denseFloatMatrix1D.getMaxLocation();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                fArray = denseFloatMatrix1D.getMaxLocation();
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix1D floatMatrix1D = new DenseFloatMatrix1D(a).viewFlip();
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            float[] fArray = ((DenseFloatMatrix1D)floatMatrix1D).getMaxLocation();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                fArray = ((DenseFloatMatrix1D)floatMatrix1D).getMaxLocation();
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "maxLocation()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testMinLocation() {
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(a);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            float[] fArray = denseFloatMatrix1D.getMinLocation();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                fArray = denseFloatMatrix1D.getMinLocation();
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix1D floatMatrix1D = new DenseFloatMatrix1D(a).viewFlip();
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            float[] fArray = ((DenseFloatMatrix1D)floatMatrix1D).getMinLocation();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                fArray = ((DenseFloatMatrix1D)floatMatrix1D).getMinLocation();
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "minLocation()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testReshapeIntInt() {
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(a);
        int n = BenchmarkMatrixKernel.MATRIX_SIZE_1D / 64;
        int n2 = 64;
        int n3 = 0;
        while (n3 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n3]);
            FloatMatrix2D floatMatrix2D = denseFloatMatrix1D.reshape(n, n2);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                floatMatrix2D = denseFloatMatrix1D.reshape(n, n2);
                t.stop();
                int n4 = n3;
                noViewTimes[n4] = noViewTimes[n4] + t.millis();
            }
            int n5 = n3++;
            noViewTimes[n5] = noViewTimes[n5] / (double)BenchmarkMatrixKernel.NITERS;
        }
        denseFloatMatrix1D = new DenseFloatMatrix1D(a);
        FloatMatrix1D floatMatrix1D = denseFloatMatrix1D.viewFlip();
        int n6 = 0;
        while (n6 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n6]);
            FloatMatrix2D floatMatrix2D = ((DenseFloatMatrix1D)floatMatrix1D).reshape(n, n2);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                floatMatrix2D = ((DenseFloatMatrix1D)floatMatrix1D).reshape(n, n2);
                t.stop();
                int n7 = n6;
                viewTimes[n7] = viewTimes[n7] + t.millis();
            }
            int n8 = n6++;
            viewTimes[n8] = viewTimes[n8] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "reshape(int, int)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testReshapeIntIntInt() {
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(a);
        int n = BenchmarkMatrixKernel.MATRIX_SIZE_1D / 64;
        int n2 = 16;
        int n3 = 4;
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            FloatMatrix3D floatMatrix3D = denseFloatMatrix1D.reshape(n, n2, n3);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                floatMatrix3D = denseFloatMatrix1D.reshape(n, n2, n3);
                t.stop();
                int n5 = n4;
                noViewTimes[n5] = noViewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            noViewTimes[n6] = noViewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        denseFloatMatrix1D = new DenseFloatMatrix1D(a);
        FloatMatrix1D floatMatrix1D = denseFloatMatrix1D.viewFlip();
        int n7 = 0;
        while (n7 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n7]);
            FloatMatrix3D floatMatrix3D = ((DenseFloatMatrix1D)floatMatrix1D).reshape(n, n2, n3);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                floatMatrix3D = ((DenseFloatMatrix1D)floatMatrix1D).reshape(n, n2, n3);
                t.stop();
                int n8 = n7;
                viewTimes[n8] = viewTimes[n8] + t.millis();
            }
            int n9 = n7++;
            viewTimes[n9] = viewTimes[n9] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "reshape(int, int, int)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testSwapFloatMatrix1D() {
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(a);
        DenseFloatMatrix1D denseFloatMatrix1D2 = new DenseFloatMatrix1D(b);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            denseFloatMatrix1D.swap(denseFloatMatrix1D2);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                denseFloatMatrix1D.swap(denseFloatMatrix1D2);
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        denseFloatMatrix1D = new DenseFloatMatrix1D(a);
        FloatMatrix1D floatMatrix1D = denseFloatMatrix1D.viewFlip();
        denseFloatMatrix1D2 = new DenseFloatMatrix1D(b);
        FloatMatrix1D floatMatrix1D2 = denseFloatMatrix1D2.viewFlip();
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            ((DenseFloatMatrix1D)floatMatrix1D).swap(floatMatrix1D2);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                ((DenseFloatMatrix1D)floatMatrix1D).swap(floatMatrix1D2);
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "swap(FloatMatrix1D)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testToArrayFloatArray() {
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(a);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            float[] fArray = denseFloatMatrix1D.toArray();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                fArray = denseFloatMatrix1D.toArray();
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix1D floatMatrix1D = new DenseFloatMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            float[] fArray = ((DenseFloatMatrix1D)floatMatrix1D).toArray();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                fArray = ((DenseFloatMatrix1D)floatMatrix1D).toArray();
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "toArray()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testZDotProductFloatMatrix1DIntInt() {
        int n;
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(a);
        DenseFloatMatrix1D denseFloatMatrix1D2 = new DenseFloatMatrix1D(b);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            float f = denseFloatMatrix1D.zDotProduct(denseFloatMatrix1D2, 5, denseFloatMatrix1D2.size() - 10);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                t.reset().start();
                f = denseFloatMatrix1D.zDotProduct(denseFloatMatrix1D2, 5, denseFloatMatrix1D2.size() - 10);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        denseFloatMatrix1D = new DenseFloatMatrix1D(a);
        FloatMatrix1D floatMatrix1D = denseFloatMatrix1D.viewFlip();
        denseFloatMatrix1D2 = new DenseFloatMatrix1D(b);
        FloatMatrix1D floatMatrix1D2 = denseFloatMatrix1D2.viewFlip();
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            float f = ((DenseFloatMatrix1D)floatMatrix1D).zDotProduct(floatMatrix1D2, 5, floatMatrix1D2.size() - 10);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                f = ((DenseFloatMatrix1D)floatMatrix1D).zDotProduct(floatMatrix1D2, 5, floatMatrix1D2.size() - 10);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "zDotProduct(FloatMatrix1D, int, int)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testZSum() {
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(a);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            float f = denseFloatMatrix1D.zSum();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                f = denseFloatMatrix1D.zSum();
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FloatMatrix1D floatMatrix1D = new DenseFloatMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            float f = ((DenseFloatMatrix1D)floatMatrix1D).zSum();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                f = ((DenseFloatMatrix1D)floatMatrix1D).zSum();
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "zSum()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }
}

