/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver.preconditioner;

import cern.colt.matrix.Norm;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.FloatAlgebra;
import cern.colt.matrix.tfloat.algo.solver.preconditioner.FloatPreconditioner;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.RCMFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix1D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FloatILUT
implements FloatPreconditioner {
    private final RCMFloatMatrix2D LU;
    private final FloatMatrix1D y;
    private final float tau;
    private final List<IntFloatEntry> lower;
    private final List<IntFloatEntry> upper;
    private final int p;

    public FloatILUT(RCMFloatMatrix2D rCMFloatMatrix2D, float f, int n) {
        if (rCMFloatMatrix2D.rows() != rCMFloatMatrix2D.columns()) {
            throw new IllegalArgumentException("ILUT only applies to square matrices");
        }
        this.LU = rCMFloatMatrix2D;
        this.tau = f;
        this.p = n;
        int n2 = rCMFloatMatrix2D.rows();
        this.lower = new ArrayList<IntFloatEntry>(n2);
        this.upper = new ArrayList<IntFloatEntry>(n2);
        this.y = new DenseFloatMatrix1D(n2);
    }

    public FloatILUT(RCMFloatMatrix2D rCMFloatMatrix2D) {
        this(rCMFloatMatrix2D, 1.0E-6f, 25);
    }

    public FloatMatrix1D apply(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
        if (floatMatrix1D2 == null) {
            floatMatrix1D2 = floatMatrix1D.like();
        }
        this.unitLowerSolve(floatMatrix1D, this.y);
        return this.upperSolve(this.y, floatMatrix1D2);
    }

    public FloatMatrix1D transApply(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
        if (floatMatrix1D2 == null) {
            floatMatrix1D2 = floatMatrix1D.like();
        }
        this.upperTransSolve(floatMatrix1D, this.y);
        return this.unitLowerTransSolve(this.y, floatMatrix1D2);
    }

    public void setMatrix(FloatMatrix2D floatMatrix2D) {
        this.LU.assign(floatMatrix2D);
        this.LU.trimToSize();
        this.factor();
    }

    private void factor() {
        int n = this.LU.rows();
        for (int i = 1; i < n; ++i) {
            SparseFloatMatrix1D sparseFloatMatrix1D = this.LU.viewRow(i);
            float f = FloatAlgebra.DEFAULT.norm(sparseFloatMatrix1D, Norm.Two) * this.tau;
            for (int j = 0; j < i; ++j) {
                SparseFloatMatrix1D sparseFloatMatrix1D2 = this.LU.viewRow(j);
                if (sparseFloatMatrix1D2.getQuick(j) == 0.0f) {
                    throw new RuntimeException("Zero diagonal entry on row " + (j + 1) + " during ILU process");
                }
                float f2 = sparseFloatMatrix1D.getQuick(j) / sparseFloatMatrix1D2.getQuick(j);
                if (Math.abs(f2) <= f) continue;
                int n2 = sparseFloatMatrix1D2.size();
                for (int k = j + 1; k < n2; ++k) {
                    sparseFloatMatrix1D.setQuick(k, sparseFloatMatrix1D.getQuick(k) - f2 * sparseFloatMatrix1D2.getQuick(k));
                }
                sparseFloatMatrix1D.setQuick(j, f2);
            }
            this.gather(sparseFloatMatrix1D, f, i);
        }
    }

    private void gather(SparseFloatMatrix1D sparseFloatMatrix1D, float f, int n) {
        IntFloatEntry intFloatEntry;
        int n2;
        int n3 = 0;
        int n4 = 0;
        long[] lArray = sparseFloatMatrix1D.elements().keys().elements();
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] < (long)n) {
                ++n3;
                continue;
            }
            if (lArray[i] <= (long)n) continue;
            ++n4;
        }
        float[] fArray = sparseFloatMatrix1D.toArray();
        sparseFloatMatrix1D.assign(0.0f);
        this.lower.clear();
        for (n2 = 0; n2 < n; ++n2) {
            if (!(Math.abs(fArray[n2]) > f)) continue;
            this.lower.add(new IntFloatEntry(n2, fArray[n2]));
        }
        this.upper.clear();
        for (n2 = n + 1; n2 < fArray.length; ++n2) {
            if (!(Math.abs(fArray[n2]) > f)) continue;
            this.upper.add(new IntFloatEntry(n2, fArray[n2]));
        }
        Collections.sort(this.lower);
        Collections.sort(this.upper);
        sparseFloatMatrix1D.setQuick(n, fArray[n]);
        for (n2 = 0; n2 < Math.min(n3 + this.p, this.lower.size()); ++n2) {
            intFloatEntry = this.lower.get(n2);
            sparseFloatMatrix1D.setQuick(intFloatEntry.index, intFloatEntry.value);
        }
        for (n2 = 0; n2 < Math.min(n4 + this.p, this.upper.size()); ++n2) {
            intFloatEntry = this.upper.get(n2);
            sparseFloatMatrix1D.setQuick(intFloatEntry.index, intFloatEntry.value);
        }
    }

    private FloatMatrix1D unitLowerSolve(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
        float[] fArray = ((DenseFloatMatrix1D)floatMatrix1D).elements();
        float[] fArray2 = ((DenseFloatMatrix1D)floatMatrix1D2).elements();
        int n = this.LU.rows();
        for (int i = 0; i < n; ++i) {
            SparseFloatMatrix1D sparseFloatMatrix1D = this.LU.viewRow(i);
            float f = 0.0f;
            for (int j = 0; j < i; ++j) {
                f += sparseFloatMatrix1D.getQuick(j) * fArray2[j];
            }
            fArray2[i] = fArray[i] - f;
        }
        return floatMatrix1D2;
    }

    private FloatMatrix1D unitLowerTransSolve(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
        floatMatrix1D2.assign(floatMatrix1D);
        float[] fArray = ((DenseFloatMatrix1D)floatMatrix1D2).elements();
        int n = this.LU.rows();
        for (int i = n - 1; i >= 0; --i) {
            SparseFloatMatrix1D sparseFloatMatrix1D = this.LU.viewRow(i);
            for (int j = 0; j < i; ++j) {
                int n2 = j;
                fArray[n2] = fArray[n2] - sparseFloatMatrix1D.getQuick(j) * fArray[i];
            }
        }
        return floatMatrix1D2;
    }

    private FloatMatrix1D upperSolve(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
        float[] fArray = ((DenseFloatMatrix1D)floatMatrix1D).elements();
        float[] fArray2 = ((DenseFloatMatrix1D)floatMatrix1D2).elements();
        int n = this.LU.rows();
        for (int i = n - 1; i >= 0; --i) {
            SparseFloatMatrix1D sparseFloatMatrix1D = this.LU.viewRow(i);
            int n2 = sparseFloatMatrix1D.size();
            float f = 0.0f;
            for (int j = i + 1; j < n2; ++j) {
                f += sparseFloatMatrix1D.getQuick(j) * fArray2[j];
            }
            fArray2[i] = (fArray[i] - f) / sparseFloatMatrix1D.getQuick(i);
        }
        return floatMatrix1D2;
    }

    private FloatMatrix1D upperTransSolve(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
        floatMatrix1D2.assign(floatMatrix1D);
        float[] fArray = ((DenseFloatMatrix1D)floatMatrix1D2).elements();
        int n = this.LU.rows();
        for (int i = 0; i < n; ++i) {
            SparseFloatMatrix1D sparseFloatMatrix1D = this.LU.viewRow(i);
            int n2 = sparseFloatMatrix1D.size();
            int n3 = i;
            fArray[n3] = fArray[n3] / sparseFloatMatrix1D.getQuick(i);
            for (int j = i + 1; j < n2; ++j) {
                int n4 = j;
                fArray[n4] = fArray[n4] - sparseFloatMatrix1D.getQuick(j) * fArray[i];
            }
        }
        return floatMatrix1D2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntFloatEntry
    implements Comparable<IntFloatEntry> {
        public int index;
        public float value;

        public IntFloatEntry(int n, float f) {
            this.index = n;
            this.value = f;
        }

        @Override
        public int compareTo(IntFloatEntry intFloatEntry) {
            if (Math.abs(this.value) < Math.abs(intFloatEntry.value)) {
                return 1;
            }
            if (Math.abs(this.value) == Math.abs(intFloatEntry.value)) {
                return 0;
            }
            return -1;
        }

        public String toString() {
            return "(" + this.index + "=" + this.value + ")";
        }
    }
}

