/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver.preconditioner;

import cern.colt.Sorting;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.decomposition.FloatLUDecompositionQuick;
import cern.colt.matrix.tfloat.algo.solver.preconditioner.FloatPreconditioner;
import cern.colt.matrix.tfloat.impl.CCFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.CCMFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.RCFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.RCMFloatMatrix2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FloatAMG
implements FloatPreconditioner {
    private SSOR[] preM;
    private SSOR[] postM;
    private int m;
    private RCFloatMatrix2D[] A;
    private FloatLUDecompositionQuick lu;
    private DenseFloatMatrix1D[] u;
    private DenseFloatMatrix1D[] f;
    private DenseFloatMatrix1D[] r;
    private CCFloatMatrix2D[] I;
    private final int min;
    private final int nu1;
    private final int nu2;
    private final int gamma;
    private final float omegaPreF;
    private final float omegaPreR;
    private final float omegaPostF;
    private final float omegaPostR;
    private final boolean reverse;
    private final float omega;
    private boolean transpose;

    public FloatAMG(float f, float f2, float f3, float f4, int n, int n2, int n3, int n4, float f5) {
        this.omegaPreF = f;
        this.omegaPreR = f2;
        this.omegaPostF = f3;
        this.omegaPostR = f4;
        this.reverse = true;
        this.nu1 = n;
        this.nu2 = n2;
        this.gamma = n3;
        this.min = n4;
        this.omega = f5;
    }

    public FloatAMG(float f, float f2, int n, int n2, int n3, int n4, float f3) {
        this.omegaPreF = f;
        this.omegaPreR = f;
        this.omegaPostF = f2;
        this.omegaPostR = f2;
        this.reverse = false;
        this.nu1 = n;
        this.nu2 = n2;
        this.gamma = n3;
        this.min = n4;
        this.omega = f3;
    }

    public FloatAMG() {
        this(1.0f, 1.85f, 1.85f, 1.0f, 1, 1, 1, 40, 0.6666667f);
    }

    public FloatMatrix1D apply(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
        if (floatMatrix1D2 == null) {
            floatMatrix1D2 = floatMatrix1D.like();
        }
        this.u[0].assign(floatMatrix1D2);
        this.f[0].assign(floatMatrix1D);
        this.transpose = false;
        this.cycle(0);
        return floatMatrix1D2.assign(this.u[0]);
    }

    public FloatMatrix1D transApply(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
        if (floatMatrix1D2 == null) {
            floatMatrix1D2 = floatMatrix1D.like();
        }
        this.u[0].assign(floatMatrix1D2);
        this.f[0].assign(floatMatrix1D);
        this.transpose = true;
        this.cycle(0);
        return floatMatrix1D2.assign(this.u[0]);
    }

    public void setMatrix(FloatMatrix2D floatMatrix2D) {
        int n;
        float f;
        RCFloatMatrix2D rCFloatMatrix2D;
        Aggregator aggregator;
        LinkedList<RCFloatMatrix2D> linkedList = new LinkedList<RCFloatMatrix2D>();
        LinkedList<CCFloatMatrix2D> linkedList2 = new LinkedList<CCFloatMatrix2D>();
        linkedList.add((RCFloatMatrix2D)new RCFloatMatrix2D(floatMatrix2D.rows(), floatMatrix2D.columns()).assign(floatMatrix2D));
        int n2 = 0;
        while (((RCFloatMatrix2D)linkedList.get(n2)).rows() > this.min && (aggregator = new Aggregator(rCFloatMatrix2D = (RCFloatMatrix2D)linkedList.get(n2), f = (float)(0.08 * Math.pow(0.5, n2)))).getAggregates().size() != 0) {
            Interpolator interpolator = new Interpolator(aggregator, rCFloatMatrix2D, this.omega);
            linkedList.add(interpolator.getGalerkinOperator());
            linkedList2.add(interpolator.getInterpolationOperator());
            ++n2;
        }
        this.m = linkedList.size();
        if (this.m == 0) {
            throw new RuntimeException("Matrix too small for AMG");
        }
        this.I = new CCFloatMatrix2D[this.m - 1];
        this.A = new RCFloatMatrix2D[this.m - 1];
        linkedList2.toArray(this.I);
        for (n2 = 0; n2 < linkedList.size() - 1; ++n2) {
            this.A[n2] = (RCFloatMatrix2D)linkedList.get(n2);
        }
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(((RCFloatMatrix2D)linkedList.get(linkedList.size() - 1)).toArray());
        this.lu = new FloatLUDecompositionQuick();
        this.lu.decompose(denseFloatMatrix2D);
        this.u = new DenseFloatMatrix1D[this.m];
        this.f = new DenseFloatMatrix1D[this.m];
        this.r = new DenseFloatMatrix1D[this.m];
        for (n = 0; n < this.m; ++n) {
            int n3 = ((RCFloatMatrix2D)linkedList.get(n)).rows();
            this.u[n] = new DenseFloatMatrix1D(n3);
            this.f[n] = new DenseFloatMatrix1D(n3);
            this.r[n] = new DenseFloatMatrix1D(n3);
        }
        this.preM = new SSOR[this.m - 1];
        this.postM = new SSOR[this.m - 1];
        for (n = 0; n < this.m - 1; ++n) {
            RCFloatMatrix2D rCFloatMatrix2D2 = this.A[n];
            this.preM[n] = new SSOR(rCFloatMatrix2D2, this.reverse, this.omegaPreF, this.omegaPreR);
            this.postM[n] = new SSOR(rCFloatMatrix2D2, this.reverse, this.omegaPostF, this.omegaPostR);
            this.preM[n].setMatrix(rCFloatMatrix2D2);
            this.postM[n].setMatrix(rCFloatMatrix2D2);
        }
    }

    private void cycle(int n) {
        if (n == this.m - 1) {
            this.directSolve();
        } else {
            this.preRelax(n);
            this.u[n + 1].assign(0.0f);
            this.A[n].zMult(this.u[n], this.r[n].assign(this.f[n]), -1.0f, 1.0f, false);
            this.I[n].zMult(this.r[n], this.f[n + 1], 1.0f, 0.0f, true);
            for (int i = 0; i < this.gamma; ++i) {
                this.cycle(n + 1);
            }
            this.I[n].zMult(this.u[n + 1], this.u[n], 1.0f, 1.0f, false);
            this.postRelax(n);
        }
    }

    private void directSolve() {
        int n = this.m - 1;
        this.u[n].assign(this.f[n]);
        if (this.transpose) {
            this.lu.setLU(this.lu.getLU().viewDice());
            this.lu.solve(this.u[n]);
            this.lu.setLU(this.lu.getLU().viewDice());
        } else {
            this.lu.solve(this.u[n]);
        }
    }

    private void preRelax(int n) {
        for (int i = 0; i < this.nu1; ++i) {
            if (this.transpose) {
                this.preM[n].transApply(this.f[n], this.u[n]);
                continue;
            }
            this.preM[n].apply(this.f[n], this.u[n]);
        }
    }

    private void postRelax(int n) {
        for (int i = 0; i < this.nu2; ++i) {
            if (this.transpose) {
                this.postM[n].transApply(this.f[n], this.u[n]);
                continue;
            }
            this.postM[n].apply(this.f[n], this.u[n]);
        }
    }

    private class SSOR
    implements FloatPreconditioner {
        private float omegaF;
        private float omegaR;
        private final RCFloatMatrix2D F;
        private final int[] diagind;
        private final float[] xx;
        private final boolean reverse;

        public SSOR(RCFloatMatrix2D rCFloatMatrix2D, boolean bl, float f, float f2) {
            if (rCFloatMatrix2D.rows() != rCFloatMatrix2D.columns()) {
                throw new IllegalArgumentException("SSOR only applies to square matrices");
            }
            this.F = rCFloatMatrix2D;
            this.reverse = bl;
            this.setOmega(f, f2);
            int n = rCFloatMatrix2D.rows();
            this.diagind = new int[n];
            this.xx = new float[n];
        }

        public SSOR(RCFloatMatrix2D rCFloatMatrix2D) {
            this(rCFloatMatrix2D, true, 1.0f, 1.0f);
        }

        public void setOmega(float f, float f2) {
            if (f < 0.0f || f > 2.0f) {
                throw new IllegalArgumentException("omegaF must be between 0 and 2");
            }
            if (f2 < 0.0f || f2 > 2.0f) {
                throw new IllegalArgumentException("omegaR must be between 0 and 2");
            }
            this.omegaF = f;
            this.omegaR = f2;
        }

        public void setMatrix(FloatMatrix2D floatMatrix2D) {
            this.F.assign(floatMatrix2D);
            int n = this.F.rows();
            int[] nArray = this.F.getRowPointers();
            int[] nArray2 = this.F.getColumnindexes().elements();
            for (int i = 0; i < n; ++i) {
                this.diagind[i] = Sorting.binarySearchFromTo(nArray2, i, nArray[i], nArray[i + 1] - 1);
                if (this.diagind[i] >= 0) continue;
                throw new RuntimeException("Missing diagonal on row " + (i + 1));
            }
        }

        public FloatMatrix1D apply(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
            int n;
            float f;
            int n2;
            if (!(floatMatrix1D instanceof DenseFloatMatrix1D) || !(floatMatrix1D2 instanceof DenseFloatMatrix1D)) {
                throw new IllegalArgumentException("b and x must be a DenseFloatMatrix1D");
            }
            int[] nArray = this.F.getRowPointers();
            int[] nArray2 = this.F.getColumnindexes().elements();
            float[] fArray = this.F.getValues().elements();
            float[] fArray2 = ((DenseFloatMatrix1D)floatMatrix1D).elements();
            float[] fArray3 = ((DenseFloatMatrix1D)floatMatrix1D2).elements();
            int n3 = this.F.rows();
            System.arraycopy(fArray3, 0, this.xx, 0, n3);
            for (n2 = 0; n2 < n3; ++n2) {
                f = 0.0f;
                for (n = nArray[n2]; n < this.diagind[n2]; ++n) {
                    f += fArray[n] * this.xx[nArray2[n]];
                }
                for (n = this.diagind[n2] + 1; n < nArray[n2 + 1]; ++n) {
                    f += fArray[n] * fArray3[nArray2[n]];
                }
                f = (fArray2[n2] - f) / fArray[this.diagind[n2]];
                this.xx[n2] = fArray3[n2] + this.omegaF * (f - fArray3[n2]);
            }
            if (!this.reverse) {
                System.arraycopy(this.xx, 0, fArray3, 0, n3);
                return floatMatrix1D2;
            }
            for (n2 = n3 - 1; n2 >= 0; --n2) {
                f = 0.0f;
                for (n = nArray[n2]; n < this.diagind[n2]; ++n) {
                    f += fArray[n] * this.xx[nArray2[n]];
                }
                for (n = this.diagind[n2] + 1; n < nArray[n2 + 1]; ++n) {
                    f += fArray[n] * fArray3[nArray2[n]];
                }
                f = (fArray2[n2] - f) / fArray[this.diagind[n2]];
                fArray3[n2] = this.xx[n2] + this.omegaR * (f - this.xx[n2]);
            }
            floatMatrix1D2.assign(fArray3);
            return floatMatrix1D2;
        }

        public FloatMatrix1D transApply(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
            return this.apply(floatMatrix1D, floatMatrix1D2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Interpolator {
        private RCFloatMatrix2D Ac;
        private CCFloatMatrix2D I;

        public Interpolator(Aggregator aggregator, RCFloatMatrix2D rCFloatMatrix2D, float f) {
            List<Set<Integer>> list = aggregator.getAggregates();
            List<Set<Integer>> list2 = aggregator.getNodeNeighborhoods();
            int[] nArray = aggregator.getDiagonalindexes();
            int[] nArray2 = this.createTentativeProlongation(list, rCFloatMatrix2D.rows());
            if (f != 0.0f) {
                List<Map<Integer, Float>> list3 = this.createSmoothedProlongation(list, list2, rCFloatMatrix2D, nArray, f, nArray2);
                this.I = this.createInterpolationMatrix(list3, rCFloatMatrix2D.rows());
                this.Ac = this.createGalerkinSlow(this.I, rCFloatMatrix2D);
            } else {
                this.Ac = this.createGalerkinFast(rCFloatMatrix2D, nArray2, list.size());
                this.I = this.createInterpolationMatrix(nArray2, list.size());
            }
        }

        private int[] createTentativeProlongation(List<Set<Integer>> list, int n) {
            int[] nArray = new int[n];
            Arrays.fill(nArray, -1);
            for (int i = 0; i < list.size(); ++i) {
                for (int n2 : list.get(i)) {
                    nArray[n2] = i;
                }
            }
            return nArray;
        }

        private RCFloatMatrix2D createGalerkinFast(RCFloatMatrix2D rCFloatMatrix2D, int[] nArray, int n) {
            int n2 = nArray.length;
            RCMFloatMatrix2D rCMFloatMatrix2D = new RCMFloatMatrix2D(n, n);
            int[] nArray2 = rCFloatMatrix2D.getRowPointers();
            int[] nArray3 = rCFloatMatrix2D.getColumnindexes().elements();
            float[] fArray = rCFloatMatrix2D.getValues().elements();
            for (int i = 0; i < n2; ++i) {
                if (nArray[i] == -1) continue;
                for (int j = nArray2[i]; j < nArray2[i + 1]; ++j) {
                    if (nArray[nArray3[j]] == -1) continue;
                    rCMFloatMatrix2D.setQuick(nArray[i], nArray[nArray3[j]], fArray[j]);
                }
            }
            return (RCFloatMatrix2D)new RCFloatMatrix2D(rCMFloatMatrix2D.rows(), rCMFloatMatrix2D.columns()).assign(rCMFloatMatrix2D);
        }

        private CCFloatMatrix2D createInterpolationMatrix(List<Map<Integer, Float>> list, int n) {
            int n2 = list.size();
            this.I = new CCFloatMatrix2D(n, n2);
            for (int i = 0; i < n2; ++i) {
                Map<Integer, Float> map = list.get(i);
                for (Map.Entry<Integer, Float> entry : map.entrySet()) {
                    this.I.setQuick(entry.getKey(), i, entry.getValue().floatValue());
                }
            }
            return this.I;
        }

        private CCFloatMatrix2D createInterpolationMatrix(int[] nArray, int n) {
            CCMFloatMatrix2D cCMFloatMatrix2D = new CCMFloatMatrix2D(nArray.length, n);
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == -1) continue;
                cCMFloatMatrix2D.setQuick(i, nArray[i], 1.0f);
            }
            return (CCFloatMatrix2D)new CCFloatMatrix2D(cCMFloatMatrix2D.rows(), cCMFloatMatrix2D.columns()).assign(cCMFloatMatrix2D);
        }

        public CCFloatMatrix2D getInterpolationOperator() {
            return this.I;
        }

        private List<Map<Integer, Float>> createSmoothedProlongation(List<Set<Integer>> list, List<Set<Integer>> list2, RCFloatMatrix2D rCFloatMatrix2D, int[] nArray, float f, int[] nArray2) {
            int n = rCFloatMatrix2D.rows();
            int n2 = list.size();
            ArrayList<Map<Integer, Float>> arrayList = new ArrayList<Map<Integer, Float>>(n2);
            for (int i = 0; i < n2; ++i) {
                arrayList.add(new HashMap());
            }
            int[] nArray3 = rCFloatMatrix2D.getRowPointers();
            int[] nArray4 = rCFloatMatrix2D.getColumnindexes().elements();
            float[] fArray = rCFloatMatrix2D.getValues().elements();
            float[] fArray2 = new float[n2];
            for (int i = 0; i < n; ++i) {
                if (nArray2[i] == -1) continue;
                Arrays.fill(fArray2, 0.0f);
                Set<Integer> set = list2.get(i);
                float f2 = 0.0f;
                for (int j = nArray3[i]; j < nArray3[i + 1]; ++j) {
                    if (nArray2[nArray4[j]] == -1) continue;
                    float f3 = fArray[j];
                    if (f3 != 0.0f && !set.contains(nArray4[j])) {
                        f2 += f3;
                        continue;
                    }
                    int n3 = nArray2[nArray4[j]];
                    fArray2[n3] = fArray2[n3] + f3;
                }
                int n4 = nArray2[i];
                fArray2[n4] = fArray2[n4] - f2;
                float f4 = -f / fArray[nArray[i]];
                int n5 = 0;
                while (n5 < fArray2.length) {
                    int n6 = n5++;
                    fArray2[n6] = fArray2[n6] * f4;
                }
                int n7 = nArray2[i];
                fArray2[n7] = fArray2[n7] + 1.0f;
                for (n5 = 0; n5 < fArray2.length; ++n5) {
                    if (fArray2[n5] == 0.0f) continue;
                    ((Map)arrayList.get(n5)).put(i, Float.valueOf(fArray2[n5]));
                }
            }
            return arrayList;
        }

        private RCFloatMatrix2D createGalerkinSlow(CCFloatMatrix2D cCFloatMatrix2D, RCFloatMatrix2D rCFloatMatrix2D) {
            int n = cCFloatMatrix2D.rows();
            int n2 = cCFloatMatrix2D.columns();
            RCMFloatMatrix2D rCMFloatMatrix2D = new RCMFloatMatrix2D(n2, n2);
            float[] fArray = new float[n];
            float[] fArray2 = new float[n];
            DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(n, fArray, 0, 1, false);
            DenseFloatMatrix1D denseFloatMatrix1D2 = new DenseFloatMatrix1D(n, fArray2, 0, 1, false);
            float[] fArray3 = new float[n2];
            DenseFloatMatrix1D denseFloatMatrix1D3 = new DenseFloatMatrix1D(n2, fArray3, 0, 1, false);
            int[] nArray = cCFloatMatrix2D.getColumnPointers();
            int[] nArray2 = cCFloatMatrix2D.getRowindexes().elements();
            float[] fArray4 = cCFloatMatrix2D.getValues().elements();
            for (int i = 0; i < n2; ++i) {
                int n3;
                denseFloatMatrix1D2.assign(0.0f);
                for (n3 = nArray[i]; n3 < nArray[i + 1]; ++n3) {
                    fArray2[nArray2[n3]] = fArray4[n3];
                }
                rCFloatMatrix2D.zMult(denseFloatMatrix1D2, denseFloatMatrix1D);
                cCFloatMatrix2D.zMult(denseFloatMatrix1D, denseFloatMatrix1D3, 1.0f, 0.0f, true);
                for (n3 = 0; n3 < n2; ++n3) {
                    if (fArray3[n3] == 0.0f) continue;
                    rCMFloatMatrix2D.setQuick(n3, i, fArray3[n3]);
                }
            }
            return (RCFloatMatrix2D)new RCFloatMatrix2D(rCMFloatMatrix2D.rows(), rCMFloatMatrix2D.columns()).assign(rCMFloatMatrix2D);
        }

        public RCFloatMatrix2D getGalerkinOperator() {
            return this.Ac;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Aggregator {
        private List<Set<Integer>> C;
        private int[] diagind;
        private List<Set<Integer>> N;

        public Aggregator(RCFloatMatrix2D rCFloatMatrix2D, float f) {
            this.diagind = this.findDiagonalindexes(rCFloatMatrix2D);
            this.N = this.findNodeNeighborhood(rCFloatMatrix2D, this.diagind, f);
            boolean[] blArray = this.createInitialR(rCFloatMatrix2D);
            this.C = this.createInitialAggregates(this.N, blArray);
            this.C = this.enlargeAggregates(this.C, this.N, blArray);
            this.C = this.createFinalAggregates(this.C, this.N, blArray);
        }

        public List<Set<Integer>> getAggregates() {
            return this.C;
        }

        public int[] getDiagonalindexes() {
            return this.diagind;
        }

        public List<Set<Integer>> getNodeNeighborhoods() {
            return this.N;
        }

        private int[] findDiagonalindexes(RCFloatMatrix2D rCFloatMatrix2D) {
            int[] nArray = rCFloatMatrix2D.getRowPointers();
            int[] nArray2 = rCFloatMatrix2D.getColumnindexes().elements();
            int[] nArray3 = new int[rCFloatMatrix2D.rows()];
            for (int i = 0; i < rCFloatMatrix2D.rows(); ++i) {
                nArray3[i] = Sorting.binarySearchFromTo(nArray2, i, nArray[i], nArray[i + 1]);
                if (nArray3[i] >= 0) continue;
                throw new RuntimeException("Matrix is missing a diagonal entry on row " + (i + 1));
            }
            return nArray3;
        }

        private List<Set<Integer>> findNodeNeighborhood(RCFloatMatrix2D rCFloatMatrix2D, int[] nArray, float f) {
            this.N = new ArrayList<Set<Integer>>(rCFloatMatrix2D.rows());
            int[] nArray2 = rCFloatMatrix2D.getRowPointers();
            int[] nArray3 = rCFloatMatrix2D.getColumnindexes().elements();
            float[] fArray = rCFloatMatrix2D.getValues().elements();
            for (int i = 0; i < rCFloatMatrix2D.rows(); ++i) {
                HashSet<Integer> hashSet = new HashSet<Integer>();
                float f2 = fArray[nArray[i]];
                for (int j = nArray2[i]; j < nArray2[i + 1]; ++j) {
                    float f3 = fArray[j];
                    float f4 = fArray[nArray[nArray3[j]]];
                    if (!((double)Math.abs(f3) >= (double)f * Math.sqrt(f2 * f4))) continue;
                    hashSet.add(nArray3[j]);
                }
                this.N.add(hashSet);
            }
            return this.N;
        }

        private boolean[] createInitialR(RCFloatMatrix2D rCFloatMatrix2D) {
            boolean[] blArray = new boolean[rCFloatMatrix2D.rows()];
            int[] nArray = rCFloatMatrix2D.getRowPointers();
            int[] nArray2 = rCFloatMatrix2D.getColumnindexes().elements();
            float[] fArray = rCFloatMatrix2D.getValues().elements();
            for (int i = 0; i < rCFloatMatrix2D.rows(); ++i) {
                boolean bl = false;
                for (int j = nArray[i]; j < nArray[i + 1]; ++j) {
                    if (nArray2[j] == i || fArray[j] == 0.0f) continue;
                    bl = true;
                    break;
                }
                blArray[i] = bl;
            }
            return blArray;
        }

        private List<Set<Integer>> createInitialAggregates(List<Set<Integer>> list, boolean[] blArray) {
            this.C = new ArrayList<Set<Integer>>();
            for (int i = 0; i < blArray.length; ++i) {
                if (!blArray[i]) continue;
                boolean bl = true;
                for (int n : list.get(i)) {
                    bl &= blArray[n];
                }
                if (!bl) continue;
                this.C.add(new HashSet(list.get(i)));
                for (int n : list.get(i)) {
                    blArray[n] = false;
                }
            }
            return this.C;
        }

        private List<Set<Integer>> enlargeAggregates(List<Set<Integer>> list, List<Set<Integer>> list2, boolean[] blArray) {
            int n;
            ArrayList arrayList = new ArrayList(blArray.length);
            for (n = 0; n < blArray.length; ++n) {
                arrayList.add(new ArrayList());
            }
            for (n = 0; n < list.size(); ++n) {
                for (int n2 : list.get(n)) {
                    ((List)arrayList.get(n2)).add(n);
                }
            }
            int[] nArray = new int[list.size()];
            for (int i = 0; i < blArray.length; ++i) {
                int n2;
                if (!blArray[i]) continue;
                Arrays.fill(nArray, 0);
                n2 = 0;
                int n3 = 0;
                for (int n4 : list2.get(i)) {
                    Iterator iterator = ((List)arrayList.get(n4)).iterator();
                    while (iterator.hasNext()) {
                        int n5;
                        int n6 = n5 = ((Integer)iterator.next()).intValue();
                        nArray[n6] = nArray[n6] + 1;
                        if (nArray[n5] <= n3) continue;
                        n2 = n5;
                        n3 = nArray[n2];
                    }
                }
                if (n3 <= 0) continue;
                blArray[i] = false;
                list.get(n2).add(i);
            }
            return list;
        }

        private List<Set<Integer>> createFinalAggregates(List<Set<Integer>> list, List<Set<Integer>> list2, boolean[] blArray) {
            for (int i = 0; i < blArray.length; ++i) {
                if (!blArray[i]) continue;
                HashSet<Integer> hashSet = new HashSet<Integer>();
                for (int n : list2.get(i)) {
                    if (!blArray[n]) continue;
                    blArray[n] = false;
                    hashSet.add(n);
                }
                if (hashSet.isEmpty()) continue;
                list.add(hashSet);
            }
            return list;
        }
    }
}

