/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver;

import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.algo.solver.AbstractFloatIterationMonitor;
import cern.colt.matrix.tfloat.algo.solver.FloatNotConvergedException;
import cern.colt.matrix.tfloat.algo.solver.IterativeSolverFloatNotConvergedException;

public class HyBRFloatIterationMonitor
extends AbstractFloatIterationMonitor {
    protected HyBRStoppingCondition stoppingCondition;
    protected int maxIter;
    protected float dtol;
    protected float initR;

    public HyBRFloatIterationMonitor() {
        this.maxIter = 100;
        this.dtol = 100000.0f;
    }

    public HyBRFloatIterationMonitor(int n, float f) {
        this.maxIter = n;
        this.dtol = f;
    }

    public boolean converged(float f, FloatMatrix1D floatMatrix1D) throws IterativeSolverFloatNotConvergedException {
        if (!this.isFirst()) {
            this.reporter.monitor(f, floatMatrix1D, this.iter);
        }
        this.residual = f;
        return this.convergedI(f, floatMatrix1D);
    }

    public boolean converged(float f) throws IterativeSolverFloatNotConvergedException {
        if (!this.isFirst()) {
            this.reporter.monitor(f, this.iter);
        }
        this.residual = f;
        return this.convergedI(f);
    }

    protected boolean convergedI(float f) throws IterativeSolverFloatNotConvergedException {
        if (this.isFirst()) {
            this.initR = f;
        }
        if ((double)this.initR != -1.0 && f > this.dtol * this.initR) {
            throw new IterativeSolverFloatNotConvergedException(FloatNotConvergedException.Reason.Divergence, this);
        }
        if (this.iter >= this.maxIter + 1) {
            throw new IterativeSolverFloatNotConvergedException(FloatNotConvergedException.Reason.Iterations, this);
        }
        if (Float.isNaN(f)) {
            throw new IterativeSolverFloatNotConvergedException(FloatNotConvergedException.Reason.Divergence, this);
        }
        return false;
    }

    protected boolean convergedI(float f, FloatMatrix1D floatMatrix1D) throws IterativeSolverFloatNotConvergedException {
        return this.convergedI(f);
    }

    public int getMaxIterations() {
        return this.maxIter;
    }

    public void setMaxIterations(int n) {
        this.maxIter = n;
    }

    public void setDivergenceTolerance(float f) {
        this.dtol = f;
    }

    public float getDivergenceTolerance() {
        return this.dtol;
    }

    public void setStoppingCondition(HyBRStoppingCondition hyBRStoppingCondition) {
        this.stoppingCondition = hyBRStoppingCondition;
    }

    public HyBRStoppingCondition getStoppingCondition() {
        return this.stoppingCondition;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum HyBRStoppingCondition {
        FLAT_GCV_CURVE,
        MIN_OF_GCV_CURVE_WITHIN_WINDOW_OF_4_ITERATIONS;

    }
}

