/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver;

import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.FloatAlgebra;
import cern.colt.matrix.tfloat.algo.solver.AbstractFloatIterativeSolver;
import cern.colt.matrix.tfloat.algo.solver.CGLSFloatIterationMonitor;
import cern.colt.matrix.tfloat.algo.solver.IterativeSolverFloatNotConvergedException;
import cern.colt.matrix.tfloat.algo.solver.preconditioner.FloatIdentity;
import cern.jet.math.tfloat.FloatFunctions;

public class FloatCGLS
extends AbstractFloatIterativeSolver {
    private static final FloatAlgebra alg = FloatAlgebra.DEFAULT;
    public static final float sqrteps = (float)Math.sqrt(Math.pow(2.0, -23.0));

    public FloatCGLS() {
        this.iter = new CGLSFloatIterationMonitor();
        ((CGLSFloatIterationMonitor)this.iter).setRelativeTolerance(-1.0f);
    }

    public FloatMatrix1D solve(FloatMatrix2D floatMatrix2D, FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) throws IterativeSolverFloatNotConvergedException {
        float f;
        float f2 = 0.0f;
        float f3 = alg.norm2(floatMatrix2D.zMult(floatMatrix1D, null, 1.0f, 0.0f, true));
        if ((double)((CGLSFloatIterationMonitor)this.iter).getRelativeTolerance() == -1.0) {
            ((CGLSFloatIterationMonitor)this.iter).setRelativeTolerance(sqrteps * f3);
        }
        FloatMatrix1D floatMatrix1D3 = floatMatrix2D.zMult(floatMatrix1D2, null);
        floatMatrix1D3.assign(floatMatrix1D, FloatFunctions.plusMultFirst(-1.0f));
        FloatMatrix1D floatMatrix1D4 = floatMatrix2D.zMult(floatMatrix1D3, null, 1.0f, 0.0f, true);
        if (!(this.M instanceof FloatIdentity)) {
            floatMatrix1D4 = this.M.transApply(floatMatrix1D4, null);
        }
        float f4 = f = alg.norm2(floatMatrix1D4);
        f *= f;
        FloatMatrix1D floatMatrix1D5 = floatMatrix1D4.copy();
        this.iter.setFirst();
        while (!this.iter.converged(f4, floatMatrix1D2)) {
            if (!this.iter.isFirst()) {
                float f5 = f / f2;
                floatMatrix1D5.assign(floatMatrix1D4, FloatFunctions.plusMultFirst(f5));
            }
            if (!(this.M instanceof FloatIdentity)) {
                floatMatrix1D5 = this.M.apply(floatMatrix1D5, null);
            }
            FloatMatrix1D floatMatrix1D6 = floatMatrix2D.zMult(floatMatrix1D5, null);
            float f6 = alg.norm2(floatMatrix1D6);
            f6 *= f6;
            float f7 = f / f6;
            floatMatrix1D2.assign(floatMatrix1D5, FloatFunctions.plusMultSecond(f7));
            floatMatrix1D3.assign(floatMatrix1D6, FloatFunctions.plusMultSecond(-f7));
            floatMatrix1D4 = floatMatrix2D.zMult(floatMatrix1D3, null, 1.0f, 0.0f, true);
            if (!(this.M instanceof FloatIdentity)) {
                floatMatrix1D4 = this.M.transApply(floatMatrix1D4, null);
            }
            f2 = f;
            f4 = f = alg.norm2(floatMatrix1D4);
            f *= f;
            this.iter.next();
        }
        return floatMatrix1D2;
    }
}

