/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.decomposition;

import cern.colt.function.tfloat.FloatFloatFunction;
import cern.colt.matrix.tfloat.FloatFactory2D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.FloatAlgebra;
import cern.colt.matrix.tfloat.algo.FloatProperty;
import cern.jet.math.tfloat.FloatFunctions;
import java.io.Serializable;

public class FloatQRDecomposition
implements Serializable {
    static final long serialVersionUID = 1020L;
    private FloatMatrix2D QR;
    private int m;
    private int n;
    private FloatMatrix1D Rdiag;

    public FloatQRDecomposition(FloatMatrix2D floatMatrix2D) {
        int n;
        FloatProperty.DEFAULT.checkRectangular(floatMatrix2D);
        FloatFunctions floatFunctions = FloatFunctions.functions;
        this.QR = floatMatrix2D.copy();
        this.m = floatMatrix2D.rows();
        this.n = floatMatrix2D.columns();
        this.Rdiag = floatMatrix2D.like1D(this.n);
        FloatFloatFunction floatFloatFunction = FloatAlgebra.hypotFunction();
        FloatMatrix1D[] floatMatrix1DArray = new FloatMatrix1D[this.n];
        FloatMatrix1D[] floatMatrix1DArray2 = new FloatMatrix1D[this.n];
        for (n = 0; n < this.n; ++n) {
            floatMatrix1DArray[n] = this.QR.viewColumn(n);
            floatMatrix1DArray2[n] = this.QR.viewColumn(n).viewPart(n, this.m - n);
        }
        for (n = 0; n < this.n; ++n) {
            int n2;
            float f = 0.0f;
            for (n2 = n; n2 < this.m; ++n2) {
                f = FloatAlgebra.hypot(f, this.QR.getQuick(n2, n));
            }
            if ((double)f != 0.0) {
                if (this.QR.getQuick(n, n) < 0.0f) {
                    f = -f;
                }
                floatMatrix1DArray2[n].assign(FloatFunctions.div(f));
                this.QR.setQuick(n, n, this.QR.getQuick(n, n) + 1.0f);
                for (n2 = n + 1; n2 < this.n; ++n2) {
                    FloatMatrix1D floatMatrix1D = this.QR.viewColumn(n2).viewPart(n, this.m - n);
                    float f2 = floatMatrix1DArray2[n].zDotProduct(floatMatrix1D);
                    f2 = -f2 / this.QR.getQuick(n, n);
                    for (int i = n; i < this.m; ++i) {
                        this.QR.setQuick(i, n2, this.QR.getQuick(i, n2) + f2 * this.QR.getQuick(i, n));
                    }
                }
            }
            this.Rdiag.setQuick(n, -f);
        }
    }

    public FloatMatrix2D getH() {
        return FloatAlgebra.DEFAULT.trapezoidalLower(this.QR.copy());
    }

    public FloatMatrix2D getQ() {
        FloatFunctions floatFunctions = FloatFunctions.functions;
        FloatMatrix2D floatMatrix2D = this.QR.like();
        for (int i = this.n - 1; i >= 0; --i) {
            FloatMatrix1D floatMatrix1D = this.QR.viewColumn(i).viewPart(i, this.m - i);
            floatMatrix2D.setQuick(i, i, 1.0f);
            for (int j = i; j < this.n; ++j) {
                if (this.QR.getQuick(i, i) == 0.0f) continue;
                FloatMatrix1D floatMatrix1D2 = floatMatrix2D.viewColumn(j).viewPart(i, this.m - i);
                float f = floatMatrix1D.zDotProduct(floatMatrix1D2);
                f = -f / this.QR.getQuick(i, i);
                floatMatrix1D2.assign(floatMatrix1D, FloatFunctions.plusMultSecond(f));
            }
        }
        return floatMatrix2D;
    }

    public FloatMatrix2D getR() {
        FloatMatrix2D floatMatrix2D = this.QR.like(this.n, this.n);
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                if (i < j) {
                    floatMatrix2D.setQuick(i, j, this.QR.getQuick(i, j));
                    continue;
                }
                if (i == j) {
                    floatMatrix2D.setQuick(i, j, this.Rdiag.getQuick(i));
                    continue;
                }
                floatMatrix2D.setQuick(i, j, 0.0f);
            }
        }
        return floatMatrix2D;
    }

    public boolean hasFullRank() {
        for (int i = 0; i < this.n; ++i) {
            if (this.Rdiag.getQuick(i) != 0.0f) continue;
            return false;
        }
        return true;
    }

    public FloatMatrix1D solve(FloatMatrix1D floatMatrix1D) {
        int n;
        FloatFunctions floatFunctions = FloatFunctions.functions;
        if (floatMatrix1D.size() != this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.hasFullRank()) {
            throw new IllegalArgumentException("Matrix is rank deficient.");
        }
        FloatMatrix1D floatMatrix1D2 = floatMatrix1D.copy();
        for (n = 0; n < this.n; ++n) {
            int n2;
            float f = 0.0f;
            for (n2 = n; n2 < this.m; ++n2) {
                f += this.QR.getQuick(n2, n) * floatMatrix1D2.getQuick(n2);
            }
            f = -f / this.QR.getQuick(n, n);
            for (n2 = n; n2 < this.m; ++n2) {
                floatMatrix1D2.setQuick(n2, floatMatrix1D2.getQuick(n2) + f * this.QR.getQuick(n2, n));
            }
        }
        for (n = this.n - 1; n >= 0; --n) {
            floatMatrix1D2.setQuick(n, floatMatrix1D2.getQuick(n) / this.Rdiag.getQuick(n));
            for (int i = 0; i < n; ++i) {
                floatMatrix1D2.setQuick(i, floatMatrix1D2.getQuick(i) - floatMatrix1D2.getQuick(n) * this.QR.getQuick(i, n));
            }
        }
        return floatMatrix1D2.viewPart(0, this.n).copy();
    }

    public FloatMatrix2D solve(FloatMatrix2D floatMatrix2D) {
        int n;
        int n2;
        FloatFunctions floatFunctions = FloatFunctions.functions;
        if (floatMatrix2D.rows() != this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.hasFullRank()) {
            throw new IllegalArgumentException("Matrix is rank deficient.");
        }
        int n3 = floatMatrix2D.columns();
        FloatMatrix2D floatMatrix2D2 = floatMatrix2D.copy();
        for (n2 = 0; n2 < this.n; ++n2) {
            for (n = 0; n < n3; ++n) {
                int n4;
                float f = 0.0f;
                for (n4 = n2; n4 < this.m; ++n4) {
                    f += this.QR.getQuick(n4, n2) * floatMatrix2D2.getQuick(n4, n);
                }
                f = -f / this.QR.getQuick(n2, n2);
                for (n4 = n2; n4 < this.m; ++n4) {
                    floatMatrix2D2.setQuick(n4, n, floatMatrix2D2.getQuick(n4, n) + f * this.QR.getQuick(n4, n2));
                }
            }
        }
        for (n2 = this.n - 1; n2 >= 0; --n2) {
            for (n = 0; n < n3; ++n) {
                floatMatrix2D2.setQuick(n2, n, floatMatrix2D2.getQuick(n2, n) / this.Rdiag.getQuick(n2));
            }
            for (n = 0; n < n2; ++n) {
                for (int i = 0; i < n3; ++i) {
                    floatMatrix2D2.setQuick(n, i, floatMatrix2D2.getQuick(n, i) - floatMatrix2D2.getQuick(n2, i) * this.QR.getQuick(n, n2));
                }
            }
        }
        return floatMatrix2D2.viewPart(0, 0, this.n, n3);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "Illegal operation or error: ";
        stringBuffer.append("-----------------------------------------------------------------\n");
        stringBuffer.append("QRDecomposition(A) --> hasFullRank(A), H, Q, R, pseudo inverse(A)\n");
        stringBuffer.append("-----------------------------------------------------------------\n");
        stringBuffer.append("hasFullRank = ");
        try {
            stringBuffer.append(String.valueOf(this.hasFullRank()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\nH = ");
        try {
            stringBuffer.append(String.valueOf(this.getH()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\nQ = ");
        try {
            stringBuffer.append(String.valueOf(this.getQ()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\nR = ");
        try {
            stringBuffer.append(String.valueOf(this.getR()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\npseudo inverse(A) = ");
        try {
            stringBuffer.append(String.valueOf(this.solve(FloatFactory2D.dense.identity(this.QR.rows()))));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        return stringBuffer.toString();
    }
}

