/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.decomposition;

import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tfloat.FloatFactory1D;
import cern.colt.matrix.tfloat.FloatFactory2D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.FloatAlgebra;
import cern.colt.matrix.tfloat.algo.FloatProperty;
import cern.jet.math.tfloat.FloatMult;
import cern.jet.math.tfloat.FloatPlusMultSecond;
import java.io.Serializable;

public class FloatLUDecompositionQuick
implements Serializable {
    static final long serialVersionUID = 1020L;
    protected FloatMatrix2D LU;
    protected int pivsign;
    protected int[] piv;
    protected boolean isNonSingular;
    protected FloatAlgebra algebra;
    protected transient float[] workFloat;
    protected transient int[] work1;
    protected transient int[] work2;

    public FloatLUDecompositionQuick() {
        this(FloatProperty.DEFAULT.tolerance());
    }

    public FloatLUDecompositionQuick(float f) {
        this.algebra = new FloatAlgebra(f);
    }

    public void decompose(FloatMatrix2D floatMatrix2D) {
        this.LU = floatMatrix2D;
        int n = floatMatrix2D.rows();
        int n2 = floatMatrix2D.columns();
        if (this.piv == null || this.piv.length != n) {
            this.piv = new int[n];
        }
        int n3 = n;
        while (--n3 >= 0) {
            this.piv[n3] = n3;
        }
        this.pivsign = 1;
        if (n * n2 == 0) {
            this.setLU(this.LU);
            return;
        }
        FloatMatrix1D[] floatMatrix1DArray = new FloatMatrix1D[n];
        for (int i = 0; i < n; ++i) {
            floatMatrix1DArray[i] = this.LU.viewRow(i);
        }
        IntArrayList intArrayList = new IntArrayList();
        FloatMatrix1D floatMatrix1D = this.LU.viewColumn(0).like();
        FloatMult floatMult = FloatMult.mult(0.0f);
        for (int i = 0; i < n2; ++i) {
            float f;
            float f2;
            int n4;
            floatMatrix1D.assign(this.LU.viewColumn(i));
            int n5 = n / 10;
            floatMatrix1D.getNonZeros(intArrayList, null, n5);
            int n6 = intArrayList.size();
            boolean bl = n6 < n5;
            for (n4 = 0; n4 < n; ++n4) {
                int n7 = Math.min(n4, i);
                float f3 = bl ? floatMatrix1DArray[n4].zDotProduct(floatMatrix1D, 0, n7, intArrayList) : floatMatrix1DArray[n4].zDotProduct(floatMatrix1D, 0, n7);
                f2 = floatMatrix1D.getQuick(n4);
                float f4 = f2 - f3;
                floatMatrix1D.setQuick(n4, f4);
                this.LU.setQuick(n4, i, f4);
                if (!bl) continue;
                if (f2 == 0.0f && f4 != 0.0f) {
                    int n8 = intArrayList.binarySearch(n4);
                    n8 = -n8 - 1;
                    intArrayList.beforeInsert(n8, n4);
                }
                if (f2 == 0.0f || f4 != 0.0f) continue;
                intArrayList.remove(intArrayList.binarySearch(n4));
            }
            n4 = i;
            if (n4 < n) {
                float f5 = Math.abs(floatMatrix1D.getQuick(n4));
                for (int j = i + 1; j < n; ++j) {
                    f2 = Math.abs(floatMatrix1D.getQuick(j));
                    if (!(f2 > f5)) continue;
                    n4 = j;
                    f5 = f2;
                }
            }
            if (n4 != i) {
                floatMatrix1DArray[n4].swap(floatMatrix1DArray[i]);
                int n9 = this.piv[n4];
                this.piv[n4] = this.piv[i];
                this.piv[i] = n9;
                this.pivsign = -this.pivsign;
            }
            if (i >= n || (double)(f = this.LU.getQuick(i, i)) == 0.0) continue;
            floatMult.multiplicator = 1.0f / f;
            this.LU.viewColumn(i).viewPart(i + 1, n - (i + 1)).assign(floatMult);
        }
        this.setLU(this.LU);
    }

    public void decompose(FloatMatrix2D floatMatrix2D, int n) {
        if (!this.algebra.property().isSquare(floatMatrix2D) || n < 0 || n > 2) {
            this.decompose(floatMatrix2D);
            return;
        }
        this.LU = floatMatrix2D;
        int n2 = floatMatrix2D.rows();
        int n3 = floatMatrix2D.columns();
        if (this.piv == null || this.piv.length != n2) {
            this.piv = new int[n2];
        }
        int n4 = n2;
        while (--n4 >= 0) {
            this.piv[n4] = n4;
        }
        this.pivsign = 1;
        if (n2 * n3 == 0) {
            this.setLU(floatMatrix2D);
            return;
        }
        if (n == 2) {
            if (n3 > 1) {
                floatMatrix2D.setQuick(1, 0, floatMatrix2D.getQuick(1, 0) / floatMatrix2D.getQuick(0, 0));
            }
            for (n4 = 1; n4 < n3; ++n4) {
                float f = floatMatrix2D.getQuick(n4, n4) - floatMatrix2D.getQuick(n4, n4 - 1) * floatMatrix2D.getQuick(n4 - 1, n4);
                floatMatrix2D.setQuick(n4, n4, f);
                if (n4 >= n3 - 1) continue;
                floatMatrix2D.setQuick(n4 + 1, n4, floatMatrix2D.getQuick(n4 + 1, n4) / f);
            }
        }
        this.setLU(floatMatrix2D);
    }

    public float det() {
        int n;
        int n2 = this.m();
        if (n2 != (n = this.n())) {
            throw new IllegalArgumentException("Matrix must be square.");
        }
        if (!this.isNonsingular()) {
            return 0.0f;
        }
        float f = this.pivsign;
        for (int i = 0; i < n; ++i) {
            f *= this.LU.getQuick(i, i);
        }
        return f;
    }

    protected float[] getFloatPivot() {
        int n = this.m();
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = this.piv[i];
        }
        return fArray;
    }

    public FloatMatrix2D getL() {
        return this.lowerTriangular(this.LU.copy());
    }

    public FloatMatrix2D getLU() {
        return this.LU.copy();
    }

    public int[] getPivot() {
        return this.piv;
    }

    public FloatMatrix2D getU() {
        return this.upperTriangular(this.LU.copy());
    }

    public boolean isNonsingular() {
        return this.isNonSingular;
    }

    protected boolean isNonsingular(FloatMatrix2D floatMatrix2D) {
        int n = floatMatrix2D.rows();
        int n2 = floatMatrix2D.columns();
        float f = this.algebra.property().tolerance();
        int n3 = Math.min(n2, n);
        while (--n3 >= 0) {
            if (!(Math.abs(floatMatrix2D.getQuick(n3, n3)) <= f)) continue;
            return false;
        }
        return true;
    }

    protected FloatMatrix2D lowerTriangular(FloatMatrix2D floatMatrix2D) {
        int n;
        int n2 = floatMatrix2D.rows();
        int n3 = floatMatrix2D.columns();
        int n4 = n = Math.min(n2, n3);
        while (--n4 >= 0) {
            int n5 = n;
            while (--n5 >= 0) {
                if (n4 < n5) {
                    floatMatrix2D.setQuick(n4, n5, 0.0f);
                    continue;
                }
                if (n4 != n5) continue;
                floatMatrix2D.setQuick(n4, n5, 1.0f);
            }
        }
        if (n3 > n2) {
            floatMatrix2D.viewPart(0, n, n2, n3 - n).assign(0.0f);
        }
        return floatMatrix2D;
    }

    protected int m() {
        return this.LU.rows();
    }

    protected int n() {
        return this.LU.columns();
    }

    public void setLU(FloatMatrix2D floatMatrix2D) {
        this.LU = floatMatrix2D;
        this.isNonSingular = this.isNonsingular(floatMatrix2D);
    }

    public void solve(FloatMatrix1D floatMatrix1D) {
        float f;
        int n;
        float f2;
        int n2;
        this.algebra.property().checkRectangular(this.LU);
        int n3 = this.m();
        int n4 = this.n();
        if (floatMatrix1D.size() != n3) {
            throw new IllegalArgumentException("Matrix dimensions must agree.");
        }
        if (!this.isNonsingular()) {
            throw new IllegalArgumentException("Matrix is singular.");
        }
        if (this.workFloat == null || this.workFloat.length < n3) {
            this.workFloat = new float[n3];
        }
        this.algebra.permute(floatMatrix1D, this.piv, this.workFloat);
        if (n3 * n4 == 0) {
            return;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            f2 = floatMatrix1D.getQuick(n2);
            if (f2 == 0.0f) continue;
            for (n = n2 + 1; n < n4; ++n) {
                f = this.LU.getQuick(n, n2);
                if (f == 0.0f) continue;
                floatMatrix1D.setQuick(n, floatMatrix1D.getQuick(n) - f2 * f);
            }
        }
        for (n2 = n4 - 1; n2 >= 0; --n2) {
            floatMatrix1D.setQuick(n2, floatMatrix1D.getQuick(n2) / this.LU.getQuick(n2, n2));
            f2 = floatMatrix1D.getQuick(n2);
            if (f2 == 0.0f) continue;
            for (n = 0; n < n2; ++n) {
                f = this.LU.getQuick(n, n2);
                if (f == 0.0f) continue;
                floatMatrix1D.setQuick(n, floatMatrix1D.getQuick(n) - f2 * f);
            }
        }
    }

    public void solve(FloatMatrix2D floatMatrix2D) {
        int n;
        boolean bl;
        int n2;
        int n3;
        int n4;
        this.algebra.property().checkRectangular(this.LU);
        int n5 = this.m();
        int n6 = this.n();
        if (floatMatrix2D.rows() != n5) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isNonsingular()) {
            throw new IllegalArgumentException("Matrix is singular.");
        }
        if (this.work1 == null || this.work1.length < n5) {
            this.work1 = new int[n5];
        }
        this.algebra.permuteRows(floatMatrix2D, this.piv, this.work1);
        if (n5 * n6 == 0) {
            return;
        }
        int n7 = floatMatrix2D.columns();
        FloatMatrix1D[] floatMatrix1DArray = new FloatMatrix1D[n6];
        for (int i = 0; i < n6; ++i) {
            floatMatrix1DArray[i] = floatMatrix2D.viewRow(i);
        }
        FloatMult floatMult = FloatMult.div(0.0f);
        FloatPlusMultSecond floatPlusMultSecond = FloatPlusMultSecond.minusMult(0.0f);
        IntArrayList intArrayList = new IntArrayList();
        FloatMatrix1D floatMatrix1D = FloatFactory1D.dense.make(n7);
        for (n4 = 0; n4 < n6; ++n4) {
            floatMatrix1D.assign(floatMatrix1DArray[n4]);
            n3 = n7 / 10;
            floatMatrix1D.getNonZeros(intArrayList, null, n3);
            n2 = intArrayList.size();
            bl = n2 < n3;
            for (n = n4 + 1; n < n6; ++n) {
                floatPlusMultSecond.multiplicator = -this.LU.getQuick(n, n4);
                if (floatPlusMultSecond.multiplicator == 0.0f) continue;
                if (bl) {
                    floatMatrix1DArray[n].assign(floatMatrix1D, floatPlusMultSecond, intArrayList);
                    continue;
                }
                floatMatrix1DArray[n].assign(floatMatrix1D, floatPlusMultSecond);
            }
        }
        for (n4 = n6 - 1; n4 >= 0; --n4) {
            floatMult.multiplicator = 1.0f / this.LU.getQuick(n4, n4);
            floatMatrix1DArray[n4].assign(floatMult);
            if (floatMatrix1D == null) {
                floatMatrix1D = FloatFactory1D.dense.make(floatMatrix2D.columns());
            }
            floatMatrix1D.assign(floatMatrix1DArray[n4]);
            n3 = n7 / 10;
            floatMatrix1D.getNonZeros(intArrayList, null, n3);
            n2 = intArrayList.size();
            bl = n2 < n3;
            for (n = 0; n < n4; ++n) {
                floatPlusMultSecond.multiplicator = -this.LU.getQuick(n, n4);
                if (floatPlusMultSecond.multiplicator == 0.0f) continue;
                if (bl) {
                    floatMatrix1DArray[n].assign(floatMatrix1D, floatPlusMultSecond, intArrayList);
                    continue;
                }
                floatMatrix1DArray[n].assign(floatMatrix1D, floatPlusMultSecond);
            }
        }
    }

    private void solveOld(FloatMatrix2D floatMatrix2D) {
        int n;
        int n2;
        this.algebra.property().checkRectangular(this.LU);
        int n3 = this.m();
        int n4 = this.n();
        if (floatMatrix2D.rows() != n3) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isNonsingular()) {
            throw new IllegalArgumentException("Matrix is singular.");
        }
        int n5 = floatMatrix2D.columns();
        if (this.work1 == null || this.work1.length < n3) {
            this.work1 = new int[n3];
        }
        this.algebra.permuteRows(floatMatrix2D, this.piv, this.work1);
        for (n2 = 0; n2 < n4; ++n2) {
            for (int i = n2 + 1; i < n4; ++i) {
                float f = this.LU.getQuick(i, n2);
                if (f == 0.0f) continue;
                for (n = 0; n < n5; ++n) {
                    floatMatrix2D.setQuick(i, n, floatMatrix2D.getQuick(i, n) - floatMatrix2D.getQuick(n2, n) * f);
                }
            }
        }
        for (n2 = n4 - 1; n2 >= 0; --n2) {
            int n6;
            float f = 1.0f / this.LU.getQuick(n2, n2);
            if (f != 1.0f) {
                for (n6 = 0; n6 < n5; ++n6) {
                    floatMatrix2D.setQuick(n2, n6, floatMatrix2D.getQuick(n2, n6) * f);
                }
            }
            for (n6 = 0; n6 < n2; ++n6) {
                f = this.LU.getQuick(n6, n2);
                if (f == 0.0f) continue;
                for (n = 0; n < n5; ++n) {
                    floatMatrix2D.setQuick(n6, n, floatMatrix2D.getQuick(n6, n) - floatMatrix2D.getQuick(n2, n) * f);
                }
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "Illegal operation or error: ";
        stringBuffer.append("-----------------------------------------------------------------------------\n");
        stringBuffer.append("LUDecompositionQuick(A) --> isNonSingular(A), det(A), pivot, L, U, inverse(A)\n");
        stringBuffer.append("-----------------------------------------------------------------------------\n");
        stringBuffer.append("isNonSingular = ");
        try {
            stringBuffer.append(String.valueOf(this.isNonsingular()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\ndet = ");
        try {
            stringBuffer.append(String.valueOf(this.det()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\npivot = ");
        try {
            stringBuffer.append(String.valueOf(new IntArrayList(this.getPivot())));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\nL = ");
        try {
            stringBuffer.append(String.valueOf(this.getL()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\nU = ");
        try {
            stringBuffer.append(String.valueOf(this.getU()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\ninverse(A) = ");
        FloatMatrix2D floatMatrix2D = FloatFactory2D.dense.identity(this.LU.rows());
        try {
            this.solve(floatMatrix2D);
            stringBuffer.append(String.valueOf(floatMatrix2D));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        return stringBuffer.toString();
    }

    protected FloatMatrix2D upperTriangular(FloatMatrix2D floatMatrix2D) {
        int n;
        int n2 = floatMatrix2D.rows();
        int n3 = floatMatrix2D.columns();
        int n4 = n = Math.min(n2, n3);
        while (--n4 >= 0) {
            int n5 = n;
            while (--n5 >= 0) {
                if (n4 <= n5) continue;
                floatMatrix2D.setQuick(n4, n5, 0.0f);
            }
        }
        if (n3 < n2) {
            floatMatrix2D.viewPart(n, 0, n2 - n, n3).assign(0.0f);
        }
        return floatMatrix2D;
    }

    private float[] xgetFloatPivot() {
        int n = this.m();
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = this.piv[i];
        }
        return fArray;
    }
}

