/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo;

import cern.colt.function.tfloat.FloatFloatFunction;
import cern.colt.function.tfloat.FloatFunction;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.FloatAlgebra;
import cern.colt.matrix.tfloat.algo.FloatBlas;
import cern.colt.matrix.tfloat.algo.FloatProperty;
import cern.jet.math.tfloat.FloatFunctions;
import cern.jet.math.tfloat.FloatPlusMultSecond;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class SmpFloatBlas
implements FloatBlas {
    public void assign(FloatMatrix2D floatMatrix2D, FloatFunction floatFunction) {
        floatMatrix2D.assign(floatFunction);
    }

    public void assign(FloatMatrix2D floatMatrix2D, FloatMatrix2D floatMatrix2D2, FloatFloatFunction floatFloatFunction) {
        floatMatrix2D.assign(floatMatrix2D2, floatFloatFunction);
    }

    public float dasum(FloatMatrix1D floatMatrix1D) {
        return floatMatrix1D.aggregate(FloatFunctions.plus, FloatFunctions.abs);
    }

    public void daxpy(float f, FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
        floatMatrix1D2.assign(floatMatrix1D, FloatFunctions.plusMultSecond(f));
    }

    public void daxpy(float f, FloatMatrix2D floatMatrix2D, FloatMatrix2D floatMatrix2D2) {
        floatMatrix2D2.assign(floatMatrix2D, FloatFunctions.plusMultSecond(f));
    }

    public void dcopy(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
        floatMatrix1D2.assign(floatMatrix1D);
    }

    public void dcopy(FloatMatrix2D floatMatrix2D, FloatMatrix2D floatMatrix2D2) {
        floatMatrix2D2.assign(floatMatrix2D);
    }

    public float ddot(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
        return floatMatrix1D.zDotProduct(floatMatrix1D2);
    }

    public void dgemm(boolean bl, boolean bl2, float f, FloatMatrix2D floatMatrix2D, FloatMatrix2D floatMatrix2D2, float f2, FloatMatrix2D floatMatrix2D3) {
        floatMatrix2D.zMult(floatMatrix2D2, floatMatrix2D3, f, f2, bl, bl2);
    }

    public void dgemv(boolean bl, float f, FloatMatrix2D floatMatrix2D, FloatMatrix1D floatMatrix1D, float f2, FloatMatrix1D floatMatrix1D2) {
        floatMatrix2D.zMult(floatMatrix1D, floatMatrix1D2, f, f2, bl);
    }

    public void dger(float f, FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2, FloatMatrix2D floatMatrix2D) {
        FloatPlusMultSecond floatPlusMultSecond = FloatPlusMultSecond.plusMult(0.0f);
        int n = floatMatrix2D.rows();
        for (int i = 0; i < n; ++i) {
            floatPlusMultSecond.multiplicator = f * floatMatrix1D.getQuick(i);
            floatMatrix2D.viewRow(i).assign(floatMatrix1D2, floatPlusMultSecond);
        }
    }

    public float dnrm2(FloatMatrix1D floatMatrix1D) {
        return FloatAlgebra.DEFAULT.norm2(floatMatrix1D);
    }

    public void drot(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2, float f, float f2) {
        floatMatrix1D.checkSize(floatMatrix1D2);
        FloatMatrix1D floatMatrix1D3 = floatMatrix1D.copy();
        floatMatrix1D.assign(FloatFunctions.mult(f));
        floatMatrix1D.assign(floatMatrix1D2, FloatFunctions.plusMultSecond(f2));
        floatMatrix1D2.assign(FloatFunctions.mult(f));
        floatMatrix1D2.assign(floatMatrix1D3, FloatFunctions.minusMult(f2));
    }

    public void drotg(float f, float f2, float[] fArray) {
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8 = f2;
        if (Math.abs(f) > Math.abs(f2)) {
            f8 = f;
        }
        if ((double)(f7 = Math.abs(f) + Math.abs(f2)) != 0.0) {
            float f9 = f / f7;
            float f10 = f2 / f7;
            f6 = (float)((double)f7 * Math.sqrt(f9 * f9 + f10 * f10));
            f6 = this.sign(1.0f, f8) * f6;
            f5 = f / f6;
            f4 = f2 / f6;
            f3 = 1.0f;
            if (Math.abs(f) > Math.abs(f2)) {
                f3 = f4;
            }
            if (Math.abs(f2) >= Math.abs(f) && (double)f5 != 0.0) {
                f3 = (float)(1.0 / (double)f5);
            }
        } else {
            f5 = 1.0f;
            f4 = 0.0f;
            f6 = 0.0f;
            f3 = 0.0f;
        }
        f = f6;
        f2 = f3;
        fArray[0] = f;
        fArray[1] = f2;
        fArray[2] = f5;
        fArray[3] = f4;
    }

    public void dscal(float f, FloatMatrix1D floatMatrix1D) {
        floatMatrix1D.assign(FloatFunctions.mult(f));
    }

    public void dscal(float f, FloatMatrix2D floatMatrix2D) {
        floatMatrix2D.assign(FloatFunctions.mult(f));
    }

    public void dswap(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
        floatMatrix1D2.swap(floatMatrix1D);
    }

    public void dswap(FloatMatrix2D floatMatrix2D, FloatMatrix2D floatMatrix2D2) {
        floatMatrix2D.checkShape(floatMatrix2D2);
        int n = floatMatrix2D.rows();
        for (int i = 0; i < n; ++i) {
            floatMatrix2D.viewRow(i).swap(floatMatrix2D2.viewRow(i));
        }
    }

    public void dsymv(boolean bl, final float f, FloatMatrix2D floatMatrix2D, final FloatMatrix1D floatMatrix1D, final float f2, final FloatMatrix1D floatMatrix1D2) {
        final FloatMatrix2D floatMatrix2D2 = bl ? floatMatrix2D.viewDice() : floatMatrix2D;
        FloatProperty.DEFAULT.checkSquare(floatMatrix2D2);
        int n = floatMatrix2D2.rows();
        if (n != floatMatrix1D.size() || n != floatMatrix1D2.size()) {
            throw new IllegalArgumentException(floatMatrix2D2.toStringShort() + ", " + floatMatrix1D.toStringShort() + ", " + floatMatrix1D2.toStringShort());
        }
        final FloatMatrix1D floatMatrix1D3 = floatMatrix1D.like();
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n2];
            int n3 = n / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? n : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            int n;
                            float f3 = 0.0f;
                            for (n = 0; n <= i; ++n) {
                                f3 += floatMatrix2D2.getQuick(i, n) * floatMatrix1D.getQuick(n);
                            }
                            for (n = i + 1; n < n5; ++n) {
                                f3 += floatMatrix2D2.getQuick(n, i) * floatMatrix1D.getQuick(n);
                            }
                            floatMatrix1D3.setQuick(i, f * f3 + f2 * floatMatrix1D2.getQuick(i));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < n; ++i) {
                int n6;
                float f3 = 0.0f;
                for (n6 = 0; n6 <= i; ++n6) {
                    f3 += floatMatrix2D2.getQuick(i, n6) * floatMatrix1D.getQuick(n6);
                }
                for (n6 = i + 1; n6 < n; ++n6) {
                    f3 += floatMatrix2D2.getQuick(n6, i) * floatMatrix1D.getQuick(n6);
                }
                floatMatrix1D3.setQuick(i, f * f3 + f2 * floatMatrix1D2.getQuick(i));
            }
        }
        floatMatrix1D2.assign(floatMatrix1D3);
    }

    public void dtrmv(boolean bl, boolean bl2, boolean bl3, FloatMatrix2D floatMatrix2D, final FloatMatrix1D floatMatrix1D) {
        int n;
        boolean bl4;
        FloatMatrix2D floatMatrix2D2;
        if (bl2) {
            floatMatrix2D2 = floatMatrix2D.viewDice();
            bl4 = !bl;
        } else {
            floatMatrix2D2 = floatMatrix2D;
            bl4 = bl;
        }
        FloatProperty.DEFAULT.checkSquare(floatMatrix2D2);
        int n2 = floatMatrix2D2.rows();
        if (n2 != floatMatrix1D.size()) {
            throw new IllegalArgumentException(floatMatrix2D2.toStringShort() + ", " + floatMatrix1D.toStringShort());
        }
        final FloatMatrix1D floatMatrix1D2 = floatMatrix1D.like();
        final FloatMatrix1D floatMatrix1D3 = floatMatrix1D.like();
        if (bl3) {
            floatMatrix1D3.assign(1.0f);
        } else {
            for (n = 0; n < n2; ++n) {
                floatMatrix1D3.setQuick(n, floatMatrix2D2.getQuick(n, n));
            }
        }
        n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n3 = n2 / n;
            for (int i = 0; i < n; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n - 1 ? n2 : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            int n;
                            float f = 0.0f;
                            if (!bl4) {
                                for (n = 0; n < i; ++n) {
                                    f += floatMatrix2D2.getQuick(i, n) * floatMatrix1D.getQuick(n);
                                }
                                f += floatMatrix1D3.getQuick(i) * floatMatrix1D.getQuick(i);
                            } else {
                                f += floatMatrix1D3.getQuick(i) * floatMatrix1D.getQuick(i);
                                for (n = i + 1; n < n5; ++n) {
                                    f += floatMatrix2D2.getQuick(i, n) * floatMatrix1D.getQuick(n);
                                }
                            }
                            floatMatrix1D2.setQuick(i, f);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < n2; ++i) {
                int n6;
                float f = 0.0f;
                if (!bl4) {
                    for (n6 = 0; n6 < i; ++n6) {
                        f += floatMatrix2D2.getQuick(i, n6) * floatMatrix1D.getQuick(n6);
                    }
                    f += floatMatrix1D3.getQuick(i) * floatMatrix1D.getQuick(i);
                } else {
                    f += floatMatrix1D3.getQuick(i) * floatMatrix1D.getQuick(i);
                    for (n6 = i + 1; n6 < n2; ++n6) {
                        f += floatMatrix2D2.getQuick(i, n6) * floatMatrix1D.getQuick(n6);
                    }
                }
                floatMatrix1D2.setQuick(i, f);
            }
        }
        floatMatrix1D.assign(floatMatrix1D2);
    }

    public int idamax(FloatMatrix1D floatMatrix1D) {
        FloatMatrix1D floatMatrix1D2 = floatMatrix1D.copy();
        floatMatrix1D2.assign(FloatFunctions.abs);
        float[] fArray = floatMatrix1D2.getMaxLocation();
        return (int)fArray[1];
    }

    private float sign(float f, float f2) {
        if ((double)f2 < 0.0) {
            return -Math.abs(f);
        }
        return Math.abs(f);
    }
}

